/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.SchemaMessages;
import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.AbstractMatchingRule;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.schema.StringPrepProfile;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.LDAPSyntaxDescription;
import org.opends.server.types.ResultCode;
import org.opends.server.types.Schema;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPSyntaxDescriptionSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
        if (this.defaultEqualityMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_EQUALITY_MATCHING_RULE.get("2.5.13.2", "LDAPSyntaxDescription"));
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
        if (this.defaultOrderingMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_ORDERING_MATCHING_RULE.get("2.5.13.3", "LDAPSyntaxDescription"));
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            ErrorLogger.logError(SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_SUBSTRING_MATCHING_RULE.get("2.5.13.4", "LDAPSyntaxDescription"));
        }
    }

    @Override
    public String getSyntaxName() {
        return "LDAPSyntaxDescription";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.54";
    }

    @Override
    public String getDescription() {
        return "LDAP Syntax Description";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    private static int parseOIDAndDescription(String valueStr, StringBuilder descriptionBuffer, StringBuilder oidBuffer) throws DirectoryException {
        String tokenName;
        char c;
        int pos;
        int length = valueStr.length();
        String lowerStr = StaticUtils.toLowerCase(valueStr);
        for (pos = 0; pos < length && valueStr.charAt(pos) == ' '; ++pos) {
        }
        if (pos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_EMPTY_VALUE.get();
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        if ((c = valueStr.charAt(pos++)) != '(') {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_EXPECTED_OPEN_PARENTHESIS.get(valueStr, pos - 1, String.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        while (pos < length && (c = valueStr.charAt(pos)) == ' ') {
            ++pos;
        }
        if (pos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        int oidStartPos = pos;
        if (StaticUtils.isDigit(c)) {
            boolean lastWasPeriod = false;
            while (pos < length && (c = valueStr.charAt(pos)) != ' ' && (c = valueStr.charAt(pos)) != ')') {
                if (c == '.') {
                    if (lastWasPeriod) {
                        Message message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRTYPE_DOUBLE_PERIOD_IN_NUMERIC_OID.get(valueStr, pos - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                    }
                    lastWasPeriod = true;
                } else {
                    if (!StaticUtils.isDigit(c)) {
                        Message message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRTYPE_ILLEGAL_CHAR_IN_NUMERIC_OID.get(valueStr, String.valueOf(c), pos - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                    }
                    lastWasPeriod = false;
                }
                ++pos;
            }
        } else {
            while (pos < length && (c = valueStr.charAt(pos)) != ' ' && (c = valueStr.charAt(pos)) != ')') {
                if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c) || c == '-' || c == '_' && DirectoryServer.allowAttributeNameExceptions()) {
                    ++pos;
                    continue;
                }
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRTYPE_ILLEGAL_CHAR_IN_STRING_OID.get(valueStr, String.valueOf(c), pos - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
        }
        if (pos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        oidBuffer.append(lowerStr.substring(oidStartPos, pos));
        while (pos < length && (c = valueStr.charAt(pos)) == ' ') {
            ++pos;
        }
        if (pos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        if (c == ')' && pos < length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_UNEXPECTED_CLOSE_PARENTHESIS.get(valueStr, pos - 1);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        try {
            StringBuilder tokenNameBuffer = new StringBuilder();
            pos = LDAPSyntaxDescriptionSyntax.readTokenName(lowerStr, tokenNameBuffer, pos);
            tokenName = tokenNameBuffer.toString();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_CANNOT_READ_DESC_TOKEN.get(valueStr, pos, StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        if (!tokenName.equals("desc")) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_TOKEN_NOT_DESC.get(valueStr, tokenName);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        try {
            pos = LDAPSyntaxDescriptionSyntax.readQuotedString(valueStr, descriptionBuffer, pos);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_CANNOT_READ_DESC_VALUE.get(valueStr, pos, StaticUtils.getExceptionMessage(e));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        return pos;
    }

    public static LDAPSyntaxDescription decodeLDAPSyntax(ByteSequence value, Schema schema, boolean allowUnknownElements) throws DirectoryException {
        Message message;
        String valueStr = ((Object)value).toString();
        String lowerStr = StaticUtils.toLowerCase(valueStr);
        int length = valueStr.length();
        StringBuilder descriptionBuffer = new StringBuilder();
        StringBuilder oidBuffer = new StringBuilder();
        int pos = LDAPSyntaxDescriptionSyntax.parseOIDAndDescription(valueStr, descriptionBuffer, oidBuffer);
        String oid = oidBuffer.toString();
        String description = descriptionBuffer.toString();
        StringBuilder extBuffer = new StringBuilder();
        LDAPSyntaxDescriptionSyntax syntax = null;
        char c = '\u0000';
        pos = LDAPSyntaxDescriptionSyntax.readTokenName(valueStr, extBuffer, pos);
        String lowerTokenName = StaticUtils.toLowerCase(extBuffer.toString());
        if (lowerTokenName.equals("x-subst")) {
            StringBuilder woidBuffer = new StringBuilder();
            pos = LDAPSyntaxDescriptionSyntax.readQuotedString(lowerStr, woidBuffer, pos);
            String syntaxOID = woidBuffer.toString();
            AttributeSyntax subSyntax = schema.getSyntax(syntaxOID);
            if (subSyntax == null) {
                Message message2 = SchemaMessages.WARN_ATTR_SYNTAX_ATTRTYPE_UNKNOWN_SYNTAX.get(String.valueOf(oid), syntaxOID);
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message2);
            }
            syntax = new SubstitutionSyntax(subSyntax, valueStr, description, oid);
        } else if (lowerTokenName.equals("x-pattern")) {
            StringBuilder regexBuffer = new StringBuilder();
            pos = LDAPSyntaxDescriptionSyntax.readQuotedString(valueStr, regexBuffer, pos);
            String regex = regexBuffer.toString().trim();
            if (regex.length() == 0) {
                Message message3 = SchemaMessages.WARN_ATTR_SYNTAX_LDAPSYNTAX_REGEX_NO_PATTERN.get(valueStr);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message3);
            }
            try {
                Pattern pattern = Pattern.compile(regex);
                syntax = new RegexSyntax(pattern, valueStr, description, oid);
            }
            catch (Exception e) {
                Message message4 = SchemaMessages.WARN_ATTR_SYNTAX_LDAPSYNTAX_REGEX_INVALID_PATTERN.get(valueStr, regex);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message4);
            }
        } else if (lowerTokenName.equals("x-enum")) {
            if ((c = valueStr.charAt(pos++)) != '(') {
                Message message5 = SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_EXPECTED_OPEN_PARENTHESIS.get(valueStr, pos, String.valueOf(c));
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message5);
            }
            LinkedList<ByteString> entries = new LinkedList<ByteString>();
            while (true) {
                if ((c = valueStr.charAt(pos)) == ')') {
                    ++pos;
                    break;
                }
                StringBuilder buffer = new StringBuilder();
                pos = LDAPSyntaxDescriptionSyntax.readQuotedString(valueStr, buffer, pos);
                ByteString entry = ByteString.valueOf(buffer.toString());
                if (entries.contains(entry)) {
                    Message message6 = SchemaMessages.WARN_ATTR_SYNTAX_LDAPSYNTAX_ENUM_DUPLICATE_VALUE.get(valueStr, entry.toString(), pos);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message6);
                }
                entries.add(entry);
            }
            syntax = new EnumSyntax(entries, valueStr, description, oid);
        } else {
            Message message7 = SchemaMessages.WARN_ATTR_SYNTAX_LDAPSYNTAX_UNKNOWN_EXT.get(valueStr, lowerTokenName, pos);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message7);
        }
        while (pos < length && (c = valueStr.charAt(pos)) == ' ') {
            ++pos;
        }
        if (pos >= length || (c = valueStr.charAt(pos++)) != ')') {
            message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_EXPECTED_CLOSE_PARENTHESIS.get(valueStr, pos, String.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        while (pos < length) {
            if ((c = valueStr.charAt(pos++)) == ' ') continue;
            message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_ILLEGAL_CHAR_AFTER_CLOSE.get(valueStr, String.valueOf(c), pos);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        return new LDAPSyntaxDescription(valueStr, syntax, description, null);
    }

    @Override
    public boolean valueIsAcceptable(ByteSequence value, MessageBuilder invalidReason) {
        String valueStr = ((Object)value).toString();
        StringBuilder descriptionBuffer = new StringBuilder();
        StringBuilder oidBuffer = new StringBuilder();
        int length = valueStr.length();
        int pos = 0;
        try {
            pos = LDAPSyntaxDescriptionSyntax.parseOIDAndDescription(valueStr, descriptionBuffer, oidBuffer);
        }
        catch (DirectoryException de) {
            invalidReason.append(de.getMessageObject());
            return false;
        }
        char c = valueStr.charAt(pos);
        if (c != ')') {
            try {
                pos = LDAPSyntaxDescriptionSyntax.parseExtension(valueStr, pos);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_INVALID_EXTENSION.get(StaticUtils.getExceptionMessage(e)));
                return false;
            }
        }
        if ((c = valueStr.charAt(pos++)) != ')') {
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_EXPECTED_CLOSE_PARENTHESIS.get(valueStr, pos, String.valueOf(c)));
            return false;
        }
        while (pos < length) {
            if ((c = valueStr.charAt(pos++)) == ' ') continue;
            invalidReason.append(SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_ILLEGAL_CHAR_AFTER_CLOSE.get(valueStr, String.valueOf(c), pos));
            return false;
        }
        return true;
    }

    private static int readTokenName(String valueStr, StringBuilder tokenName, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = valueStr.length();
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        while (startPos < length && (c = valueStr.charAt(startPos++)) != ' ') {
            tokenName.append(c);
        }
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        return startPos;
    }

    private static int readQuotedString(String valueStr, StringBuilder valueBuffer, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = valueStr.length();
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        if (c != '\'') {
            Message message = SchemaMessages.WARN_ATTR_SYNTAX_ATTRSYNTAX_EXPECTED_QUOTE_AT_POS.get(valueStr, startPos, String.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        ++startPos;
        while (startPos < length && (c = valueStr.charAt(startPos)) != '\'') {
            valueBuffer.append(c);
            ++startPos;
        }
        ++startPos;
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        return startPos;
    }

    private static int parseExtension(String valueStr, int startPos) throws DirectoryException {
        int pos = startPos;
        int len = valueStr.length();
        do {
            StringBuilder qdString;
            Message message;
            StringBuilder tokenNameBuffer = new StringBuilder();
            pos = LDAPSyntaxDescriptionSyntax.readTokenName(valueStr, tokenNameBuffer, pos);
            String tokenName = tokenNameBuffer.toString();
            if (tokenName.length() <= 2 || !tokenName.startsWith("X-")) {
                Message message2 = SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_EXTENSION_INVALID_CHARACTER.get(valueStr, pos);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message2);
            }
            String xstring = tokenName.substring(2);
            if (xstring.split("^[A-Za-z_-]+").length > 0) {
                message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_EXTENSION_INVALID_CHARACTER.get(valueStr, pos);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            char c = valueStr.charAt(pos);
            if (c == '\'') {
                qdString = new StringBuilder();
                pos = LDAPSyntaxDescriptionSyntax.readQuotedString(valueStr, qdString, pos);
            } else if (c == '(') {
                ++pos;
                qdString = new StringBuilder();
                while ((c = valueStr.charAt(pos)) != ')') {
                    pos = LDAPSyntaxDescriptionSyntax.readQuotedString(valueStr, qdString, pos);
                }
                ++pos;
            } else {
                message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_EXTENSION_INVALID_CHARACTER.get(valueStr, pos);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            if (pos >= len) {
                message = SchemaMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_TRUNCATED_VALUE.get(valueStr);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            while (pos < valueStr.length() && (c = valueStr.charAt(pos)) == ' ') {
                ++pos;
            }
        } while (valueStr.charAt(pos) != ')');
        return pos;
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnumSyntax
    extends LDAPSyntaxDescriptionSyntax {
        LinkedList<ByteSequence> entries;
        private String description;
        private String oid;
        private EqualityMatchingRule equalityMatchingRule;
        private SubstringMatchingRule substringMatchingRule;
        private OrderingMatchingRule orderingMatchingRule;
        private ApproximateMatchingRule approximateMatchingRule;
        private String definition;

        private EnumSyntax(LinkedList<ByteSequence> entries, String definition, String description, String oid) {
            this.entries = entries;
            this.definition = definition;
            this.description = description;
            this.oid = oid;
        }

        @Override
        public String getSyntaxName() {
            return null;
        }

        @Override
        public String getOID() {
            return this.oid;
        }

        @Override
        public String toString() {
            return this.definition;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public void finalizeSyntax() {
            DirectoryServer.deregisterMatchingRule(this.orderingMatchingRule);
        }

        @Override
        public boolean valueIsAcceptable(ByteSequence value, MessageBuilder invalidReason) {
            boolean isAllowed = this.entries.contains(value);
            if (!isAllowed) {
                Message message = SchemaMessages.WARN_ATTR_SYNTAX_LDAPSYNTAX_ENUM_INVALID_VALUE.get(((Object)value).toString(), this.oid);
                invalidReason.append(message);
            }
            return isAllowed;
        }

        @Override
        public EqualityMatchingRule getEqualityMatchingRule() {
            if (this.equalityMatchingRule == null) {
                this.equalityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
            }
            return this.equalityMatchingRule;
        }

        @Override
        public OrderingMatchingRule getOrderingMatchingRule() {
            if (this.orderingMatchingRule == null) {
                this.orderingMatchingRule = new EnumOrderingMatchingRule(this, this.oid);
                try {
                    DirectoryServer.registerMatchingRule(this.orderingMatchingRule, false);
                }
                catch (DirectoryException de) {
                    ErrorLogger.logError(de.getMessageObject());
                }
            }
            return this.orderingMatchingRule;
        }

        @Override
        public SubstringMatchingRule getSubstringMatchingRule() {
            if (this.substringMatchingRule == null) {
                this.substringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
            }
            return this.substringMatchingRule;
        }

        @Override
        public ApproximateMatchingRule getApproximateMatchingRule() {
            if (this.approximateMatchingRule == null) {
                this.approximateMatchingRule = DirectoryServer.getApproximateMatchingRule("1.3.6.1.4.1.26027.1.4.1");
            }
            return this.approximateMatchingRule;
        }

        private LinkedList<ByteSequence> getEnumValues() {
            return this.entries;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class EnumOrderingMatchingRule
        extends AbstractMatchingRule
        implements OrderingMatchingRule {
            private EnumSyntax syntax;
            private String oid;
            private String name;
            static final long serialVersionUID = -2624642267131703408L;

            private EnumOrderingMatchingRule(EnumSyntax syntax, String oid) {
                this.syntax = syntax;
                this.oid = "1.3.6.1.4.1.26027.1.4.8." + oid;
                this.name = "enumOrderingMatch" + oid;
            }

            @Override
            public int compare(byte[] arg0, byte[] arg1) {
                return this.compareValues(ByteString.wrap(arg0), ByteString.wrap(arg1));
            }

            @Override
            public int compareValues(ByteSequence value1, ByteSequence value2) {
                LinkedList enumValues = this.syntax.getEnumValues();
                return enumValues.indexOf(value1) - enumValues.indexOf(value2);
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public Collection<String> getAllNames() {
                return Collections.singleton(this.getName());
            }

            @Override
            public String getOID() {
                return this.oid;
            }

            @Override
            public String getDescription() {
                return null;
            }

            @Override
            public String getSyntaxOID() {
                return "1.3.6.1.4.1.1466.115.121.1.15";
            }

            @Override
            public ByteString normalizeValue(ByteSequence value) throws DirectoryException {
                StringBuilder buffer = new StringBuilder();
                StringPrepProfile.prepareUnicode(buffer, value, true, true);
                int bufferLength = buffer.length();
                if (bufferLength == 0) {
                    if (value.length() > 0) {
                        return ServerConstants.SINGLE_SPACE_VALUE;
                    }
                    return ByteString.empty();
                }
                for (int pos = bufferLength - 1; pos > 0; --pos) {
                    if (buffer.charAt(pos) != ' ' || buffer.charAt(pos - 1) != ' ') continue;
                    buffer.delete(pos, pos + 1);
                }
                return ByteString.valueOf(buffer.toString());
            }
        }
    }

    private static class RegexSyntax
    extends LDAPSyntaxDescriptionSyntax {
        private Pattern pattern;
        private String description;
        private String oid;
        private String definition;
        private EqualityMatchingRule equalityMatchingRule;
        private SubstringMatchingRule substringMatchingRule;
        private OrderingMatchingRule orderingMatchingRule;
        private ApproximateMatchingRule approximateMatchingRule;

        private RegexSyntax(Pattern pattern, String definition, String description, String oid) {
            this.definition = definition;
            this.pattern = pattern;
            this.description = description;
            this.oid = oid;
        }

        public String getSyntaxName() {
            return null;
        }

        public String getOID() {
            return this.oid;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.definition;
        }

        public boolean valueIsAcceptable(ByteSequence value, MessageBuilder invalidReason) {
            String strValue = ((Object)value).toString();
            boolean matches = this.pattern.matcher(strValue).matches();
            if (!matches) {
                Message message = SchemaMessages.WARN_ATTR_SYNTAX_LDAPSYNTAX_REGEX_INVALID_VALUE.get(strValue, this.pattern.pattern());
                invalidReason.append(message);
            }
            return matches;
        }

        public EqualityMatchingRule getEqualityMatchingRule() {
            if (this.equalityMatchingRule == null) {
                this.equalityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
            }
            return this.equalityMatchingRule;
        }

        public OrderingMatchingRule getOrderingMatchingRule() {
            if (this.orderingMatchingRule == null) {
                this.orderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
            }
            return this.orderingMatchingRule;
        }

        public SubstringMatchingRule getSubstringMatchingRule() {
            if (this.substringMatchingRule == null) {
                this.substringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
            }
            return this.substringMatchingRule;
        }

        public ApproximateMatchingRule getApproximateMatchingRule() {
            if (this.approximateMatchingRule == null) {
                this.approximateMatchingRule = DirectoryServer.getApproximateMatchingRule("1.3.6.1.4.1.26027.1.4.1");
            }
            return this.approximateMatchingRule;
        }
    }

    private static class SubstitutionSyntax
    extends LDAPSyntaxDescriptionSyntax {
        private AttributeSyntax subSyntax;
        private String description;
        private String definition;
        private String oid;

        private SubstitutionSyntax(AttributeSyntax subSyntax, String definition, String description, String oid) {
            this.subSyntax = subSyntax;
            this.definition = definition;
            this.description = description;
            this.oid = oid;
        }

        public String getSyntaxName() {
            return null;
        }

        public String getOID() {
            return this.oid;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.definition;
        }

        public boolean valueIsAcceptable(ByteSequence value, MessageBuilder invalidReason) {
            return this.subSyntax.valueIsAcceptable(value, invalidReason);
        }

        public EqualityMatchingRule getEqualityMatchingRule() {
            return this.subSyntax.getEqualityMatchingRule();
        }

        public OrderingMatchingRule getOrderingMatchingRule() {
            return this.subSyntax.getOrderingMatchingRule();
        }

        public SubstringMatchingRule getSubstringMatchingRule() {
            return this.subSyntax.getSubstringMatchingRule();
        }

        public ApproximateMatchingRule getApproximateMatchingRule() {
            return this.subSyntax.getApproximateMatchingRule();
        }
    }
}

