/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.servicetag;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.DebugLogLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Util {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    Util() {
    }

    public static String generateURN() {
        return "urn:st:" + UUID.randomUUID().toString();
    }

    public static int getIntValue(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("\"" + value + "\"" + " expected to be an integer");
        }
    }

    public static Date parseTimestamp(String timestamp) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        try {
            return df.parse(timestamp);
        }
        catch (ParseException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.WARNING, e);
            }
            return new Date();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String commandOutput(Process p) throws IOException {
        InputStreamReader r = null;
        Reader err = null;
        try {
            r = new InputStreamReader(p.getInputStream());
            err = new InputStreamReader(p.getErrorStream());
            String output = Util.commandOutput(r);
            String errorMsg = Util.commandOutput(err);
            p.waitFor();
            String string = output + errorMsg.trim();
            return string;
        }
        catch (InterruptedException e) {
            String string = e.getMessage();
            return string;
        }
        finally {
            if (r != null) {
                ((Reader)r).close();
            }
            if (err != null) {
                err.close();
            }
        }
    }

    public static String commandOutput(Reader r) throws IOException {
        int c;
        StringBuilder sb = new StringBuilder();
        while ((c = r.read()) > 0) {
            if (c == 13) continue;
            sb.append((char)c);
        }
        return sb.toString();
    }

    private static byte[] stringToByteArray(String str) {
        return (str + "\u0000").getBytes();
    }

    private static String byteArrayToString(byte[] array) {
        return new String(array, 0, array.length - 1);
    }

    public static File getWindowsStClientFile() {
        File out = null;
        String regKey = "software\\microsoft\\windows\\currentversion\\app paths\\stclient.exe";
        String keyName = "";
        String path = Util.getRegistryKey(regKey, keyName);
        if (path != null && new File(path).exists()) {
            out = new File(path);
        }
        return out;
    }

    private static String getRegistryKey(String regKey, String keyName) {
        String out = null;
        try {
            Class<?> clazz = Class.forName("java.util.prefs.WindowsPreferences");
            Method winRegOpenKeyM = clazz.getDeclaredMethod("WindowsRegOpenKey", Integer.TYPE, byte[].class, Integer.TYPE);
            winRegOpenKeyM.setAccessible(true);
            Method winRegCloseKeyM = clazz.getDeclaredMethod("WindowsRegCloseKey", Integer.TYPE);
            winRegCloseKeyM.setAccessible(true);
            Method winRegQueryValueM = clazz.getDeclaredMethod("WindowsRegQueryValueEx", Integer.TYPE, byte[].class);
            winRegQueryValueM.setAccessible(true);
            int HKLM = Util.getValueFromStaticField("HKEY_LOCAL_MACHINE", clazz);
            int KEY_READ = Util.getValueFromStaticField("KEY_READ", clazz);
            int ERROR_CODE = Util.getValueFromStaticField("ERROR_CODE", clazz);
            int NATIVE_HANDLE = Util.getValueFromStaticField("NATIVE_HANDLE", clazz);
            int ERROR_SUCCESS = Util.getValueFromStaticField("ERROR_SUCCESS", clazz);
            byte[] reg = Util.stringToByteArray(regKey);
            byte[] key = Util.stringToByteArray(keyName);
            int[] result = (int[])winRegOpenKeyM.invoke(null, HKLM, reg, KEY_READ);
            if (result[ERROR_CODE] == ERROR_SUCCESS) {
                byte[] stvalue = (byte[])winRegQueryValueM.invoke(null, result[NATIVE_HANDLE], key);
                out = Util.byteArrayToString(stvalue);
                winRegCloseKeyM.invoke(null, result[NATIVE_HANDLE]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out;
    }

    private static int getValueFromStaticField(String fldName, Class<?> klass) throws Exception {
        Field f = klass.getDeclaredField(fldName);
        f.setAccessible(true);
        return f.getInt(null);
    }
}

