/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tasks;

import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.TaskMessages;
import org.opends.server.api.ClientConnection;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskState;
import org.opends.server.core.DirectoryServer;
import org.opends.server.tasks.RestartTaskThread;
import org.opends.server.tasks.ShutdownTaskThread;
import org.opends.server.tools.StopWindowsService;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.Operation;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class ShutdownTask
extends Task {
    private boolean restart;
    private Message shutdownMessage;

    public Message getDisplayName() {
        return TaskMessages.INFO_TASK_SHUTDOWN_NAME.get();
    }

    public void initializeTask() throws DirectoryException {
        Operation operation;
        String valueString;
        Attribute attr;
        Entry taskEntry = this.getTaskEntry();
        this.restart = false;
        this.shutdownMessage = TaskMessages.INFO_TASK_SHUTDOWN_DEFAULT_MESSAGE.get(String.valueOf(taskEntry.getDN()));
        AttributeType attrType = DirectoryServer.getAttributeType("ds-task-shutdown-message", true);
        List<Attribute> attrList = taskEntry.getAttribute(attrType);
        if (attrList != null && attrList.size() > 0 && !(attr = attrList.get(0)).isEmpty()) {
            valueString = attr.iterator().next().getValue().toString();
            this.shutdownMessage = TaskMessages.INFO_TASK_SHUTDOWN_CUSTOM_MESSAGE.get(String.valueOf(taskEntry.getDN()), String.valueOf(valueString));
        }
        if ((attrList = taskEntry.getAttribute(attrType = DirectoryServer.getAttributeType("ds-task-restart-server", true))) != null && attrList.size() > 0 && !(attr = attrList.get(0)).isEmpty()) {
            valueString = StaticUtils.toLowerCase(attr.iterator().next().getValue().toString());
            boolean bl = this.restart = valueString.equals("true") || valueString.equals("yes") || valueString.equals("on") || valueString.equals("1");
        }
        if ((operation = this.getOperation()) != null) {
            ClientConnection clientConnection = operation.getClientConnection();
            if (this.restart) {
                if (!clientConnection.hasPrivilege(Privilege.SERVER_RESTART, operation)) {
                    Message message = TaskMessages.ERR_TASK_SHUTDOWN_INSUFFICIENT_RESTART_PRIVILEGES.get();
                    throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, message);
                }
            } else if (!clientConnection.hasPrivilege(Privilege.SERVER_SHUTDOWN, operation)) {
                Message message = TaskMessages.ERR_TASK_SHUTDOWN_INSUFFICIENT_SHUTDOWN_PRIVILEGES.get();
                throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, message);
            }
        }
    }

    public TaskState runTask() {
        boolean configuredAsService = DirectoryServer.isRunningAsWindowsService();
        if (configuredAsService && !this.restart) {
            ShutdownTaskThread shutdownThread = new ShutdownTaskThread(this.shutdownMessage){

                public void run() {
                    StopWindowsService.main(new String[0]);
                }
            };
            shutdownThread.start();
        } else if (this.restart) {
            RestartTaskThread restartThread = new RestartTaskThread(this.shutdownMessage);
            restartThread.start();
        } else {
            ShutdownTaskThread shutdownThread = new ShutdownTaskThread(this.shutdownMessage);
            shutdownThread.start();
        }
        return TaskState.COMPLETED_SUCCESSFULLY;
    }
}

