/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.configurator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.Message;
import org.opends.messages.QuickSetupMessages;
import org.opends.messages.ToolMessages;
import org.opends.quicksetup.ApplicationException;
import org.opends.quicksetup.CliApplication;
import org.opends.quicksetup.Launcher;
import org.opends.quicksetup.QuickSetupLog;
import org.opends.quicksetup.ReturnCode;
import org.opends.quicksetup.util.Utils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;

public class Configurator
extends Launcher {
    private static final Logger LOG = Logger.getLogger(Configurator.class.getName());
    public static final String LOG_FILE_PREFIX = "opends-configure-";
    private String installRootFromSystem;
    public static final String IPATH_OPTION_LONG = "instancePath";
    public static final Character IPATH_OPTION_SHORT = null;
    public static final String USERNAME_OPTION_LONG = "userName";
    public static final Character USERNAME_OPTION_SHORT = null;
    public static final String GROUPNAME_OPTION_LONG = "groupName";
    public static final Character GROUPNAME_OPTION_SHORT = null;
    private ArgumentParser argParser;
    private StringArgument iPath;
    private StringArgument username;
    private StringArgument groupname;
    private BooleanArgument showUsage;
    private String user;
    private String group;
    private String ipath;

    public static void main(String[] args) {
        try {
            QuickSetupLog.initLogFileHandler(File.createTempFile(LOG_FILE_PREFIX, ".log"));
        }
        catch (Throwable t) {
            System.err.println(QuickSetupMessages.INFO_ERROR_INITIALIZING_LOG.get());
            t.printStackTrace();
        }
        try {
            Configurator configurator = new Configurator(args);
            configurator.parseArgs(args);
            configurator.configure();
        }
        catch (ApplicationException ae) {
            LOG.log(Level.SEVERE, "Error during config: " + ae.getMessageObject());
            System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
        }
    }

    private void parseArgs(String[] args) {
        String cmd = null;
        Process proc = null;
        int exit = 0;
        try {
            this.argParser.parseArguments(args);
            if (this.argParser.usageOrVersionDisplayed()) {
                System.exit(ReturnCode.PRINT_USAGE.getReturnCode());
            }
            this.ipath = this.iPath.hasValue() ? this.iPath.getValue() : "/var/opends";
            File f = new File(this.ipath);
            if (f.exists()) {
                File[] l;
                if (!f.isDirectory()) {
                    System.err.println(ToolMessages.ERR_CONFIGURE_NOT_DIRECTORY.get(this.ipath));
                    System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
                }
                if ((l = f.listFiles()).length != 0) {
                    System.err.println(ToolMessages.ERR_CONFIGURE_DIRECTORY_NOT_EMPTY.get(this.ipath));
                    System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
                }
                if (!f.canWrite()) {
                    System.err.println(ToolMessages.ERR_CONFIGURE_DIRECTORY_NOT_WRITABLE.get(this.ipath));
                    System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
                }
            } else {
                File parent;
                for (parent = f; parent != null && !parent.exists(); parent = parent.getParentFile()) {
                }
                if (parent != null && !parent.canWrite()) {
                    System.err.println(ToolMessages.ERR_CONFIGURE_DIRECTORY_NOT_WRITABLE.get(parent.getName()));
                    System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
                }
                f.mkdirs();
            }
            File temp = File.createTempFile(Configurator.class.getName(), null);
            if (this.username.hasValue()) {
                this.user = this.username.getValue();
                if (!Character.isLetter(this.user.charAt(0))) {
                    System.err.println(ToolMessages.ERR_CONFIGURE_BAD_USER_NAME.get(this.user));
                    System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
                }
                cmd = "id " + this.user;
                proc = Runtime.getRuntime().exec(cmd);
                proc.waitFor();
                exit = proc.exitValue();
                if (exit != 0) {
                    LOG.log(Level.SEVERE, "[" + cmd + "] returns " + exit);
                    System.err.println(ToolMessages.ERR_CONFIGURE_USER_NOT_EXIST.get(this.user));
                    System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
                }
            } else {
                this.user = "ldap";
                cmd = "id " + this.user;
                proc = Runtime.getRuntime().exec(cmd);
                proc.waitFor();
                exit = proc.exitValue();
                if (exit != 0) {
                    LOG.log(Level.SEVERE, "[" + cmd + "] returns " + exit);
                    System.err.println(ToolMessages.ERR_CONFIGURE_LDAPUSER_NOT_EXIST.get(this.user));
                    System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
                }
            }
            if (!this.groupname.hasValue()) {
                int c;
                InputStreamReader reader = null;
                StringBuffer sb = new StringBuffer();
                cmd = "groups " + this.user;
                proc = Runtime.getRuntime().exec(cmd);
                proc.waitFor();
                reader = new InputStreamReader(proc.getInputStream());
                while ((c = reader.read()) != -1 && c != 32) {
                    sb.append((char)c);
                }
                exit = proc.exitValue();
                if (exit != 0) {
                    LOG.log(Level.SEVERE, "[" + cmd + "] returns " + exit);
                    System.err.println(ToolMessages.ERR_CONFIGURE_GET_GROUP_ERROR.get(this.user, this.user));
                    System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
                }
                this.group = sb.toString();
            } else {
                this.group = this.groupname.getValue();
            }
            cmd = "chown " + this.user + ":" + this.group + " " + temp.getPath();
            proc = Runtime.getRuntime().exec(cmd);
            proc.waitFor();
            exit = proc.exitValue();
            if (exit != 0) {
                LOG.log(Level.SEVERE, "[" + cmd + "] returns " + exit);
                System.err.println(ToolMessages.ERR_CONFIGURE_CHMOD_ERROR.get(this.user, this.group, this.user, this.group));
                System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
            }
            temp.delete();
        }
        catch (InterruptedException ex) {
            System.err.println(ex.getLocalizedMessage());
            this.printUsage(false);
            System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
        }
        catch (IOException ex) {
            System.err.println(ex.getLocalizedMessage());
            this.printUsage(false);
            System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
        }
        catch (ArgumentException ae) {
            System.err.println(ae.getMessageObject());
            this.printUsage(false);
            System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
        }
    }

    private void configure() throws ApplicationException {
        File templ_dir = new File(this.installRootFromSystem + "/" + "tmpl_instance");
        String cmd = null;
        Process proc = null;
        int exit = 0;
        try {
            File[] l = templ_dir.listFiles();
            for (int i = 0; i < l.length; ++i) {
                File subf = l[i];
                cmd = subf.isDirectory() ? "cp -R " + l[i].getAbsolutePath() + " " + this.ipath : "cp " + l[i].getAbsolutePath() + " " + this.ipath;
                proc = Runtime.getRuntime().exec(cmd);
                proc.waitFor();
                exit = proc.exitValue();
                if (exit == 0) continue;
                LOG.log(Level.SEVERE, "[" + cmd + "] returns " + exit);
                System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
            }
            cmd = "chown -R " + this.user + ":" + this.group + " " + this.ipath;
            proc = Runtime.getRuntime().exec(cmd);
            proc.waitFor();
            exit = proc.exitValue();
            if (exit != 0) {
                LOG.log(Level.SEVERE, "[" + cmd + "] returns " + exit);
                System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
            }
            File iloc = new File("/etc/opends/instance.loc");
            iloc.getParentFile().mkdirs();
            iloc.createNewFile();
            FileWriter instanceLoc = new FileWriter(iloc);
            instanceLoc.write(this.ipath);
            instanceLoc.close();
        }
        catch (IOException ex) {
            System.err.println(ex.getLocalizedMessage());
            this.printUsage(false);
            System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
        }
        catch (InterruptedException ex) {
            System.err.println(ex.getLocalizedMessage());
            this.printUsage(false);
            System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
        }
    }

    private Configurator(String[] args) {
        super(args);
        String scriptName = "configure";
        if (Utils.isWindows()) {
            System.err.println("Not supported platform: Windows");
            System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
        } else {
            scriptName = "configure";
        }
        if (System.getProperty("org.opends.server.scriptName") == null) {
            System.setProperty("org.opends.server.scriptName", scriptName);
        }
        this.installRootFromSystem = System.getProperty("INSTALL_ROOT");
        if (this.installRootFromSystem == null) {
            System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
        }
        this.argParser = new ArgumentParser(this.getClass().getName(), ToolMessages.INFO_CONFIGURE_USAGE_DESCRIPTION.get(), false);
        try {
            this.iPath = new StringArgument(IPATH_OPTION_LONG, IPATH_OPTION_SHORT, IPATH_OPTION_LONG, false, true, ToolMessages.INFO_IPATH_PLACEHOLDER.get(), ToolMessages.INFO_CONFIGURE_DESCRIPTION_IPATH.get());
            this.argParser.addArgument(this.iPath);
            this.username = new StringArgument(USERNAME_OPTION_LONG, USERNAME_OPTION_SHORT, USERNAME_OPTION_LONG, false, true, ToolMessages.INFO_USER_NAME_PLACEHOLDER.get(), ToolMessages.INFO_CONFIGURE_DESCRIPTION_USERNAME.get());
            this.argParser.addArgument(this.username);
            this.groupname = new StringArgument(GROUPNAME_OPTION_LONG, GROUPNAME_OPTION_SHORT, GROUPNAME_OPTION_LONG, false, true, ToolMessages.INFO_GROUPNAME_PLACEHOLDER.get(), ToolMessages.INFO_CONFIGURE_DESCRIPTION_GROUPNAME.get());
            this.argParser.addArgument(this.groupname);
            this.showUsage = new BooleanArgument("showusage", Character.valueOf('H'), "help", ToolMessages.INFO_DESCRIPTION_USAGE.get());
            this.argParser.addArgument(this.showUsage);
            this.argParser.setUsageArgument(this.showUsage);
        }
        catch (ArgumentException ae) {
            System.err.println(ae.getMessageObject());
            this.printUsage(false);
            System.exit(ReturnCode.APPLICATION_ERROR.getReturnCode());
        }
    }

    protected void willLaunchGui() {
    }

    protected void guiLaunchFailed(String logFilePath) {
    }

    protected CliApplication createCliApplication() {
        return null;
    }

    protected Message getFrameTitle() {
        return null;
    }

    public ArgumentParser getArgumentParser() {
        return this.argParser;
    }
}

