/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsconfig;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.opends.messages.DSConfigMessages;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.quicksetup.util.Utils;
import org.opends.server.admin.AttributeTypePropertyDefinition;
import org.opends.server.admin.ClassLoaderProvider;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.SetRelationDefinition;
import org.opends.server.admin.Tag;
import org.opends.server.admin.client.ManagedObjectDecodingException;
import org.opends.server.admin.client.MissingMandatoryPropertiesException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.ToolConstants;
import org.opends.server.tools.dsconfig.ArgumentExceptionFactory;
import org.opends.server.tools.dsconfig.CreateSubCommandHandler;
import org.opends.server.tools.dsconfig.DeleteSubCommandHandler;
import org.opends.server.tools.dsconfig.GetPropSubCommandHandler;
import org.opends.server.tools.dsconfig.LDAPManagementContextFactory;
import org.opends.server.tools.dsconfig.ListSubCommandHandler;
import org.opends.server.tools.dsconfig.ManagementContextFactory;
import org.opends.server.tools.dsconfig.SetPropSubCommandHandler;
import org.opends.server.tools.dsconfig.SubCommandHandler;
import org.opends.server.tools.dsconfig.SubCommandHandlerFactory;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.InitializationException;
import org.opends.server.util.EmbeddedUtils;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentGroup;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.args.SubCommand;
import org.opends.server.util.args.SubCommandArgumentParser;
import org.opends.server.util.cli.CLIException;
import org.opends.server.util.cli.CommandBuilder;
import org.opends.server.util.cli.ConsoleApplication;
import org.opends.server.util.cli.Menu;
import org.opends.server.util.cli.MenuBuilder;
import org.opends.server.util.cli.MenuCallback;
import org.opends.server.util.cli.MenuResult;
import org.opends.server.util.cli.OutputStreamConsoleApplication;

public final class DSConfig
extends ConsoleApplication {
    public static final String CUSTOM_TYPE = "custom";
    public static final String GENERIC_TYPE = "generic";
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final boolean alwaysSSL = true;
    private long sessionStartTime;
    private boolean sessionStartTimePrinted = false;
    private int sessionEquivalentOperationNumber = 0;
    private BooleanArgument advancedModeArgument;
    private boolean environmentInitialized = false;
    private final ManagementContextFactory factory;
    private boolean globalArgumentsInitialized = false;
    private SubCommandHandlerFactory handlerFactory = null;
    private final Map<SubCommand, SubCommandHandler> handlers = new HashMap<SubCommand, SubCommandHandler>();
    private boolean hasSubCommand = true;
    private StringArgument batchFileArgument;
    private BooleanArgument noPromptArgument;
    private BooleanArgument displayEquivalentArgument;
    private StringArgument equivalentCommandFileArgument;
    private final SubCommandArgumentParser parser = new SubCommandArgumentParser(this.getClass().getName(), ToolMessages.INFO_CONFIGDS_TOOL_DESCRIPTION.get(), false);
    private BooleanArgument quietArgument;
    private BooleanArgument scriptFriendlyArgument;
    private BooleanArgument showUsageArgument;
    private BooleanArgument verboseArgument;
    private StringArgument propertiesFileArgument;
    private BooleanArgument noPropertiesFileArgument;

    public static void main(String[] args) {
        int exitCode = DSConfig.main(args, true, System.out, System.err);
        if (exitCode != 0) {
            System.exit(StaticUtils.filterExitCode(exitCode));
        }
    }

    public static int main(String[] args, boolean initializeServer, OutputStream outStream, OutputStream errStream) {
        DSConfig app = new DSConfig(System.in, outStream, errStream, new LDAPManagementContextFactory(true));
        app.sessionStartTime = System.currentTimeMillis();
        if (initializeServer) {
            try {
                app.initializeClientEnvironment();
            }
            catch (InitializationException e) {
                app.println(e.getMessageObject());
                return 1;
            }
        }
        return app.run(args);
    }

    private DSConfig(InputStream in, OutputStream out, OutputStream err, ManagementContextFactory factory) {
        super(in, out, err);
        this.factory = factory;
    }

    private void initializeClientEnvironment() throws InitializationException {
        if (!this.environmentInitialized) {
            EmbeddedUtils.initializeForClientUse();
            ClassLoaderProvider.getInstance().enable();
            ClassPropertyDefinition.setAllowClassValidation(false);
            AttributeTypePropertyDefinition.setCheckSchema(false);
            this.environmentInitialized = true;
        }
    }

    public boolean isAdvancedMode() {
        return this.advancedModeArgument.isPresent();
    }

    public boolean isInteractive() {
        return !this.noPromptArgument.isPresent();
    }

    public boolean isMenuDrivenMode() {
        return !this.hasSubCommand;
    }

    public boolean isQuiet() {
        return this.quietArgument.isPresent();
    }

    public boolean isScriptFriendly() {
        return this.scriptFriendlyArgument.isPresent();
    }

    public boolean isVerbose() {
        return this.verboseArgument.isPresent();
    }

    private void displayMessageAndUsageReference(Message message) {
        this.println(message);
        this.println();
        this.println(this.parser.getHelpUsageReference());
    }

    private void initializeGlobalArguments(String[] args) throws ArgumentException {
        if (!this.globalArgumentsInitialized) {
            this.verboseArgument = new BooleanArgument("verbose", Character.valueOf('v'), "verbose", ToolMessages.INFO_DESCRIPTION_VERBOSE.get());
            this.quietArgument = new BooleanArgument("quiet", ToolConstants.OPTION_SHORT_QUIET, "quiet", ToolMessages.INFO_DESCRIPTION_QUIET.get());
            this.quietArgument.setPropertyName("quiet");
            this.scriptFriendlyArgument = new BooleanArgument("script-friendly", ToolConstants.OPTION_SHORT_SCRIPT_FRIENDLY, "script-friendly", ToolMessages.INFO_DESCRIPTION_SCRIPT_FRIENDLY.get());
            this.scriptFriendlyArgument.setPropertyName("script-friendly");
            this.noPromptArgument = new BooleanArgument("no-prompt", ToolConstants.OPTION_SHORT_NO_PROMPT, "no-prompt", ToolMessages.INFO_DESCRIPTION_NO_PROMPT.get());
            this.advancedModeArgument = new BooleanArgument("advanced", ToolConstants.OPTION_DSCFG_SHORT_ADVANCED, "advanced", DSConfigMessages.INFO_DSCFG_DESCRIPTION_ADVANCED.get());
            this.advancedModeArgument.setPropertyName("advanced");
            this.showUsageArgument = new BooleanArgument("showUsage", Character.valueOf('H'), "help", DSConfigMessages.INFO_DSCFG_DESCRIPTION_SHOW_GROUP_USAGE_SUMMARY.get());
            this.batchFileArgument = new StringArgument("batchFilePath", Character.valueOf('F'), "batchFilePath", false, false, true, ToolMessages.INFO_BATCH_FILE_PATH_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_BATCH_FILE_PATH.get());
            this.displayEquivalentArgument = new BooleanArgument("displayCommand", null, "displayCommand", DSConfigMessages.INFO_DSCFG_DESCRIPTION_DISPLAY_EQUIVALENT.get());
            this.advancedModeArgument.setPropertyName("displayCommand");
            this.equivalentCommandFileArgument = new StringArgument("commandFilePath", null, "commandFilePath", false, false, true, ToolMessages.INFO_PATH_PLACEHOLDER.get(), null, null, DSConfigMessages.INFO_DSCFG_DESCRIPTION_EQUIVALENT_COMMAND_FILE_PATH.get());
            this.propertiesFileArgument = new StringArgument("propertiesFilePath", null, "propertiesFilePath", false, false, true, ToolMessages.INFO_PROP_FILE_PATH_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_PROP_FILE_PATH.get());
            this.noPropertiesFileArgument = new BooleanArgument("noPropertiesFileArgument", null, "noPropertiesFile", ToolMessages.INFO_DESCRIPTION_NO_PROP_FILE.get());
            ArgumentGroup toolOptionsGroup = new ArgumentGroup(ToolMessages.INFO_DESCRIPTION_CONFIG_OPTIONS_ARGS.get(), 2);
            this.parser.addGlobalArgument(this.advancedModeArgument, toolOptionsGroup);
            this.parser.addGlobalArgument(this.showUsageArgument);
            this.parser.setUsageArgument(this.showUsageArgument, this.getOutputStream());
            this.parser.addGlobalArgument(this.verboseArgument);
            this.parser.addGlobalArgument(this.quietArgument);
            this.parser.addGlobalArgument(this.scriptFriendlyArgument);
            this.parser.addGlobalArgument(this.noPromptArgument);
            this.parser.addGlobalArgument(this.batchFileArgument);
            this.parser.addGlobalArgument(this.displayEquivalentArgument);
            this.parser.addGlobalArgument(this.equivalentCommandFileArgument);
            this.parser.addGlobalArgument(this.propertiesFileArgument);
            this.parser.setFilePropertiesArgument(this.propertiesFileArgument);
            this.parser.addGlobalArgument(this.noPropertiesFileArgument);
            this.parser.setNoPropertiesFileArgument(this.noPropertiesFileArgument);
            this.factory.setRawArguments(args);
            this.factory.registerGlobalArguments(this.parser);
            this.globalArgumentsInitialized = true;
        }
    }

    private void initializeSubCommands() throws ArgumentException {
        if (this.handlerFactory == null) {
            this.handlerFactory = new SubCommandHandlerFactory(this.parser);
            Comparator<SubCommand> c = new Comparator<SubCommand>(){

                @Override
                public int compare(SubCommand o1, SubCommand o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            };
            TreeMap<Tag, TreeSet<SubCommand>> groups = new TreeMap<Tag, TreeSet<SubCommand>>();
            TreeSet<SubCommand> allSubCommands = new TreeSet<SubCommand>(c);
            for (SubCommandHandler subCommandHandler : this.handlerFactory.getAllSubCommandHandlers()) {
                SubCommand sc = subCommandHandler.getSubCommand();
                this.handlers.put(sc, subCommandHandler);
                allSubCommands.add(sc);
                for (Tag tag : subCommandHandler.getTags()) {
                    TreeSet<SubCommand> group = (TreeSet<SubCommand>)groups.get(tag);
                    if (group == null) {
                        group = new TreeSet<SubCommand>(c);
                        groups.put(tag, group);
                    }
                    group.add(sc);
                }
            }
            for (Map.Entry entry : groups.entrySet()) {
                Tag tag = (Tag)entry.getKey();
                SortedSet subCommands = (SortedSet)entry.getValue();
                String option = "help-" + tag.getName();
                String synopsis = tag.getSynopsis().toString().toLowerCase();
                BooleanArgument arg = new BooleanArgument(option, null, option, DSConfigMessages.INFO_DSCFG_DESCRIPTION_SHOW_GROUP_USAGE.get(synopsis));
                this.parser.addGlobalArgument(arg);
                this.parser.setUsageGroupArgument(arg, subCommands);
            }
            String option = "help-all";
            BooleanArgument booleanArgument = new BooleanArgument(option, null, option, DSConfigMessages.INFO_DSCFG_DESCRIPTION_SHOW_GROUP_USAGE_ALL.get());
            this.parser.addGlobalArgument(booleanArgument);
            this.parser.setUsageGroupArgument(booleanArgument, allSubCommands);
        }
    }

    private int run(String[] args) {
        try {
            this.initializeGlobalArguments(args);
            this.initializeSubCommands();
        }
        catch (ArgumentException e) {
            Message message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(e.getMessage());
            this.println(message);
            return 1;
        }
        try {
            this.parser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            Message message = ToolMessages.ERR_ERROR_PARSING_ARGS.get(ae.getMessage());
            this.displayMessageAndUsageReference(message);
            return 1;
        }
        if (this.parser.usageOrVersionDisplayed()) {
            return 0;
        }
        if (this.quietArgument.isPresent() && this.verboseArgument.isPresent()) {
            Message message = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(this.quietArgument.getLongIdentifier(), this.verboseArgument.getLongIdentifier());
            this.displayMessageAndUsageReference(message);
            return 1;
        }
        if (this.batchFileArgument.isPresent() && !this.noPromptArgument.isPresent()) {
            Message message = ToolMessages.ERR_DSCFG_ERROR_BATCH_FILE_AND_INTERACTIVE_INCOMPATIBLE.get(this.batchFileArgument.getLongIdentifier(), this.noPromptArgument.getLongIdentifier());
            this.displayMessageAndUsageReference(message);
            return 1;
        }
        if (this.quietArgument.isPresent() && !this.noPromptArgument.isPresent()) {
            Message message = ToolMessages.ERR_DSCFG_ERROR_QUIET_AND_INTERACTIVE_INCOMPATIBLE.get(this.quietArgument.getLongIdentifier(), this.noPromptArgument.getLongIdentifier());
            this.displayMessageAndUsageReference(message);
            return 1;
        }
        if (this.scriptFriendlyArgument.isPresent() && this.verboseArgument.isPresent()) {
            Message message = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(this.scriptFriendlyArgument.getLongIdentifier(), this.verboseArgument.getLongIdentifier());
            this.displayMessageAndUsageReference(message);
            return 1;
        }
        if (this.noPropertiesFileArgument.isPresent() && this.propertiesFileArgument.isPresent()) {
            Message message = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(this.noPropertiesFileArgument.getLongIdentifier(), this.propertiesFileArgument.getLongIdentifier());
            this.displayMessageAndUsageReference(message);
            return 1;
        }
        if (this.equivalentCommandFileArgument.isPresent()) {
            String file = this.equivalentCommandFileArgument.getValue();
            if (!Utils.canWrite(file)) {
                this.println(DSConfigMessages.ERR_DSCFG_CANNOT_WRITE_EQUIVALENT_COMMAND_LINE_FILE.get(file));
                return 1;
            }
            File f = new File(file);
            if (f.isDirectory()) {
                this.println(DSConfigMessages.ERR_DSCFG_EQUIVALENT_COMMAND_LINE_FILE_DIRECTORY.get(file));
                return 1;
            }
        }
        try {
            this.factory.validateGlobalArguments();
        }
        catch (ArgumentException e) {
            this.println(e.getMessageObject());
            return 1;
        }
        if (this.batchFileArgument.isPresent()) {
            this.handleBatchFile(args);
            return 0;
        }
        int retCode = 0;
        if (this.parser.getSubCommand() == null) {
            this.hasSubCommand = false;
            if (this.isInteractive()) {
                retCode = this.runInteractiveMode();
            } else {
                Message message = ToolMessages.ERR_ERROR_PARSING_ARGS.get(DSConfigMessages.ERR_DSCFG_ERROR_MISSING_SUBCOMMAND.get());
                this.displayMessageAndUsageReference(message);
                retCode = 1;
            }
        } else {
            this.hasSubCommand = true;
            SubCommandHandler handler = this.handlers.get(this.parser.getSubCommand());
            retCode = this.runSubCommand(handler);
        }
        try {
            this.factory.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retCode;
    }

    private int runInteractiveMode() {
        OutputStreamConsoleApplication app = new OutputStreamConsoleApplication(this);
        Comparator c = new Comparator<RelationDefinition<?, ?>>(){

            @Override
            public int compare(RelationDefinition<?, ?> rd1, RelationDefinition<?, ?> rd2) {
                String s1 = rd1.getUserFriendlyName().toString();
                String s2 = rd2.getUserFriendlyName().toString();
                return s1.compareToIgnoreCase(s2);
            }
        };
        TreeSet relations = new TreeSet(c);
        HashMap createHandlers = new HashMap();
        HashMap deleteHandlers = new HashMap();
        HashMap listHandlers = new HashMap();
        HashMap getPropHandlers = new HashMap();
        HashMap setPropHandlers = new HashMap();
        for (CreateSubCommandHandler createSubCommandHandler : this.handlerFactory.getCreateSubCommandHandlers()) {
            relations.add(createSubCommandHandler.getRelationDefinition());
            createHandlers.put(createSubCommandHandler.getRelationDefinition(), createSubCommandHandler);
        }
        for (DeleteSubCommandHandler deleteSubCommandHandler : this.handlerFactory.getDeleteSubCommandHandlers()) {
            relations.add(deleteSubCommandHandler.getRelationDefinition());
            deleteHandlers.put(deleteSubCommandHandler.getRelationDefinition(), deleteSubCommandHandler);
        }
        for (ListSubCommandHandler listSubCommandHandler : this.handlerFactory.getListSubCommandHandlers()) {
            relations.add(listSubCommandHandler.getRelationDefinition());
            listHandlers.put(listSubCommandHandler.getRelationDefinition(), listSubCommandHandler);
        }
        for (GetPropSubCommandHandler getPropSubCommandHandler : this.handlerFactory.getGetPropSubCommandHandlers()) {
            relations.add(getPropSubCommandHandler.getRelationDefinition());
            getPropHandlers.put(getPropSubCommandHandler.getRelationDefinition(), getPropSubCommandHandler);
        }
        for (SetPropSubCommandHandler setPropSubCommandHandler : this.handlerFactory.getSetPropSubCommandHandlers()) {
            relations.add(setPropSubCommandHandler.getRelationDefinition());
            setPropHandlers.put(setPropSubCommandHandler.getRelationDefinition(), setPropSubCommandHandler);
        }
        MenuBuilder<Integer> builder = new MenuBuilder<Integer>(app);
        builder.setTitle(DSConfigMessages.INFO_DSCFG_HEADING_MAIN_MENU_TITLE.get());
        builder.setPrompt(DSConfigMessages.INFO_DSCFG_HEADING_MAIN_MENU_PROMPT.get());
        builder.setMultipleColumnThreshold(0);
        for (RelationDefinition relationDefinition : relations) {
            SubMenuCallback callback = new SubMenuCallback(app, relationDefinition, (CreateSubCommandHandler)createHandlers.get(relationDefinition), (DeleteSubCommandHandler)deleteHandlers.get(relationDefinition), (ListSubCommandHandler)listHandlers.get(relationDefinition), (SetPropSubCommandHandler)setPropHandlers.get(relationDefinition));
            builder.addNumberedOption(relationDefinition.getUserFriendlyName(), callback, new Message[0]);
        }
        builder.addQuitOption();
        Menu menu = builder.toMenu();
        try {
            this.factory.getManagementContext(app);
        }
        catch (ArgumentException argumentException) {
            app.println(argumentException.getMessageObject());
            return 1;
        }
        catch (ClientException clientException) {
            app.println(clientException.getMessageObject());
            return 1;
        }
        try {
            app.println();
            app.println();
            MenuResult menuResult = menu.run();
            if (menuResult.isQuit()) {
                return 0;
            }
            return (Integer)menuResult.getValue();
        }
        catch (CLIException cLIException) {
            app.println(cLIException.getMessageObject());
            return 1;
        }
    }

    private int runSubCommand(SubCommandHandler handler) {
        try {
            MenuResult<Integer> result = handler.run(this, this.factory);
            if (result.isSuccess()) {
                if (this.isInteractive() && handler.isCommandBuilderUseful()) {
                    this.printCommandBuilder(this.getCommandBuilder(handler));
                }
                return result.getValue();
            }
            return 1;
        }
        catch (ArgumentException e) {
            this.println(e.getMessageObject());
            return 1;
        }
        catch (CLIException e) {
            this.println(e.getMessageObject());
            return 1;
        }
        catch (ClientException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ManagedObjectDecodingException) {
                ManagedObjectDecodingException de = (ManagedObjectDecodingException)cause;
                this.println();
                ArgumentExceptionFactory.displayManagedObjectDecodingException(this, de);
                this.println();
            } else if (cause instanceof MissingMandatoryPropertiesException) {
                MissingMandatoryPropertiesException mmpe = (MissingMandatoryPropertiesException)cause;
                this.println();
                ArgumentExceptionFactory.displayMissingMandatoryPropertyException(this, mmpe);
                this.println();
            } else if (cause instanceof OperationRejectedException) {
                OperationRejectedException ore = (OperationRejectedException)cause;
                this.println();
                ArgumentExceptionFactory.displayOperationRejectedException(this, ore);
                this.println();
            } else {
                this.println(e.getMessageObject());
            }
            return 1;
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            this.println(Message.raw(StaticUtils.stackTraceToString(e), new Object[0]));
            return 1;
        }
    }

    private CommandBuilder getCommandBuilder(SubCommandHandler handler) {
        String commandName = System.getProperty("org.opends.server.scriptName");
        if (commandName == null) {
            commandName = "dsconfig";
        }
        CommandBuilder commandBuilder = new CommandBuilder(commandName, handler.getSubCommand().getName());
        commandBuilder.append(handler.getCommandBuilder());
        if (this.factory != null && this.factory.getContextCommandBuilder() != null) {
            commandBuilder.append(this.factory.getContextCommandBuilder());
        }
        if (this.verboseArgument.isPresent()) {
            commandBuilder.addArgument(this.verboseArgument);
        }
        if (this.scriptFriendlyArgument.isPresent()) {
            commandBuilder.addArgument(this.scriptFriendlyArgument);
        }
        commandBuilder.addArgument(this.noPromptArgument);
        if (this.propertiesFileArgument.isPresent()) {
            commandBuilder.addArgument(this.propertiesFileArgument);
        }
        if (this.noPropertiesFileArgument.isPresent()) {
            commandBuilder.addArgument(this.noPropertiesFileArgument);
        }
        return commandBuilder;
    }

    CommandBuilder getCommandBuilder(String subcommandName) {
        String commandName = System.getProperty("org.opends.server.scriptName");
        if (commandName == null) {
            commandName = "dsconfig";
        }
        CommandBuilder commandBuilder = new CommandBuilder(commandName, subcommandName);
        if (this.factory != null && this.factory.getContextCommandBuilder() != null) {
            commandBuilder.append(this.factory.getContextCommandBuilder());
        }
        if (this.verboseArgument.isPresent()) {
            commandBuilder.addArgument(this.verboseArgument);
        }
        if (this.scriptFriendlyArgument.isPresent()) {
            commandBuilder.addArgument(this.scriptFriendlyArgument);
        }
        commandBuilder.addArgument(this.noPromptArgument);
        if (this.propertiesFileArgument.isPresent()) {
            commandBuilder.addArgument(this.propertiesFileArgument);
        }
        if (this.noPropertiesFileArgument.isPresent()) {
            commandBuilder.addArgument(this.noPropertiesFileArgument);
        }
        return commandBuilder;
    }

    void printCommandBuilder(CommandBuilder commandBuilder) {
        if (this.displayEquivalentArgument.isPresent()) {
            this.println();
            this.println(DSConfigMessages.INFO_DSCFG_NON_INTERACTIVE.get(commandBuilder.toString()));
        }
        if (this.equivalentCommandFileArgument.isPresent()) {
            String file = this.equivalentCommandFileArgument.getValue();
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(file, true));
                if (!this.sessionStartTimePrinted) {
                    writer.write(SHELL_COMMENT_SEPARATOR + this.getSessionStartTimeMessage());
                    writer.newLine();
                    this.sessionStartTimePrinted = true;
                }
                ++this.sessionEquivalentOperationNumber;
                writer.newLine();
                writer.write(SHELL_COMMENT_SEPARATOR + DSConfigMessages.INFO_DSCFG_EQUIVALENT_COMMAND_LINE_SESSION_OPERATION_NUMBER.get(this.sessionEquivalentOperationNumber));
                writer.newLine();
                writer.write(SHELL_COMMENT_SEPARATOR + this.getCurrentOperationDateMessage());
                writer.newLine();
                writer.write(commandBuilder.toString());
                writer.newLine();
                writer.newLine();
                writer.flush();
                writer.close();
            }
            catch (IOException ioe) {
                this.println(DSConfigMessages.ERR_DSCFG_ERROR_WRITING_EQUIVALENT_COMMAND_LINE.get(file, ioe.toString()));
            }
        }
    }

    private String getSessionStartTimeMessage() {
        String scriptName = System.getProperty("org.opends.server.scriptName");
        if (scriptName == null || scriptName.length() == 0) {
            scriptName = "dsconfig";
        }
        String date = this.formatDateTimeStringForEquivalentCommand(new Date(this.sessionStartTime));
        return DSConfigMessages.INFO_DSCFG_SESSION_START_TIME_MESSAGE.get(scriptName, date).toString();
    }

    private void handleBatchFile(String[] args) {
        BufferedReader reader = null;
        try {
            String line;
            ArrayList initialArgs = new ArrayList();
            Collections.addAll(initialArgs, args);
            int batchFileArgIndex = -1;
            for (String elem : initialArgs) {
                if (!elem.startsWith("-F") && !elem.contains("batchFilePath")) continue;
                batchFileArgIndex = initialArgs.indexOf(elem);
                break;
            }
            if (batchFileArgIndex != -1) {
                initialArgs.remove(batchFileArgIndex);
                initialArgs.remove(batchFileArgIndex);
            }
            String batchFilePath = this.batchFileArgument.getValue().trim();
            reader = new BufferedReader(new FileReader(batchFilePath));
            String command = "";
            while ((line = reader.readLine()) != null) {
                if (line.equals("") || line.startsWith("#")) continue;
                if (line.endsWith("\\")) {
                    command = command + line.substring(0, line.length() - 1);
                    continue;
                }
                command = command + line;
                command = command.trim();
                command = this.replaceSpacesInQuotes(command);
                command = command.replace("\\ ", "##");
                String[] fileArguments = command.split("\\s+");
                command = "";
                for (int ii = 0; ii < fileArguments.length; ++ii) {
                    fileArguments[ii] = fileArguments[ii].replace("##", " ");
                    System.out.println(fileArguments[ii]);
                }
                ArrayList allArguments = new ArrayList();
                Collections.addAll(allArguments, fileArguments);
                allArguments.addAll(initialArgs);
                String[] allArgsArray = allArguments.toArray(new String[0]);
                StringBuffer cli = new StringBuffer();
                for (String arg : allArgsArray) {
                    cli.append(arg + " ");
                }
                int exitCode = DSConfig.main(allArgsArray, false, this.getOutputStream(), this.getErrorStream());
                if (exitCode == 0) continue;
                reader.close();
                System.exit(StaticUtils.filterExitCode(exitCode));
            }
            reader.close();
        }
        catch (IOException ex) {
            this.println(DSConfigMessages.ERR_DSCFG_ERROR_READING_BATCH_FILE.get(ex.toString()));
        }
    }

    private String replaceSpacesInQuotes(String line) {
        String newLine = "";
        boolean inQuotes = false;
        for (int ii = 0; ii < line.length(); ++ii) {
            char ch = line.charAt(ii);
            if (ch == '\"' || ch == '\'') {
                if (!inQuotes) {
                    inQuotes = true;
                    continue;
                }
                inQuotes = false;
                continue;
            }
            newLine = inQuotes && ch == ' ' ? newLine + "\\ " : newLine + ch;
        }
        return newLine;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SubMenuCallback
    implements MenuCallback<Integer> {
        private final Menu<Integer> menu;

        public SubMenuCallback(ConsoleApplication app, RelationDefinition<?, ?> rd, CreateSubCommandHandler<?, ?> ch, DeleteSubCommandHandler dh, ListSubCommandHandler lh, SetPropSubCommandHandler sh) {
            SubCommandHandlerMenuCallback callback;
            Message ufn = rd.getUserFriendlyName();
            Message ufpn = null;
            if (rd instanceof InstantiableRelationDefinition) {
                InstantiableRelationDefinition ir = (InstantiableRelationDefinition)rd;
                ufpn = ir.getUserFriendlyPluralName();
            } else if (rd instanceof SetRelationDefinition) {
                SetRelationDefinition sr = (SetRelationDefinition)rd;
                ufpn = sr.getUserFriendlyPluralName();
            }
            MenuBuilder<Integer> builder = new MenuBuilder<Integer>(app);
            builder.setTitle(DSConfigMessages.INFO_DSCFG_HEADING_COMPONENT_MENU_TITLE.get(ufn));
            builder.setPrompt(DSConfigMessages.INFO_DSCFG_HEADING_COMPONENT_MENU_PROMPT.get());
            if (lh != null) {
                callback = new SubCommandHandlerMenuCallback(lh);
                if (ufpn != null) {
                    builder.addNumberedOption(DSConfigMessages.INFO_DSCFG_OPTION_COMPONENT_MENU_LIST_PLURAL.get(ufpn), callback, new Message[0]);
                } else {
                    builder.addNumberedOption(DSConfigMessages.INFO_DSCFG_OPTION_COMPONENT_MENU_LIST_SINGULAR.get(ufn), callback, new Message[0]);
                }
            }
            if (ch != null) {
                callback = new SubCommandHandlerMenuCallback(ch);
                builder.addNumberedOption(DSConfigMessages.INFO_DSCFG_OPTION_COMPONENT_MENU_CREATE.get(ufn), callback, new Message[0]);
            }
            if (sh != null) {
                callback = new SubCommandHandlerMenuCallback(sh);
                if (ufpn != null) {
                    builder.addNumberedOption(DSConfigMessages.INFO_DSCFG_OPTION_COMPONENT_MENU_MODIFY_PLURAL.get(ufn), callback, new Message[0]);
                } else {
                    builder.addNumberedOption(DSConfigMessages.INFO_DSCFG_OPTION_COMPONENT_MENU_MODIFY_SINGULAR.get(ufn), callback, new Message[0]);
                }
            }
            if (dh != null) {
                callback = new SubCommandHandlerMenuCallback(dh);
                builder.addNumberedOption(DSConfigMessages.INFO_DSCFG_OPTION_COMPONENT_MENU_DELETE.get(ufn), callback, new Message[0]);
            }
            builder.addBackOption(true);
            builder.addQuitOption();
            this.menu = builder.toMenu();
        }

        @Override
        public final MenuResult<Integer> invoke(ConsoleApplication app) throws CLIException {
            try {
                app.println();
                app.println();
                MenuResult<Integer> result = this.menu.run();
                if (result.isCancel()) {
                    return MenuResult.again();
                }
                return result;
            }
            catch (CLIException e) {
                app.println(e.getMessageObject());
                return MenuResult.success(1);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SubCommandHandlerMenuCallback
    implements MenuCallback<Integer> {
        private final SubCommandHandler handler;

        public SubCommandHandlerMenuCallback(SubCommandHandler handler) {
            this.handler = handler;
        }

        @Override
        public MenuResult<Integer> invoke(ConsoleApplication app) throws CLIException {
            try {
                MenuResult<Integer> result = this.handler.run(app, DSConfig.this.factory);
                if (result.isQuit()) {
                    return result;
                }
                if (result.isSuccess() && DSConfig.this.isInteractive() && this.handler.isCommandBuilderUseful()) {
                    DSConfig.this.printCommandBuilder(DSConfig.this.getCommandBuilder(this.handler));
                }
                app.println();
                app.pressReturnToContinue();
                return MenuResult.again();
            }
            catch (ArgumentException e) {
                app.println(e.getMessageObject());
                return MenuResult.success(1);
            }
            catch (ClientException e) {
                app.println(e.getMessageObject());
                return MenuResult.success(e.getExitCode());
            }
        }
    }
}

