/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.dsconfig;

import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import org.opends.messages.DSConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.InstantiableRelationDefinition;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.ManagedObjectOption;
import org.opends.server.admin.ManagedObjectPath;
import org.opends.server.admin.OptionalRelationDefinition;
import org.opends.server.admin.PropertyDefinition;
import org.opends.server.admin.RelationDefinition;
import org.opends.server.admin.SetRelationDefinition;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.ManagedObject;
import org.opends.server.admin.client.ManagedObjectDecodingException;
import org.opends.server.admin.client.ManagementContext;
import org.opends.server.tools.ClientException;
import org.opends.server.tools.dsconfig.CLIProfile;
import org.opends.server.tools.dsconfig.ManagementContextFactory;
import org.opends.server.tools.dsconfig.PropertyValuePrinter;
import org.opends.server.tools.dsconfig.SubCommandHandler;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.StringArgument;
import org.opends.server.util.args.SubCommand;
import org.opends.server.util.args.SubCommandArgumentParser;
import org.opends.server.util.cli.CLIException;
import org.opends.server.util.cli.ConsoleApplication;
import org.opends.server.util.cli.MenuResult;
import org.opends.server.util.table.TableBuilder;
import org.opends.server.util.table.TablePrinter;
import org.opends.server.util.table.TextTablePrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ListSubCommandHandler
extends SubCommandHandler {
    private final List<StringArgument> namingArgs;
    private final ManagedObjectPath<?, ?> path;
    private final RelationDefinition<?, ?> relation;
    private final SubCommand subCommand;

    public static ListSubCommandHandler create(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, InstantiableRelationDefinition<?, ?> r) throws ArgumentException {
        return new ListSubCommandHandler(parser, p, r, r.getPluralName(), r.getUserFriendlyPluralName());
    }

    public static ListSubCommandHandler create(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, SetRelationDefinition<?, ?> r) throws ArgumentException {
        return new ListSubCommandHandler(parser, p, r, r.getPluralName(), r.getUserFriendlyPluralName());
    }

    public static ListSubCommandHandler create(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, OptionalRelationDefinition<?, ?> r) throws ArgumentException {
        return new ListSubCommandHandler(parser, p, r, r.getName(), r.getUserFriendlyName());
    }

    private ListSubCommandHandler(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, RelationDefinition<?, ?> r, String rname, Message rufn) throws ArgumentException {
        this.path = p;
        this.relation = r;
        String name = "list-" + rname;
        Message desc = DSConfigMessages.INFO_DSCFG_DESCRIPTION_SUBCMD_LIST.get(rufn);
        this.subCommand = new SubCommand(parser, name, false, 0, 0, null, desc);
        this.namingArgs = this.createNamingArgs(this.subCommand, this.path, false);
        this.registerPropertyNameArgument(this.subCommand);
        this.registerUnitSizeArgument(this.subCommand);
        this.registerUnitTimeArgument(this.subCommand);
        this.addTags(this.relation.getChildDefinition().getAllTags());
    }

    public RelationDefinition<?, ?> getRelationDefinition() {
        return this.relation;
    }

    @Override
    public SubCommand getSubCommand() {
        return this.subCommand;
    }

    @Override
    public MenuResult<Integer> run(ConsoleApplication app, ManagementContextFactory factory) throws ArgumentException, ClientException, CLIException {
        MenuResult<ManagedObject<?>> result;
        Message ufn;
        Set<String> propertyNames = this.getPropertyNames();
        this.getCommandBuilder().clearArguments();
        this.updateCommandBuilderWithSubCommand();
        if (propertyNames.isEmpty()) {
            propertyNames = CLIProfile.getInstance().getDefaultListPropertyNames(this.relation);
        }
        PropertyValuePrinter valuePrinter = new PropertyValuePrinter(this.getSizeUnit(), this.getTimeUnit(), app.isScriptFriendly());
        List<String> names = this.getNamingArgValues(app, this.namingArgs);
        if (this.relation instanceof InstantiableRelationDefinition) {
            InstantiableRelationDefinition irelation = (InstantiableRelationDefinition)this.relation;
            ufn = irelation.getUserFriendlyPluralName();
        } else if (this.relation instanceof SetRelationDefinition) {
            SetRelationDefinition srelation = (SetRelationDefinition)this.relation;
            ufn = srelation.getUserFriendlyPluralName();
        } else {
            ufn = this.relation.getUserFriendlyName();
        }
        ManagementContext context = factory.getManagementContext(app);
        try {
            result = this.getManagedObject(app, context, this.path, names);
        }
        catch (AuthorizationException e) {
            Message msg = DSConfigMessages.ERR_DSCFG_ERROR_LIST_AUTHZ.get(ufn);
            throw new ClientException(50, msg);
        }
        catch (DefinitionDecodingException e) {
            ufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
            Message msg = DSConfigMessages.ERR_DSCFG_ERROR_GET_PARENT_DDE.get(ufn, ufn, ufn);
            throw new ClientException(80, msg);
        }
        catch (ManagedObjectDecodingException e) {
            ufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
            Message msg = DSConfigMessages.ERR_DSCFG_ERROR_GET_PARENT_MODE.get(ufn);
            throw new ClientException(80, msg, e);
        }
        catch (CommunicationException e) {
            Message msg = DSConfigMessages.ERR_DSCFG_ERROR_LIST_CE.get(ufn, e.getMessage());
            throw new ClientException(81, msg);
        }
        catch (ConcurrentModificationException e) {
            Message msg = DSConfigMessages.ERR_DSCFG_ERROR_LIST_CME.get(ufn);
            throw new ClientException(19, msg);
        }
        catch (ManagedObjectNotFoundException e) {
            ufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
            Message msg = DSConfigMessages.ERR_DSCFG_ERROR_GET_PARENT_MONFE.get(ufn);
            if (app.isInteractive()) {
                app.println();
                app.printVerboseMessage(msg);
                return MenuResult.cancel();
            }
            throw new ClientException(32, msg);
        }
        if (result.isQuit()) {
            return MenuResult.quit();
        }
        if (result.isCancel()) {
            return MenuResult.cancel();
        }
        ManagedObject<?> parent = result.getValue();
        TreeMap children = new TreeMap();
        if (this.relation instanceof InstantiableRelationDefinition) {
            InstantiableRelationDefinition irelation = (InstantiableRelationDefinition)this.relation;
            try {
                for (String s : parent.listChildren(irelation)) {
                    try {
                        children.put(s, parent.getChild(irelation, s));
                    }
                    catch (ManagedObjectNotFoundException e) {
                        // empty catch block
                    }
                }
            }
            catch (DefinitionDecodingException e) {
                Message msg = DSConfigMessages.ERR_DSCFG_ERROR_LIST_DDE.get(ufn, ufn, ufn);
                throw new ClientException(80, msg);
            }
            catch (ManagedObjectDecodingException e) {
                Message msg = DSConfigMessages.ERR_DSCFG_ERROR_LIST_MODE.get(ufn);
                throw new ClientException(80, msg, e);
            }
            catch (AuthorizationException e) {
                Message msg = DSConfigMessages.ERR_DSCFG_ERROR_LIST_AUTHZ.get(ufn);
                throw new ClientException(50, msg);
            }
            catch (ConcurrentModificationException e) {
                Message msg = DSConfigMessages.ERR_DSCFG_ERROR_LIST_CME.get(ufn);
                throw new ClientException(19, msg);
            }
            catch (CommunicationException e) {
                Message msg = DSConfigMessages.ERR_DSCFG_ERROR_LIST_CE.get(ufn, e.getMessage());
                throw new ClientException(81, msg);
            }
        }
        if (this.relation instanceof SetRelationDefinition) {
            SetRelationDefinition srelation = (SetRelationDefinition)this.relation;
            try {
                for (String s : parent.listChildren(srelation)) {
                    try {
                        children.put(s, parent.getChild(srelation, s));
                    }
                    catch (ManagedObjectNotFoundException e) {
                        // empty catch block
                    }
                }
            }
            catch (DefinitionDecodingException e) {
                Message msg = DSConfigMessages.ERR_DSCFG_ERROR_LIST_DDE.get(ufn, ufn, ufn);
                throw new ClientException(80, msg);
            }
            catch (ManagedObjectDecodingException e) {
                Message msg = DSConfigMessages.ERR_DSCFG_ERROR_LIST_MODE.get(ufn);
                throw new ClientException(80, msg, e);
            }
            catch (AuthorizationException e) {
                Message msg = DSConfigMessages.ERR_DSCFG_ERROR_LIST_AUTHZ.get(ufn);
                throw new ClientException(50, msg);
            }
            catch (ConcurrentModificationException e) {
                Message msg = DSConfigMessages.ERR_DSCFG_ERROR_LIST_CME.get(ufn);
                throw new ClientException(19, msg);
            }
            catch (CommunicationException e) {
                Message msg = DSConfigMessages.ERR_DSCFG_ERROR_LIST_CE.get(ufn, e.getMessage());
                throw new ClientException(81, msg);
            }
        }
        if (this.relation instanceof OptionalRelationDefinition) {
            OptionalRelationDefinition orelation = (OptionalRelationDefinition)this.relation;
            try {
                if (!parent.hasChild(orelation)) {
                    Message msg = DSConfigMessages.ERR_DSCFG_ERROR_FINDER_NO_CHILDREN.get(ufn);
                    if (app.isInteractive()) {
                        app.println();
                        app.printVerboseMessage(msg);
                        return MenuResult.cancel();
                    }
                    throw new ClientException(32, msg);
                }
                ManagedObject child = parent.getChild(orelation);
                children.put(child.getManagedObjectDefinition().getName(), child);
            }
            catch (AuthorizationException e) {
                Message msg = DSConfigMessages.ERR_DSCFG_ERROR_LIST_AUTHZ.get(ufn);
                throw new ClientException(50, msg);
            }
            catch (DefinitionDecodingException e) {
                Message msg = DSConfigMessages.ERR_DSCFG_ERROR_LIST_DDE.get(ufn, ufn, ufn);
                throw new ClientException(80, msg);
            }
            catch (ManagedObjectDecodingException e) {
                Message msg = DSConfigMessages.ERR_DSCFG_ERROR_LIST_MODE.get(ufn);
                throw new ClientException(80, msg, e);
            }
            catch (ConcurrentModificationException e) {
                Message msg = DSConfigMessages.ERR_DSCFG_ERROR_LIST_CME.get(ufn);
                throw new ClientException(19, msg);
            }
            catch (CommunicationException e) {
                Message msg = DSConfigMessages.ERR_DSCFG_ERROR_LIST_CE.get(ufn, e.getMessage());
                throw new ClientException(81, msg);
            }
            catch (ManagedObjectNotFoundException e) {
                Message msg = DSConfigMessages.ERR_DSCFG_ERROR_LIST_MONFE.get(ufn);
                throw new ClientException(32, msg);
            }
        }
        if (app.isScriptFriendly()) {
            for (String name : children.keySet()) {
                ManagedObject child;
                ManagedObjectDefinition d;
                if (!app.isAdvancedMode() && ((d = (child = (ManagedObject)children.get(name)).getManagedObjectDefinition()).hasOption(ManagedObjectOption.HIDDEN) || d.hasOption(ManagedObjectOption.ADVANCED))) continue;
                app.println(Message.raw(name, new Object[0]));
            }
        } else {
            TablePrinter printer;
            TableBuilder builder = new TableBuilder();
            builder.appendHeading(this.relation.getUserFriendlyName());
            builder.appendHeading(DSConfigMessages.INFO_DSCFG_HEADING_COMPONENT_TYPE.get());
            for (String propertyName : propertyNames) {
                builder.appendHeading(Message.raw(propertyName, new Object[0]));
            }
            builder.addSortKey(0);
            String baseType = this.relation.getChildDefinition().getName();
            String typeSuffix = "-" + baseType;
            for (String name : children.keySet()) {
                ManagedObject child = (ManagedObject)children.get(name);
                ManagedObjectDefinition d = child.getManagedObjectDefinition();
                if (!app.isAdvancedMode() && (d.hasOption(ManagedObjectOption.HIDDEN) || d.hasOption(ManagedObjectOption.ADVANCED))) continue;
                builder.startRow();
                if (this.relation instanceof SetRelationDefinition) {
                    builder.appendCell(d.getUserFriendlyName());
                } else {
                    builder.appendCell(name);
                }
                String childType = d.getName();
                boolean isCustom = CLIProfile.getInstance().isForCustomization(d);
                if (baseType.equals(childType)) {
                    if (isCustom) {
                        builder.appendCell("custom");
                    } else {
                        builder.appendCell("generic");
                    }
                } else if (childType.endsWith(typeSuffix)) {
                    String ctname = childType.substring(0, childType.length() - typeSuffix.length());
                    if (isCustom) {
                        ctname = String.format("%s-%s", "custom", ctname);
                    }
                    builder.appendCell(ctname);
                } else {
                    builder.appendCell(childType);
                }
                for (String propertyName : propertyNames) {
                    try {
                        PropertyDefinition<?> pd = d.getPropertyDefinition(propertyName);
                        this.displayProperty(app, builder, child, pd, valuePrinter);
                    }
                    catch (IllegalArgumentException e) {
                        if (app.isScriptFriendly()) {
                            builder.appendCell();
                            continue;
                        }
                        builder.appendCell("-");
                    }
                }
            }
            PrintStream out = app.getOutputStream();
            if (app.isScriptFriendly()) {
                printer = this.createScriptFriendlyTablePrinter(out);
                builder.print(printer);
            } else {
                if (app.isInteractive()) {
                    app.println();
                    app.println();
                }
                printer = new TextTablePrinter(out);
                ((TextTablePrinter)printer).setColumnSeparator(":");
                builder.print(printer);
            }
        }
        return MenuResult.success(0);
    }

    private <T> void displayProperty(ConsoleApplication app, TableBuilder builder, ManagedObject<?> mo, PropertyDefinition<T> pd, PropertyValuePrinter valuePrinter) {
        SortedSet<T> values = mo.getPropertyValues(pd);
        if (values.isEmpty()) {
            if (app.isScriptFriendly()) {
                builder.appendCell();
            } else {
                builder.appendCell("-");
            }
        } else {
            StringBuilder sb = new StringBuilder();
            boolean isFirst = true;
            for (Object value : values) {
                if (!isFirst) {
                    sb.append(", ");
                }
                sb.append(valuePrinter.print(pd, value));
                isFirst = false;
            }
            builder.appendCell(sb.toString());
        }
    }
}

