/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.SortedSet;
import java.util.zip.DataFormatException;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.Mac;
import javax.net.ssl.SSLContext;
import org.opends.server.config.ConfigException;
import org.opends.server.types.CryptoManagerException;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public interface CryptoManager {
    public String getPreferredMessageDigestAlgorithm();

    public MessageDigest getPreferredMessageDigest() throws NoSuchAlgorithmException;

    public MessageDigest getMessageDigest(String var1) throws NoSuchAlgorithmException;

    public byte[] digest(byte[] var1) throws NoSuchAlgorithmException;

    public byte[] digest(String var1, byte[] var2) throws NoSuchAlgorithmException;

    public byte[] digest(InputStream var1) throws IOException, NoSuchAlgorithmException;

    public byte[] digest(String var1, InputStream var2) throws IOException, NoSuchAlgorithmException;

    public String getMacEngineKeyEntryID() throws CryptoManagerException;

    public String getMacEngineKeyEntryID(String var1, int var2) throws CryptoManagerException;

    public Mac getMacEngine(String var1) throws CryptoManagerException;

    public byte[] encrypt(byte[] var1) throws GeneralSecurityException, CryptoManagerException;

    public byte[] encrypt(String var1, int var2, byte[] var3) throws GeneralSecurityException, CryptoManagerException;

    public CipherOutputStream getCipherOutputStream(OutputStream var1) throws CryptoManagerException;

    public CipherOutputStream getCipherOutputStream(String var1, int var2, OutputStream var3) throws CryptoManagerException;

    public byte[] decrypt(byte[] var1) throws GeneralSecurityException, CryptoManagerException;

    public CipherInputStream getCipherInputStream(InputStream var1) throws CryptoManagerException;

    public int compress(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6);

    public int uncompress(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6) throws DataFormatException;

    public SSLContext getSslContext(String var1) throws ConfigException;

    public String getSslCertNickname();

    public boolean isSslEncryption();

    public SortedSet<String> getSslProtocols();

    public SortedSet<String> getSslCipherSuites();
}

