/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.workflowelement.externalchangelog;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.opends.messages.Category;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.messages.ReplicationMessages;
import org.opends.messages.Severity;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.controls.EntryChangelogNotificationControl;
import org.opends.server.controls.ExternalChangelogRequestControl;
import org.opends.server.controls.LDAPAssertionRequestControl;
import org.opends.server.controls.MatchedValuesControl;
import org.opends.server.controls.PersistentSearchControl;
import org.opends.server.controls.ProxiedAuthV1Control;
import org.opends.server.controls.ProxiedAuthV2Control;
import org.opends.server.controls.SubentriesControl;
import org.opends.server.core.AccessControlConfigManager;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.PersistentSearch;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.core.SearchOperation;
import org.opends.server.core.SearchOperationWrapper;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.ExternalChangeLogSession;
import org.opends.server.replication.common.MultiDomainServerState;
import org.opends.server.replication.plugin.MultimasterReplication;
import org.opends.server.replication.protocol.AddMsg;
import org.opends.server.replication.protocol.DeleteMsg;
import org.opends.server.replication.protocol.ECLUpdateMsg;
import org.opends.server.replication.protocol.ModifyDNMsg;
import org.opends.server.replication.protocol.ModifyMsg;
import org.opends.server.replication.protocol.StartECLSessionMsg;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Attributes;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.CanceledOperationException;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.FilterType;
import org.opends.server.types.Modification;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.Privilege;
import org.opends.server.types.RawAttribute;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.types.operation.PostOperationSearchOperation;
import org.opends.server.types.operation.PreOperationSearchOperation;
import org.opends.server.types.operation.SearchEntrySearchOperation;
import org.opends.server.types.operation.SearchReferenceSearchOperation;
import org.opends.server.util.Base64;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;
import org.opends.server.workflowelement.externalchangelog.ECLWorkflowElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ECLSearchOperation
extends SearchOperationWrapper
implements PreOperationSearchOperation,
PostOperationSearchOperation,
SearchEntrySearchOperation,
SearchReferenceSearchOperation {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private StartECLSessionMsg startECLSessionMsg;
    private static HashMap<ObjectClass, String> eclObjectClasses;
    private DN rootBaseDN;
    protected ReplicationServer replicationServer;
    protected ClientConnection clientConnection;
    protected DN baseDN;
    protected PersistentSearch persistentSearch;
    protected SearchFilter filter;
    private ExternalChangeLogSession eclSession;
    private HashSet<String> supportedControls;
    private HashSet<String> supportedFeatures;
    String privateDomainsBaseDN;

    public ECLSearchOperation(SearchOperation search) {
        super(search);
        try {
            this.rootBaseDN = DN.decode("cn=changelog");
        }
        catch (Exception e) {
            // empty catch block
        }
        eclObjectClasses = new LinkedHashMap<ObjectClass, String>(2);
        ObjectClass topOC = DirectoryServer.getObjectClass("top", true);
        eclObjectClasses.put(topOC, "top");
        ObjectClass eclEntryOC = DirectoryServer.getObjectClass("changeLogEntry", true);
        eclObjectClasses.put(eclEntryOC, "changeLogEntry");
        this.supportedControls = new HashSet(0);
        this.supportedControls.add("1.2.840.113556.1.4.473");
        this.supportedControls.add("2.16.840.1.113730.3.4.9");
        this.supportedFeatures = new HashSet(0);
        ECLWorkflowElement.attachLocalOperation(search, this);
    }

    public void processECLSearch(ECLWorkflowElement wfe) throws CanceledOperationException {
        PluginResult.PostOperation postOpResult;
        PluginConfigManager pluginConfigManager;
        boolean executePostOpPlugins;
        block22: {
            executePostOpPlugins = false;
            pluginConfigManager = DirectoryServer.getPluginConfigManager();
            this.checkIfCanceled(false);
            this.replicationServer = wfe.getReplicationServer();
            this.clientConnection = this.getClientConnection();
            this.startECLSessionMsg = new StartECLSessionMsg();
            this.startECLSessionMsg.setECLRequestType((short)1);
            this.startECLSessionMsg.setOperationId(this.toString());
            ArrayList<String> excludedDomains = MultimasterReplication.getECLDisabledDomains();
            if (!excludedDomains.contains("cn=changelog")) {
                excludedDomains.add("cn=changelog");
            }
            this.startECLSessionMsg.setExcludedDNs(excludedDomains);
            if (this.replicationServer == null) {
                this.setResultCode(ResultCode.OPERATIONS_ERROR);
                this.appendErrorMessage(CoreMessages.ERR_SEARCH_BASE_DOESNT_EXIST.get(String.valueOf(this.baseDN)));
            } else {
                this.baseDN = this.getBaseDN();
                this.filter = this.getFilter();
                if (this.baseDN != null && this.filter != null) {
                    try {
                        this.handleRequestControls();
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        this.setResponseData(de);
                        break block22;
                    }
                    try {
                        ECLSearchOperation.evaluateFilter(this.startECLSessionMsg, this.getFilter());
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        this.setResponseData(de);
                        break block22;
                    }
                    this.checkIfCanceled(false);
                    executePostOpPlugins = true;
                    PluginResult.PreOperation preOpResult = pluginConfigManager.invokePreOperationSearchPlugins(this);
                    if (!preOpResult.continueProcessing()) {
                        this.setResultCode(preOpResult.getResultCode());
                        this.appendErrorMessage(preOpResult.getErrorMessage());
                        this.setMatchedDN(preOpResult.getMatchedDN());
                        this.setReferralURLs(preOpResult.getReferralURLs());
                    } else {
                        this.checkIfCanceled(false);
                        this.setResultCode(ResultCode.SUCCESS);
                        if (this.persistentSearch != null) {
                            wfe.registerPersistentSearch(this.persistentSearch);
                            this.persistentSearch.enable();
                        }
                        try {
                            this.processSearch();
                        }
                        catch (DirectoryException de) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, de);
                            }
                            this.setResponseData(de);
                            if (this.persistentSearch != null) {
                                this.persistentSearch.cancel();
                                this.setSendResponse(true);
                            }
                        }
                        catch (CanceledOperationException coe) {
                            if (this.persistentSearch != null) {
                                this.persistentSearch.cancel();
                                this.setSendResponse(true);
                            }
                            this.abort(null);
                            throw coe;
                        }
                        catch (Exception e) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                            }
                            this.setResultCode(DirectoryServer.getServerErrorResultCode());
                            this.appendErrorMessage(CoreMessages.ERR_SEARCH_BACKEND_EXCEPTION.get(StaticUtils.getExceptionMessage(e)));
                            if (this.persistentSearch == null) break block22;
                            this.persistentSearch.cancel();
                            this.setSendResponse(true);
                        }
                    }
                }
            }
        }
        this.checkIfCanceled(false);
        if (executePostOpPlugins && !(postOpResult = pluginConfigManager.invokePostOperationSearchPlugins(this)).continueProcessing()) {
            this.setResultCode(postOpResult.getResultCode());
            this.appendErrorMessage(postOpResult.getErrorMessage());
            this.setMatchedDN(postOpResult.getMatchedDN());
            this.setReferralURLs(postOpResult.getReferralURLs());
        }
    }

    protected void handleRequestControls() throws DirectoryException {
        List<Control> requestControls = this.getRequestControls();
        if (requestControls != null && !requestControls.isEmpty()) {
            for (int i = 0; i < requestControls.size(); ++i) {
                Entry authorizationEntry;
                Control proxyControl;
                Control c = requestControls.get(i);
                String oid = c.getOID();
                if (!AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(this.baseDN, this, c)) {
                    throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, CoreMessages.ERR_CONTROL_INSUFFICIENT_ACCESS_RIGHTS.get(oid));
                }
                if (oid.equals("1.3.6.1.4.1.26027.1.5.4")) {
                    ExternalChangelogRequestControl eclControl = this.getRequestControl(ExternalChangelogRequestControl.DECODER);
                    MultiDomainServerState cookie = eclControl.getCookie();
                    if (cookie == null) continue;
                    this.startECLSessionMsg.setECLRequestType((short)0);
                    this.startECLSessionMsg.setCrossDomainServerState(cookie.toString());
                    continue;
                }
                if (oid.equals("1.3.6.1.1.12")) {
                    LDAPAssertionRequestControl assertControl = this.getRequestControl(LDAPAssertionRequestControl.DECODER);
                    try {
                        Entry entry;
                        SearchFilter assertionFilter = assertControl.getSearchFilter();
                        try {
                            entry = DirectoryServer.getEntry(this.baseDN);
                        }
                        catch (DirectoryException de) {
                            if (DebugLogger.debugEnabled()) {
                                TRACER.debugCaught(DebugLogLevel.ERROR, de);
                            }
                            throw new DirectoryException(de.getResultCode(), CoreMessages.ERR_SEARCH_CANNOT_GET_ENTRY_FOR_ASSERTION.get(de.getMessageObject()));
                        }
                        if (entry == null) {
                            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, CoreMessages.ERR_SEARCH_NO_SUCH_ENTRY_FOR_ASSERTION.get());
                        }
                        if (assertionFilter.matchesEntry(entry)) continue;
                        throw new DirectoryException(ResultCode.ASSERTION_FAILED, CoreMessages.ERR_SEARCH_ASSERTION_FAILED.get());
                    }
                    catch (DirectoryException de) {
                        if (de.getResultCode() == ResultCode.ASSERTION_FAILED) {
                            throw de;
                        }
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        throw new DirectoryException(ResultCode.PROTOCOL_ERROR, CoreMessages.ERR_SEARCH_CANNOT_PROCESS_ASSERTION_FILTER.get(de.getMessageObject()), de);
                    }
                }
                if (oid.equals("2.16.840.1.113730.3.4.12")) {
                    if (!this.clientConnection.hasPrivilege(Privilege.PROXIED_AUTH, this)) {
                        throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, CoreMessages.ERR_PROXYAUTH_INSUFFICIENT_PRIVILEGES.get());
                    }
                    proxyControl = this.getRequestControl(ProxiedAuthV1Control.DECODER);
                    authorizationEntry = ((ProxiedAuthV1Control)proxyControl).getAuthorizationEntry();
                    this.setAuthorizationEntry(authorizationEntry);
                    if (authorizationEntry == null) {
                        this.setProxiedAuthorizationDN(DN.nullDN());
                        continue;
                    }
                    this.setProxiedAuthorizationDN(authorizationEntry.getDN());
                    continue;
                }
                if (oid.equals("2.16.840.1.113730.3.4.18")) {
                    if (!this.clientConnection.hasPrivilege(Privilege.PROXIED_AUTH, this)) {
                        throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, CoreMessages.ERR_PROXYAUTH_INSUFFICIENT_PRIVILEGES.get());
                    }
                    proxyControl = this.getRequestControl(ProxiedAuthV2Control.DECODER);
                    authorizationEntry = ((ProxiedAuthV2Control)proxyControl).getAuthorizationEntry();
                    this.setAuthorizationEntry(authorizationEntry);
                    if (authorizationEntry == null) {
                        this.setProxiedAuthorizationDN(DN.nullDN());
                        continue;
                    }
                    this.setProxiedAuthorizationDN(authorizationEntry.getDN());
                    continue;
                }
                if (oid.equals("2.16.840.1.113730.3.4.3")) {
                    PersistentSearchControl psearchControl = this.getRequestControl(PersistentSearchControl.DECODER);
                    this.persistentSearch = new PersistentSearch(this, psearchControl.getChangeTypes(), psearchControl.getReturnECs());
                    if (!psearchControl.getChangesOnly()) {
                        this.startECLSessionMsg.setPersistent((short)0);
                        continue;
                    }
                    this.startECLSessionMsg.setPersistent((short)2);
                    continue;
                }
                if (oid.equals("1.3.6.1.4.1.4203.1.10.1")) {
                    SubentriesControl subentriesControl = this.getRequestControl(SubentriesControl.DECODER);
                    this.setReturnLDAPSubentries(subentriesControl.getVisibility());
                    continue;
                }
                if (oid.equals("1.2.826.0.1.3344810.2.3")) {
                    MatchedValuesControl matchedValuesControl = this.getRequestControl(MatchedValuesControl.DECODER);
                    this.setMatchedValuesControl(matchedValuesControl);
                    continue;
                }
                if (oid.equals("1.3.6.1.4.1.42.2.27.9.5.8")) {
                    this.setIncludeUsableControl(true);
                    continue;
                }
                if (oid.equals("2.16.840.1.113730.3.4.17")) {
                    this.setRealAttributesOnly(true);
                    continue;
                }
                if (oid.equals("2.16.840.1.113730.3.4.19")) {
                    this.setVirtualAttributesOnly(true);
                    continue;
                }
                if (oid.equals("1.3.6.1.4.1.42.2.27.9.5.2") && DirectoryServer.isSupportedControl("1.3.6.1.4.1.42.2.27.9.5.2") || !c.isCritical() || this.replicationServer != null && this.supportsControl(oid)) continue;
                throw new DirectoryException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, CoreMessages.ERR_SEARCH_UNSUPPORTED_CRITICAL_CONTROL.get(oid));
            }
        }
    }

    private void processSearch() throws DirectoryException, CanceledOperationException {
        block7: {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo(" processSearch toString=[" + this.toString() + "] opid=[" + this.startECLSessionMsg.getOperationId() + "]");
            }
            this.eclSession = this.replicationServer.createECLSession(this.startECLSessionMsg);
            boolean INITIAL = false;
            boolean PSEARCH = true;
            boolean phase = INITIAL;
            boolean returnedRoot = false;
            while (true) {
                this.checkIfCanceled(false);
                ECLUpdateMsg update = this.eclSession.getNextUpdate();
                if (update != null) {
                    if (!returnedRoot) {
                        this.returnRootEntryIfRequired(true);
                        returnedRoot = true;
                    }
                    if (phase != INITIAL || this.buildAndReturnEntry(update)) continue;
                    this.eclSession.close();
                    break block7;
                }
                if (!returnedRoot) {
                    this.returnRootEntryIfRequired(false);
                    returnedRoot = true;
                }
                if (phase == INITIAL) break;
            }
            if (this.persistentSearch == null) {
                this.eclSession.close();
            } else {
                phase = PSEARCH;
            }
        }
    }

    private void returnRootEntryIfRequired(boolean hasSubordinates) throws DirectoryException {
        Entry entry;
        if (!this.getScope().equals((Object)SearchScope.SINGLE_LEVEL) && this.matchFilter(entry = this.createRootEntry(hasSubordinates))) {
            this.returnEntry(entry, null);
        }
    }

    private boolean supportsControl(String oid) {
        return this.supportedControls != null && this.supportedControls.contains(oid);
    }

    private boolean buildAndReturnEntry(ECLUpdateMsg eclmsg) throws DirectoryException {
        Entry entry = null;
        entry = ECLSearchOperation.createEntryFromMsg(eclmsg);
        if (this.matchFilter(entry)) {
            ArrayList<Control> controls = new ArrayList<Control>(0);
            EntryChangelogNotificationControl clrc = new EntryChangelogNotificationControl(true, eclmsg.getCookie().toString());
            controls.add(clrc);
            return this.returnEntry(entry, controls);
        }
        return true;
    }

    private boolean matchFilter(Entry entry) throws DirectoryException {
        boolean baseScopeMatch = entry.matchesBaseAndScope(this.getBaseDN(), this.getScope());
        boolean filterMatch = this.getFilter().matchesEntry(entry);
        return baseScopeMatch && filterMatch;
    }

    public static Entry createEntryFromMsg(ECLUpdateMsg eclmsg) throws DirectoryException {
        Entry clEntry = null;
        UpdateMsg msg = eclmsg.getUpdateMsg();
        if (msg instanceof AddMsg) {
            AddMsg addMsg = (AddMsg)msg;
            String LDIFchanges = ECLSearchOperation.addMsgToLDIFString(addMsg);
            ArrayList<RawAttribute> eclAttributes = addMsg.getEclIncludes();
            clEntry = ECLSearchOperation.createChangelogEntry(eclmsg.getServiceId(), eclmsg.getCookie().toString(), DN.decode(addMsg.getDn()), addMsg.getChangeNumber(), LDIFchanges, addMsg.getUniqueId(), null, eclAttributes, eclmsg.getDraftChangeNumber(), "add", null);
        } else if (msg instanceof ModifyMsg) {
            ModifyMsg modMsg = (ModifyMsg)msg;
            InternalClientConnection conn = InternalClientConnection.getRootConnection();
            try {
                ModifyOperation modifyOperation = (ModifyOperation)((Object)modMsg.createOperation(conn));
                String LDIFchanges = ECLSearchOperation.modToLDIF(modifyOperation.getModifications());
                ArrayList<RawAttribute> eclAttributes = modMsg.getEclIncludes();
                clEntry = ECLSearchOperation.createChangelogEntry(eclmsg.getServiceId(), eclmsg.getCookie().toString(), DN.decode(modMsg.getDn()), modMsg.getChangeNumber(), LDIFchanges, modMsg.getUniqueId(), null, eclAttributes, eclmsg.getDraftChangeNumber(), "modify", null);
            }
            catch (Exception e) {
                throw new DirectoryException(ResultCode.OTHER, Message.raw(Category.SYNC, Severity.NOTICE, " Server fails to create entry: ", new Object[0]), e);
            }
        } else if (msg instanceof ModifyDNMsg) {
            try {
                InternalClientConnection conn = InternalClientConnection.getRootConnection();
                ModifyDNMsg modDNMsg = (ModifyDNMsg)msg;
                ArrayList<RawAttribute> eclAttributes = modDNMsg.getEclIncludes();
                ModifyDNOperation modifyDNOperation = (ModifyDNOperation)((Object)modDNMsg.createOperation(conn));
                String LDIFchanges = ECLSearchOperation.modToLDIF(modifyDNOperation.getModifications());
                clEntry = ECLSearchOperation.createChangelogEntry(eclmsg.getServiceId(), eclmsg.getCookie().toString(), DN.decode(modDNMsg.getDn()), modDNMsg.getChangeNumber(), LDIFchanges, modDNMsg.getUniqueId(), null, eclAttributes, eclmsg.getDraftChangeNumber(), "modrdn", null);
                Attribute a = Attributes.create("newrdn", modDNMsg.getNewRDN());
                clEntry.addAttribute(a, null);
                if (modDNMsg.getNewSuperior() != null) {
                    Attribute b = Attributes.create("newsuperior", modDNMsg.getNewSuperior());
                    clEntry.addAttribute(b, null);
                }
                Attribute c = Attributes.create("deleteoldrdn", String.valueOf(modDNMsg.deleteOldRdn()));
                clEntry.addAttribute(c, null);
            }
            catch (Exception e) {
                throw new DirectoryException(ResultCode.OTHER, Message.raw(Category.SYNC, Severity.NOTICE, " Server fails to create entry: ", new Object[0]), e);
            }
        } else if (msg instanceof DeleteMsg) {
            DeleteMsg delMsg = (DeleteMsg)msg;
            ArrayList<RawAttribute> eclAttributes = delMsg.getEclIncludes();
            clEntry = ECLSearchOperation.createChangelogEntry(eclmsg.getServiceId(), eclmsg.getCookie().toString(), DN.decode(delMsg.getDn()), delMsg.getChangeNumber(), null, delMsg.getUniqueId(), null, eclAttributes, eclmsg.getDraftChangeNumber(), "delete", delMsg.getInitiatorsName());
        }
        return clEntry;
    }

    private Entry createRootEntry(boolean hasSubordinates) {
        LinkedHashMap<ObjectClass, String> oclasses = new LinkedHashMap<ObjectClass, String>(3);
        LinkedHashMap<ObjectClass, String> rootObjectClasses = new LinkedHashMap<ObjectClass, String>(2);
        ObjectClass topOC = DirectoryServer.getObjectClass("top", true);
        rootObjectClasses.put(topOC, "top");
        ObjectClass containerOC = DirectoryServer.getObjectClass("container", true);
        rootObjectClasses.put(containerOC, "container");
        oclasses.putAll(rootObjectClasses);
        LinkedHashMap<AttributeType, List<Attribute>> userAttrs = new LinkedHashMap<AttributeType, List<Attribute>>();
        LinkedHashMap<AttributeType, List<Attribute>> operationalAttrs = new LinkedHashMap<AttributeType, List<Attribute>>();
        AttributeType aType = DirectoryServer.getAttributeType("subschemasubentry");
        if (aType == null) {
            aType = DirectoryServer.getDefaultAttributeType("subschemaSubentry");
        }
        Attribute a = Attributes.create("subschemaSubentry", "cn=schema");
        List<Attribute> attrList = Collections.singletonList(a);
        if (aType.isOperational()) {
            operationalAttrs.put(aType, attrList);
        } else {
            userAttrs.put(aType, attrList);
        }
        if (hasSubordinates) {
            aType = DirectoryServer.getAttributeType("hassubordinates");
            if (aType == null) {
                aType = DirectoryServer.getDefaultAttributeType("hasSubordinates");
            }
            a = Attributes.create("hasSubordinates", "true");
            attrList = Collections.singletonList(a);
            if (aType.isOperational()) {
                operationalAttrs.put(aType, attrList);
            } else {
                userAttrs.put(aType, attrList);
            }
        }
        if ((aType = DirectoryServer.getAttributeType("entrydn")) == null) {
            aType = DirectoryServer.getDefaultAttributeType("entryDN");
        }
        a = Attributes.create("entryDN", this.rootBaseDN.toNormalizedString());
        attrList = Collections.singletonList(a);
        if (aType.isOperational()) {
            operationalAttrs.put(aType, attrList);
        } else {
            userAttrs.put(aType, attrList);
        }
        Entry e = new Entry(this.rootBaseDN, oclasses, userAttrs, operationalAttrs);
        return e;
    }

    public static Entry createChangelogEntry(String serviceID, String cookie, DN targetDN, ChangeNumber changeNumber, String clearLDIFchanges, String targetUUID, Entry entry, List<RawAttribute> histEntryAttributes, int draftChangenumber, String changetype, String delInitiatorsName) throws DirectoryException {
        List<Attribute> attrList;
        Attribute a;
        AttributeType aType;
        LinkedHashMap<AttributeType, List<Attribute>> operationalAttrs;
        LinkedHashMap<AttributeType, List<Attribute>> uAttrs;
        String dnString;
        block73: {
            dnString = "";
            dnString = draftChangenumber == 0 ? "replicationcsn=" + changeNumber + "," + serviceID + "," + "cn=changelog" : "changenumber=" + draftChangenumber + "," + "cn=changelog";
            LinkedHashMap<ObjectClass, String> oClasses = new LinkedHashMap<ObjectClass, String>(3);
            oClasses.putAll(eclObjectClasses);
            ObjectClass extensibleObjectOC = DirectoryServer.getObjectClass("extensibleobject", true);
            oClasses.put(extensibleObjectOC, "extensibleObject");
            uAttrs = new LinkedHashMap<AttributeType, List<Attribute>>();
            operationalAttrs = new LinkedHashMap<AttributeType, List<Attribute>>();
            aType = DirectoryServer.getAttributeType("subschemasubentry");
            if (aType == null) {
                aType = DirectoryServer.getDefaultAttributeType("subschemasubentry");
            }
            a = Attributes.create("subschemasubentry", "cn=schema");
            attrList = Collections.singletonList(a);
            if (aType.isOperational()) {
                operationalAttrs.put(aType, attrList);
            } else {
                uAttrs.put(aType, attrList);
            }
            aType = DirectoryServer.getAttributeType("numsubordinates");
            if (aType == null) {
                aType = DirectoryServer.getDefaultAttributeType("numSubordinates");
            }
            a = Attributes.create("numSubordinates", "0");
            attrList = Collections.singletonList(a);
            if (aType.isOperational()) {
                operationalAttrs.put(aType, attrList);
            } else {
                uAttrs.put(aType, attrList);
            }
            aType = DirectoryServer.getAttributeType("hassubordinates");
            if (aType == null) {
                aType = DirectoryServer.getDefaultAttributeType("hasSubordinates");
            }
            a = Attributes.create("hasSubordinates", "false");
            attrList = Collections.singletonList(a);
            if (aType.isOperational()) {
                operationalAttrs.put(aType, attrList);
            } else {
                uAttrs.put(aType, attrList);
            }
            aType = DirectoryServer.getAttributeType("entrydn");
            if (aType == null) {
                aType = DirectoryServer.getDefaultAttributeType("entryDN");
            }
            a = Attributes.create("entryDN", dnString);
            attrList = Collections.singletonList(a);
            if (aType.isOperational()) {
                operationalAttrs.put(aType, attrList);
            } else {
                uAttrs.put(aType, attrList);
            }
            aType = DirectoryServer.getAttributeType("changenumber");
            if (aType == null) {
                aType = DirectoryServer.getDefaultAttributeType("changenumber");
            }
            a = Attributes.create("changenumber", String.valueOf(draftChangenumber));
            attrList = new ArrayList<Attribute>(1);
            attrList.add(a);
            if (aType.isOperational()) {
                operationalAttrs.put(aType, attrList);
            } else {
                uAttrs.put(aType, attrList);
            }
            aType = DirectoryServer.getAttributeType("changetime");
            if (aType == null) {
                aType = DirectoryServer.getDefaultAttributeType("changetime");
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            a = Attributes.create(aType, dateFormat.format(new Date(changeNumber.getTime())));
            attrList = new ArrayList<Attribute>(1);
            attrList.add(a);
            if (aType.isOperational()) {
                operationalAttrs.put(aType, attrList);
            } else {
                uAttrs.put(aType, attrList);
            }
            aType = DirectoryServer.getAttributeType("changetype");
            if (aType == null) {
                aType = DirectoryServer.getDefaultAttributeType("changetype");
            }
            a = Attributes.create(aType, changetype);
            attrList = new ArrayList<Attribute>(1);
            attrList.add(a);
            if (aType.isOperational()) {
                operationalAttrs.put(aType, attrList);
            } else {
                uAttrs.put(aType, attrList);
            }
            aType = DirectoryServer.getAttributeType("targetdn");
            if (aType == null) {
                aType = DirectoryServer.getDefaultAttributeType("targetdn");
            }
            a = Attributes.create(aType, targetDN.toNormalizedString());
            attrList = new ArrayList<Attribute>(1);
            attrList.add(a);
            if (aType.isOperational()) {
                operationalAttrs.put(aType, attrList);
            } else {
                uAttrs.put(aType, attrList);
            }
            aType = DirectoryServer.getAttributeType("replicationcsn");
            if (aType == null) {
                aType = DirectoryServer.getDefaultAttributeType("replicationcsn");
            }
            a = Attributes.create(aType, changeNumber.toString());
            attrList = new ArrayList<Attribute>(1);
            attrList.add(a);
            if (aType.isOperational()) {
                operationalAttrs.put(aType, attrList);
            } else {
                uAttrs.put(aType, attrList);
            }
            aType = DirectoryServer.getAttributeType("replicaidentifier");
            if (aType == null) {
                aType = DirectoryServer.getDefaultAttributeType("replicaidentifier");
            }
            a = Attributes.create(aType, Integer.toString(changeNumber.getServerId()));
            attrList = new ArrayList<Attribute>(1);
            attrList.add(a);
            if (aType.isOperational()) {
                operationalAttrs.put(aType, attrList);
            } else {
                uAttrs.put(aType, attrList);
            }
            if (clearLDIFchanges != null) {
                int end_val_cr;
                int start_val_cr;
                String pattern;
                if (changetype.equals("add")) {
                    aType = DirectoryServer.getAttributeType("changes");
                    if (aType == null) {
                        aType = DirectoryServer.getDefaultAttributeType("changes");
                    }
                    a = Attributes.create(aType, clearLDIFchanges + "\n");
                    attrList = new ArrayList<Attribute>(1);
                    attrList.add(a);
                    if (aType.isOperational()) {
                        operationalAttrs.put(aType, attrList);
                    } else {
                        uAttrs.put(aType, attrList);
                    }
                    pattern = "creatorsName: ";
                    try {
                        int att_cr = clearLDIFchanges.indexOf(pattern);
                        if (att_cr <= 0) break block73;
                        start_val_cr = clearLDIFchanges.indexOf(58, att_cr);
                        end_val_cr = clearLDIFchanges.indexOf(ServerConstants.EOL, att_cr);
                        String creatorsName = clearLDIFchanges.substring(start_val_cr + 2, end_val_cr);
                        aType = DirectoryServer.getAttributeType("changeInitiatorsName");
                        if (aType == null) {
                            aType = DirectoryServer.getDefaultAttributeType("changeInitiatorsName");
                        }
                        a = Attributes.create(aType, creatorsName);
                        attrList = new ArrayList<Attribute>(1);
                        attrList.add(a);
                        if (aType.isOperational()) {
                            operationalAttrs.put(aType, attrList);
                            break block73;
                        }
                        uAttrs.put(aType, attrList);
                    }
                    catch (Exception e) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        ErrorLogger.logError(Message.raw(Category.SYNC, Severity.MILD_ERROR, "Error in External Change Log when looking for pattern \"" + pattern + "\" in string \"" + clearLDIFchanges + "\" for change " + dnString, new Object[0]));
                    }
                } else if (changetype.equals("modify") || changetype.equals("modrdn")) {
                    if (changetype.equals("modify")) {
                        aType = DirectoryServer.getAttributeType("changes");
                        if (aType == null) {
                            aType = DirectoryServer.getDefaultAttributeType("changes");
                        }
                        a = Attributes.create(aType, clearLDIFchanges + "\n");
                        attrList = new ArrayList<Attribute>(1);
                        attrList.add(a);
                        if (aType.isOperational()) {
                            operationalAttrs.put(aType, attrList);
                        } else {
                            uAttrs.put(aType, attrList);
                        }
                    }
                    pattern = "modifiersName: ";
                    try {
                        int att_cr = clearLDIFchanges.indexOf(pattern);
                        if (att_cr > 0) {
                            start_val_cr = att_cr + pattern.length();
                            end_val_cr = clearLDIFchanges.indexOf(ServerConstants.EOL, att_cr);
                            String modifiersName = clearLDIFchanges.substring(start_val_cr, end_val_cr);
                            aType = DirectoryServer.getAttributeType("changeInitiatorsName");
                            if (aType == null) {
                                aType = DirectoryServer.getDefaultAttributeType("changeInitiatorsName");
                            }
                            a = Attributes.create(aType, modifiersName);
                            attrList = new ArrayList<Attribute>(1);
                            attrList.add(a);
                            if (aType.isOperational()) {
                                operationalAttrs.put(aType, attrList);
                            } else {
                                uAttrs.put(aType, attrList);
                            }
                        }
                    }
                    catch (Exception e) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        ErrorLogger.logError(Message.raw(Category.SYNC, Severity.MILD_ERROR, "Error in External Change Log when looking for pattern \"" + pattern + "\" in string \"" + clearLDIFchanges + "\" for change " + dnString, new Object[0]));
                    }
                }
            }
        }
        if (changetype.equals("delete") && delInitiatorsName != null) {
            aType = DirectoryServer.getAttributeType("changeInitiatorsName");
            if (aType == null) {
                aType = DirectoryServer.getDefaultAttributeType("changeInitiatorsName");
            }
            a = Attributes.create(aType, delInitiatorsName);
            attrList = new ArrayList<Attribute>(1);
            attrList.add(a);
            if (aType.isOperational()) {
                operationalAttrs.put(aType, attrList);
            } else {
                uAttrs.put(aType, attrList);
            }
        }
        if (targetUUID != null) {
            aType = DirectoryServer.getAttributeType("targetentryuuid");
            if (aType == null) {
                aType = DirectoryServer.getDefaultAttributeType("targetentryuuid");
            }
            a = Attributes.create(aType, targetUUID);
            attrList = new ArrayList<Attribute>(1);
            attrList.add(a);
            if (aType.isOperational()) {
                operationalAttrs.put(aType, attrList);
            } else {
                uAttrs.put(aType, attrList);
            }
            if (draftChangenumber > 0) {
                String dseeValue;
                block74: {
                    aType = DirectoryServer.getAttributeType("targetuniqueid");
                    if (aType == null) {
                        aType = DirectoryServer.getDefaultAttributeType("targetuniqueid");
                    }
                    dseeValue = null;
                    try {
                        dseeValue = ECLSearchOperation.openDsToSunDseeNsUniqueId(targetUUID);
                    }
                    catch (Exception e) {
                        Message errMessage = ReplicationMessages.NOTE_ERR_ENTRY_UID_DSEE_MAPPING.get(targetDN.toNormalizedString(), targetUUID, e.getLocalizedMessage());
                        ErrorLogger.logError(errMessage);
                        if (!DebugLogger.debugEnabled()) break block74;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
                if (dseeValue != null) {
                    a = Attributes.create(aType, dseeValue);
                    attrList = new ArrayList<Attribute>(1);
                    attrList.add(a);
                    if (aType.isOperational()) {
                        operationalAttrs.put(aType, attrList);
                    } else {
                        uAttrs.put(aType, attrList);
                    }
                }
            }
        }
        if ((aType = DirectoryServer.getAttributeType("changelogcookie")) == null) {
            aType = DirectoryServer.getDefaultAttributeType("changelogcookie");
        }
        a = Attributes.create(aType, cookie);
        attrList = new ArrayList<Attribute>(1);
        attrList.add(a);
        if (aType.isOperational()) {
            operationalAttrs.put(aType, attrList);
        } else {
            uAttrs.put(aType, attrList);
        }
        if (histEntryAttributes != null) {
            for (RawAttribute ra : histEntryAttributes) {
                try {
                    String attrName = ra.getAttributeType().toLowerCase();
                    String eclName = "target" + attrName;
                    AttributeBuilder builder = new AttributeBuilder(DirectoryServer.getDefaultAttributeType(eclName));
                    AttributeType at = builder.getAttributeType();
                    builder.setOptions(ra.toAttribute().getOptions());
                    builder.addAll(ra.toAttribute());
                    attrList = new ArrayList<Attribute>(1);
                    attrList.add(builder.toAttribute());
                    uAttrs.put(at, attrList);
                }
                catch (Exception e) {}
            }
        }
        Entry cle = new Entry(DN.decode(dnString), eclObjectClasses, uAttrs, operationalAttrs);
        return cle;
    }

    private static String addMsgToLDIFString(AddMsg addMsg) {
        StringBuilder modTypeLine = new StringBuilder();
        try {
            AddOperation addOperation = (AddOperation)((Object)addMsg.createOperation(InternalClientConnection.getRootConnection()));
            HashMap<AttributeType, ArrayList<Attribute>> attributes = new HashMap<AttributeType, ArrayList<Attribute>>();
            for (RawAttribute a : addOperation.getRawAttributes()) {
                Attribute attr = a.toAttribute();
                AttributeType attrType = attr.getAttributeType();
                ArrayList<Attribute> attrs = (ArrayList<Attribute>)attributes.get(attrType);
                if (attrs == null) {
                    attrs = new ArrayList<Attribute>(1);
                    attrs.add(attr);
                    attributes.put(attrType, attrs);
                    continue;
                }
                attrs.add(attr);
            }
            for (List attrList : attributes.values()) {
                for (Attribute a : attrList) {
                    StringBuilder attrName = new StringBuilder(a.getName());
                    for (String o : a.getOptions()) {
                        attrName.append(";");
                        attrName.append(o);
                    }
                    for (AttributeValue av : a) {
                        String stringValue = ((Object)av).toString();
                        modTypeLine.append((CharSequence)attrName);
                        if (StaticUtils.needsBase64Encoding(stringValue)) {
                            modTypeLine.append(":: ");
                            modTypeLine.append(Base64.encode(av.getValue()));
                        } else {
                            modTypeLine.append(": ");
                            modTypeLine.append(stringValue);
                        }
                        modTypeLine.append("\n");
                    }
                }
            }
            return modTypeLine.toString();
        }
        catch (Exception e) {
            TRACER.debugCaught(DebugLogLevel.ERROR, e);
            return null;
        }
    }

    public static String modToLDIF(List<Modification> mods) {
        if (mods == null) {
            return null;
        }
        StringBuilder modTypeLine = new StringBuilder();
        Iterator<Modification> iterator = mods.iterator();
        while (iterator.hasNext()) {
            Modification m = iterator.next();
            Attribute a = m.getAttribute();
            String attrName = a.getName();
            modTypeLine.append(m.getModificationType().getLDIFName());
            modTypeLine.append(": ");
            modTypeLine.append(attrName);
            modTypeLine.append("\n");
            for (AttributeValue av : a) {
                String stringValue = ((Object)av).toString();
                modTypeLine.append(attrName);
                if (StaticUtils.needsBase64Encoding(stringValue)) {
                    modTypeLine.append(":: ");
                    modTypeLine.append(Base64.encode(av.getValue()));
                } else {
                    modTypeLine.append(": ");
                    modTypeLine.append(stringValue);
                }
                modTypeLine.append("\n");
            }
            modTypeLine.append("-");
            if (!iterator.hasNext()) continue;
            modTypeLine.append("\n");
        }
        return modTypeLine.toString();
    }

    @Override
    public CancelResult cancel(CancelRequest cancelRequest) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo(this + " cancel() " + this.eclSession);
        }
        if (this.eclSession != null) {
            try {
                this.eclSession.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.cancel(cancelRequest);
    }

    @Override
    public void abort(CancelRequest cancelRequest) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo(this + " abort() " + this.eclSession);
        }
        if (this.eclSession != null) {
            try {
                this.eclSession.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static String openDsToSunDseeNsUniqueId(String entryUid) {
        StringBuffer buffer = new StringBuffer(entryUid);
        buffer.deleteCharAt(13);
        buffer.deleteCharAt(22);
        buffer.insert(26, '-');
        return buffer.toString();
    }

    public static void evaluateFilter(StartECLSessionMsg startCLmsg, SearchFilter sf) throws DirectoryException {
        StartECLSessionMsg msg = ECLSearchOperation.evaluateFilter2(sf);
        startCLmsg.setFirstDraftChangeNumber(msg.getFirstDraftChangeNumber());
        startCLmsg.setLastDraftChangeNumber(msg.getLastDraftChangeNumber());
        startCLmsg.setChangeNumber(msg.getChangeNumber());
    }

    private static StartECLSessionMsg evaluateFilter2(SearchFilter sf) throws DirectoryException {
        StartECLSessionMsg startCLmsg = new StartECLSessionMsg();
        startCLmsg.setFirstDraftChangeNumber(-1);
        startCLmsg.setLastDraftChangeNumber(-1);
        startCLmsg.setChangeNumber(new ChangeNumber(0L, 0, 0));
        if (sf != null && sf.getFilterType() == FilterType.GREATER_OR_EQUAL && sf.getAttributeType() != null && sf.getAttributeType().getPrimaryName().equalsIgnoreCase("changeNumber")) {
            int sn = Integer.decode(sf.getAssertionValue().getNormalizedValue().toString());
            startCLmsg.setFirstDraftChangeNumber(sn);
            return startCLmsg;
        }
        if (sf != null && sf.getFilterType() == FilterType.LESS_OR_EQUAL && sf.getAttributeType() != null && sf.getAttributeType().getPrimaryName().equalsIgnoreCase("changeNumber")) {
            int sn = Integer.decode(sf.getAssertionValue().getNormalizedValue().toString());
            startCLmsg.setLastDraftChangeNumber(sn);
            return startCLmsg;
        }
        if (sf != null && sf.getFilterType() == FilterType.EQUALITY && sf.getAttributeType() != null && sf.getAttributeType().getPrimaryName().equalsIgnoreCase("replicationcsn")) {
            ChangeNumber cn = new ChangeNumber(((Object)sf.getAssertionValue()).toString());
            startCLmsg.setChangeNumber(cn);
            return startCLmsg;
        }
        if (sf != null && sf.getFilterType() == FilterType.EQUALITY && sf.getAttributeType() != null && sf.getAttributeType().getPrimaryName().equalsIgnoreCase("changenumber")) {
            int sn = Integer.decode(sf.getAssertionValue().getNormalizedValue().toString());
            startCLmsg.setFirstDraftChangeNumber(sn);
            startCLmsg.setLastDraftChangeNumber(sn);
            return startCLmsg;
        }
        if (sf != null && sf.getFilterType() == FilterType.AND) {
            Set<SearchFilter> comps = sf.getFilterComponents();
            SearchFilter[] sfs = comps.toArray(new SearchFilter[0]);
            StartECLSessionMsg m1 = ECLSearchOperation.evaluateFilter2(sfs[0]);
            StartECLSessionMsg m2 = ECLSearchOperation.evaluateFilter2(sfs[1]);
            int l1 = m1.getLastDraftChangeNumber();
            int l2 = m2.getLastDraftChangeNumber();
            if (l1 == -1) {
                startCLmsg.setLastDraftChangeNumber(l2);
            } else if (l2 == -1) {
                startCLmsg.setLastDraftChangeNumber(l1);
            } else {
                startCLmsg.setLastDraftChangeNumber(Math.min(l1, l2));
            }
            int f1 = m1.getFirstDraftChangeNumber();
            int f2 = m2.getFirstDraftChangeNumber();
            startCLmsg.setFirstDraftChangeNumber(Math.max(f1, f2));
            return startCLmsg;
        }
        return startCLmsg;
    }
}

