INSERT INTO fpWorkgroup
(workgroupID, jid, displayName, description, status, modes, creationDate, modificationDate, maxchats, minchats, requestTimeout, offerTimeout, schedule)
SELECT workgroupID, jid, displayName, description, status, modes, creationDate, modificationDate, maxchats, minchats, requestTimeout, offerTimeout, schedule
FROM jlaWorkgroup;

INSERT INTO fpWorkgroupProp
(ownerID, name, propValue)
SELECT ownerID, name, REPLACE(propValue, '.liveassistant.', '.wildfire.fastpath.')
FROM jlaWorkgroupProp;

INSERT INTO fpAgent
(agentID, agentJID, name, maxchats, minchats)
SELECT agentID, agentJID, name, maxchats, minchats
FROM jlaAgent;

INSERT INTO fpAgentProp
(ownerID, name, propValue)
SELECT ownerID, name, REPLACE(propValue, '.liveassistant.', '.wildfire.fastpath.')
FROM jlaAgentProp;

INSERT INTO fpQueue
(queueID, workgroupID, name, description, priority, maxchats, minchats, overflow, backupQueue)
SELECT queueID, workgroupID, name, description, priority, maxchats, minchats, overflow, backupQueue
FROM jlaQueue;

INSERT INTO fpDispatcherProp
(ownerID, name, propValue)
SELECT ownerID, name, propValue
FROM jlaDispatcherProp;

INSERT INTO fpDispatcher
(queueID, name, description, offerTimeout, requestTimeout)
SELECT queueID, name, description, offerTimeout, requestTimeout
FROM jlaDispatcher;

INSERT INTO fpQueueProp
(ownerID, name, propValue)
SELECT ownerID, name, propValue
FROM jlaQueueProp;

INSERT INTO fpQueueAgent
(queueID, objectID, objectType, administrator)
SELECT queueID, objectID, objectType, administrator
FROM jlaQueueAgent;

INSERT INTO fpQueueGroup
(queueID, groupName)
SELECT queueID, groupName
FROM jlaQueueGroup;

INSERT INTO fpAgentSession
(sessionID, agentJID, joinTime, leftTime)
SELECT sessionID, agentJID, joinTime, leftTime
FROM jlaAgentSession;

INSERT INTO fpSessionMetadata
(sessionID, metadataName, metadataValue)
SELECT sessionID, metadataName, metadataValue
FROM jlaSessionMetadata;

INSERT INTO fpSessionProp
(sessionID, name, propValue)
SELECT sessionID, name, propValue
FROM jlaSessionProp;

INSERT INTO fpSetting
(workgroupName, name, namespace, value)
SELECT workgroupName, name, namespace, value
FROM jlaSettings;

INSERT INTO fpSearchIndex
(workgroupID, lastUpdated, lastOptimization)
SELECT workgroupID, lastUpdated, lastOptimization
FROM jlaSearchIndex;

INSERT INTO fpWorkgroupRoster
(workgroupID, jid, lastContact)
SELECT workgroupID, jid, lastContact
FROM jlaWorkgroupRoster;

INSERT INTO fpChatSetting
(workgroupNode, type, label, description, name, value, defaultValue)
SELECT workgroupNode, type, label, description, name, value, defaultValue
FROM chatSettings;

INSERT INTO fpOfflineSetting
(workgroupID, redirectPage, emailAddress, subject, offlineText)
SELECT workgroupID, redirectPage, emailAddress, subject, offlineText
FROM jlaOfflineSettings;

INSERT INTO fpRouteRule
(workgroupID, queueID, rulePosition, query)
SELECT workgroupID, queueID, rulePosition, query
FROM fpRouting;

INSERT INTO fpSession
(sessionID, userID, workgroupID, transcript, startTime, endTime, queueWaitTime, state, caseID, status, notes)
SELECT sessionID, userID, workgroupID, transcript, startTime, endTime, cast(queueWaitTime as integer), state, caseID, status, notes
FROM jlaSession;