ALTER TABLE entConversation ADD room VARCHAR(512);

RENAME TABLE entConParticipant TO entConParticipant2;

CREATE TABLE entConParticipant (
  conversationID       INTEGER       NOT NULL,
  joinedDate           BIGINT        NOT NULL,
  leftDate             BIGINT,
  bareJID              VARCHAR(255)  NOT NULL,
  jidResource          VARCHAR(255)  NOT NULL,
  nickname             VARCHAR(255)
);
CREATE INDEX entConPar_con_idx ON entConParticipant (conversationID, bareJID, jidResource, joinedDate);
CREATE INDEX entConPar_jid_idx ON entConParticipant (bareJID);

INSERT INTO entConParticipant (conversationID, joinedDate, bareJID, jidResource)
SELECT conversationID, 0, jid, '' FROM entConParticipant2;

UPDATE entConParticipant SET joinedDate = (select startDate from entConversation where entConversation.conversationID =  entConParticipant.conversationID);
UPDATE entConParticipant SET leftDate = (select lastActivity from entConversation where entConversation.conversationID =  entConParticipant.conversationID);

UPDATE jiveVersion set version=6 where name = 'enterprise';