ALTER TABLE entConversation ADD room NVARCHAR(1024) NULL;

ALTER TABLE entConParticipant ADD joinedDate BIGINT NULL;
ALTER TABLE entConParticipant ADD leftDate BIGINT NULL ;
ALTER TABLE entConParticipant ADD bareJID NVARCHAR(255) NULL;
ALTER TABLE entConParticipant ADD jidResource NVARCHAR(255) NULL;
ALTER TABLE entConParticipant ADD nickname NVARCHAR(255) NULL;

UPDATE entConParticipant SET joinedDate = (select startDate from entConversation where entConversation.conversationID =  entConParticipant.conversationID);
UPDATE entConParticipant SET leftDate = (select lastActivity from entConversation where entConversation.conversationID =  entConParticipant.conversationID);
UPDATE entConParticipant SET jidResource = '';
UPDATE entConParticipant SET bareJID = jid;

ALTER TABLE entConParticipant ALTER COLUMN joinedDate BIGINT NOT NULL;
ALTER TABLE entConParticipant ALTER COLUMN bareJID NVARCHAR(255) NOT NULL;
ALTER TABLE entConParticipant ALTER COLUMN jidResource NVARCHAR(255) NOT NULL;

DROP INDEX entConParticipant_jid_idx ON entConParticipant;
ALTER TABLE entConParticipant DROP COLUMN jid;

CREATE INDEX entConParticipant_conv_idx ON entConParticipant (conversationID, bareJID, jidResource, joinedDate);
CREATE INDEX entConParticipant_jid_idx ON entConParticipant (bareJID);

UPDATE jiveVersion set version=6 where name = 'enterprise';