package org.operamasks.faces.demo.hr.entity;

import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.Query;
import java.util.*;

/** 
 * @generated
 */
@Stateless
public class EmployeeService implements IEmployeeService {
	/** 
	 * @generated default persist manager
	 */
	@PersistenceContext
	private EntityManager _innerDao;

	/** 
	 * @generated default persist method
	 */
	@TransactionAttribute(value = TransactionAttributeType.REQUIRED)
	public void createEmployee(Employee vo) {
		_innerDao.persist(vo);
	}

	/** 
	 * @generated default persist method
	 */
	@TransactionAttribute(value = TransactionAttributeType.REQUIRED)
	public void modifyEmployee(Employee vo) {
		Employee managed = _innerDao.merge(vo);
		_innerDao.persist(managed);
	}

	/** 
	 * @generated default remove method
	 */
	@TransactionAttribute(value = TransactionAttributeType.REQUIRED)
	public void removeEmployee(Employee vo) {
		Employee managed = _innerDao.merge(vo);
		_innerDao.remove(managed);
	}

	/** 
	 * @generated default query method
	 */
	@TransactionAttribute(value = TransactionAttributeType.REQUIRED)
	public List<Employee> listEmployee() {
		Query q = _innerDao.createQuery("SELECT o FROM Employee o ");
		return q.getResultList();
	}

	/** 
	 * @generated default query method
	 */
	@TransactionAttribute(value = TransactionAttributeType.REQUIRED)
	public Employee getEmployee(java.lang.String pk) {
		return _innerDao.find(Employee.class, pk);
	}

    public List<Object[]> getCountByDepartment() {
        Query q = _innerDao.createNamedQuery("countByDepartment");
        return q.getResultList();
    }

    public List<Object[]> getCountByRank() {
        Query q = _innerDao.createNamedQuery("countByRank");
        return q.getResultList();
    }
}
