package org.operamasks.faces.demo.hr.entity;

import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.Query;
import java.util.*;

/** 
 * @generated
 */
@Stateless
public class TrainRecordService implements ITrainRecordService {
	/** 
	 * @generated default persist manager
	 */
	@PersistenceContext
	private EntityManager _innerDao;

	/** 
	 * @generated default persist method
	 */
	@TransactionAttribute(value = TransactionAttributeType.REQUIRED)
	public void createTrainRecord(TrainRecord vo) {
		_innerDao.persist(vo);
	}

	/** 
	 * @generated default persist method
	 */
	@TransactionAttribute(value = TransactionAttributeType.REQUIRED)
	public void modifyTrainRecord(TrainRecord vo) {
		TrainRecord managed = _innerDao.merge(vo);
		_innerDao.persist(managed);
	}

	/** 
	 * @generated default remove method
	 */
	@TransactionAttribute(value = TransactionAttributeType.REQUIRED)
	public void removeTrainRecord(TrainRecord vo) {
		TrainRecord managed = _innerDao.merge(vo);
		_innerDao.remove(managed);
	}

	/** 
	 * @generated default query method
	 */
	@TransactionAttribute(value = TransactionAttributeType.REQUIRED)
	public List<TrainRecord> listTrainRecord() {
		Query q = _innerDao.createQuery("SELECT o FROM TrainRecord o ");
		return q.getResultList();
	}

	/** 
	 * @generated default query method
	 */
	@TransactionAttribute(value = TransactionAttributeType.REQUIRED)
	public TrainRecord getTrainRecord(java.lang.String pk) {
		return _innerDao.find(TrainRecord.class, pk);
	}

    public List<Object[]> getRankReport(String reportDate) {
        StringBuffer buf = new StringBuffer();
        buf.append("SELECT o.employee.rank,");
        buf.append("COUNT(o.employee.name),");
        buf.append("SUM(o.trainHours),");
        buf.append("COUNT(DISTINCT o.employee.name)");
        buf.append("FROM TrainRecord o ");
        buf.append("GROUP BY o.employee.rank");
        Query q = _innerDao.createQuery(buf.toString());
        return q.getResultList();
    }

    public List<Object[]> getDepartmentReport(String reportDate) {
        StringBuffer buf = new StringBuffer();
        buf.append("SELECT o.employee.department,");
        buf.append("COUNT(o.employee.name),");
        buf.append("SUM(o.trainHours),");
        buf.append("COUNT(DISTINCT o.employee.name)");
        buf.append("FROM TrainRecord o ");
        buf.append("GROUP BY o.employee.department");
        Query q = _innerDao.createQuery(buf.toString());
        return q.getResultList();
    }
}
