package org.operamasks.faces.demo.hr.entity;

import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.Query;
import java.util.*;

/** 
 * @generated
 */
@Stateless
public class UserService implements IUserService {
	/** 
	 * @generated default persist manager
	 */
	@PersistenceContext
	private EntityManager _innerDao;

	/** 
	 * @generated default persist method
	 */
	@TransactionAttribute(value = TransactionAttributeType.REQUIRED)
	public void createUser(User vo) {
		_innerDao.persist(vo);
	}

	/** 
	 * @generated default persist method
	 */
	@TransactionAttribute(value = TransactionAttributeType.REQUIRED)
	public void modifyUser(User vo) {
		User managed = _innerDao.merge(vo);
		_innerDao.persist(managed);
	}

	/** 
	 * @generated default remove method
	 */
	@TransactionAttribute(value = TransactionAttributeType.REQUIRED)
	public void removeUser(User vo) {
		User managed = _innerDao.merge(vo);
		_innerDao.remove(managed);
	}

	/** 
	 * @generated default query method
	 */
	@TransactionAttribute(value = TransactionAttributeType.REQUIRED)
	public List<User> listUser() {
		Query q = _innerDao.createQuery("SELECT o FROM User o ");
		return q.getResultList();
	}

	/** 
	 * @generated default query method
	 */
	@TransactionAttribute(value = TransactionAttributeType.REQUIRED)
	public User getUser(java.lang.String pk) {
		return _innerDao.find(User.class, pk);
	}

    public List<User> findUserByName(String loginName) {
        Query q = _innerDao.createQuery("SELECT o FROM User o WHERE o.loginName=:loginName");
        q.setParameter("loginName", loginName);
        return q.getResultList();
    }
}
