/*
 * $Id: DepartmentBean.java,v 1.2 2007/07/12 15:29:07 jacky Exp $
 *
 * Copyright (C) 2006 Operamasks Community.
 * Copyright (C) 2000-2006 Apusic Systems, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses.
 * 
 */
package org.operamasks.faces.demo.hr;

import java.util.List;
import java.util.UUID;

import javax.ejb.EJB;
import javax.faces.model.SelectItem;

import org.operamasks.faces.annotation.ManagedBean;
import org.operamasks.faces.annotation.ManagedBeanScope;
import org.operamasks.faces.demo.hr.entity.Department;
import org.operamasks.faces.demo.hr.entity.IDepartmentService;

@ManagedBean(scope = ManagedBeanScope.SESSION)
public class DepartmentBean extends BaseGridBean {
    @EJB(name = "org.operamasks.faces.demo.hr.entity.DepartmentService")
    private IDepartmentService departmentService;
    
    private Department department;
    
    public DepartmentBean() {
        create();
    }
    
    public List<Department> getDepartments() {
        return departmentService.listDepartment();
    }

    public Department getDepartment() {
        grid.setRowIndex(row);
        if (grid.isRowAvailable()) {
            department = (Department) grid.getRowData();
        }
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }
    
    public SelectItem[] getItems() {
        List<Department> models = departmentService.listDepartment();
        if(models != null) {
            SelectItem[] items = new SelectItem[models.size()];
            int i = 0;
            for(Department model : models) {
                items[i++] = new SelectItem(model.getId(),model.getName());
            }
            return items;
        }
        return null;
    }
    
    public void create() {
        department = new Department();
        department.setId(UUID.randomUUID().toString());
        row = -1;
    }
    
    public void remove() {
        grid.setRowIndex(row);
        if(grid.isRowAvailable()) {
            department = (Department) grid.getRowData();
            departmentService.removeDepartment(department);
            if(row-1 > 0) {
                grid.setRowIndex(row-1);
                department = (Department) grid.getRowData();
            }
            else {
                create();
            }
            grid.reload();
        }
    }
    
    public void saveAndAdd() {
        save();
        create();
    }

    public void save() {
        departmentService.modifyDepartment(department);
        grid.reload();
    }
}
