/*
 * $Id: DepartmentReportBean.java,v 1.2 2007/07/17 11:19:23 jacky Exp $
 *
 * Copyright (C) 2006 Operamasks Community.
 * Copyright (C) 2000-2006 Apusic Systems, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses.
 * 
 */
package org.operamasks.faces.demo.hr;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.ejb.EJB;

import org.operamasks.faces.annotation.ManagedBean;
import org.operamasks.faces.annotation.ManagedBeanScope;
import org.operamasks.faces.demo.hr.entity.Department;
import org.operamasks.faces.demo.hr.entity.IEmployeeService;
import org.operamasks.faces.demo.hr.entity.ITrainRecordService;

@ManagedBean(scope = ManagedBeanScope.SESSION)
public class DepartmentReportBean 
{
    @EJB(name = "org.operamasks.faces.demo.hr.entity.TrainRecordService")
    private ITrainRecordService trainRecordService;
    @EJB(name = "org.operamasks.faces.demo.hr.entity.EmployeeService")
    private IEmployeeService employeeService;
    
    private Map<String,Long> countByDepartment;
    
    private Object[] total;

    public DepartmentReportBean() {
        countByDepartment = new HashMap<String, Long>();
        total = new Object[7];
    }

    private void init() {
        List<Object[]> rank = employeeService.getCountByDepartment();
        for(Object[] o : rank) {
            countByDepartment.put(o[0].toString(),(Long)o[1]);
        }
    }

    public List<Object[]> getData() {
        init();
        List<Object[]> result = trainRecordService.getDepartmentReport(null);
        return transResult(result);
    }

    private List<Object[]> transResult(List<Object[]> result) {
        List<Object[]> data = new ArrayList<Object[]>();
        total[0] = "Total";
        total[1] = Long.valueOf(0L);
        total[2] = Double.valueOf(0D);
        total[3] = Long.valueOf(0L);
        total[4] = Long.valueOf(0L);
        for(Object[] rec : result) {
            Object[] each = new Object[7];
            Department dep = (Department)rec[0];
            each[0] = dep.getName();
            each[1] = rec[1]; // total employee
            each[2] = rec[2]; // total hours
            each[3] = rec[3]; // distinct employee
            each[4] = countByDepartment.get(dep.getId());
            total[1] = ((Long)total[1]).longValue() + Long.valueOf(each[1].toString()); 
            total[2] = Double.valueOf(((Double)total[2]).doubleValue()+Double.valueOf(each[2].toString())); 
            total[3] = ((Long)total[3]).longValue() + Long.valueOf(each[3].toString()); 
            total[4] = ((Long)total[4]).longValue() + Long.valueOf(each[4].toString());
            if(each[4] == null || Long.valueOf(each[4].toString()) == 0) {
                each[5] = "0";
                each[6] = "0";
            } else {
                DecimalFormat f = new DecimalFormat();
                f.applyPattern("###.00");
                each[5] = f.format(Double.valueOf(each[2].toString()).doubleValue() / Long.valueOf(each[4].toString()).doubleValue());
                f.applyPattern("###.00%");
                each[6] = f.format(Long.valueOf(each[3].toString()).doubleValue() / Long.valueOf(each[4].toString()).doubleValue());
            }
            data.add(each);
        }
        if(total[4] == null || ((Long)total[4]).longValue() == 0) {
            total[5] = "0";
            total[6] = "0";
        } else {
            DecimalFormat f = new DecimalFormat();
            f.applyPattern("###.00");
            total[5] = f.format(((Double)total[2]).doubleValue() / ((Long)total[4]).doubleValue());
            f.applyPattern("###.00%");
            total[6] = f.format(((Long)total[3]).doubleValue() / ((Long)total[4]).doubleValue());
        }
        return data;
    }

    public Object[] getTotal() {
        return this.total;
    }

    public void setTotal(Object[] total) {
        this.total = total;
    }
}
