/*
 * $Id: EmployeeBean.java,v 1.3 2007/07/17 11:58:04 jacky Exp $
 *
 * Copyright (C) 2006 Operamasks Community.
 * Copyright (C) 2000-2006 Apusic Systems, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses.
 * 
 */
package org.operamasks.faces.demo.hr;

import java.util.List;
import java.util.UUID;

import javax.ejb.EJB;
import javax.faces.model.SelectItem;

import org.operamasks.faces.annotation.ManagedBean;
import org.operamasks.faces.annotation.ManagedBeanScope;
import org.operamasks.faces.demo.hr.entity.Department;
import org.operamasks.faces.demo.hr.entity.Employee;
import org.operamasks.faces.demo.hr.entity.IDepartmentService;
import org.operamasks.faces.demo.hr.entity.IEmployeeService;
import org.operamasks.faces.demo.hr.entity.IRankService;
import org.operamasks.faces.demo.hr.entity.Rank;

@ManagedBean(scope = ManagedBeanScope.SESSION)
public class EmployeeBean extends BaseGridBean{
    @EJB(name = "org.operamasks.faces.demo.hr.entity.EmployeeService")
    private IEmployeeService employeeService;
    @EJB(name = "org.operamasks.faces.demo.hr.entity.DepartmentService")
    private IDepartmentService departmentService;
    @EJB(name = "org.operamasks.faces.demo.hr.entity.RankService")
    private IRankService rankService;

    private Employee employee;
    
    public EmployeeBean() {
        create();
    }
    
    public List<Employee> getEmployees() {
        return employeeService.listEmployee();
    }

    public Employee getEmployee() {
        grid.setRowIndex(row);
        if (grid.isRowAvailable()) {
            employee = (Employee) grid.getRowData();
        }
        if(employee.getDepartment() == null) {
            employee.setDepartment(new Department());
        }
        if(employee.getRank() == null) {
            employee.setRank(new Rank());
        }
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public SelectItem[] getItems() {
        List<Employee> models = employeeService.listEmployee();
        if(models != null) {
            SelectItem[] items = new SelectItem[models.size()];
            int i = 0;
            for(Employee model : models) {
                String label = model.getName();
                if(model.getDepartment() != null) {
                    label = label.concat("[").concat(model.getDepartment().getName()).concat("]");
                }
                items[i++] = new SelectItem(model.getId(),label);
            }
            return items;
        }
        return null;
    }

    public void create() {
        employee = new Employee();
        employee.setId(UUID.randomUUID().toString());
        employee.setDepartment(new Department());
        employee.setRank(new Rank());
        row = -1;
        
    }
    
    public void remove() {
        grid.setRowIndex(row);
        if(grid.isRowAvailable()) {
            employee = (Employee) grid.getRowData();
            employeeService.removeEmployee(employee);
            if(row-1 > 0) {
                grid.setRowIndex(row-1);
                employee = (Employee) grid.getRowData();
            }
            else {
                create();
            }
            grid.reload();
        }
    }
    
    public void saveAndAdd() {
        save();
        create();
    }

    public void save() {
        Rank rank = null;
        Department department = null;
        if(employee.getRank().getId() != null){
            rank = rankService.getRank(employee.getRank().getId());
        }
        if(employee.getDepartment().getId() != null){
            department = departmentService.getDepartment(employee.getDepartment().getId());
        }
        employee.setDepartment(department);
        employee.setRank(rank);
        employeeService.modifyEmployee(employee);
        grid.reload();
    }
 
}
