package org.operamasks.faces.demo.hr;

import java.util.UUID;

import javax.ejb.EJB;

import org.operamasks.faces.annotation.ManagedBean;
import org.operamasks.faces.annotation.ManagedBeanScope;
import org.operamasks.faces.demo.hr.entity.Department;
import org.operamasks.faces.demo.hr.entity.IDepartmentService;
import org.operamasks.faces.demo.hr.entity.IEmployeeService;
import org.operamasks.faces.demo.hr.entity.IModuleService;
import org.operamasks.faces.demo.hr.entity.IRankService;
import org.operamasks.faces.demo.hr.entity.IRoleService;
import org.operamasks.faces.demo.hr.entity.ITrainItemCategoryService;
import org.operamasks.faces.demo.hr.entity.ITrainItemService;
import org.operamasks.faces.demo.hr.entity.ITrainRecordService;
import org.operamasks.faces.demo.hr.entity.IUserService;
import org.operamasks.faces.demo.hr.entity.Module;
import org.operamasks.faces.demo.hr.entity.Role;
import org.operamasks.faces.demo.hr.entity.TrainItem;
import org.operamasks.faces.demo.hr.entity.TrainItemCategory;
import org.operamasks.faces.demo.hr.entity.User;

@ManagedBean(scope=ManagedBeanScope.SESSION)
public class InitDataBean {
    @EJB(name="org.operamasks.faces.demo.hr.entity.UserService")
    private IUserService userService;

    @EJB(name="org.operamasks.faces.demo.hr.entity.ModuleService")
    private IModuleService moduleService;

    @EJB(name="org.operamasks.faces.demo.hr.entity.RoleService")
    private IRoleService roleService;

    @EJB(name="org.operamasks.faces.demo.hr.entity.EmployeeService")
    private IEmployeeService employService;

    @EJB(name="org.operamasks.faces.demo.hr.entity.DepartmentService")
    private IDepartmentService departmentService;

    @EJB(name="org.operamasks.faces.demo.hr.entity.RankService")
    private IRankService rankService;

    @EJB(name="org.operamasks.faces.demo.hr.entity.TrainItemCategoryService")
    private ITrainItemCategoryService trainCategoryService;

    @EJB(name="org.operamasks.faces.demo.hr.entity.TrainItemService")
    private ITrainItemService trainItemService;

    @EJB(name="org.operamasks.faces.demo.hr.entity.EmployeeService")
    private IEmployeeService employeeService;
    
    @EJB(name="org.operamasks.faces.demo.hr.entity.TrainRecordService")
    private ITrainRecordService trainRecordService;
    
    private String result = "";
    
    private Module rootModule = new Module();
    private Role role = new Role();
    
    public void initData() {
        createTrainCategory();
        createTrainItem();
        createDepartment();
        createEmpoyee();
        createTrainRecord();
        createModule();
        createRole();
        createUser();
        result = "completed";
    }
    
    private void createTrainRecord() {
        
    }

    private void createEmpoyee() {
        
    }

    private void createDepartment() {
        Department department = new Department();
        department.setId(getId());
        department.setName("开发部");
        departmentService.createDepartment(department);
    }

    private void createTrainItem() {
//        TrainItem trainItem = new TrainItem();
//        trainItem.setId(getId());
//        trainItem.setName("MQ内部培训");
//        trainItemService.createTrainItem(trainItem);
    }

    private void createTrainCategory() {
        TrainItemCategory category = new TrainItemCategory();
        category.setId(getId());
        category.setName("内部培训");
        trainCategoryService.createTrainItemCategory(category);
        category = new TrainItemCategory();
        category.setId(getId());
        category.setName("外部培训");
        trainCategoryService.createTrainItemCategory(category);
    }

    private String getId() {
        return UUID.randomUUID().toString();
    }

    private void createModule() {
        rootModule = new Module();
        rootModule.setId("root");
        rootModule.setName("所有模块");

        Module baseModule = new Module();
        baseModule.setId(getId());
        baseModule.setName("基础数据");
        baseModule.setModule(rootModule);
        rootModule.getModules().add(baseModule);
        
        Module sysModule = new Module();
        sysModule.setId(getId());
        sysModule.setName("系统管理");
        sysModule.setModule(rootModule);
        rootModule.getModules().add(sysModule);

        Module subModule = new Module();
        subModule.setId(getId());
        subModule.setName("用户管理");
        subModule.setUrl("userManager.jsp");
        subModule.setModule(sysModule);
        sysModule.getModules().add(subModule);
        
        subModule = new Module();
        subModule.setId(getId());
        subModule.setName("模块管理");
        subModule.setUrl("module/moduleManager.jsp");
        subModule.setModule(sysModule);
        sysModule.getModules().add(subModule);

        subModule = new Module();
        subModule.setId(getId());
        subModule.setName("角色管理");
        subModule.setUrl("roleManager.jsp");
        subModule.setModule(sysModule);
        sysModule.getModules().add(subModule);
        
        subModule = new Module();
        subModule.setId(getId());
        subModule.setName("角色授权");
        subModule.setUrl("roleModule.jsp");
        subModule.setModule(sysModule);
        sysModule.getModules().add(subModule);

        subModule = new Module();
        subModule.setId(getId());
        subModule.setName("权限管理");
        subModule.setUrl("userRole.jsp");
        subModule.setModule(sysModule);
        sysModule.getModules().add(subModule);

        moduleService.createModule(rootModule);
    }

    private void createRole() {
        role = new Role();
        role.setId(getId());
        role.setName("管理员");
        role.getModules().add(rootModule);
        roleService.createRole(role);
    }

    private void createUser() {
        User user = new User();
        user.setId(getId());
        user.setLoginName("admin");
        user.getRoles().add(role);
        userService.createUser(user);
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

}
