/*
 * $Id: LoginBean.java,v 1.5 2007/07/18 16:39:51 jacky Exp $
 *
 * Copyright (C) 2006 Operamasks Community.
 * Copyright (C) 2000-2006 Apusic Systems, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses.
 * 
 */
package org.operamasks.faces.demo.hr;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.List;
import java.util.Random;

import javax.ejb.EJB;
import javax.faces.context.FacesContext;

import org.operamasks.faces.annotation.ManagedBean;
import org.operamasks.faces.annotation.ManagedBeanScope;
import org.operamasks.faces.demo.hr.entity.IUserService;
import org.operamasks.faces.demo.hr.entity.User;

@ManagedBean(scope = ManagedBeanScope.SESSION)
public class LoginBean
{
    @EJB(name = "org.operamasks.faces.demo.hr.entity.UserService")
    private IUserService userService;
    
    private User user;
    private String message;
    private String loginScript;
    private String logoutScript;
    private boolean sucessfully = false;
    private Random random = new Random();

    private String authCode;

    public LoginBean() {
        user = new User();
        user.setLoginName("user2");
        user.setPassword("user2");
        message = "";
    }
    
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @SuppressWarnings("unchecked")
    public void login() {
        if(validateAuthCode() && checkUser()) {
            UserBean.setCurrentUser(user);
            sucessfully = true;
            loginScript = "location.href='../index.jsf';";
            logoutScript = null;
        } else {
            user = new User();
            user.setLoginName("user2");
            user.setPassword("user2");
        }
    }
    
    public void logout() {
        sucessfully = false;
        UserBean.removeCurrentUser();
        user = new User();
        user.setLoginName("user2");
        user.setPassword("user2");
        logoutScript = "location.href='module/login.jsf';";
        loginScript = null;
        message = null;
        MenuBean menuBean = getMenuBean();
        if(menuBean != null) {
            menuBean.getContentUpdater().unload();
        }
    }

    private MenuBean getMenuBean() {
        FacesContext context = FacesContext.getCurrentInstance();
        return (MenuBean) context.getExternalContext().getSessionMap().get("MenuBean");
    }

    private boolean checkUser() {
        List<User> users = userService.findUserByName(user.getLoginName());
        if(users == null || users.size() == 0) {
            message = "用户名不存在";
            return false ;
        }
        for(User realUser : users) {
            if(realUser.getPassword() == null || user.getPassword().equals(realUser.getPassword())) {
                user = realUser;
                return true;
            }
        }
        message = "密码错误";
        return false;
    }
    
    public String getAuthCode() { return this.authCode; }
    public void setAuthCode(String authCode) {this.authCode = authCode;}

    public boolean validateAuthCode() {
        String rand = this.randCode;
        this.randCode = null; // 下次重新生成新的验证码

        if (authCode == null || !authCode.equals(rand)) {
            message = "验证码错误";
            authCode = null;
            return false;
        }
        authCode = null;
        return true;
    }

    private Color randColor(int fc, int bc) {
        if (fc > 255) fc = 255;
        if (bc > 255) bc = 255;
        int r = fc + random.nextInt(bc-fc);
        int g = fc + random.nextInt(bc-fc);
        int b = fc + random.nextInt(bc-fc);
        return new Color(r,g,b);
    }

    
    public void draw(Graphics g, int width, int height) {
        g.setColor(randColor(200, 250));
        g.fillRect(0, 0, width, height);
        g.setFont(new Font("Times New Roman", Font.PLAIN, 18));
        g.setColor(randColor(160, 200));

        // 随机产生155条干扰线，使图像中的验证码不易被识别
        for (int i = 0; i < 155; i++) {
            int x = random.nextInt(width);
            int y = random.nextInt(height);
            int xl = random.nextInt(12);
            int yl = random.nextInt(12);
            g.drawLine(x, y, x + xl, y + yl);
        }

        // 将验证码显示在图像中
        String code = randCode();
        for (int i = 0; i < 4; i++) {
            g.setColor(randColor(20,130));
            g.drawString(code.substring(i,i+1), 13 * i + 6, 16);
        }
    }

    private String randCode() {
        if (this.randCode == null) {
            randCode = "";
            for (int i = 0; i < 4; i++) {
                randCode += String.valueOf(random.nextInt(10));
            }
        }
        return randCode;
    }

    private String randCode = null;

    public String getLoginScript() {
        return this.loginScript;
    }

    public void setLoginScript(String script) {
        this.loginScript = script;
    }

    public boolean isSucessfully() {
        return this.sucessfully;
    }

    public void setSucessfully(boolean sucessfully) {
        this.sucessfully = sucessfully;
    }

    public String getLogoutScript() {
        return this.logoutScript;
    }

    public void setLogoutScript(String logoutScript) {
        this.logoutScript = logoutScript;
    }
    
}
