/*
 * $Id: MenuBean.java,v 1.6 2007/07/16 12:38:59 jacky Exp $
 *
 * Copyright (C) 2006 Operamasks Community.
 * Copyright (C) 2000-2006 Apusic Systems, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses.
 * 
 */
package org.operamasks.faces.demo.hr;

import java.util.Map;

import javax.ejb.EJB;
import javax.faces.context.FacesContext;

import org.operamasks.faces.annotation.ManagedBean;
import org.operamasks.faces.annotation.ManagedBeanScope;
import org.operamasks.faces.component.ajax.AjaxUpdater;
import org.operamasks.faces.demo.hr.entity.IModuleService;
import org.operamasks.faces.demo.hr.entity.Module;
import org.operamasks.faces.demo.hr.entity.Role;
import org.operamasks.faces.demo.hr.entity.User;

@ManagedBean(scope=ManagedBeanScope.SESSION)
public class MenuBean 
{
    @EJB(name="org.operamasks.faces.demo.hr.entity.ModuleService")
    private IModuleService moduleService;
    private AjaxUpdater contentUpdater;
    
    //private final static String SELECTED_ID = "_selectedMenuId";
    private final static String SELECTED_URL = "_selectedMenuUrl";
    
    public Module getRootModule() {
        Module rootModule = moduleService.getModule("root");
        rootModule = checkRoles(rootModule);
        return rootModule;
    }
    
    private Module checkRoles(Module rootModule) {
        User user = UserBean.getCurrentUser();
        if(user == null){
            return null;
        }
        Module userModule = cloneModule(rootModule) ;
        for(Module module : rootModule.getModules()) {
            Module userSubModule = null;
            if(isValidModule(user,module)) {
                userSubModule = cloneModule(module);
                userModule.getModules().add(userSubModule);
                for(Module subModule : module.getModules()) {
                    if(isValidModule(user,subModule)) {
                        Module wrapped = cloneModule(subModule);
                        userSubModule.getModules().add(wrapped);
                    }
                }
            }
        }
        return userModule;
    }
    
    private Module cloneModule(Module source) {
        Module dest = new Module();
        dest.setIcon(source.getIcon());
        dest.setId(source.getId());
        dest.setName(source.getName());
        dest.setUrl(source.getUrl());
        return dest;
    }
    
    private boolean isValidModule(User user, Module module) {
        boolean valid = false;
        for(Role role :user.getRoles()) {
            for(Module roleModule : role.getModules()) {
                if(roleModule.getId().equals(module.getId())) {
                    valid = true;
                    break;
                }
            }
        }
        return valid;
    }

    public void menuAction() {
        FacesContext context = FacesContext.getCurrentInstance() ;
        if( context != null ) {
            Map<String,String> paramMap = context.getExternalContext().getRequestParameterMap();
            String selectedURL = paramMap.get(SELECTED_URL);
            if (selectedURL!=null) {
                if(!selectedURL.startsWith("/")) {
                    selectedURL = "/"+selectedURL;
                }
                loadContent(selectedURL);
            } else {
                contentUpdater.unload();
            }
        }
    }
    private void loadContent(String uri) {
        contentUpdater.unload();
        String viewId = contentUpdater.getSubviewId();
        if (viewId == null || !viewId.equals(uri)) {
            contentUpdater.load(uri);
        }
    }
    public AjaxUpdater getContentUpdater() {
        return this.contentUpdater;
    }
    
    public void setContentUpdater(AjaxUpdater contentUpdater) {
        this.contentUpdater = contentUpdater;
    }

}
