/*
 * $Id: ModuleBean.java,v 1.3 2007/07/12 15:29:07 jacky Exp $
 *
 * Copyright (C) 2006 Operamasks Community.
 * Copyright (C) 2000-2006 Apusic Systems, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses.
 * 
 */
package org.operamasks.faces.demo.hr;

import java.util.List;
import java.util.UUID;

import javax.ejb.EJB;
import javax.faces.model.SelectItem;

import org.operamasks.faces.annotation.ManagedBean;
import org.operamasks.faces.annotation.ManagedBeanScope;
import org.operamasks.faces.demo.hr.entity.IModuleService;
import org.operamasks.faces.demo.hr.entity.Module;

@ManagedBean(scope=ManagedBeanScope.SESSION)
public class ModuleBean extends BaseGridBean
{
    @EJB(name="org.operamasks.faces.demo.hr.entity.ModuleService")
    private IModuleService moduleService;
    
    private Module module;
    private String parentModuleId;
    
    public ModuleBean() {
        create();
    }
    
    public Module getRootModule() {
        Module rootModule = moduleService.getModule("root");
        return rootModule;
    }
    
    public SelectItem[] getModuleItems() {
        List<Module> modules = moduleService.listModule();
        if(modules != null) {
            SelectItem[] items = new SelectItem[modules.size()];
            int i = 0;
            for(Module module : modules) {
                items[i++] = new SelectItem(module.getId(),module.getName());
            }
            return items;
        }
        return null;
    }
    
    public List<Module> getModules() {
        return moduleService.listModule();
    }

    
    public Module getModule() {
        grid.setRowIndex(row);
        if(grid.isRowAvailable()) {
            module = (Module) grid.getRowData();
            Module parent = module.getModule();
            if(parent != null) {
                parentModuleId = parent.getId();
            }
        }
        return this.module;
    }

    public void setModule(Module module) {
        this.module = module;
    }

    public void create() {
        module = new Module();
        module.setId(UUID.randomUUID().toString());
        parentModuleId = null;
        row = -1;
    }
    
    public void remove() {
        grid.setRowIndex(row);
        if(grid.isRowAvailable()) {
            module = (Module) grid.getRowData();
            moduleService.removeModule(module);
            if(row < grid.getRowCount()-1) {
                row++;
            }
            grid.setRowIndex(row);
            module = (Module) grid.getRowData();
            grid.reload();
        }
    }
    
    public void save() {
        if(parentModuleId != null) {
            Module parent = moduleService.getModule(parentModuleId);
            module.setModule(parent);
            parent.getModules().add(module);
        }
        moduleService.modifyModule(module);
        grid.reload();
    }


    public String getParentModuleId() {
        return this.parentModuleId;
    }

    public void setParentModuleId(String parentModuleId) {
        this.parentModuleId = parentModuleId;
    }

}
