/*
 * $Id: RankBean.java,v 1.2 2007/07/12 15:29:08 jacky Exp $
 *
 * Copyright (C) 2006 Operamasks Community.
 * Copyright (C) 2000-2006 Apusic Systems, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses.
 * 
 */
package org.operamasks.faces.demo.hr;

import java.util.List;
import java.util.UUID;

import javax.ejb.EJB;
import javax.faces.model.SelectItem;

import org.operamasks.faces.annotation.ManagedBean;
import org.operamasks.faces.annotation.ManagedBeanScope;
import org.operamasks.faces.demo.hr.entity.IRankService;
import org.operamasks.faces.demo.hr.entity.Rank;

@ManagedBean(scope = ManagedBeanScope.SESSION)
public class RankBean extends BaseGridBean
{
    @EJB(name = "org.operamasks.faces.demo.hr.entity.RankService")
    private IRankService rankService;
    
    private Rank rank;
    
    public RankBean() {
        create();
    }
    
    public List<Rank> getRanks() {
        return rankService.listRank();
    }

    public Rank getRank() {
        grid.setRowIndex(row);
        if (grid.isRowAvailable()) {
            rank = (Rank) grid.getRowData();
        }
        return this.rank;
    }

    public void setRank(Rank rank) {
        this.rank = rank;
    }
    
    public SelectItem[] getItems() {
        List<Rank> models = rankService.listRank();
        if(models != null) {
            SelectItem[] items = new SelectItem[models.size()];
            int i = 0;
            for(Rank model : models) {
                items[i++] = new SelectItem(model.getId(),model.getName());
            }
            return items;
        }
        return null;
    }
    
    public void create() {
        rank = new Rank();
        rank.setId(UUID.randomUUID().toString());
        row = -1;
    }
    
    public void remove() {
        grid.setRowIndex(row);
        if(grid.isRowAvailable()) {
            rank = (Rank) grid.getRowData();
            rankService.removeRank(rank);
            if(row-1 > 0) {
                grid.setRowIndex(row-1);
                rank = (Rank) grid.getRowData();
            }
            else {
                create();
            }
            grid.reload();
        }
    }
    
    public void saveAndAdd() {
        save();
        create();
    }

    public void save() {
        rankService.modifyRank(rank);
        grid.reload();
    }
}
