/*
 * $Id: RoleBean.java,v 1.2 2007/07/12 15:29:07 jacky Exp $
 *
 * Copyright (C) 2006 Operamasks Community.
 * Copyright (C) 2000-2006 Apusic Systems, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses.
 * 
 */
package org.operamasks.faces.demo.hr;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import javax.ejb.EJB;
import javax.faces.model.SelectItem;

import org.operamasks.faces.annotation.ManagedBean;
import org.operamasks.faces.annotation.ManagedBeanScope;
import org.operamasks.faces.demo.hr.entity.IModuleService;
import org.operamasks.faces.demo.hr.entity.IRoleService;
import org.operamasks.faces.demo.hr.entity.Module;
import org.operamasks.faces.demo.hr.entity.Role;

@ManagedBean(scope=ManagedBeanScope.SESSION)
public class RoleBean extends BaseGridBean
{
    @EJB(name="org.operamasks.faces.demo.hr.entity.RoleService")
    private IRoleService roleService;
    @EJB(name="org.operamasks.faces.demo.hr.entity.ModuleService")
    private IModuleService moduleService;

    private Role role;
    private String[] selectedModules;
    
    public RoleBean() {
        create();
    }
    
    public List<Role> getRoles() {
        return roleService.listRole();
    }

    
    public Role getRole() {
        grid.setRowIndex(row);
        if(grid.isRowAvailable()) {
            role = (Role) grid.getRowData();
        }
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public void create() {
        role = new Role();
        role.setId(UUID.randomUUID().toString());
        selectedModules = null;
        row = -1;
    }
    
    public void remove() {
        grid.setRowIndex(row);
        if(grid.isRowAvailable()) {
            role = (Role) grid.getRowData();
            roleService.removeRole(role);
            if(row-1 > 0) {
                grid.setRowIndex(row-1);
                role = (Role) grid.getRowData();
                getSelectedModules(row-1);
            }
            else {
                create();
            }
            grid.reload();
        }
    }
    
    public void save() {
        if(selectedModules != null) {
            List<Module> modules = getModules();
            if(modules != null) {
                role.getModules().clear();
                role.getModules().addAll(modules);
            }
        }
        roleService.modifyRole(role);
        grid.reload();
    }
    
    public SelectItem[] getItems() {
        List<Role> models = roleService.listRole();
        if(models != null) {
            SelectItem[] items = new SelectItem[models.size()];
            int i = 0;
            for(Role model : models) {
                items[i++] = new SelectItem(model.getId(),model.getName());
            }
            return items;
        }
        return null;
    }

    private List<Module> getModules() {
        if(selectedModules == null) {
            return null;
        }
        List<Module> modules = new ArrayList<Module>();
        for(String moduleId : selectedModules) {
            Module module = moduleService.getModule(moduleId);
            if(module != null) {
                modules.add(module);
            }
        }
        return modules;
    }

    public String[] getSelectedModules() {
        return getSelectedModules(row);
    }
    
    public String[] getSelectedModules(int index) {
        Role selectedRole = null;
        grid.setRowIndex(row);
        if(grid.isRowAvailable()) {
            selectedRole = (Role) grid.getRowData();
        }
        if(selectedRole != null) {
            List<Module> modules = selectedRole.getModules();
            if(modules != null) {
                this.selectedModules = new String[modules.size()];
                int i = 0;
                for(Module module : modules) {
                    selectedModules[i++] = module.getId();
                }
            }
        }
        return this.selectedModules;
    }

    public void setSelectedModules(String[] selectedRole) {
        this.selectedModules = selectedRole;
    }


}
