/*
 * $Id: TrainItemBean.java,v 1.2 2007/07/17 11:58:04 jacky Exp $
 *
 * Copyright (C) 2006 Operamasks Community.
 * Copyright (C) 2000-2006 Apusic Systems, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses.
 * 
 */
package org.operamasks.faces.demo.hr;

import java.util.List;
import java.util.UUID;

import javax.ejb.EJB;
import javax.faces.model.SelectItem;

import org.operamasks.faces.annotation.ManagedBean;
import org.operamasks.faces.annotation.ManagedBeanScope;
import org.operamasks.faces.demo.hr.entity.ITrainItemCategoryService;
import org.operamasks.faces.demo.hr.entity.ITrainItemService;
import org.operamasks.faces.demo.hr.entity.TrainItem;
import org.operamasks.faces.demo.hr.entity.TrainItemCategory;

@ManagedBean(scope = ManagedBeanScope.SESSION)
public class TrainItemBean extends BaseGridBean
{
    @EJB(name = "org.operamasks.faces.demo.hr.entity.TrainItemService")
    private ITrainItemService trainItemService;
    @EJB(name = "org.operamasks.faces.demo.hr.entity.TrainItemCategoryService")
    private ITrainItemCategoryService trainItemCategoryService;

    private TrainItem trainItem;
    
    public TrainItemBean() {
        create();
    }
    
    public List<TrainItem> getTrainItems() {
        return trainItemService.listTrainItem();
    }

    public TrainItem getTrainItem() {
        grid.setRowIndex(row);
        if (grid.isRowAvailable()) {
            trainItem = (TrainItem) grid.getRowData();
        }
        if(trainItem.getTrainItemCategory() == null) {
            trainItem.setTrainItemCategory(new TrainItemCategory());
        }
        return this.trainItem;
    }

    public void setTrainItem(TrainItem trainItem) {
        this.trainItem = trainItem;
    }
    
    public SelectItem[] getItems() {
        List<TrainItem> models = trainItemService.listTrainItem();
        if(models != null) {
            SelectItem[] items = new SelectItem[models.size()];
            int i = 0;
            for(TrainItem model : models) {
                items[i++] = new SelectItem(model.getId(),model.getName());
            }
            return items;
        }
        return null;
    }
    
    public void create() {
        trainItem = new TrainItem();
        trainItem.setId(UUID.randomUUID().toString());
        trainItem.setTrainItemCategory(new TrainItemCategory());
        row = -1;
    }
    
    public void remove() {
        grid.setRowIndex(row);
        if(grid.isRowAvailable()) {
            trainItem = (TrainItem) grid.getRowData();
            trainItemService.removeTrainItem(trainItem);
            if(row-1 > 0) {
                grid.setRowIndex(row-1);
                trainItem = (TrainItem) grid.getRowData();
            }
            else {
                create();
            }
            grid.reload();
        }
    }
    
    public void saveAndAdd() {
        save();
        create();
    }

    public void save() {
        TrainItemCategory category = null;
        if(trainItem.getTrainItemCategory().getId() != null) {
            category = trainItemCategoryService.getTrainItemCategory(trainItem.getTrainItemCategory().getId());
        }
        trainItem.setTrainItemCategory(category);
        trainItemService.modifyTrainItem(trainItem);
        grid.reload();
    }
}
