/*
 * $Id: TrainItemCategoryBean.java,v 1.1 2007/07/12 15:29:08 jacky Exp $
 *
 * Copyright (C) 2006 Operamasks Community.
 * Copyright (C) 2000-2006 Apusic Systems, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses.
 * 
 */
package org.operamasks.faces.demo.hr;

import java.util.List;
import java.util.UUID;

import javax.ejb.EJB;
import javax.faces.model.SelectItem;

import org.operamasks.faces.annotation.ManagedBean;
import org.operamasks.faces.annotation.ManagedBeanScope;
import org.operamasks.faces.demo.hr.entity.ITrainItemCategoryService;
import org.operamasks.faces.demo.hr.entity.TrainItemCategory;

@ManagedBean(scope = ManagedBeanScope.SESSION)
public class TrainItemCategoryBean extends BaseGridBean
{
    @EJB(name = "org.operamasks.faces.demo.hr.entity.TrainItemCategoryService")
    private ITrainItemCategoryService trainItemCategoryService;
    
    private TrainItemCategory trainItemCategory;
    
    public TrainItemCategoryBean() {
        create();
    }
    
    public List<TrainItemCategory> getTrainItemCategories() {
        return trainItemCategoryService.listTrainItemCategory();
    }

    public TrainItemCategory getTrainItemCategory() {
        grid.setRowIndex(row);
        if (grid.isRowAvailable()) {
            trainItemCategory = (TrainItemCategory) grid.getRowData();
        }
        return this.trainItemCategory;
    }

    public void setTrainItemCategory(TrainItemCategory trainItemCategory) {
        this.trainItemCategory = trainItemCategory;
    }
    
    public SelectItem[] getItems() {
        List<TrainItemCategory> models = trainItemCategoryService.listTrainItemCategory();
        if(models != null) {
            SelectItem[] items = new SelectItem[models.size()];
            int i = 0;
            for(TrainItemCategory model : models) {
                items[i++] = new SelectItem(model.getId(),model.getName());
            }
            return items;
        }
        return null;
    }
    
    public void create() {
        trainItemCategory = new TrainItemCategory();
        trainItemCategory.setId(UUID.randomUUID().toString());
        row = -1;
    }
    
    public void remove() {
        grid.setRowIndex(row);
        if(grid.isRowAvailable()) {
            trainItemCategory = (TrainItemCategory) grid.getRowData();
            trainItemCategoryService.removeTrainItemCategory(trainItemCategory);
            if(row-1 > 0) {
                grid.setRowIndex(row-1);
                trainItemCategory = (TrainItemCategory) grid.getRowData();
            }
            else {
                create();
            }
            grid.reload();
        }
    }
    
    public void saveAndAdd() {
        save();
        create();
    }

    public void save() {
        trainItemCategoryService.modifyTrainItemCategory(trainItemCategory);
        grid.reload();
    }
}
