/*
 * $Id: TrainRecordBean.java,v 1.2 2007/07/17 11:58:04 jacky Exp $
 *
 * Copyright (C) 2006 Operamasks Community.
 * Copyright (C) 2000-2006 Apusic Systems, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses.
 * 
 */
package org.operamasks.faces.demo.hr;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;

import javax.ejb.EJB;

import org.operamasks.faces.annotation.ManagedBean;
import org.operamasks.faces.annotation.ManagedBeanScope;
import org.operamasks.faces.demo.hr.entity.Employee;
import org.operamasks.faces.demo.hr.entity.IEmployeeService;
import org.operamasks.faces.demo.hr.entity.ITrainItemService;
import org.operamasks.faces.demo.hr.entity.ITrainRecordService;
import org.operamasks.faces.demo.hr.entity.TrainItem;
import org.operamasks.faces.demo.hr.entity.TrainRecord;

@ManagedBean(scope = ManagedBeanScope.SESSION)
public class TrainRecordBean extends BaseGridBean {
	@EJB(name = "org.operamasks.faces.demo.hr.entity.TrainRecordService")
	private ITrainRecordService trainRecordService;
	@EJB(name = "org.operamasks.faces.demo.hr.entity.EmployeeService")
	private IEmployeeService employeeService;
	@EJB(name = "org.operamasks.faces.demo.hr.entity.TrainItemService")
	private ITrainItemService trainItemService;

	private TrainRecord trainRecord;

	private Date trainRecordDate;

	public TrainRecordBean() {
		create();
	}

	public List<TrainRecord> getTrainRecords() {
		return trainRecordService.listTrainRecord();
	}

	public TrainRecord getTrainRecord() {
		grid.setRowIndex(row);
		if (grid.isRowAvailable()) {
			trainRecord = (TrainRecord) grid.getRowData();
		}
		if (trainRecord.getEmployee() == null) {
			trainRecord.setEmployee(new Employee());
		}
		if (trainRecord.getTrainItem() == null) {
			trainRecord.setTrainItem(new TrainItem());
		}
		return this.trainRecord;
	}

	public void setTrainRecord(TrainRecord trainRecord) {
		this.trainRecord = trainRecord;
	}

	public void create() {
		trainRecord = new TrainRecord();
		trainRecord.setId(UUID.randomUUID().toString());
		trainRecord.setEmployee(new Employee());
		trainRecord.setTrainItem(new TrainItem());
		row = -1;
	}

	public void remove() {
		grid.setRowIndex(row);
		if (grid.isRowAvailable()) {
			trainRecord = (TrainRecord) grid.getRowData();
			trainRecordService.removeTrainRecord(trainRecord);
			if (row - 1 > 0) {
				grid.setRowIndex(row - 1);
				trainRecord = (TrainRecord) grid.getRowData();
			} else {
				create();
			}
			grid.reload();
		}
	}

	public void saveAndAdd() {
		save();
		create();
	}

	public void save() {
		Employee employee = null;
		TrainItem trainItem = null;
		if (trainRecord.getEmployee().getId() != null) {
			employee = employeeService.getEmployee(trainRecord.getEmployee()
					.getId());
		}
		if (trainRecord.getTrainItem().getId() != null) {
			trainItem = trainItemService.getTrainItem(trainRecord
					.getTrainItem().getId());
		}
		trainRecord.setEmployee(employee);
		trainRecord.setTrainItem(trainItem);
		trainRecordService.modifyTrainRecord(trainRecord);
		grid.reload();
	}

	public Date getTrainRecordDate() {
		SimpleDateFormat sdf = new SimpleDateFormat();
		sdf.applyPattern("yyyy-MM-dd");
		try {
			return sdf.parse(trainRecord.getTrainDate());
		} catch (Exception e) {
			e.printStackTrace();
		}
		return new Date();
	}

	public void setTrainRecordDate(Date trainRecordDate) {
		SimpleDateFormat sdf = new SimpleDateFormat();
		sdf.applyPattern("yyyy-MM-dd");
		this.trainRecord.setTrainDate(sdf.format(trainRecordDate));
	}


}
