/*
 * $Id: UserBean.java,v 1.2 2007/07/16 12:38:59 jacky Exp $
 *
 * Copyright (C) 2006 Operamasks Community.
 * Copyright (C) 2000-2006 Apusic Systems, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses.
 * 
 */
package org.operamasks.faces.demo.hr;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.ejb.EJB;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;

import org.operamasks.faces.annotation.ManagedBean;
import org.operamasks.faces.annotation.ManagedBeanScope;
import org.operamasks.faces.demo.hr.entity.IRoleService;
import org.operamasks.faces.demo.hr.entity.IUserService;
import org.operamasks.faces.demo.hr.entity.Role;
import org.operamasks.faces.demo.hr.entity.User;

@ManagedBean(scope = ManagedBeanScope.SESSION)
public class UserBean extends BaseGridBean
{
    @EJB(name = "org.operamasks.faces.demo.hr.entity.UserService")
    private IUserService userService;
    @EJB(name="org.operamasks.faces.demo.hr.entity.RoleService")
    private IRoleService roleService;
    
    public final static String CURRENT_USER = "currentUser";

    private User user;
    private String[] selectedRoles;

    public UserBean() {
        create();
    }
    
    public List<User> getUsers() {
        return userService.listUser();
    }

    public User getUser() {
        grid.setRowIndex(row);
        if (grid.isRowAvailable()) {
            user = (User) grid.getRowData();
        }
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }
    
    public SelectItem[] getItems() {
        List<User> models = userService.listUser();
        if(models != null) {
            SelectItem[] items = new SelectItem[models.size()];
            int i = 0;
            for(User model : models) {
                items[i++] = new SelectItem(model.getId(),model.getLoginName());
            }
            return items;
        }
        return null;
    }
    
    public void create() {
        user = new User();
        user.setId(UUID.randomUUID().toString());
        row = -1;
    }
    
    public void remove() {
        grid.setRowIndex(row);
        if(grid.isRowAvailable()) {
            user = (User) grid.getRowData();
            userService.removeUser(user);
            if(row-1 > 0) {
                grid.setRowIndex(row-1);
                user = (User) grid.getRowData();
                getSelectedRoles(row-1);
            }
            else {
                create();
            }
            grid.reload();
        }
    }
    
    public void saveAndAdd() {
        save();
        create();
    }

    public void save() {
        if(selectedRoles != null) {
            List<Role> roles = getRoles();
            if(roles != null) {
                user.getRoles().clear();
                user.getRoles().addAll(roles);
            }
        }
        userService.modifyUser(user);
        grid.reload();
    }
    
    private List<Role> getRoles() {
        if(selectedRoles == null) {
            return null;
        }
        List<Role> roles = new ArrayList<Role>();
        for(String roleId : selectedRoles) {
            Role role = roleService.getRole(roleId);
            if(role != null) {
                roles.add(role);
            }
        }
        return roles;
    }


    public String[] getSelectedRoles() {
        return getSelectedRoles(row);
    }
    
    public String[] getSelectedRoles(int index) {
        User selectedUser = null;
        grid.setRowIndex(row);
        if(grid.isRowAvailable()) {
            selectedUser = (User) grid.getRowData();
        }
        if(selectedUser != null) {
            List<Role> roles = selectedUser.getRoles();
            if(roles != null) {
                this.selectedRoles = new String[roles.size()];
                int i = 0;
                for(Role role : roles) {
                    selectedRoles[i++] = role.getId();
                }
            }
        }
        return this.selectedRoles;
    }


    public void setSelectedRoles(String[] selectedRoles) {
        this.selectedRoles = selectedRoles;
    }

    public static void setCurrentUser(User currUser) {
        Map<String,Object> session = FacesContext.getCurrentInstance().getExternalContext().getSessionMap(); 
        session.put(CURRENT_USER,currUser);
    }

    public static void removeCurrentUser() {
        Map<String,Object> session = FacesContext.getCurrentInstance().getExternalContext().getSessionMap(); 
        session.remove(CURRENT_USER);
    }

    public static User getCurrentUser() {
        if(FacesContext.getCurrentInstance() == null) {
            return null;
        }
        Map<String,Object> session = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
        if(session==null) {
            return null;
        }
        return (User) session.get(CURRENT_USER);
    }
}
