<%@ page trimDirectiveWhitespaces="true" pageEncoding="UTF-8" %>
<%@ taglib prefix="f" uri="http://java.sun.com/jsf/core" %>
<%@ taglib prefix="h" uri="http://java.sun.com/jsf/html" %>
<%@ taglib prefix="w" uri="http://www.apusic.com/jsf/widget" %>
<%@ taglib prefix="l" uri="http://www.apusic.com/jsf/layout" %>
<%@ taglib prefix="ajax" uri="http://www.apusic.com/jsf/ajax" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>
<w:form id="myform">
<h:commandButton id="_hiddenButton" action="#{MenuBean.menuAction}" style="display:none"/>
</w:form>

<l:dynamicAccordionLayout container="west" indexVar="pIndex" var="module" value="#{MenuBean.rootModule.modules}">
    <l:dynamicAccordionPanel collapsed="#{pIndex>0}" showPin="true" title="#{module.name}" icon="#{module.icon}">
		  <w:dataView value="#{module.modules}" var="subModule" async="false">
		    <w:outputColumn id="id" value="#{subModule.id}"/>
		    <w:outputColumn id="subModuleName" value="#{subModule.name}"/>
		    <w:outputColumn id="moduleUrl" value="#{subModule.url}"/>
		    <w:outputColumn id="moduleIcon" value="#{subModule.icon}"/>
		    <f:facet name="template">
		      <f:verbatim>
			<h:panelGroup layout="block" style="padding:3px;padding-left:10px;padding-right:10px">
			<table border="0" cellpadding="3" cellspacing="1" width="100%">
			<tr>
			<td class="menuItem" id="{id}" url="{moduleUrl}"
			onclick="menuItemClick('{id}','{moduleUrl}')" 
			onmouseout="this.className='menuItem';" 
			onmouseover="this.className='menuItemHover';"
			>
				<table>
				<tr>
				<td class="menuIcon" style="background-image:url('{moduleIcon}')">&nbsp;</td>
				<td style="padding-left:2px"><h:outputText value="{subModuleName}"/></td>
				</tr>
				</table>
			</td>
			</tr>
			</table>
			</h:panelGroup>
		     </f:verbatim>
		    </f:facet>
		    <f:facet name="empty">
		      <f:verbatim>没有子模块</f:verbatim>
		    </f:facet>
		  </w:dataView>
    </l:dynamicAccordionPanel>
</l:dynamicAccordionLayout>

<script lang="JAVAScript">
function menuItemClick( menuItemId , menuItemUrl ) {
    OM.ajax.addRequestParameter('_selectedMenuId',menuItemId);
    OM.ajax.addRequestParameter('_selectedMenuUrl',menuItemUrl);
    window.setTimeout(function() {
        OM.ajax.action(document.forms['west:myform'], '/hr/index.jsf', 'west:myform:_hiddenButton' , false);
    }, 50);
    return true;
}

</script>
