<?php
/**
 * File Name: pradolite.php
 * Last Update: 2006/06/04 18:52:43
 * Generated By: buildscripts/phpbuilder/build.php
 *
 * This file is used in lieu of prado.php to boost PRADO application performance.
 * It is generated by expanding prado.php with included files.
 * Comments and trace statements are stripped off.
 *
 * Do not modify this file manually.
 */

if(!defined('PRADO_DIR'))
	define('PRADO_DIR',dirname(__FILE__));
class TComponent
{
	private $_e=array();
	public function __get($name)
	{
		$getter='get'.$name;
		if(method_exists($this,$getter))
		{
			return $this->$getter();
		}
		else if(strncasecmp($name,'on',2)===0 && method_exists($this,$name))
		{
			$name=strtolower($name);
			if(!isset($this->_e[$name]))
				$this->_e[$name]=new TList;
			return $this->_e[$name];
		}
		else
		{
			throw new TInvalidOperationException('component_property_undefined',get_class($this),$name);
		}
	}
	public function __set($name,$value)
	{
		$setter='set'.$name;
		if(method_exists($this,$setter))
		{
			$this->$setter($value);
		}
		else if(strncasecmp($name,'on',2)===0 && method_exists($this,$name))
		{
			$this->attachEventHandler($name,$value);
		}
		else if(method_exists($this,'get'.$name))
		{
			throw new TInvalidOperationException('component_property_readonly',get_class($this),$name);
		}
		else
		{
			throw new TInvalidOperationException('component_property_undefined',get_class($this),$name);
		}
	}
	public function hasProperty($name)
	{
		return method_exists($this,'get'.$name) || method_exists($this,'set'.$name);
	}
	public function canGetProperty($name)
	{
		return method_exists($this,'get'.$name);
	}
	public function canSetProperty($name)
	{
		return method_exists($this,'set'.$name);
	}
	public function getSubProperty($path)
	{
		$object=$this;
		foreach(explode('.',$path) as $property)
			$object=$object->$property;
		return $object;
	}
	public function setSubProperty($path,$value)
	{
		$object=$this;
		if(($pos=strrpos($path,'.'))===false)
			$property=$path;
		else
		{
			$object=$this->getSubProperty(substr($path,0,$pos));
			$property=substr($path,$pos+1);
		}
		$object->$property=$value;
	}
	public function hasEvent($name)
	{
		return strncasecmp($name,'on',2)===0 && method_exists($this,$name);
	}
	public function hasEventHandler($name)
	{
		$name=strtolower($name);
		return isset($this->_e[$name]) && $this->_e[$name]->getCount()>0;
	}
	public function getEventHandlers($name)
	{
		if(strncasecmp($name,'on',2)===0 && method_exists($this,$name))
		{
			$name=strtolower($name);
			if(!isset($this->_e[$name]))
				$this->_e[$name]=new TList;
			return $this->_e[$name];
		}
		else
			throw new TInvalidOperationException('component_event_undefined',get_class($this),$name);
	}
	public function attachEventHandler($name,$handler)
	{
		$this->getEventHandlers($name)->add($handler);
	}
	public function detachEventHandler($name,$handler)
	{
		if($this->hasEventHandler($name))
		{
			try
			{
				$this->getEventHandlers($name)->remove($handler);
				return true;
			}
			catch(Exception $e)
			{
			}
		}
		return false;
	}
	public function raiseEvent($name,$sender,$param)
	{
		$name=strtolower($name);
		if(isset($this->_e[$name]))
		{
			foreach($this->_e[$name] as $handler)
			{
				if(is_string($handler))
				{
					call_user_func($handler,$sender,$param);
				}
				else if(is_callable($handler,true))
				{
					list($object,$method)=$handler;
					if(is_string($object))	
						call_user_func($handler,$sender,$param);
					else
					{
						if(($pos=strrpos($method,'.'))!==false)
						{
							$object=$this->getSubProperty(substr($method,0,$pos));
							$method=substr($method,$pos+1);
						}
						if(method_exists($object,$method))
							$object->$method($sender,$param);
						else
							throw new TInvalidDataValueException('component_eventhandler_invalid',get_class($this),$name);
					}
				}
				else
					throw new TInvalidDataValueException('component_eventhandler_invalid',get_class($this),$name);
			}
		}
		else if(!$this->hasEvent($name))
			throw new TInvalidOperationException('component_event_undefined',get_class($this),$name);
	}
	public function evaluateExpression($expression)
	{
		try
		{
			if(eval("\$result=$expression;")===false)
				throw new Exception('');
			return $result;
		}
		catch(Exception $e)
		{
			throw new TInvalidOperationException('component_expression_invalid',get_class($this),$expression,$e->getMessage());
		}
	}
	public function evaluateStatements($statements)
	{
		try
		{
			ob_start();
			if(eval($statements)===false)
				throw new Exception('');
			$content=ob_get_contents();
			ob_end_clean();
			return $content;
		}
		catch(Exception $e)
		{
			throw new TInvalidOperationException('component_statements_invalid',get_class($this),$statements,$e->getMessage());
		}
	}
}
class TPropertyValue
{
	public static function ensureBoolean($value)
	{
		if (is_string($value))
			return strcasecmp($value,'true')==0 || $value!=0;
		else
			return (boolean)$value;
	}
	public static function ensureString($value)
	{
		if (is_bool($value))
			return $value?'true':'false';
		else
			return (string)$value;
	}
	public static function ensureInteger($value)
	{
		return (integer)$value;
	}
	public static function ensureFloat($value)
	{
		return (float)$value;
	}
	public static function ensureArray($value)
	{
		if(is_string($value))
		{
			$trimmed = trim($value);
			$len = strlen($value);
			if ($len >= 2 && $trimmed[0] == '(' && $trimmed[$len-1] == ')')
			{
				eval('$array=array'.$trimmed.';');
				return $array;
			}
			else
				return $len>0?array($value):array();
		}
		else
			return (array)$value;
	}
	public static function ensureObject($value)
	{
		return (object)$value;
	}
	public static function ensureEnum($value,$enums)
	{
		if(!is_array($enums))
		{
			$enums=func_get_args();
			array_shift($enums);
		}
		if(in_array($value,$enums,true))
			return $value;
		else
			throw new TInvalidDataValueException('propertyvalue_enumvalue_invalid',$value,implode(' | ',$enums));
	}
}
class TEventParameter extends TComponent
{
}
class TComponentReflection extends TComponent
{
	private $_className;
	private $_properties=array();
	private $_events=array();
	private $_methods=array();
	public function __construct($component)
	{
		if(is_string($component) && class_exists($component,false))
			$this->_className=$component;
		else if(is_object($component))
			$this->_className=get_class($component);
		else
			throw new TInvalidDataTypeException('componentreflection_class_invalid');
		$this->reflect();
	}
	private function isPropertyMethod($method)
	{
		$methodName=$method->getName();
		return $method->getNumberOfRequiredParameters()===0
				&& strncasecmp($methodName,'get',3)===0
				&& isset($methodName[3]);
	}
	private function isEventMethod($method)
	{
		$methodName=$method->getName();
		return strncasecmp($methodName,'on',2)===0
				&& isset($methodName[2]);
	}
	private function reflect()
	{
		$class=new TReflectionClass($this->_className);
		$properties=array();
		$events=array();
		$methods=array();
		$isComponent=is_subclass_of($this->_className,'TComponent') || strcasecmp($this->_className,'TComponent')===0;
		foreach($class->getMethods() as $method)
		{
			if($method->isPublic() || $method->isProtected())
			{
				$methodName=$method->getName();
				if(!$method->isStatic() && $isComponent)
				{
					if($this->isPropertyMethod($method))
						$properties[substr($methodName,3)]=$method;
					else if($this->isEventMethod($method))
					{
						$methodName[0]='O';
						$events[$methodName]=$method;
					}
				}
				if(strncmp($methodName,'__',2)!==0)
					$methods[$methodName]=$method;
			}
		}
		$reserved=array();
		ksort($properties);
		foreach($properties as $name=>$method)
		{
			$this->_properties[$name]=array(
				'type'=>$this->determinePropertyType($method),
				'readonly'=>!$class->hasMethod('set'.$name),
				'protected'=>$method->isProtected(),
				'class'=>$method->getDeclaringClass()->getName(),
				'comments'=>$method->getDocComment()
			);
			$reserved['get'.strtolower($name)]=1;
			$reserved['set'.strtolower($name)]=1;
		}
		ksort($events);
		foreach($events as $name=>$method)
		{
			$this->_events[$name]=array(
				'class'=>$method->getDeclaringClass()->getName(),
				'protected'=>$method->isProtected(),
				'comments'=>$method->getDocComment()
			);
			$reserved[strtolower($name)]=1;
		}
		ksort($methods);
		foreach($methods as $name=>$method)
		{
			if(!isset($reserved[strtolower($name)]))
				$this->_methods[$name]=array(
					'class'=>$method->getDeclaringClass()->getName(),
					'protected'=>$method->isProtected(),
					'static'=>$method->isStatic(),
					'comments'=>$method->getDocComment()
				);
		}
	}
	protected function determinePropertyType($method)
	{
		$comment=$method->getDocComment();
		if(preg_match('/@return\\s+(.*?)\\s+/',$comment,$matches))
			return $matches[1];
		else
			return '{unknown}';
	}
	public function getClassName()
	{
		return $this->_className;
	}
	public function getProperties()
	{
		return $this->_properties;
	}
	public function getEvents()
	{
		return $this->_events;
	}
	public function getMethods()
	{
		return $this->_methods;
	}
}
class TException extends Exception
{
	private $_errorCode='';
	public function __construct($errorMessage)
	{
		$this->_errorCode=$errorMessage;
		$errorMessage=$this->translateErrorMessage($errorMessage);
		$args=func_get_args();
		array_shift($args);
		$n=count($args);
		$tokens=array();
		for($i=0;$i<$n;++$i)
			$tokens['{'.$i.'}']=TPropertyValue::ensureString($args[$i]);
		parent::__construct(strtr($errorMessage,$tokens));
	}
	protected function translateErrorMessage($key)
	{
		$msgFile=$this->getErrorMessageFile();
		if(($entries=@file($msgFile))===false)
			return $key;
		else
		{
			foreach($entries as $entry)
			{
				@list($code,$message)=explode('=',$entry,2);
				if(trim($code)===$key)
					return trim($message);
			}
			return $key;
		}
	}
	protected function getErrorMessageFile()
	{
		$lang=Prado::getPreferredLanguage();
		$msgFile=Prado::getFrameworkPath().'/Exceptions/messages-'.$lang.'.txt';
		if(!is_file($msgFile))
			$msgFile=Prado::getFrameworkPath().'/Exceptions/messages.txt';
		return $msgFile;
	}
	public function getErrorCode()
	{
		return $this->_errorCode;
	}
	public function setErrorCode($code)
	{
		$this->_errorCode=$code;
	}
	public function getErrorMessage()
	{
		return $this->getMessage();
	}
	protected function setErrorMessage($message)
	{
		$this->message=$message;
	}
}
class TSystemException extends TException
{
}
class TApplicationException extends TException
{
}
class TInvalidOperationException extends TSystemException
{
}
class TInvalidDataTypeException extends TSystemException
{
}
class TInvalidDataValueException extends TSystemException
{
}
class TConfigurationException extends TSystemException
{
}
class TIOException extends TSystemException
{
}
class TDbException extends TSystemException
{
}
class TDbConnectionException extends TDbException
{
}
class TNotSupportedException extends TSystemException
{
}
class TPhpErrorException extends TSystemException
{
	public function __construct($errno,$errstr,$errfile,$errline)
	{
		static $errorTypes=array(
			E_ERROR           => "Error",
			E_WARNING         => "Warning",
			E_PARSE           => "Parsing Error",
			E_NOTICE          => "Notice",
			E_CORE_ERROR      => "Core Error",
			E_CORE_WARNING    => "Core Warning",
			E_COMPILE_ERROR   => "Compile Error",
			E_COMPILE_WARNING => "Compile Warning",
			E_USER_ERROR      => "User Error",
			E_USER_WARNING    => "User Warning",
			E_USER_NOTICE     => "User Notice",
			E_STRICT          => "Runtime Notice"
		);
		$errorType=isset($errorTypes[$errno])?$errorTypes[$errno]:'Unknown Error';
		parent::__construct("[$errorType] $errstr (@line $errline in file $errfile).");
	}
}
class THttpException extends TSystemException
{
	private $_statusCode;
	public function __construct($statusCode,$errorMessage)
	{
		$this->_statusCode=$statusCode;
		$this->setErrorCode($errorMessage);
		$errorMessage=$this->translateErrorMessage($errorMessage);
		$args=func_get_args();
		array_shift($args);
		array_shift($args);
		$n=count($args);
		$tokens=array();
		for($i=0;$i<$n;++$i)
			$tokens['{'.$i.'}']=TPropertyValue::ensureString($args[$i]);
		parent::__construct(strtr($errorMessage,$tokens));
	}
	public function getStatusCode()
	{
		return $this->_statusCode;
	}
}
class TLogger extends TComponent
{
	const DEBUG=0x01;
	const INFO=0x02;
	const NOTICE=0x04;
	const WARNING=0x08;
	const ERROR=0x10;
	const ALERT=0x20;
	const FATAL=0x40;
	private $_logs=array();
	private $_levels;
	private $_categories;
	public function log($message,$level,$category='Uncategorized')
	{
		$this->_logs[]=array($message,$level,$category,microtime(true));
	}
	public function getLogs($levels=null,$categories=null)
	{
		$this->_levels=$levels;
		$this->_categories=$categories;
		if(empty($levels) && empty($categories))
			return $this->_logs;
		else if(empty($levels))
			return array_values(array_filter(array_filter($this->_logs,array($this,'filterByCategories'))));
		else if(empty($categories))
			return array_values(array_filter(array_filter($this->_logs,array($this,'filterByLevels'))));
		else
		{
			$ret=array_values(array_filter(array_filter($this->_logs,array($this,'filterByLevels'))));
			return array_values(array_filter(array_filter($ret,array($this,'filterByCategories'))));
		}
	}
	private function filterByCategories($value)
	{
		foreach($this->_categories as $category)
		{
			if($value[2]===$category || strpos($value[2],$category.'.')===0)
				return $value;
		}
		return false;
	}
	private function filterByLevels($value)
	{
		if($value[1] & $this->_levels)
			return $value;
		else
			return false;
	}
}
class PradoBase
{
	const CLASS_FILE_EXT='.php';
	private static $_aliases=array('System'=>PRADO_DIR);
	private static $_usings=array();
	private static $_application=null;
	private static $_logger=null;
	public static function getVersion()
	{
		return '3.0.1';
	}
	public static function initErrorHandlers()
	{
		set_error_handler(array('PradoBase','phpErrorHandler'),error_reporting());
		set_exception_handler(array('PradoBase','exceptionHandler'));
	}
	public static function autoload($className)
	{
		include_once($className.self::CLASS_FILE_EXT);
		if(!class_exists($className,false) && !interface_exists($className,false))
			self::fatalError("Class file for '$className' cannot be found.");
	}
	public static function poweredByPrado()
	{
		return '<a title="Powered by PRADO" href="http://www.pradosoft.com/"><img src="http://www.pradosoft.com/images/powered.gif" style="border-width:0px;" alt="Powered by PRADO" /></a>';
	}
	public static function phpErrorHandler($errno,$errstr,$errfile,$errline)
	{
		if(error_reporting()!=0)
			throw new TPhpErrorException($errno,$errstr,$errfile,$errline);
	}
	public static function exceptionHandler($exception)
	{
		if(self::$_application!==null && ($errorHandler=self::$_application->getErrorHandler())!==null)
		{
			$errorHandler->handleError(null,$exception);
		}
		else
		{
			echo $exception;
		}
		exit(1);
	}
	public static function setApplication($application)
	{
		if(self::$_application!==null)
			throw new TInvalidOperationException('prado_application_singleton_required');
		self::$_application=$application;
	}
	public static function getApplication()
	{
		return self::$_application;
	}
	public static function getFrameworkPath()
	{
		return PRADO_DIR;
	}
	public static function serialize($data)
	{
		$arr[0]=$data;
		return serialize($arr);
	}
	public static function unserialize($str)
	{
		$arr=unserialize($str);
		return isset($arr[0])?$arr[0]:null;
	}
	public static function createComponent($type)
	{
		self::using($type);
		if(($pos=strrpos($type,'.'))!==false)
			$type=substr($type,$pos+1);
		if(($n=func_num_args())>1)
		{
			$args=func_get_args();
			$s='$args[1]';
			for($i=2;$i<$n;++$i)
				$s.=",\$args[$i]";
			eval("\$component=new $type($s);");
			return $component;
		}
		else
			return new $type;
	}
	public static function using($namespace)
	{
		if(isset(self::$_usings[$namespace]) || class_exists($namespace,false))
			return;
		if(($pos=strrpos($namespace,'.'))===false)  
		{
			try
			{
				include_once($namespace.self::CLASS_FILE_EXT);
			}
			catch(Exception $e)
			{
				if(!class_exists($namespace,false))
					throw new TInvalidOperationException('prado_component_unknown',$namespace);
				else
					throw $e;
			}
		}
		else if(($path=self::getPathOfNamespace($namespace,self::CLASS_FILE_EXT))!==null)
		{
			$className=substr($namespace,$pos+1);
			if($className==='*')  
			{
				if(is_dir($path))
				{
					self::$_usings[$namespace]=$path;
					set_include_path(get_include_path().PATH_SEPARATOR.$path);
				}
				else
					throw new TInvalidDataValueException('prado_using_invalid',$namespace);
			}
			else  
			{
				if(is_file($path))
				{
					self::$_usings[$namespace]=$path;
					if(!class_exists($className,false))
					{
						try
						{
							include_once($path);
						}
						catch(Exception $e)
						{
							if(!class_exists($className,false))
								throw new TInvalidOperationException('prado_component_unknown',$className);
							else
								throw $e;
						}
					}
				}
				else
					throw new TInvalidDataValueException('prado_using_invalid',$namespace);
			}
		}
		else
			throw new TInvalidDataValueException('prado_using_invalid',$namespace);
	}
	public static function getPathOfNamespace($namespace,$ext='')
	{
		if(isset(self::$_usings[$namespace]))
			return self::$_usings[$namespace];
		else if(isset(self::$_aliases[$namespace]))
			return self::$_aliases[$namespace];
		else
		{
			$segs=explode('.',$namespace);
			$alias=array_shift($segs);
			if(($file=array_pop($segs))!==null && ($root=self::getPathOfAlias($alias))!==null)
				return rtrim($root.'/'.implode('/',$segs),'/').(($file==='*')?'':'/'.$file.$ext);
			else
				return null;
		}
	}
	public static function getPathOfAlias($alias)
	{
		return isset(self::$_aliases[$alias])?self::$_aliases[$alias]:null;
	}
	public static function setPathOfAlias($alias,$path)
	{
		if(isset(self::$_aliases[$alias]))
			throw new TInvalidOperationException('prado_alias_redefined',$alias);
		else if(($rp=realpath($path))!==false && is_dir($rp))
		{
			if(strpos($alias,'.')===false)
				self::$_aliases[$alias]=$rp;
			else
				throw new TInvalidDataValueException('prado_aliasname_invalid',$alias);
		}
		else
			throw new TInvalidDataValueException('prado_alias_invalid',$alias,$path);
	}
	public static function fatalError($msg)
	{
		echo '<h1>Fatal Error</h1>';
		echo '<p>'.$msg.'</p>';
		if(!function_exists('debug_backtrace'))
			return;
		echo '<h2>Debug Backtrace</h2>';
		echo '<pre>';
		$index=-1;
		foreach(debug_backtrace() as $t)
		{
			$index++;
			if($index==0)  
				continue;
			echo '#'.$index.' ';
			if(isset($t['file']))
				echo basename($t['file']) . ':' . $t['line'];
			else
			   echo '<PHP inner-code>';
			echo ' -- ';
			if(isset($t['class']))
				echo $t['class'] . $t['type'];
			echo $t['function'];
			if(isset($t['args']) && sizeof($t['args']) > 0)
				echo '(...)';
			else
				echo '()';
			echo "\n";
		}
		echo '</pre>';
		exit(1);
	}
	public static function getUserLanguages()
	{
		static $languages=null;
		if($languages===null)
		{
			if(!isset($_SERVER['HTTP_ACCEPT_LANGUAGE']))
				$languages[0]='en';
			else
			{
				$languages=array();
				foreach(explode(',',$_SERVER['HTTP_ACCEPT_LANGUAGE']) as $language)
				{
					$array=split(';q=',trim($language));
					$languages[trim($array[0])]=isset($array[1])?(float)$array[1]:1.0;
				}
				arsort($languages);
				$languages=array_keys($languages);
				if(empty($languages))
					$languages[0]='en';
			}
		}
		return $languages;
	}
	public static function getPreferredLanguage()
	{
		static $language=null;
		if($language===null)
		{
			$langs=Prado::getUserLanguages();
			$lang=explode('-',$langs[0]);
			if(empty($lang[0]) || !ctype_alpha($lang[0]))
				$language='en';
			else
				$language=$lang[0];
		}
		return $language;
	}
	public static function trace($msg,$category='Uncategorized')
	{
		if(self::$_application && self::$_application->getMode()===TApplication::STATE_PERFORMANCE)
			return;
		if(!self::$_application || self::$_application->getMode()===TApplication::STATE_DEBUG)
		{
			$trace=debug_backtrace();
			if(isset($trace[0]['file']) && isset($trace[0]['line']))
				$msg.=" (line {$trace[0]['line']}, {$trace[0]['file']})";
			$level=TLogger::DEBUG;
		}
		else
			$level=TLogger::INFO;
		self::log($msg,$level,$category);
	}
	public static function log($msg,$level=TLogger::INFO,$category='Uncategorized')
	{
		if(self::$_logger===null)
			self::$_logger=new TLogger;
		self::$_logger->log($msg,$level,$category);
	}
	public static function getLogger()
	{
		if(self::$_logger===null)
			self::$_logger=new TLogger;
		return self::$_logger;
	}
	public static function varDump($var,$depth=10,$highlight=false)
	{
		require_once(PRADO_DIR.'/Util/TVarDumper.php');
		return TVarDumper::dump($var,$depth,$highlight);
	}
	public static function localize($text, $parameters=array(), $catalogue=null, $charset=null)
	{
		Prado::using('System.I18N.Translation');
		$app = Prado::getApplication()->getGlobalization(false);
		$params = array();
		foreach($parameters as $key => $value)
			$params['{'.$key.'}'] = $value;
		if($app===null || ($config = $app->getTranslationConfiguration())===null)
			return strtr($text, $params);
		Translation::init();
		if(empty($catalogue) && isset($config['catalogue']))
			$catalogue = $config['catalogue'];
		$appCharset = $app===null ? '' : $app->getCharset();
		$defaultCharset = ($app===null) ? 'UTF-8' : $app->getDefaultCharset();
		if(empty($charset)) $charset = $appCharset;
		if(empty($charset)) $charset = $defaultCharset;
		return Translation::formatter()->format($text,$params,$catalogue,$charset);
	}
}
if(version_compare(phpversion(),'5.1.0','>='))
{
	class TReflectionClass extends ReflectionClass
	{
	}
}
else 
{
	class TReflectionClass extends ReflectionClass
	{
		public function hasMethod($method)
		{
			try
			{
				return $this->getMethod($method)!==null;
			}
			catch(Exception $e)
			{
				return false;
			}
		}
		public function hasProperty($property)
		{
			try
			{
				return $this->getProperty($property)!==null;
			}
			catch(Exception $e)
			{
				return false;
			}
		}
	}
	if(!function_exists('property_exists'))
	{
		function property_exists($object, $property)
		{
			if(is_object($object))
				return array_key_exists($property, get_object_vars($object));
			else
				return false;
		}
	}
}
if(!class_exists('Prado',false))
{
	class Prado extends PradoBase
	{
	}
}
if(!function_exists('__autoload'))
{
	function __autoload($className)
	{
		Prado::autoload($className);
	}
}
Prado::initErrorHandlers();
interface IModule
{
	public function init($config);
	public function getID();
	public function setID($id);
}
interface IService
{
	public function init($config);
	public function getID();
	public function setID($id);
	public function run();
}
interface ITextWriter
{
	public function write($str);
	public function flush();
}
interface IUser
{
	public function getName();
	public function setName($value);
	public function getIsGuest();
	public function setIsGuest($value);
	public function getRoles();
	public function setRoles($value);
	public function isInRole($role);
	public function saveToString();
	public function loadFromString($string);
}
interface IStatePersister
{
	public function load();
	public function save($state);
}
interface ICache
{
	public function get($id);
	public function set($id,$value,$expire=0,$dependency=null);
	public function add($id,$value,$expire=0,$dependency=null);
	public function delete($id);
	public function flush();
}
interface ICacheDependency
{
	public function getHasChanged();
}
interface IRenderable
{
	public function render($writer);
}
interface IBindable
{
	public function dataBind();
}
class TApplicationComponent extends TComponent
{
	public function getApplication()
	{
		return Prado::getApplication();
	}
	public function getService()
	{
		return Prado::getApplication()->getService();
	}
	public function getRequest()
	{
		return Prado::getApplication()->getRequest();
	}
	public function getResponse()
	{
		return Prado::getApplication()->getResponse();
	}
	public function getSession()
	{
		return Prado::getApplication()->getSession();
	}
	public function getUser()
	{
		return Prado::getApplication()->getUser();
	}
	public function publishAsset($assetPath)
	{
		$class=new ReflectionClass(get_class($this));
		$fullPath=dirname($class->getFileName()).'/'.$assetPath;
		return $this->publishFilePath($fullPath);
	}
	public function publishFilePath($fullPath)
	{
		return Prado::getApplication()->getAssetManager()->publishFilePath($fullPath);
	}
}
abstract class TModule extends TApplicationComponent implements IModule
{
	private $_id;
	public function init($config)
	{
	}
	public function getID()
	{
		return $this->_id;
	}
	public function setID($value)
	{
		$this->_id=$value;
	}
}
abstract class TService extends TApplicationComponent implements IService
{
	private $_id;
	public function init($config)
	{
	}
	public function getID()
	{
		return $this->_id;
	}
	public function setID($value)
	{
		$this->_id=$value;
	}
	public function run()
	{
	}
}
class TErrorHandler extends TModule
{
	const ERROR_FILE_NAME='error';
	const EXCEPTION_FILE_NAME='exception';
	const SOURCE_LINES=12;
	private $_templatePath=null;
	public function init($config)
	{
		$this->getApplication()->setErrorHandler($this);
	}
	public function getErrorTemplatePath()
	{
		return $this->_templatePath;
	}
	public function setErrorTemplatePath($value)
	{
		if(($templatePath=Prado::getPathOfNamespace($value))!==null && is_dir($templatePath))
			$this->_templatePath=$templatePath;
		else
			throw new TConfigurationException('errorhandler_errortemplatepath_invalid',$value);
	}
	public function handleError($sender,$param)
	{
		static $handling=false;
		restore_error_handler();
		restore_exception_handler();
		if($handling)
			$this->handleRecursiveError($param);
		else
		{
			$handling=true;
			if(($response=$this->getResponse())!==null)
				$response->clear();
			if(!headers_sent())
				header('Content-Type: text/html; charset=UTF-8');
			if($param instanceof THttpException)
				$this->handleExternalError($param->getStatusCode(),$param);
			else if($this->getApplication()->getMode()===TApplication::STATE_DEBUG)
				$this->displayException($param);
			else
				$this->handleExternalError(500,$param);
		}
	}
	protected function handleExternalError($statusCode,$exception)
	{
		if(!($exception instanceof THttpException))
			error_log($exception->__toString());
		if($this->_templatePath===null)
			$this->_templatePath=Prado::getFrameworkPath().'/Exceptions/templates';
		$base=$this->_templatePath.'/'.self::ERROR_FILE_NAME;
		$lang=Prado::getPreferredLanguage();
		if(is_file("$base$statusCode-$lang.html"))
			$errorFile="$base$statusCode-$lang.html";
		else if(is_file("$base$statusCode.html"))
			$errorFile="$base$statusCode.html";
		else if(is_file("$base-$lang.html"))
			$errorFile="$base-$lang.html";
		else
			$errorFile="$base.html";
		if(($content=@file_get_contents($errorFile))===false)
			die("Unable to open error template file '$errorFile'.");
		$serverAdmin=isset($_SERVER['SERVER_ADMIN'])?$_SERVER['SERVER_ADMIN']:'';
		$tokens=array(
			'%%StatusCode%%' => "$statusCode",
			'%%ErrorMessage%%' => htmlspecialchars($exception->getMessage()),
			'%%ServerAdmin%%' => $serverAdmin,
			'%%Version%%' => $_SERVER['SERVER_SOFTWARE'].' <a href="http://www.pradosoft.com/">PRADO</a>/'.Prado::getVersion(),
			'%%Time%%' => @strftime('%Y-%m-%d %H:%M',time())
		);
		echo strtr($content,$tokens);
	}
	protected function handleRecursiveError($exception)
	{
		if($this->getApplication()->getMode()===TApplication::STATE_DEBUG)
		{
			echo "<html><head><title>Recursive Error</title></head>\n";
			echo "<body><h1>Recursive Error</h1>\n";
			echo "<pre>".$exception->__toString()."</pre>\n";
			echo "</body></html>";
		}
		else
		{
			error_log("Error happened while processing an existing error:\n".$exception->__toString());
			header('HTTP/1.0 500 Internal Error');
		}
	}
	protected function displayException($exception)
	{
		$fileName=$exception->getFile();
		$errorLine=$exception->getLine();
		if($exception instanceof TPhpErrorException)
		{
			$trace=$exception->getTrace();
			if(isset($trace[1]) && isset($trace[1]['file']) && isset($trace[1]['line']))
			{
				$fileName=$trace[1]['file'];
				$errorLine=$trace[1]['line'];
			}
		}
		$lines=file($fileName);
		$beginLine=$errorLine-self::SOURCE_LINES>=0?$errorLine-self::SOURCE_LINES:0;
		$endLine=$errorLine+self::SOURCE_LINES<=count($lines)?$errorLine+self::SOURCE_LINES:count($lines);
		$source='';
		for($i=$beginLine;$i<$endLine;++$i)
		{
			if($i===$errorLine-1)
			{
				$line=htmlspecialchars(sprintf("%04d: %s",$i+1,str_replace("\t",'    ',$lines[$i])));
				$source.="<div class=\"error\">".$line."</div>";
			}
			else
				$source.=htmlspecialchars(sprintf("%04d: %s",$i+1,str_replace("\t",'    ',$lines[$i])));
		}
		$tokens=array(
			'%%ErrorType%%' => get_class($exception),
			'%%ErrorMessage%%' => htmlspecialchars($exception->getMessage()),
			'%%SourceFile%%' => htmlspecialchars($fileName).' ('.$errorLine.')',
			'%%SourceCode%%' => $source,
			'%%StackTrace%%' => htmlspecialchars($exception->getTraceAsString()),
			'%%Version%%' => $_SERVER['SERVER_SOFTWARE'].' <a href="http://www.pradosoft.com/">PRADO</a>/'.Prado::getVersion(),
			'%%Time%%' => @strftime('%Y-%m-%d %H:%M',time())
		);
		$lang=Prado::getPreferredLanguage();
		$exceptionFile=Prado::getFrameworkPath().'/Exceptions/templates/'.self::EXCEPTION_FILE_NAME.'-'.$lang.'.html';
		if(!is_file($exceptionFile))
			$exceptionFile=Prado::getFrameworkPath().'/Exceptions/templates/'.self::EXCEPTION_FILE_NAME.'.html';
		if(($content=@file_get_contents($exceptionFile))===false)
			die("Unable to open exception template file '$exceptionFile'.");
		echo strtr($content,$tokens);
	}
}
abstract class TCache extends TModule implements ICache
{
	private $_prefix=null;
	public function init($config)
	{
		if($this->_prefix===null)
			$this->_prefix=$this->getApplication()->getUniqueID();
		$this->getApplication()->setCache($this);
	}
	public function getKeyPrefix()
	{
		return $this->_prefix;
	}
	public function setKeyPrefix($value)
	{
		$this->_prefix=$value;
	}
	protected function generateUniqueKey($key)
	{
		return md5($this->_prefix.$key);
	}
	public function get($id)
	{
		if(($value=$this->getValue($this->generateUniqueKey($id)))!==false)
		{
			$data=unserialize($value);
			if(!($data[1] instanceof ICacheDependency) || !$data[1]->getHasChanged())
				return $data[0];
		}
		return false;
	}
	public function set($id,$value,$expire=0,$dependency=null)
	{
		$data=array($value,$dependency);
		$expire=($expire<=0)?0:time()+$expire;
		return $this->setValue($this->generateUniqueKey($id),serialize($data),$expire);
	}
	public function add($id,$value,$expire=0,$dependency=null)
	{
		$data=array($value,$dependency);
		$expire=($expire<=0)?0:time()+$expire;
		return $this->addValue($this->generateUniqueKey($id),serialize($data),$expire);
	}
	public function delete($id)
	{
		return $this->deleteValue($this->generateUniqueKey($id));
	}
	public function flush()
	{
		throw new TNotSupportedException('cache_flush_unsupported');
	}
	abstract protected function getValue($key);
	abstract protected function setValue($key,$value,$expire);
	abstract protected function addValue($key,$value,$expire);
	abstract protected function deleteValue($key);
}
class TTextWriter extends TComponent implements ITextWriter
{
	private $_str='';
	public function flush()
	{
		$str=$this->_str;
		$this->_str='';
		return $str;
	}
	public function write($str)
	{
		$this->_str.=$str;
	}
	public function writeLine($str='')
	{
		$this->write($str."\n");
	}
}
class TList extends TComponent implements IteratorAggregate,ArrayAccess
{
	private $_d=array();
	private $_c=0;
	private $_r=false;
	public function __construct($data=null,$readOnly=false)
	{
		if($data!==null)
			$this->copyFrom($data);
		$this->setReadOnly($readOnly);
	}
	public function getReadOnly()
	{
		return $this->_r;
	}
	protected function setReadOnly($value)
	{
		$this->_r=TPropertyValue::ensureBoolean($value);
	}
	public function getIterator()
	{
		return new TListIterator($this->_d);
	}
	public function getCount()
	{
		return $this->_c;
	}
	public function itemAt($index)
	{
		if($index>=0 && $index<$this->_c)
			return $this->_d[$index];
		else
			throw new TInvalidDataValueException('list_index_invalid',$index);
	}
	public function add($item)
	{
		$this->insertAt($this->_c,$item);
		return $this->_c;
	}
	public function insertAt($index,$item)
	{
		if(!$this->_r)
		{
			if($index===$this->_c)
				$this->_d[$this->_c++]=$item;
			else if($index>=0 && $index<$this->_c)
			{
				array_splice($this->_d,$index,0,array($item));
				$this->_c++;
			}
			else
				throw new TInvalidDataValueException('list_index_invalid',$index);
		}
		else
			throw new TInvalidOperation('list_readonly',get_class($this));
	}
	public function remove($item)
	{
		if(($index=$this->indexOf($item))>=0)
		{
			$this->removeAt($index);
			return $index;
		}
		else
			throw new TInvalidDataValueException('list_item_inexistent');
	}
	public function removeAt($index)
	{
		if(!$this->_r)
		{
			if($index>=0 && $index<$this->_c)
			{
				$this->_c--;
				if($index===$this->_c)
					return array_pop($this->_d);
				else
				{
					$item=$this->_d[$index];
					array_splice($this->_d,$index,1);
					return $item;
				}
			}
			else
				throw new TInvalidDataValueException('list_index_invalid',$index);
		}
		else
			throw new TInvalidOperation('list_readonly',get_class($this));
	}
	public function clear()
	{
		for($i=$this->_c-1;$i>=0;--$i)
			$this->removeAt($i);
	}
	public function contains($item)
	{
		return $this->indexOf($item)>=0;
	}
	public function indexOf($item)
	{
		if(($index=array_search($item,$this->_d,true))===false)
			return -1;
		else
			return $index;
	}
	public function toArray()
	{
		return $this->_d;
	}
	public function copyFrom($data)
	{
		if(is_array($data) || ($data instanceof Traversable))
		{
			if($this->_c>0)
				$this->clear();
			foreach($data as $item)
				$this->add($item);
		}
		else if($data!==null)
			throw new TInvalidDataTypeException('list_data_not_iterable');
	}
	public function mergeWith($data)
	{
		if(is_array($data) || ($data instanceof Traversable))
		{
			foreach($data as $item)
				$this->add($item);
		}
		else if($data!==null)
			throw new TInvalidDataTypeException('list_data_not_iterable');
	}
	public function offsetExists($offset)
	{
		return ($offset>=0 && $offset<$this->_c);
	}
	public function offsetGet($offset)
	{
		return $this->itemAt($offset);
	}
	public function offsetSet($offset,$item)
	{
		if($offset===null || $offset===$this->_c)
			$this->insertAt($this->_c,$item);
		else
		{
			$this->removeAt($offset);
			$this->insertAt($offset,$item);
		}
	}
	public function offsetUnset($offset)
	{
		$this->removeAt($offset);
	}
}
class TListIterator implements Iterator
{
	private $_d;
	private $_i;
	private $_c;
	public function __construct(&$data)
	{
		$this->_d=&$data;
		$this->_i=0;
		$this->_c=count($this->_d);
	}
	public function rewind()
	{
		$this->_i=0;
	}
	public function key()
	{
		return $this->_i;
	}
	public function current()
	{
		return $this->_d[$this->_i];
	}
	public function next()
	{
		$this->_i++;
	}
	public function valid()
	{
		return $this->_i<$this->_c;
	}
}
class TMap extends TComponent implements IteratorAggregate,ArrayAccess
{
	private $_d=array();
	private $_r=false;
	public function __construct($data=null,$readOnly=false)
	{
		if($data!==null)
			$this->copyFrom($data);
		$this->setReadOnly($readOnly);
	}
	public function getReadOnly()
	{
		return $this->_r;
	}
	protected function setReadOnly($value)
	{
		$this->_r=TPropertyValue::ensureBoolean($value);
	}
	public function getIterator()
	{
		return new TMapIterator($this->_d);
	}
	public function getCount()
	{
		return count($this->_d);
	}
	public function getKeys()
	{
		return array_keys($this->_d);
	}
	public function itemAt($key)
	{
		return isset($this->_d[$key]) ? $this->_d[$key] : null;
	}
	public function add($key,$value)
	{
		if(!$this->_r)
			$this->_d[$key]=$value;
		else
			throw new TInvalidOperation('map_readonly',get_class($this));
	}
	public function remove($key)
	{
		if(!$this->_r)
		{
			if(isset($this->_d[$key]) || array_key_exists($key,$this->_d))
			{
				$value=$this->_d[$key];
				unset($this->_d[$key]);
				return $value;
			}
			else
				return null;
		}
		else
			throw new TInvalidOperation('map_readonly',get_class($this));
	}
	public function clear()
	{
		foreach(array_keys($this->_d) as $key)
			$this->remove($key);
	}
	public function contains($key)
	{
		return isset($this->_d[$key]) || array_key_exists($key,$this->_d);
	}
	public function toArray()
	{
		return $this->_d;
	}
	public function copyFrom($data)
	{
		if(is_array($data) || $data instanceof Traversable)
		{
			if($this->getCount()>0)
				$this->clear();
			foreach($data as $key=>$value)
				$this->add($key,$value);
		}
		else if($data!==null)
			throw new TInvalidDataTypeException('map_data_not_iterable');
	}
	public function mergeWith($data)
	{
		if(is_array($data) || $data instanceof Traversable)
		{
			foreach($data as $key=>$value)
				$this->add($key,$value);
		}
		else if($data!==null)
			throw new TInvalidDataTypeException('map_data_not_iterable');
	}
	public function offsetExists($offset)
	{
		return $this->contains($offset);
	}
	public function offsetGet($offset)
	{
		return $this->itemAt($offset);
	}
	public function offsetSet($offset,$item)
	{
		$this->add($offset,$item);
	}
	public function offsetUnset($offset)
	{
		$this->remove($offset);
	}
}
class TMapIterator implements Iterator
{
	private $_d;
	private $_keys;
	private $_key;
	public function __construct(&$data)
	{
		$this->_d=&$data;
		$this->_keys=array_keys($data);
	}
	public function rewind()
	{
		$this->_key=reset($this->_keys);
	}
	public function key()
	{
		return $this->_key;
	}
	public function current()
	{
		return $this->_d[$this->_key];
	}
	public function next()
	{
		$this->_key=next($this->_keys);
	}
	public function valid()
	{
		return $this->_key!==false;
	}
}
class TXmlElement extends TComponent
{
	private $_parent=null;
	private $_tagName='unknown';
	private $_value='';
	private $_elements=null;
	private $_attributes=null;
	public function __construct($tagName)
	{
		$this->setTagName($tagName);
	}
	public function getParent()
	{
		return $this->_parent;
	}
	public function setParent($parent)
	{
		$this->_parent=$parent;
	}
	public function getTagName()
	{
		return $this->_tagName;
	}
	public function setTagName($tagName)
	{
		$this->_tagName=$tagName;
	}
	public function getValue()
	{
		return $this->_value;
	}
	public function setValue($value)
	{
		$this->_value=$value;
	}
	public function getHasElement()
	{
		return $this->_elements!==null && $this->_elements->getCount()>0;
	}
	public function getHasAttribute()
	{
		return $this->_attributes!==null && $this->_attributes->getCount()>0;
	}
	public function getAttribute($name)
	{
		if($this->_attributes!==null)
			return $this->_attributes->itemAt($name);
		else
			return null;
	}
	public function setAttribute($name,$value)
	{
		$this->getAttributes()->add($name,$value);
	}
	public function getElements()
	{
		if(!$this->_elements)
			$this->_elements=new TXmlElementList($this);
		return $this->_elements;
	}
	public function getAttributes()
	{
		if(!$this->_attributes)
			$this->_attributes=new TMap;
		return $this->_attributes;
	}
	public function getElementByTagName($tagName)
	{
		if($this->_elements)
		{
			foreach($this->_elements as $element)
				if($element->_tagName===$tagName)
					return $element;
		}
		return null;
	}
	public function getElementsByTagName($tagName)
	{
		$list=new TList;
		if($this->_elements)
		{
			foreach($this->_elements as $element)
				if($element->_tagName===$tagName)
					$list->add($element);
		}
		return $list;
	}
	public function toString($indent=0)
	{
		$attr='';
		if($this->_attributes!==null)
		{
			foreach($this->_attributes as $name=>$value)
				$attr.=" $name=\"$value\"";
		}
		$prefix=str_repeat(' ',$indent*4);
		if($this->getHasElement())
		{
			$str=$prefix."<{$this->_tagName}$attr>\n";
			foreach($this->getElements() as $element)
				$str.=$element->toString($indent+1)."\n";
			$str.=$prefix."</{$this->_tagName}>";
			return $str;
		}
		else if($this->getValue()!=='')
		{
			return $prefix."<{$this->_tagName}$attr>{$this->_value}</{$this->_tagName}>";
		}
		else
			return $prefix."<{$this->_tagName}$attr />";
	}
}
class TXmlDocument extends TXmlElement
{
	private $_version;
	private $_encoding;
	public function __construct($version='1.0',$encoding='')
	{
		parent::__construct('');
		$this->setversion($version);
		$this->setEncoding($encoding);
	}
	public function getVersion()
	{
		return $this->_version;
	}
	public function setVersion($version)
	{
		$this->_version=$version;
	}
	public function getEncoding()
	{
		return $this->_encoding;
	}
	public function setEncoding($encoding)
	{
		$this->_encoding=$encoding;
	}
	public function loadFromFile($file)
	{
		if(($str=@file_get_contents($file))!==false)
			return $this->loadFromString($str);
		else
			throw new TIOException('xmldocument_file_read_failed',$file);
	}
	public function loadFromString($string)
	{
				$doc=new DOMDocument();
		if($doc->loadXML($string)===false)
			return false;
		$this->setEncoding($doc->encoding);
		$this->setVersion($doc->version);
		$element=$doc->documentElement;
		$this->setTagName($element->tagName);
		$this->setValue($element->nodeValue);
		$elements=$this->getElements();
		$attributes=$this->getAttributes();
		$elements->clear();
		$attributes->clear();
		foreach($element->attributes as $name=>$attr)
			$attributes->add($name,$attr->value);
		foreach($element->childNodes as $child)
		{
			if($child instanceof DOMElement)
				$elements->add($this->buildElement($child));
		}
		return true;
	}
	public function saveToFile($file)
	{
		if(($fw=fopen($file,'w'))!==false)
		{
			fwrite($fw,$this->saveToString());
			fclose($fw);
		}
		else
			throw new TIOException('xmldocument_file_write_failed',$file);
	}
	public function saveToString()
	{
		$version=empty($this->_version)?' version="1.0"':' version="'.$this->_version.'"';
		$encoding=empty($this->_encoding)?'':' encoding="'.$this->_encoding.'"';
		return "<?xml{$version}{$encoding}?>\n".$this->toString(0);
	}
	private function buildElement($node)
	{
		$element=new TXmlElement($node->tagName);
		$element->setValue($node->nodeValue);
		foreach($node->attributes as $name=>$attr)
			$element->getAttributes()->add($name,$attr->value);
		foreach($node->childNodes as $child)
		{
			if($child instanceof DOMElement)
				$element->getElements()->add($this->buildElement($child));
		}
		return $element;
	}
}
class TXmlElementList extends TList
{
	private $_o;
	public function __construct(TXmlElement $owner)
	{
		$this->_o=$owner;
	}
	protected function getOwner()
	{
		return $this->_o;
	}
	public function insertAt($index,$item)
	{
		if($item instanceof TXmlElement)
		{
			parent::insertAt($index,$item);
			if($item->getParent()!==null)
				$item->getParent()->getElements()->remove($item);
			$item->setParent($this->_o);
		}
		else
			throw new TInvalidDataTypeException('xmlelementlist_xmlelement_required');
	}
	public function removeAt($index)
	{
		$item=parent::removeAt($index);
		if($item instanceof TXmlElement)
			$item->setParent(null);
		return $item;
	}
}
class TAuthorizationRule extends TComponent
{
	private $_action;
	private $_users;
	private $_roles;
	private $_verb;
	private $_everyone;
	private $_guest;
	public function __construct($action,$users,$roles,$verb='')
	{
		$action=strtolower(trim($action));
		if($action==='allow' || $action==='deny')
			$this->_action=$action;
		else
			throw new TInvalidDataValueException('authorizationrule_action_invalid',$action);
		$this->_users=array();
		$this->_roles=array();
		$this->_everyone=false;
		$this->_guest=false;
		foreach(explode(',',$users) as $user)
		{
			if(($user=trim(strtolower($user)))!=='')
			{
				if($user==='*')
					$this->_everyone=true;
				else if($user==='?')
					$this->_guest=true;
				else
					$this->_users[]=$user;
			}
		}
		foreach(explode(',',$roles) as $role)
		{
			if(($role=trim(strtolower($role)))!=='')
				$this->_roles[]=$role;
		}
		$verb=trim(strtolower($verb));
		if($verb==='' || $verb==='get' || $verb==='post')
			$this->_verb=$verb;
		else
			throw new TInvalidDataValueException('authorizationrule_verb_invalid',$verb);
	}
	public function getAction()
	{
		return $this->_action;
	}
	public function getUsers()
	{
		return $this->_users;
	}
	public function getRoles()
	{
		return $this->_roles;
	}
	public function getVerb()
	{
		return $this->_verb;
	}
	public function getGuestApplied()
	{
		return $this->_guest;
	}
	public function getEveryoneApplied()
	{
		return $this->_everyone;
	}
	public function isUserAllowed(IUser $user,$verb)
	{
		$decision=($this->_action==='allow')?1:-1;
		if($this->_verb==='' || strcasecmp($verb,$this->_verb)===0)
		{
			if($this->_everyone || ($this->_guest && $user->getIsGuest()))
				return $decision;
			if(in_array(strtolower($user->getName()),$this->_users))
				return $decision;
			foreach($this->_roles as $role)
				if($user->isInRole($role))
					return $decision;
		}
		return 0;
	}
}
class TAuthorizationRuleCollection extends TList
{
	public function isUserAllowed($user,$verb)
	{
		if($user instanceof IUser)
		{
			$verb=strtolower(trim($verb));
			foreach($this as $rule)
			{
				if(($decision=$rule->isUserAllowed($user,$verb))!==0)
					return ($decision>0);
			}
			return true;
		}
		else
			return false;
	}
	public function insertAt($index,$item)
	{
		if($item instanceof TAuthorizationRule)
			parent::insertAt($index,$item);
		else
			throw new TInvalidDataTypeException('authorizationrulecollection_authorizationrule_required');
	}
}
class TSecurityManager extends TModule
{
	const STATE_VALIDATION_KEY='prado:securitymanager:validationkey';
	const STATE_ENCRYPTION_KEY='prado:securitymanager:encryptionkey';
	const STATE_INIT_VECTOR='prado:securitymanager:initvector';
	private $_validationKey=null;
	private $_encryptionKey=null;
	private $_initVector=null;
	private $_validation='SHA1';
	private $_encryption='3DES';
	public function init($config)
	{
		$this->getApplication()->setSecurityManager($this);
	}
	protected function generateRandomKey()
	{
		return rand().rand().rand().rand();
	}
	public function getValidationKey()
	{
		if($this->_validationKey===null)
		{
			if(($this->_validationKey=$this->getApplication()->getGlobalState(self::STATE_VALIDATION_KEY))===null)
			{
				$this->_validationKey=$this->generateRandomKey();
				$this->getApplication()->setGlobalState(self::STATE_VALIDATION_KEY,$this->_validationKey,null);
			}
		}
		return $this->_validationKey;
	}
	public function setValidationKey($value)
	{
		if($value!=='')
			$this->_validationKey=$value;
		else
			throw new TInvalidDataValueException('securitymanager_validationkey_invalid');
	}
	public function getEncryptionKey()
	{
		if($this->_encryptionKey===null)
		{
			if(($this->_encryptionKey=$this->getApplication()->getGlobalState(self::STATE_ENCRYPTION_KEY))===null)
			{
				$this->_encryptionKey=$this->generateRandomKey();
				$this->getApplication()->setGlobalState(self::STATE_ENCRYPTION_KEY,$this->_encryptionKey,null);
			}
		}
		return $this->_encryptionKey;
	}
	public function setEncryptionKey($value)
	{
		if($value!=='')
			$this->_encryptionKey=$value;
		else
			throw new TInvalidDataValueException('securitymanager_encryptionkey_invalid');
	}
	public function getValidation()
	{
		return $this->_validation;
	}
	public function setValidation($value)
	{
		$this->_validation=TPropertyValue::ensureEnum($value,'SHA1','MD5');
	}
	public function getEncryption()
	{
		return $this->_encryption;
	}
	public function setEncryption($value)
	{
		throw new TNotSupportedException('Currently only 3DES encryption is supported');
	}
	public function encrypt($data)
	{
		if(function_exists('mcrypt_encrypt'))
		{
			$module=mcrypt_module_open(MCRYPT_3DES, '', MCRYPT_MODE_CBC, '');
			$key=substr(md5($this->getEncryptionKey()),0,mcrypt_enc_get_key_size($module));
			srand();
			$iv=mcrypt_create_iv(mcrypt_enc_get_iv_size($module), MCRYPT_RAND);
			mcrypt_generic_init($module,$key,$iv);
			$encrypted=$iv.mcrypt_generic($module,$data);
			mcrypt_generic_deinit($module);
			mcrypt_module_close($module);
			return $encrypted;
		}
		else
			throw new TNotSupportedException('securitymanager_mcryptextension_required');
	}
	public function decrypt($data)
	{
		if(function_exists('mcrypt_decrypt'))
		{
			$module=mcrypt_module_open(MCRYPT_3DES, '', MCRYPT_MODE_CBC, '');
			$key=substr(md5($this->getEncryptionKey()),0,mcrypt_enc_get_key_size($module));
			$ivSize=mcrypt_enc_get_iv_size($module);
			$iv=substr($data,0,$ivSize);
			mcrypt_generic_init($module,$key,$iv);
			$decrypted=mdecrypt_generic($module,substr($data,$ivSize));
			mcrypt_generic_deinit($module);
			mcrypt_module_close($module);
			return rtrim($decrypted,"\0");
		}
		else
			throw new TNotSupportedException('securitymanager_mcryptextension_required');
	}
	public function hashData($data)
	{
		$hmac=$this->computeHMAC($data);
		return $hmac.$data;
	}
	public function validateData($data)
	{
		$len=$this->_validation==='SHA1'?40:32;
		if(strlen($data)>=$len)
		{
			$hmac=substr($data,0,$len);
			$data2=substr($data,$len);
			return $hmac===$this->computeHMAC($data2)?$data2:false;
		}
		else
			return false;
	}
	protected function computeHMAC($data)
	{
		if($this->_validation==='SHA1')
		{
			$pack='H40';
			$func='sha1';
		}
		else
		{
			$pack='H32';
			$func='md5';
		}
		$key=$this->getValidationKey();
		$key=str_pad($func($key), 64, chr(0));
		return $func((str_repeat(chr(0x5C), 64) ^ substr($key, 0, 64)) . pack($pack, $func((str_repeat(chr(0x36), 64) ^ substr($key, 0, 64)) . $data)));
	}
}
class THttpUtility
{
	private static $_encodeTable=array('<'=>'&lt;','>'=>'&gt;','"'=>'&quot;');
	private static $_decodeTable=array('&lt;'=>'<','&gt;'=>'>','&quot;'=>'"');
	public static function htmlEncode($s)
	{
		return strtr($s,self::$_encodeTable);
	}
	public static function htmlDecode($s)
	{
		return strtr($s,self::$_decodeTable);
	}
}
class TJavaScript
{
	public static function renderScriptFiles($files)
	{
		$str='';
		foreach($files as $file)
			$str.= self::renderScriptFile($file);
		return $str;
	}
	public static function renderScriptFile($file)
	{
		return '<script type="text/javascript" src="'.THttpUtility::htmlEncode($file)."\"></script>\n";
	}
	public static function renderScriptBlocks($scripts)
	{
		if(count($scripts))
			return "<script type=\"text/javascript\">\n/*<![CDATA[*/\n".implode("\n",$scripts)."\n/*]]>*/\n</script>\n";
		else
			return '';
	}
	public static function renderScriptBlock($script)
	{
		return "<script type=\"text/javascript\">\n/*<![CDATA[*/\n{$script}\n/*]]>*/\n</script>\n";
	}
	public static function quoteString($js,$forUrl=false)
	{
		if($forUrl)
			return strtr($js,array('%'=>'%25',"\t"=>'\t',"\n"=>'\n',"\r"=>'\r','"'=>'\"','\''=>'\\\'','\\'=>'\\\\'));
		else
			return strtr($js,array("\t"=>'\t',"\n"=>'\n',"\r"=>'\r','"'=>'\"','\''=>'\\\'','\\'=>'\\\\'));
	}
	public static function quoteFunction($js)
	{
		if(self::isFunction($js))
			return $js;
		else
			return 'javascript:'.$js; 
	}
	public static function isFunction($js)
	{
		return preg_match('/^\s*javascript:/', $js);
	}
	public static function encode($value,$toMap=true)
	{
		if(is_string($value))
		{
			if(($n=strlen($value))>2)
			{
				$first=$value[0];
				$last=$value[$n-1];
				if(($first==='[' && $last===']') || ($first==='{' && $last==='}'))
					return $value;
			}
			if(self::isFunction($value))
				return preg_replace('/^\s*javascript:/', '', $value);
			else
				return "'".self::quoteString($value)."'";
		}
		else if(is_bool($value))
			return $value?'true':'false';
		else if(is_array($value))
		{
			$results=array();
			if($toMap)
			{
				foreach($value as $k=>$v)
					if($v!=='')
						$results[]="'{$k}':".self::encode($v,$toMap);
				return '{'.implode(',',$results).'}';
			}
			else
			{
				foreach($value as $k=>$v)
					if($v!=='')
						$results[]=self::encode($v,$toMap);
				return '['.implode(',',$results).']';
			}
		}
		else if(is_integer($value))
			return "$value";
		else if(is_float($value))
		{
			if($value===-INF)
				return 'Number.NEGATIVE_INFINITY';
			else if($value===INF)
				return 'Number.POSITIVE_INFINITY';
			else
				return "$value";
		}
		else if(is_object($value))
			return self::encode(get_object_vars($this->data),$toMap);
		else if($value===null)
			return 'null';
		else
			return '';
	}
	public static function jsonEncode($value)
	{
		Prado::using('System.Web.Javascripts.TJSON');
		return TJSON::encode($value);
	}
	public static function jsonDecode($value)
	{
		Prado::using('System.Web.Javascripts.TJSON');
		return TJSON::decode($value);
	}
}
class THttpRequest extends TApplicationComponent implements IteratorAggregate,ArrayAccess,IModule
{
	const URL_PARAM_SEPARATOR=',';
	private $_initialized=false;
	private $_serviceID=null;
	private $_serviceParam=null;
	private $_cookies=null;
	private $_requestUri;
	private $_pathInfo;
	private $_urlFormat='Get';
	private $_services;
	private $_requestResolved=false;
	private $_enableCookieValidation=false;
	private $_url=null;
	private $_id;
	private $_items=array();
	public function getID()
	{
		return $this->_id;
	}
	public function setID($value)
	{
		$this->_id=$value;
	}
	public function init($config)
	{
		if(isset($_SERVER['REQUEST_URI']))
			$this->_requestUri=$_SERVER['REQUEST_URI'];
		else  
			$this->_requestUri=$_SERVER['SCRIPT_NAME'].(empty($_SERVER['QUERY_STRING'])?'':'?'.$_SERVER['QUERY_STRING']);
		if(isset($_SERVER['PATH_INFO']))
			$this->_pathInfo=$_SERVER['PATH_INFO'];
		else if(strpos($_SERVER['PHP_SELF'],$_SERVER['SCRIPT_NAME'])===0)
			$this->_pathInfo=substr($_SERVER['PHP_SELF'],strlen($_SERVER['SCRIPT_NAME']));
		else
			$this->_pathInfo='';
		if(get_magic_quotes_gpc())
		{
			if(isset($_GET))
				$_GET=$this->stripSlashes($_GET);
			if(isset($_POST))
				$_POST=$this->stripSlashes($_POST);
			if(isset($_REQUEST))
				$_REQUEST=$this->stripSlashes($_REQUEST);
			if(isset($_COOKIE))
				$_COOKIE=$this->stripSlashes($_COOKIE);
		}
		if($this->getUrlFormat()==='Path' && ($pathInfo=trim($this->_pathInfo,'/'))!=='')
		{
			$paths=explode('/',$pathInfo);
			foreach($paths as $path)
			{
				if(($path=trim($path))!=='')
				{
					if(($pos=strpos($path,','))!==false)
					{
						$name=substr($path,0,$pos);
						$value=substr($path,$pos+1);
						if(($pos=strpos($name,'[]'))!==false)
							$getVariables[substr($name,0,$pos)][]=$value;
						else
							$getVariables[$name]=$value;
					}
					else
						$getVariables[$path]='';
				}
			}
			$this->_items=array_merge($getVariables,array_merge($_GET,$_POST));
		}
		else
			$this->_items=array_merge($_GET,$_POST);
		$this->_initialized=true;
		$this->getApplication()->setRequest($this);
	}
	public function stripSlashes(&$data)
	{
		return is_array($data)?array_map(array($this,'stripSlashes'),$data):stripslashes($data);
	}
	public function getUrl()
	{
		if($this->_url===null)
		{
			$secure=$this->getIsSecureConnection();
			$url=$secure?'https://':'http://';
			if(empty($_SERVER['HTTP_HOST']))
			{
				$url.=$_SERVER['SERVER_NAME'];
				$port=$_SERVER['SERVER_PORT'];
				if(($port!=80 && !$secure) || ($port!=443 && $secure))
					$url.=':'.$port;
			}
			else
				$url.=$_SERVER['HTTP_HOST'];
			$url.=$this->getRequestUri();
			$this->_url=new TUri($url);
		}
		return $this->_url;
	}
	public function getUrlFormat()
	{
		return $this->_urlFormat;
	}
	public function setUrlFormat($value)
	{
		$this->_urlFormat=TPropertyValue::ensureEnum($value,'Path','Get');
	}
	public function getRequestType()
	{
		return $_SERVER['REQUEST_METHOD'];
	}
	public function getIsSecureConnection()
	{
		return !empty($_SERVER['HTTPS']);
	}
	public function getPathInfo()
	{
		return $this->_pathInfo;
	}
	public function getQueryString()
	{
		return isset($_SERVER['QUERY_STRING'])?$_SERVER['QUERY_STRING']:'';
	}
	public function getRequestUri()
	{
		return $this->_requestUri;
	}
	public function getApplicationUrl()
	{
		return $_SERVER['SCRIPT_NAME'];
	}
	public function getApplicationFilePath()
	{
		return realpath($_SERVER['SCRIPT_FILENAME']);
	}
	public function getServerName()
	{
		return $_SERVER['SERVER_NAME'];
	}
	public function getServerPort()
	{
		return $_SERVER['SERVER_PORT'];
	}
	public function getUrlReferrer()
	{
		return isset($_SERVER['HTTP_REFERER'])?$_SERVER['HTTP_REFERER']:null;
	}
	public function getBrowser()
	{
		return get_browser();
	}
	public function getUserAgent()
	{
		return $_SERVER['HTTP_USER_AGENT'];
	}
	public function getUserHostAddress()
	{
		return $_SERVER['REMOTE_ADDR'];
	}
	public function getUserHost()
	{
		return isset($_SERVER['REMOTE_HOST'])?$_SERVER['REMOTE_HOST']:null;
	}
	public function getAcceptTypes()
	{
				return $_SERVER['HTTP_ACCEPT'];
	}
	public function getUserLanguages()
	{
		return Prado::getUserLanguages();
	}
	public function getEnableCookieValidation()
	{
		return $this->_enableCookieValidation;
	}
	public function setEnableCookieValidation($value)
	{
		$this->_enableCookieValidation=TPropertyValue::ensureBoolean($value);
	}
	public function getCookies()
	{
		if($this->_cookies===null)
		{
			$this->_cookies=new THttpCookieCollection;
			if($this->getEnableCookieValidation())
			{
				$sm=$this->getApplication()->getSecurityManager();
				foreach($_COOKIE as $key=>$value)
				{
					if(($value=$sm->validateData($value))!==false)
						$this->_cookies->add(new THttpCookie($key,$value));
				}
			}
			else
			{
				foreach($_COOKIE as $key=>$value)
					$this->_cookies->add(new THttpCookie($key,$value));
			}
		}
		return $this->_cookies;
	}
	public function getUploadedFiles()
	{
		return $_FILES;
	}
	public function getServerVariables()
	{
		return $_SERVER;
	}
	public function getEnvironmentVariables()
	{
		return $_ENV;
	}
	public function constructUrl($serviceID,$serviceParam,$getItems=null,$encodeAmpersand=false,$encodeGetItems=true)
	{
		$url=$serviceID.'='.$serviceParam;
		$amp=$encodeAmpersand?'&amp;':'&';
		if(is_array($getItems) || $getItems instanceof Traversable)
		{
			if($encodeGetItems)
			{
				foreach($getItems as $name=>$value)
				{
					if(is_array($value))
					{
						$name=urlencode($name.'[]');
						foreach($value as $v)
							$url.=$amp.$name.'='.$v;
					}
					else
						$url.=$amp.urlencode($name).'='.urlencode($value);
				}
			}
			else
			{
				foreach($getItems as $name=>$value)
				{
					if(is_array($value))
					{
						foreach($value as $v)
							$url.=$amp.$name.'[]='.$v;
					}
					else
						$url.=$amp.$name.'='.$value;
				}
			}
		}
		if($this->getUrlFormat()==='Path')
		{
			$url=strtr($url,array($amp=>'/','?'=>'/','='=>self::URL_PARAM_SEPARATOR));
			if(defined('SID') && SID != '' && !((int)ini_get('session.use_cookies')===1 && ((int)ini_get('session.use_only_cookies')===1)))
				$url.='?'.SID;
			return $this->getApplicationUrl().'/'.$url;
		}
		else
		{
			if(defined('SID') && SID != '' && !((int)ini_get('session.use_cookies')===1 && ((int)ini_get('session.use_only_cookies')===1)))
				$url.=$amp.SID;
			return $this->getApplicationUrl().'?'.$url;
		}
	}
	protected function resolveRequest()
	{
		$this->_requestResolved=true;
		foreach($this->_services as $id)
		{
			if($this->contains($id))
			{
				$this->setServiceID($id);
				$this->setServiceParameter($this->itemAt($id));
				break;
			}
		}
	}
	public function getAvailableServices()
	{
		return $this->_services;
	}
	public function setAvailableServices($services)
	{
		$this->_services=$services;
	}
	public function getServiceID()
	{
		if(!$this->_requestResolved)
			$this->resolveRequest();
		return $this->_serviceID;
	}
	protected function setServiceID($value)
	{
		$this->_serviceID=$value;
	}
	public function getServiceParameter()
	{
		if(!$this->_requestResolved)
			$this->resolveRequest();
		return $this->_serviceParam;
	}
	protected function setServiceParameter($value)
	{
		$this->_serviceParam=$value;
	}
	public function getIterator()
	{
		return new TMapIterator($this->_items);
	}
	public function getCount()
	{
		return count($this->_items);
	}
	public function getKeys()
	{
		return array_keys($this->_items);
	}
	public function itemAt($key)
	{
		return isset($this->_items[$key]) ? $this->_items[$key] : null;
	}
	public function add($key,$value)
	{
		$this->_items[$key]=$value;
	}
	public function remove($key)
	{
		if(isset($this->_items[$key]) || array_key_exists($key,$this->_items))
		{
			$value=$this->_items[$key];
			unset($this->_items[$key]);
			return $value;
		}
		else
			return null;
	}
	public function clear()
	{
		foreach(array_keys($this->_items) as $key)
			$this->remove($key);
	}
	public function contains($key)
	{
		return isset($this->_items[$key]) || array_key_exists($key,$this->_items);
	}
	public function toArray()
	{
		return $this->_items;
	}
	public function offsetExists($offset)
	{
		return $this->contains($offset);
	}
	public function offsetGet($offset)
	{
		return $this->itemAt($offset);
	}
	public function offsetSet($offset,$item)
	{
		$this->add($offset,$item);
	}
	public function offsetUnset($offset)
	{
		$this->remove($offset);
	}
}
class THttpCookieCollection extends TList
{
	private $_o;
	public function __construct($owner=null)
	{
		$this->_o=$owner;
	}
	public function insertAt($index,$item)
	{
		if($item instanceof THttpCookie)
		{
			parent::insertAt($index,$item);
			if($this->_o instanceof THttpResponse)
				$this->_o->addCookie($item);
		}
		else
			throw new TInvalidDataTypeException('authorizationrulecollection_authorizationrule_required');
	}
	public function removeAt($index)
	{
		$item=parent::removeAt($index);
		if($this->_o instanceof THttpResponse)
			$this->_o->removeCookie($item);
		return $item;
	}
	public function itemAt($index)
	{
		if(is_integer($index))
			return parent::itemAt($index);
		else
			return $this->findCookieByName($index);
	}
	public function findCookieByName($name)
	{
		foreach($this as $cookie)
			if($cookie->getName()===$name)
				return $cookie;
		return null;
	}
}
class THttpCookie extends TComponent
{
	private $_domain='';
	private $_name;
	private $_value=0;
	private $_expire=0;
	private $_path='/';
	private $_secure=false;
	public function __construct($name,$value)
	{
		$this->_name=$name;
		$this->_value=$value;
	}
	public function getDomain()
	{
		return $this->_domain;
	}
	public function setDomain($value)
	{
		$this->_domain=$value;
	}
	public function getExpire()
	{
		return $this->_expire;
	}
	public function setExpire($value)
	{
		$this->_expire=TPropertyValue::ensureInteger($value);
	}
	public function getName()
	{
		return $this->_name;
	}
	public function setName($value)
	{
		$this->_name=$value;
	}
	public function getValue()
	{
		return $this->_value;
	}
	public function setValue($value)
	{
		$this->_value=$value;
	}
	public function getPath()
	{
		return $this->_path;
	}
	public function setPath($value)
	{
		$this->_path=$value;
	}
	public function getSecure()
	{
		return $this->_secure;
	}
	public function setSecure($value)
	{
		$this->_secure=TPropertyValue::ensureBoolean($value);
	}
}
class TUri extends TComponent
{
	private static $_defaultPort=array(
		'ftp'=>21,
		'gopher'=>70,
		'http'=>80,
		'https'=>443,
		'news'=>119,
		'nntp'=>119,
		'wais'=>210,
		'telnet'=>23
	);
	private $_scheme;
	private $_host;
	private $_port;
	private $_user;
	private $_pass;
	private $_path;
	private $_query;
	private $_fragment;
	private $_uri;
	public function __construct($uri)
	{
		if(($ret=@parse_url($uri))!==false)
		{
						$this->_scheme=isset($ret['scheme'])?$ret['scheme']:'';
			$this->_host=isset($ret['host'])?$ret['host']:'';
			$this->_port=isset($ret['port'])?$ret['port']:'';
			$this->_user=isset($ret['user'])?$ret['user']:'';
			$this->_pass=isset($ret['pass'])?$ret['pass']:'';
			$this->_path=isset($ret['path'])?$ret['path']:'';
			$this->_query=isset($ret['query'])?$ret['query']:'';
			$this->_fragment=isset($ret['fragment'])?$ret['fragment']:'';
			$this->_uri=$uri;
		}
		else
		{
			throw new TInvalidDataValueException('uri_format_invalid',$uri);
		}
	}
	public function getUri()
	{
		return $this->_uri;
	}
	public function getScheme()
	{
		return $this->_scheme;
	}
	public function getHost()
	{
		return $this->_host;
	}
	public function getPort()
	{
		return $this->_port;
	}
	public function getUser()
	{
		return $this->_user;
	}
	public function getPassword()
	{
		return $this->_pass;
	}
	public function getPath()
	{
		return $this->_path;
	}
	public function getQuery()
	{
		return $this->_query;
	}
	public function getFragment()
	{
		return $this->_fragment;
	}
}
class THttpResponse extends TModule implements ITextWriter
{
	private $_bufferOutput=true;
	private $_initialized=false;
	private $_cookies=null;
	private $_status=200;
	private $_htmlWriterType='System.Web.UI.THtmlWriter';
	private $_contentType=null;
	private $_charset='';
	public function __destruct()
	{
		if($this->_bufferOutput)
			@ob_end_flush();
	}
	public function init($config)
	{
		if($this->_bufferOutput)
			ob_start();
		$this->_initialized=true;
		$this->getApplication()->setResponse($this);
	}
	public function getCacheExpire()
	{
		return session_cache_expire();
	}
	public function setCacheExpire($value)
	{
		session_cache_expire(TPropertyValue::ensureInteger($value));
	}
	public function getCacheControl()
	{
		return session_cache_limiter();
	}
	public function setCacheControl($value)
	{
		session_cache_limiter(TPropertyValue::ensureEnum($value,array('none','nocache','private','private_no_expire','public')));
	}
	public function setContentType($type)
	{
		$this->_contentType = $type;
	}
	public function getContentType()
	{
		return $this->_contentType;
	}
	public function getCharset()
	{
		return $this->_charset;
	}
	public function setCharset($charset)
	{
		$this->_charset = $charset;
	}
	public function getBufferOutput()
	{
		return $this->_bufferOutput;
	}
	public function setBufferOutput($value)
	{
		if($this->_initialized)
			throw new TInvalidOperationException('httpresponse_bufferoutput_unchangeable');
		else
			$this->_bufferOutput=TPropertyValue::ensureBoolean($value);
	}
	public function getStatusCode()
	{
		return $this->_status;
	}
	public function setStatusCode($status)
	{
		$this->_status=TPropertyValue::ensureInteger($status);
	}
	public function getCookies()
	{
		if($this->_cookies===null)
			$this->_cookies=new THttpCookieCollection($this);
		return $this->_cookies;
	}
	public function write($str)
	{
		echo $str;
	}
	public function writeFile($fileName,$content=null,$mimeType=null,$headers=null)
	{
		static $defaultMimeTypes=array(
			'css'=>'text/css',
			'gif'=>'image/gif',
			'jpg'=>'image/jpeg',
			'jpeg'=>'image/jpeg',
			'htm'=>'text/html',
			'html'=>'text/html',
			'js'=>'javascript/js'
		);
		if($mimeType===null)
		{
			$mimeType='text/plain';
			if(function_exists('mime_content_type'))
				$mimeType=mime_content_type($fileName);
			else if(($ext=strrchr($fileName,'.'))!==false)
			{
				$ext=substr($ext,1);
				if(isset($defaultMimeTypes[$ext]))
					$mimeType=$defaultMimeTypes[$ext];
			}
		}
		$fn=basename($fileName);
		if(is_array($headers))
		{
			foreach($headers as $h)
				header($h);
		}
		else
		{
			header('Pragma: public');
			header('Expires: 0');
			header('Cache-Component: must-revalidate, post-check=0, pre-check=0');
		}
		header("Content-type: $mimeType");
		header('Content-Length: '.($content===null?filesize($fileName):strlen($content)));
		header("Content-Disposition: attachment; filename=\"$fn\"");
		header('Content-Transfer-Encoding: binary');
		if($content===null)
			readfile($fileName);
		else
			echo $content;
	}
	public function redirect($url)
	{
		if(!$this->getApplication()->getRequestCompleted())
			$this->getApplication()->onEndRequest();
		header('Location:'.$url);
		exit();
	}
	public function reload()
	{
		$this->redirect($this->getRequest()->getRequestUri());
	}
	public function flush()
	{
		$this->sendContentTypeHeader();
		if($this->_bufferOutput)
			ob_flush();
	}
	protected function sendContentTypeHeader()
	{
		$charset=$this->getCharset();
		if($charset==='' && ($globalization=$this->getApplication()->getGlobalization(false))!==null)
			$charset=$globalization->getCharset();
		if($charset!=='')
		{
			$contentType=$this->_contentType===null?'text/html':$this->_contentType;
			$this->appendHeader('Content-Type: '.$contentType.';charset='.$charset);
		}
		else if($this->_contentType!==null)
			$this->appendHeader('Content-Type: '.$this->_contentType.';charset=UTF-8');
	}
	public function getContents()
	{
		return $this->_bufferOutput?ob_get_contents():'';
	}
	public function clear()
	{
		if($this->_bufferOutput)
			ob_clean();
	}
	public function appendHeader($value)
	{
		header($value);
	}
	public function appendLog($message,$messageType=0,$destination='',$extraHeaders='')
	{
		error_log($message,$messageType,$destination,$extraHeaders);
	}
	public function addCookie($cookie)
	{
		$request=$this->getRequest();
		if($request->getEnableCookieValidation())
		{
			$value=$this->getApplication()->getSecurityManager()->hashData($cookie->getValue());
			setcookie($cookie->getName(),$value,$cookie->getExpire(),$cookie->getPath(),$cookie->getDomain(),$cookie->getSecure());
		}
		else
			setcookie($cookie->getName(),$cookie->getValue(),$cookie->getExpire(),$cookie->getPath(),$cookie->getDomain(),$cookie->getSecure());
	}
	public function removeCookie($cookie)
	{
		setcookie($cookie->getName(),null,0,$cookie->getPath(),$cookie->getDomain(),$cookie->getSecure());
	}
	public function getHtmlWriterType()
	{
		return $this->_htmlWriterType;
	}
	public function setHtmlWriterType($value)
	{
		$this->_htmlWriterType=$value;
	}
	public function createHtmlWriter($type=null)
	{
		if($type===null)
			$type=$this->_htmlWriterType;
		return Prado::createComponent($type,$this);
	}
}
class THttpSession extends TApplicationComponent implements IteratorAggregate,ArrayAccess,IModule
{
	private $_initialized=false;
	private $_started=false;
	private $_autoStart=false;
	private $_cookie=null;
	private $_id;
	private $_customStorage=false;
	public function __destruct()
	{
		if($this->_started)
			$this->close();
	}
	public function getID()
	{
		return $this->_id;
	}
	public function setID($value)
	{
		$this->_id=$value;
	}
	public function init($config)
	{
		if($this->_autoStart)
			$this->open();
		$this->_initialized=true;
		$this->getApplication()->setSession($this);
	}
	public function open()
	{
		if(!$this->_started)
		{
			if($this->_customStorage)
				session_set_save_handler(array($this,'_open'),array($this,'_close'),array($this,'_read'),array($this,'_write'),array($this,'_destroy'),array($this,'_gc'));
			if($this->_cookie!==null)
				session_set_cookie_params($this->_cookie->getExpire(),$this->_cookie->getPath(),$this->_cookie->getDomain(),$this->_cookie->getSecure());
			session_start();
			$this->_started=true;
		}
	}
	public function close()
	{
		if($this->_started)
		{
			session_write_close();
			$this->_started=false;
		}
	}
	public function destroy()
	{
		if($this->_started)
		{
			session_destroy();
			$this->_started=false;
		}
	}
	public function getIsStarted()
	{
		return $this->_started;
	}
	public function getSessionID()
	{
		return session_id();
	}
	public function setSessionID($value)
	{
		if($this->_started)
			throw new TInvalidOperationException('httpsession_sessionid_unchangeable');
		else
			session_id($value);
	}
	public function getSessionName()
	{
		return session_name();
	}
	public function setSessionName($value)
	{
		if($this->_started)
			throw new TInvalidOperationException('httpsession_sessionname_unchangeable');
		else if(ctype_alnum($value))
			session_name($value);
		else
			throw new TInvalidDataValueException('httpsession_sessionname_invalid',$value);
	}
	public function getSavePath()
	{
		return session_save_path();
	}
	public function setSavePath($value)
	{
		if($this->_started)
			throw new TInvalidOperationException('httpsession_savepath_unchangeable');
		else if(is_dir($value))
			session_save_path($value);
		else
			throw new TInvalidDataValueException('httpsession_savepath_invalid',$value);
	}
	public function getUseCustomStorage()
	{
		return $this->_customStorage;
	}
	public function setUseCustomStorage($value)
	{
		$this->_customStorage=TPropertyValue::ensureBoolean($value);
	}
	public function getCookie()
	{
		if($this->_cookie===null)
			$this->_cookie=new THttpCookie($this->getSessionName(),$this->getSessionID());
		return $this->_cookie;
	}
	public function getCookieMode()
	{
		if(ini_get('session.use_cookies')==='0')
			return 'None';
		else if(ini_get('session.use_only_cookies')==='0')
			return 'Allow';
		else
			return 'Only';
	}
	public function setCookieMode($value)
	{
		if($this->_started)
			throw new TInvalidOperationException('httpsession_cookiemode_unchangeable');
		else
		{
			$value=TPropertyValue::ensureEnum($value,array('None','Allow','Only'));
			if($value==='None')
				ini_set('session.use_cookies','0');
			else if($value==='Allow')
			{
				ini_set('session.use_cookies','1');
				ini_set('session.use_only_cookies','0');
			}
			else
			{
				ini_set('session.use_cookies','1');
				ini_set('session.use_only_cookies','1');
			}
		}
	}
	public function getAutoStart()
	{
		return $this->_autoStart;
	}
	public function setAutoStart($value)
	{
		if($this->_initialized)
			throw new TInvalidOperationException('httpsession_autostart_unchangeable');
		else
			$this->_autoStart=TPropertyValue::ensureBoolean($value);
	}
	public function getGCProbability()
	{
		return TPropertyValue::ensureInteger(ini_get('session.gc_probability'));
	}
	public function setGCProbability($value)
	{
		if($this->_started)
			throw new TInvalidOperationException('httpsession_gcprobability_unchangeable');
		else
		{
			$value=TPropertyValue::ensureInteger($value);
			if($value>=0 && $value<=100)
			{
				ini_set('session.gc_probability',$value);
				ini_set('session.gc_divisor','100');
			}
			else
				throw new TInvalidDataValueException('httpsession_gcprobability_invalid',$value);
		}
	}
	public function getUseTransparentSessionID()
	{
		return ini_get('session.use_trans_sid')==='1';
	}
	public function setUseTransparentSessionID($value)
	{
		if($this->_started)
			throw new TInvalidOperationException('httpsession_transid_unchangeable');
		else
			ini_set('session.use_only_cookies',TPropertyValue::ensureBoolean($value)?'1':'0');
	}
	public function getTimeout()
	{
		return TPropertyValue::ensureInteger(ini_get('session.gc_maxlifetime'));
	}
	public function setTimeout($value)
	{
		if($this->_started)
			throw new TInvalidOperationException('httpsession_maxlifetime_unchangeable');
		else
			ini_set('session.gc_maxlifetime',$value);
	}
	public function _open($savePath,$sessionName)
	{
		return true;
	}
	public function _close()
	{
		return true;
	}
	public function _read($id)
	{
		return '';
	}
	public function _write($id,$data)
	{
		return true;
	}
	public function _destroy($id)
	{
		return true;
	}
	public function _gc($maxLifetime)
	{
		return true;
	}
	public function getIterator()
	{
		return new TSessionIterator;
	}
	public function getCount()
	{
		return count($_SESSION);
	}
	public function getKeys()
	{
		return array_keys($_SESSION);
	}
	public function itemAt($key)
	{
		return isset($_SESSION[$key]) ? $_SESSION[$key] : null;
	}
	public function add($key,$value)
	{
		$_SESSION[$key]=$value;
	}
	public function remove($key)
	{
		if(isset($_SESSION[$key]))
		{
			$value=$_SESSION[$key];
			unset($_SESSION[$key]);
			return $value;
		}
		else
			return null;
	}
	public function clear()
	{
		foreach(array_keys($_SESSION) as $key)
			unset($_SESSION[$key]);
	}
	public function contains($key)
	{
		return isset($_SESSION[$key]);
	}
	public function toArray()
	{
		return $_SESSION;
	}
	public function offsetExists($offset)
	{
		return isset($_SESSION[$offset]);
	}
	public function offsetGet($offset)
	{
		return isset($_SESSION[$offset]) ? $_SESSION[$offset] : null;
	}
	public function offsetSet($offset,$item)
	{
		$_SESSION[$offset]=$item;
	}
	public function offsetUnset($offset)
	{
		unset($_SESSION[$offset]);
	}
}
class TSessionIterator implements Iterator
{
	private $_keys;
	private $_key;
	public function __construct()
	{
		$this->_keys=array_keys($_SESSION);
	}
	public function rewind()
	{
		$this->_key=reset($this->_keys);
	}
	public function key()
	{
		return $this->_key;
	}
	public function current()
	{
		return isset($_SESSION[$this->_key])?$_SESSION[$this->_key]:null;
	}
	public function next()
	{
		do
		{
			$this->_key=next($this->_keys);
		}
		while(!isset($_SESSION[$this->_key]) && $this->_key!==false);
	}
	public function valid()
	{
		return $this->_key!==false;
	}
}
Prado::using('System.Web.UI.WebControls.*');
class TAttributeCollection extends TMap
{
	public function __get($name)
	{
		return $this->contains($name)?$this->itemAt($name):parent::__get($name);
	}
	public function __set($name,$value)
	{
		$this->add($name,$value);
	}
	public function itemAt($key)
	{
		return parent::itemAt(strtolower($key));
	}
	public function add($key,$value)
	{
		parent::add(strtolower($key),$value);
	}
	public function remove($key)
	{
		return parent::remove(strtolower($key));
	}
	public function contains($key)
	{
		return parent::contains(strtolower($key));
	}
	public function hasProperty($name)
	{
		return $this->contains($name) || parent::hasProperty($name);
	}
	public function canGetProperty($name)
	{
		return $this->contains($name) || parent::canGetProperty($name);
	}
	public function canSetProperty($name)
	{
		return true;
	}
}
class TControlAdapter extends TApplicationComponent
{
	private $_control;
	public function __construct($control)
	{
		$this->_control=$control;
	}
	public function getControl()
	{
		return $this->_control;
	}
	public function getPage()
	{
		return $this->_control?$this->_control->getPage():null;
	}
	public function createChildControls()
	{
		$this->_control->createChildControls();
	}
	public function loadState()
	{
		$this->_control->loadState();
	}
	public function saveState()
	{
		$this->_control->saveState();
	}
	public function onInit($param)
	{
		$this->_control->onInit($param);
	}
	public function onLoad($param)
	{
		$this->_control->onLoad($param);
	}
	public function onPreRender($param)
	{
		$this->_control->onPreRender($param);
	}
	public function onUnload($param)
	{
		$this->_control->onUnload($param);
	}
	public function render($writer)
	{
		$this->_control->render($writer);
	}
	public function renderChildren($writer)
	{
		$this->_control->renderChildren($writer);
	}
}
class TControl extends TApplicationComponent implements IRenderable, IBindable
{
	const ID_FORMAT='/^[a-zA-Z_]\\w*$/';
	const ID_SEPARATOR='$';
	const CLIENT_ID_SEPARATOR='_';
	const AUTOMATIC_ID_PREFIX='ctl';
	const CS_CONSTRUCTED=0;
	const CS_CHILD_INITIALIZED=1;
	const CS_INITIALIZED=2;
	const CS_STATE_LOADED=3;
	const CS_LOADED=4;
	const CS_PRERENDERED=5;
	const IS_ID_SET=0x01;
	const IS_DISABLE_VIEWSTATE=0x02;
	const IS_SKIN_APPLIED=0x04;
	const IS_STYLESHEET_APPLIED=0x08;
	const IS_DISABLE_THEMING=0x10;
	const IS_CHILD_CREATED=0x20;
	const IS_CREATING_CHILD=0x40;
	const RF_CONTROLS=0;			
	const RF_CHILD_STATE=1;			
	const RF_NAMED_CONTROLS=2;		
	const RF_NAMED_CONTROLS_ID=3;	
	const RF_SKIN_ID=4;				
	const RF_DATA_BINDINGS=5;		
	const RF_EVENTS=6;				
	const RF_CONTROLSTATE=7;		
	const RF_NAMED_OBJECTS=8;		
	const RF_ADAPTER=9;				
	const RF_AUTO_BINDINGS=10;		
	private $_id='';
	private $_uid='';
	private $_parent=null;
	private $_page=null;
	private $_namingContainer=null;
	private $_tplControl=null;
	private $_viewState=array();
	private $_stage=0;
	private $_flags=0;
	private $_rf=array();
	public function __construct()
	{
	}
	public function __get($name)
	{
		if(isset($this->_rf[self::RF_NAMED_OBJECTS][$name]))
			return $this->_rf[self::RF_NAMED_OBJECTS][$name];
		else
			return parent::__get($name);
	}
	public function getHasAdapter()
	{
		return isset($this->_rf[self::RF_ADAPTER]);
	}
	public function getAdapter()
	{
		return isset($this->_rf[self::RF_ADAPTER])?$this->_rf[self::RF_ADAPTER]:null;
	}
	public function setAdapter(TControlAdapter $adapter)
	{
		$this->_rf[self::RF_ADAPTER]=$adapter;
	}
	public function getParent()
	{
		return $this->_parent;
	}
	public function getNamingContainer()
	{
		if(!$this->_namingContainer && $this->_parent)
		{
			if($this->_parent instanceof INamingContainer)
				$this->_namingContainer=$this->_parent;
			else
				$this->_namingContainer=$this->_parent->getNamingContainer();
		}
		return $this->_namingContainer;
	}
	public function getPage()
	{
		if(!$this->_page)
		{
			if($this->_parent)
				$this->_page=$this->_parent->getPage();
			else if($this->_tplControl)
				$this->_page=$this->_tplControl->getPage();
		}
		return $this->_page;
	}
	public function setPage($page)
	{
		$this->_page=$page;
	}
	public function setTemplateControl($control)
	{
		$this->_tplControl=$control;
	}
	public function getTemplateControl()
	{
		if(!$this->_tplControl && $this->_parent)
			$this->_tplControl=$this->_parent->getTemplateControl();
		return $this->_tplControl;
	}
	public function getSourceTemplateControl()
	{
		$control=$this;
		while(($control instanceof TControl) && ($control=$control->getTemplateControl())!==null)
		{
			if(($control instanceof TTemplateControl) && $control->getIsSourceTemplateControl())
				return $control;
		}
		return $this->getPage();
	}
	protected function getControlStage()
	{
		return $this->_stage;
	}
	protected function setControlStage($value)
	{
		$this->_stage=$value;
	}
	public function getID($hideAutoID=true)
	{
		if($hideAutoID)
			return ($this->_flags & self::IS_ID_SET) ? $this->_id : '';
		else
			return $this->_id;
	}
	public function setID($id)
	{
		if(!preg_match(self::ID_FORMAT,$id))
			throw new TInvalidDataValueException('control_id_invalid',get_class($this),$id);
		$this->_id=$id;
		$this->_flags |= self::IS_ID_SET;
		$this->clearCachedUniqueID($this instanceof INamingContainer);
		if($this->_namingContainer)
			$this->_namingContainer->clearNameTable();
	}
	public function getUniqueID()
	{
		if($this->_uid==='')	
		{
			if($namingContainer=$this->getNamingContainer())
			{
				if($this->getPage()===$namingContainer)
					return ($this->_uid=$this->_id);
				else if(($prefix=$namingContainer->getUniqueID())==='')
					return $this->_id;
				else
					return ($this->_uid=$prefix.self::ID_SEPARATOR.$this->_id);
			}
			else	
				return $this->_id;
		}
		else
			return $this->_uid;
	}
	public function focus()
	{
		$this->getPage()->setFocus($this);
	}
	public function getClientID()
	{
		return strtr($this->getUniqueID(),self::ID_SEPARATOR,self::CLIENT_ID_SEPARATOR);
	}
	public function getSkinID()
	{
		return isset($this->_rf[self::RF_SKIN_ID])?$this->_rf[self::RF_SKIN_ID]:'';
	}
	public function setSkinID($value)
	{
		if(($this->_flags & self::IS_SKIN_APPLIED) || $this->_stage>=self::CS_CHILD_INITIALIZED)
			throw new TInvalidOperationException('control_skinid_unchangeable',get_class($this));
		else
			$this->_rf[self::RF_SKIN_ID]=$value;
	}
	public function getEnableTheming()
	{
		if($this->_flags & self::IS_DISABLE_THEMING)
			return false;
		else
			return $this->_parent?$this->_parent->getEnableTheming():true;
	}
	public function setEnableTheming($value)
	{
		if($this->_stage>=self::CS_CHILD_INITIALIZED)
			throw new TInvalidOperationException('control_enabletheming_unchangeable',get_class($this),$this->getUniqueID());
		else if(TPropertyValue::ensureBoolean($value))
			$this->_flags &= ~self::IS_DISABLE_THEMING;
		else
			$this->_flags |= self::IS_DISABLE_THEMING;
	}
	public function getHasControls()
	{
		return isset($this->_rf[self::RF_CONTROLS]) && $this->_rf[self::RF_CONTROLS]->getCount()>0;
	}
	public function getControls()
	{
		if(!isset($this->_rf[self::RF_CONTROLS]))
			$this->_rf[self::RF_CONTROLS]=$this->createControlCollection();
		return $this->_rf[self::RF_CONTROLS];
	}
	protected function createControlCollection()
	{
		return $this->getAllowChildControls()?new TControlCollection($this):new TEmptyControlCollection($this);
	}
	public function getVisible($checkParents=true)
	{
		if($checkParents)
		{
			for($control=$this;$control;$control=$control->_parent)
				if(!$control->getVisible(false))
					return false;
			return true;
		}
		else
			return $this->getViewState('Visible',true);
	}
	public function setVisible($value)
	{
		$this->setViewState('Visible',TPropertyValue::ensureBoolean($value),true);
	}
	public function getEnabled($checkParents=false)
	{
		if($checkParents)
		{
			for($control=$this;$control;$control=$control->_parent)
				if(!$control->getViewState('Enabled',true))
					return false;
			return true;
		}
		else
			return $this->getViewState('Enabled',true);
	}
	public function setEnabled($value)
	{
		$this->setViewState('Enabled',TPropertyValue::ensureBoolean($value),true);
	}
	public function getHasAttributes()
	{
		if($attributes=$this->getViewState('Attributes',null))
			return $attributes->getCount()>0;
		else
			return false;
	}
	public function getAttributes()
	{
		if($attributes=$this->getViewState('Attributes',null))
			return $attributes;
		else
		{
			$attributes=new TAttributeCollection;
			$this->setViewState('Attributes',$attributes,null);
			return $attributes;
		}
	}
	public function hasAttribute($name)
	{
		if($attributes=$this->getViewState('Attributes',null))
			return $attributes->contains($name);
		else
			return false;
	}
	public function getAttribute($name)
	{
		if($attributes=$this->getViewState('Attributes',null))
			return $attributes->itemAt($name);
		else
			return null;
	}
	public function setAttribute($name,$value)
	{
		$this->getAttributes()->add($name,$value);
	}
	public function removeAttribute($name)
	{
		if($attributes=$this->getViewState('Attributes',null))
			return $attributes->remove($name);
		else
			return null;
	}
	public function getEnableViewState($checkParents=false)
	{
		if($checkParents)
		{
			for($control=$this;$control!==null;$control=$control->getParent())
				if($control->_flags & self::IS_DISABLE_VIEWSTATE)
					return false;
			return true;
		}
		else
			return !($this->_flags & self::IS_DISABLE_VIEWSTATE);
	}
	public function setEnableViewState($value)
	{
		if(TPropertyValue::ensureBoolean($value))
			$this->_flags &= ~self::IS_DISABLE_VIEWSTATE;
		else
			$this->_flags |= self::IS_DISABLE_VIEWSTATE;
	}
	protected function getControlState($key,$defaultValue=null)
	{
		return isset($this->_rf[self::RF_CONTROLSTATE][$key])?$this->_rf[self::RF_CONTROLSTATE][$key]:$defaultValue;
	}
	protected function setControlState($key,$value,$defaultValue=null)
	{
		if($value===$defaultValue)
			unset($this->_rf[self::RF_CONTROLSTATE][$key]);
		else
			$this->_rf[self::RF_CONTROLSTATE][$key]=$value;
	}
	protected function clearControlState($key)
	{
		unset($this->_rf[self::RF_CONTROLSTATE][$key]);
	}
	public function getViewState($key,$defaultValue=null)
	{
		return isset($this->_viewState[$key])?$this->_viewState[$key]:$defaultValue;
	}
	public function setViewState($key,$value,$defaultValue=null)
	{
		if($value===$defaultValue)
			unset($this->_viewState[$key]);
		else
			$this->_viewState[$key]=$value;
	}
	public function clearViewState($key)
	{
		unset($this->_viewState[$key]);
	}
	public function bindProperty($name,$expression)
	{
		$this->_rf[self::RF_DATA_BINDINGS][$name]=$expression;
	}
	public function unbindProperty($name)
	{
		unset($this->_rf[self::RF_DATA_BINDINGS][$name]);
	}
	public function autoBindProperty($name,$expression)
	{
		$this->_rf[self::RF_AUTO_BINDINGS][$name]=$expression;
	}
	public function dataBind()
	{
		$this->dataBindProperties();
		$this->onDataBinding(null);
		$this->dataBindChildren();
	}
	protected function dataBindProperties()
	{
		if(isset($this->_rf[self::RF_DATA_BINDINGS]))
		{
			if(($context=$this->getTemplateControl())===null)
				$context=$this;
			foreach($this->_rf[self::RF_DATA_BINDINGS] as $property=>$expression)
				$this->setSubProperty($property,$context->evaluateExpression($expression));
		}
	}
	protected function autoDataBindProperties()
	{
		if(isset($this->_rf[self::RF_AUTO_BINDINGS]))
		{
			if(($context=$this->getTemplateControl())===null)
				$context=$this;
			foreach($this->_rf[self::RF_AUTO_BINDINGS] as $property=>$expression)
				$this->setSubProperty($property,$context->evaluateExpression($expression));
		}
	}
	protected function dataBindChildren()
	{
		if(isset($this->_rf[self::RF_CONTROLS]))
		{
			foreach($this->_rf[self::RF_CONTROLS] as $control)
				if($control instanceof IBindable)
					$control->dataBind();
		}
	}
	final protected function getChildControlsCreated()
	{
		return ($this->_flags & self::IS_CHILD_CREATED)!==0;
	}
	final protected function setChildControlsCreated($value)
	{
		if($value)
			$this->_flags |= self::IS_CHILD_CREATED;
		else
		{
			if($this->hasControl() && ($this->_flags & self::IS_CHILD_CREATED))
				$this->getControls()->clear();
			$this->_flags &= ~self::IS_CHILD_CREATED;
		}
	}
	public function ensureChildControls()
	{
		if(!($this->_flags & self::IS_CHILD_CREATED) && !($this->_flags & self::IS_CREATING_CHILD))
		{
			try
			{
				$this->_flags |= self::IS_CREATING_CHILD;
				if(isset($this->_rf[self::RF_ADAPTER]))
					$this->_rf[self::RF_ADAPTER]->createChildControls();
				else
					$this->createChildControls();
				$this->_flags &= ~self::IS_CREATING_CHILD;
				$this->_flags |= self::IS_CHILD_CREATED;
			}
			catch(Exception $e)
			{
				$this->_flags &= ~self::IS_CREATING_CHILD;
				$this->_flags |= self::IS_CHILD_CREATED;
				throw $e;
			}
		}
	}
	public function createChildControls()
	{
	}
	public function findControl($id)
	{
		$id=strtr($id,'.',self::ID_SEPARATOR);
		$container=($this instanceof INamingContainer)?$this:$this->getNamingContainer();
		if(!$container || !$container->getHasControls())
			return null;
		if(!isset($container->_rf[self::RF_NAMED_CONTROLS]))
		{
			$container->_rf[self::RF_NAMED_CONTROLS]=array();
			$container->fillNameTable($container,$container->_rf[self::RF_CONTROLS]);
		}
		if(($pos=strpos($id,self::ID_SEPARATOR))===false)
			return isset($container->_rf[self::RF_NAMED_CONTROLS][$id])?$container->_rf[self::RF_NAMED_CONTROLS][$id]:null;
		else
		{
			$cid=substr($id,0,$pos);
			$sid=substr($id,$pos+1);
			if(isset($container->_rf[self::RF_NAMED_CONTROLS][$cid]))
				return $container->_rf[self::RF_NAMED_CONTROLS][$cid]->findControl($sid);
			else
				return null;
		}
	}
	public function findControlsByType($type)
	{
		$controls=array();
		if($this->getHasControls())
		{
			foreach($this->_rf[self::RF_CONTROLS] as $control)
			{
				if($control instanceof $type)
					$controls[]=$control;
				if(($control instanceof TControl) && $control->getHasControls())
					$controls=array_merge($controls,$control->findControlsByType($type));
			}
		}
		return $controls;
	}
	public function findControlsByID($id)
	{
		$controls=array();
		if($this->getHasControls())
		{
			foreach($this->_rf[self::RF_CONTROLS] as $control)
			{
				if($control instanceof TControl)
				{
					if($control->_id===$id)
						$controls[]=$control;
					$controls=array_merge($controls,$control->findControlsByID($id));
				}
			}
		}
		return $controls;
	}
	public function clearNamingContainer()
	{
		unset($this->_rf[self::RF_NAMED_CONTROLS_ID]);
		$this->clearNameTable();
	}
	public function registerObject($name,$object)
	{
		if(isset($this->_rf[self::RF_NAMED_OBJECTS][$name]))
			throw new TInvalidOperationException('control_object_reregistered',$name);
		$this->_rf[self::RF_NAMED_OBJECTS][$name]=$object;
	}
	public function unregisterObject($name)
	{
		unset($this->_rf[self::RF_NAMED_OBJECTS][$name]);
	}
	public function isObjectRegistered($name)
	{
		return isset($this->_rf[self::RF_NAMED_OBJECTS][$name]);
	}
	public function getRegisteredObject($name)
	{
		return isset($this->_rf[self::RF_NAMED_OBJECTS][$name])?$this->_rf[self::RF_NAMED_OBJECTS][$name]:null;
	}
	public function getAllowChildControls()
	{
		return true;
	}
	public function createdOnTemplate($parent)
	{
		$parent->addParsedObject($this);
	}
	public function addParsedObject($object)
	{
		$this->getControls()->add($object);
	}
	final protected function clearChildState()
	{
		unset($this->_rf[self::RF_CHILD_STATE]);
	}
	final protected function isDescendentOf($ancestor)
	{
		$control=$this;
		while($control!==$ancestor && $control->_parent)
			$control=$control->_parent;
		return $control===$ancestor;
	}
	public function addedControl($control)
	{
		if($control->_parent)
			$control->_parent->getControls()->remove($control);
		$control->_parent=$this;
		$control->_page=$this->getPage();
		$namingContainer=($this instanceof INamingContainer)?$this:$this->_namingContainer;
		if($namingContainer)
		{
			$control->_namingContainer=$namingContainer;
			if($control->_id==='')
				$control->generateAutomaticID();
			else
				$namingContainer->clearNameTable();
		}
		if($this->_stage>=self::CS_CHILD_INITIALIZED)
		{
			$control->initRecursive($namingContainer);
			if($this->_stage>=self::CS_STATE_LOADED)
			{
				if(isset($this->_rf[self::RF_CHILD_STATE][$control->_id]))
				{
					$state=$this->_rf[self::RF_CHILD_STATE][$control->_id];
					unset($this->_rf[self::RF_CHILD_STATE][$control->_id]);
				}
				else
					$state=null;
				$control->loadStateRecursive($state,!($this->_flags & self::IS_DISABLE_VIEWSTATE));
				if($this->_stage>=self::CS_LOADED)
				{
					$control->loadRecursive();
					if($this->_stage>=self::CS_PRERENDERED)
						$control->preRenderRecursive();
				}
			}
		}
	}
	public function removedControl($control)
	{
		if($this->_namingContainer)
			$this->_namingContainer->clearNameTable();
		$control->unloadRecursive();
		$control->_parent=null;
		$control->_page=null;
		$control->_namingContainer=null;
		$control->_tplControl=null;
		if(!($control->_flags & self::IS_ID_SET))
			$control->_id='';
		else
			unset($this->_rf[self::RF_NAMED_OBJECTS][$control->_id]);
		$control->clearCachedUniqueID(true);
	}
	protected function initRecursive($namingContainer=null)
	{
		if($this->getHasControls())
		{
			if($this instanceof INamingContainer)
				$namingContainer=$this;
			$page=$this->getPage();
			foreach($this->_rf[self::RF_CONTROLS] as $control)
			{
				if($control instanceof TControl)
				{
					$control->_namingContainer=$namingContainer;
					$control->_page=$page;
					if($control->_id==='' && $namingContainer)
						$control->generateAutomaticID();
					$control->initRecursive($namingContainer);
				}
			}
		}
		if($this->_stage<self::CS_INITIALIZED)
		{
			$this->_stage=self::CS_CHILD_INITIALIZED;
			if(($page=$this->getPage()) && $this->getEnableTheming() && !($this->_flags & self::IS_SKIN_APPLIED))
			{
				$page->applyControlSkin($this);
				$this->_flags |= self::IS_SKIN_APPLIED;
			}
			if(isset($this->_rf[self::RF_ADAPTER]))
				$this->_rf[self::RF_ADAPTER]->onInit(null);
			else
				$this->onInit(null);
			$this->_stage=self::CS_INITIALIZED;
		}
	}
	protected function loadRecursive()
	{
		if($this->_stage<self::CS_LOADED)
		{
			if(($context=$this->getTemplateControl())===null)
				$context=$this;
			if(isset($this->_rf[self::RF_ADAPTER]))
				$this->_rf[self::RF_ADAPTER]->onLoad(null);
			else
				$this->onLoad(null);
		}
		if($this->getHasControls())
		{
			foreach($this->_rf[self::RF_CONTROLS] as $control)
			{
				if($control instanceof TControl)
					$control->loadRecursive();
			}
		}
		if($this->_stage<self::CS_LOADED)
			$this->_stage=self::CS_LOADED;
	}
	protected function preRenderRecursive()
	{
		$this->autoDataBindProperties();
		if($this->getVisible(false))
		{
			$this->ensureChildControls();
			if(isset($this->_rf[self::RF_ADAPTER]))
				$this->_rf[self::RF_ADAPTER]->onPreRender(null);
			else
				$this->onPreRender(null);
			if($this->getHasControls())
			{
				foreach($this->_rf[self::RF_CONTROLS] as $control)
				{
					if($control instanceof TControl)
						$control->preRenderRecursive();
					else if($control instanceof TCompositeLiteral)
						$control->evaluateDynamicContent();
				}
			}
		}
		$this->_stage=self::CS_PRERENDERED;
	}
	protected function unloadRecursive()
	{
		if(!($this->_flags & self::IS_ID_SET))
			$this->_id='';
		if($this->getHasControls())
		{
			foreach($this->_rf[self::RF_CONTROLS] as $control)
				if($control instanceof TControl)
					$control->unloadRecursive();
		}
		if(isset($this->_rf[self::RF_ADAPTER]))
			$this->_rf[self::RF_ADAPTER]->onUnload(null);
		else
			$this->onUnload(null);
	}
	public function onInit($param)
	{
		$this->raiseEvent('OnInit',$this,$param);
	}
	public function onLoad($param)
	{
		$this->raiseEvent('OnLoad',$this,$param);
	}
	public function onDataBinding($param)
	{
		$this->raiseEvent('OnDataBinding',$this,$param);
	}
	public function onUnload($param)
	{
		$this->raiseEvent('OnUnload',$this,$param);
	}
	public function onPreRender($param)
	{
		$this->raiseEvent('OnPreRender',$this,$param);
	}
	protected function raiseBubbleEvent($sender,$param)
	{
		$control=$this;
		while($control=$control->_parent)
		{
			if($control->bubbleEvent($sender,$param))
				break;
		}
	}
	public function bubbleEvent($sender,$param)
	{
		return false;
	}
	protected function broadcastEvent($sender,TBroadCastEventParameter $param)
	{
		$origin=(($page=$this->getPage())===null)?$this:$page;
		$origin->broadcastEventInternal($sender,$param);
	}
	final protected function broadcastEventInternal($sender,$param)
	{
		if($this instanceof IBroadcastEventReceiver)
			$this->broadcastEventReceived($sender,$param);
		if($this->getHasControls())
		{
			foreach($this->_rf[self::RF_CONTROLS] as $control)
			{
				if($control instanceof TControl)
					$control->broadcastEventInternal($sender,$param);
			}
		}
	}
	protected function traverseChildControls($param,$preCallback=null,$postCallback=null)
	{
		if($preCallback!==null)
			call_user_func($preCallback,$this,$param);
		if($this->getHasControls())
		{
			foreach($this->_rf[self::RF_CONTROLS] as $control)
			{
				if($control instanceof TControl)
				{
					$control->traverseChildControls($param,$preCallback,$postCallback);
				}
			}
		}
		if($postCallback!==null)
			call_user_func($postCallback,$this,$param);
	}
	public function renderControl($writer)
	{
		if($this->getVisible(false))
		{
			if(isset($this->_rf[self::RF_ADAPTER]))
				$this->_rf[self::RF_ADAPTER]->render($writer);
			else
				$this->render($writer);
		}
	}
	public function render($writer)
	{
		$this->renderChildren($writer);
	}
	public function renderChildren($writer)
	{
		if($this->getHasControls())
		{
			foreach($this->_rf[self::RF_CONTROLS] as $control)
			{
				if(is_string($control))
					$writer->write($control);
				else if($control instanceof TControl)
					$control->renderControl($writer);
				else if($control instanceof IRenderable)
					$control->render($writer);
			}
		}
	}
	public function saveState()
	{
	}
	public function loadState()
	{
	}
	final protected function loadStateRecursive(&$state,$needViewState=true)
	{
		if($state!==null)
		{
			$needViewState=($needViewState && !($this->_flags & self::IS_DISABLE_VIEWSTATE));
			if(isset($state[1]))
			{
				$this->_rf[self::RF_CONTROLSTATE]=&$state[1];
				unset($state[1]);
			}
			else
				unset($this->_rf[self::RF_CONTROLSTATE]);
			if($needViewState)
			{
				if(isset($state[0]))
					$this->_viewState=&$state[0];
				else
					$this->_viewState=array();
			}
			unset($state[0]);
			if($this->getHasControls())
			{
				foreach($this->_rf[self::RF_CONTROLS] as $control)
				{
					if($control instanceof TControl)
					{
						if(isset($state[$control->_id]))
						{
							$control->loadStateRecursive($state[$control->_id],$needViewState);
							unset($state[$control->_id]);
						}
					}
				}
			}
			if(!empty($state))
				$this->_rf[self::RF_CHILD_STATE]=&$state;
			$this->_stage=self::CS_STATE_LOADED;
		}
		else
			$this->_stage=self::CS_STATE_LOADED;
		if(isset($this->_rf[self::RF_ADAPTER]))
			$this->_rf[self::RF_ADAPTER]->loadState(null);
		else
			$this->loadState();
	}
	final protected function &saveStateRecursive($needViewState=true)
	{
		if(isset($this->_rf[self::RF_ADAPTER]))
			$this->_rf[self::RF_ADAPTER]->saveState(null);
		else
			$this->saveState();
		$needViewState=($needViewState && !($this->_flags & self::IS_DISABLE_VIEWSTATE));
		$state=array();
		if($this->getHasControls())
		{
			foreach($this->_rf[self::RF_CONTROLS] as $control)
			{
				if($control instanceof TControl)
					$state[$control->_id]=&$control->saveStateRecursive($needViewState);
			}
		}
		if($needViewState && !empty($this->_viewState))
			$state[0]=&$this->_viewState;
		if(isset($this->_rf[self::RF_CONTROLSTATE]))
			$state[1]=&$this->_rf[self::RF_CONTROLSTATE];
		return $state;
	}
	public function applyStyleSheetSkin($page)
	{
		if($page && !($this->_flags & self::IS_STYLESHEET_APPLIED))
		{
			$page->applyControlStyleSheet($this);
			$this->_flags |= self::IS_STYLESHEET_APPLIED;
		}
		else if($this->_flags & self::IS_STYLESHEET_APPLIED)
			throw new TInvalidOperationException('control_stylesheet_applied',get_class($this));
	}
	private function clearCachedUniqueID($recursive)
	{
		$this->_uid='';
		if($recursive && isset($this->_rf[self::RF_CONTROLS]))
		{
			foreach($this->_rf[self::RF_CONTROLS] as $control)
				if($control instanceof TControl)
					$control->clearCachedUniqueID($recursive);
		}
	}
	private function generateAutomaticID()
	{
		$this->_flags &= ~self::IS_ID_SET;
		if(!isset($this->_namingContainer->_rf[self::RF_NAMED_CONTROLS_ID]))
			$this->_namingContainer->_rf[self::RF_NAMED_CONTROLS_ID]=0;
		$id=$this->_namingContainer->_rf[self::RF_NAMED_CONTROLS_ID]++;
		$this->_id=self::AUTOMATIC_ID_PREFIX . $id;
		$this->_namingContainer->clearNameTable();
	}
	private function clearNameTable()
	{
		unset($this->_rf[self::RF_NAMED_CONTROLS]);
	}
	private function fillNameTable($container,$controls)
	{
		foreach($controls as $control)
		{
			if($control instanceof TControl)
			{
				if($control->_id!=='')
				{
					if(isset($container->_rf[self::RF_NAMED_CONTROLS][$control->_id]))
						throw new TInvalidDataValueException('control_id_nonunique',get_class($control),$control->_id);
					else
						$container->_rf[self::RF_NAMED_CONTROLS][$control->_id]=$control;
				}
				if(!($control instanceof INamingContainer) && $control->getHasControls())
					$this->fillNameTable($container,$control->_rf[self::RF_CONTROLS]);
			}
		}
	}
}
class TControlCollection extends TList
{
	private $_o;
	public function __construct(TControl $owner,$readOnly=false)
	{
		$this->_o=$owner;
		parent::__construct(null,$readOnly);
	}
	protected function getOwner()
	{
		return $this->_o;
	}
	public function insertAt($index,$item)
	{
		if($item instanceof TControl)
		{
			parent::insertAt($index,$item);
			$this->_o->addedControl($item);
		}
		else if(is_string($item) || ($item instanceof IRenderable))
			parent::insertAt($index,$item);
		else
			throw new TInvalidDataTypeException('controlcollection_control_required');
	}
	public function removeAt($index)
	{
		$item=parent::removeAt($index);
		if($item instanceof TControl)
			$this->_o->removedControl($item);
		return $item;
	}
	public function clear()
	{
		parent::clear();
		if($this->_o instanceof INamingContainer)
			$this->_o->clearNamingContainer();
	}
}
class TEmptyControlCollection extends TControlCollection
{
	public function __construct(TControl $owner)
	{
		parent::__construct($owner,true);
	}
}
interface INamingContainer
{
}
interface IPostBackEventHandler
{
	public function raisePostBackEvent($param);
}
interface IPostBackDataHandler
{
	public function loadPostData($key,$values);
	public function raisePostDataChangedEvent();
}
interface IValidator
{
	public function validate();
	public function getIsValid();
	public function setIsValid($value);
	public function getErrorMessage();
	public function setErrorMessage($value);
}
interface IValidatable
{
	public function getValidationPropertyValue();
}
interface IBroadcastEventReceiver
{
	public function broadcastEventReceived($sender,$param);
}
interface ITheme
{
	public function applySkin($control);
}
interface ITemplate
{
	public function instantiateIn($parent);
}
interface IButtonControl
{
	public function getText();
	public function setText($value);
	public function getCausesValidation();
	public function setCausesValidation($value);
	public function getCommandName();
	public function setCommandName($value);
	public function getCommandParameter();
	public function setCommandParameter($value);
	public function getValidationGroup();
	public function setValidationGroup($value);
	public function onClick($param);
	public function onCommand($param);
}
class TBroadcastEventParameter extends TEventParameter
{
	private $_name;
	private $_param;
	public function __construct($name='',$parameter=null)
	{
		$this->_name=$name;
		$this->_param=$parameter;
	}
	public function getName()
	{
		return $this->_name;
	}
	public function setName($value)
	{
		$this->_name=$value;
	}
	public function getParameter()
	{
		return $this->_param;
	}
	public function setParameter($value)
	{
		$this->_param=$value;
	}
}
class TCommandEventParameter extends TEventParameter
{
	private $_name;
	private $_param;
	public function __construct($name='',$parameter='')
	{
		$this->_name=$name;
		$this->_param=$parameter;
	}
	public function getCommandName()
	{
		return $this->_name;
	}
	public function getCommandParameter()
	{
		return $this->_param;
	}
}
class TCompositeLiteral extends TComponent implements IRenderable, IBindable
{
	const TYPE_EXPRESSION=0;
	const TYPE_STATEMENTS=1;
	const TYPE_DATABINDING=2;
	private $_container=null;
	private $_items=array();
	private $_expressions=array();
	private $_statements=array();
	private $_bindings=array();
	public function __construct($items)
	{
		$this->_items=array();
		$this->_expressions=array();
		$this->_statements=array();
		foreach($items as $id=>$item)
		{
			if(is_array($item))
			{
				if($item[0]===self::TYPE_EXPRESSION)
					$this->_expressions[$id]=$item[1];
				else if($item[0]===self::TYPE_STATEMENTS)
					$this->_statements[$id]=$item[1];
				else if($item[0]===self::TYPE_DATABINDING)
					$this->_bindings[$id]=$item[1];
				$this->_items[$id]='';
			}
			else
				$this->_items[$id]=$item;
		}
	}
	public function getContainer()
	{
		return $this->_container;
	}
	public function setContainer(TComponent $value)
	{
		$this->_container=$value;
	}
	public function evaluateDynamicContent()
	{
		$context=$this->_container===null?$this:$this->_container;
		foreach($this->_expressions as $id=>$expression)
			$this->_items[$id]=$context->evaluateExpression($expression);
		foreach($this->_statements as $id=>$statement)
			$this->_items[$id]=$context->evaluateStatements($statement);
	}
	public function dataBind()
	{
		$context=$this->_container===null?$this:$this->_container;
		foreach($this->_bindings as $id=>$binding)
			$this->_items[$id]=$context->evaluateExpression($binding);
	}
	public function render($writer)
	{
		$writer->write(implode('',$this->_items));
	}
}
class TFont extends TComponent
{
	const IS_BOLD=0x01;
	const IS_ITALIC=0x02;
	const IS_OVERLINE=0x04;
	const IS_STRIKEOUT=0x08;
	const IS_UNDERLINE=0x10;
	const IS_SET_BOLD=0x01000;
	const IS_SET_ITALIC=0x02000;
	const IS_SET_OVERLINE=0x04000;
	const IS_SET_STRIKEOUT=0x08000;
	const IS_SET_UNDERLINE=0x10000;
	const IS_SET_SIZE=0x20000;
	const IS_SET_NAME=0x40000;
	private $_flags=0;
	private $_name='';
	private $_size='';
	public function getBold()
	{
		return ($this->_flags & self::IS_BOLD)!==0;
	}
	public function setBold($value)
	{
		$this->_flags |= self::IS_SET_BOLD;
		if(TPropertyValue::ensureBoolean($value))
			$this->_flags |= self::IS_BOLD;
		else
			$this->_flags &= ~self::IS_BOLD;
	}
	public function getItalic()
	{
		return ($this->_flags & self::IS_ITALIC)!==0;
	}
	public function setItalic($value)
	{
		$this->_flags |= self::IS_SET_ITALIC;
		if(TPropertyValue::ensureBoolean($value))
			$this->_flags |= self::IS_ITALIC;
		else
			$this->_flags &= ~self::IS_ITALIC;
	}
	public function getOverline()
	{
		return ($this->_flags & self::IS_OVERLINE)!==0;
	}
	public function setOverline($value)
	{
		$this->_flags |= self::IS_SET_OVERLINE;
		if(TPropertyValue::ensureBoolean($value))
			$this->_flags |= self::IS_OVERLINE;
		else
			$this->_flags &= ~self::IS_OVERLINE;
	}
	public function getSize()
	{
		return $this->_size;
	}
	public function setSize($value)
	{
		$this->_flags |= self::IS_SET_SIZE;
		$this->_size=$value;
	}
	public function getStrikeout()
	{
		return ($this->_flags & self::IS_STRIKEOUT)!==0;
	}
	public function setStrikeout($value)
	{
		$this->_flags |= self::IS_SET_STRIKEOUT;
		if(TPropertyValue::ensureBoolean($value))
			$this->_flags |= self::IS_STRIKEOUT;
		else
			$this->_flags &= ~self::IS_STRIKEOUT;
	}
	public function getUnderline()
	{
		return ($this->_flags & self::IS_UNDERLINE)!==0;
	}
	public function setUnderline($value)
	{
		$this->_flags |= self::IS_SET_UNDERLINE;
		if(TPropertyValue::ensureBoolean($value))
			$this->_flags |= self::IS_UNDERLINE;
		else
			$this->_flags &= ~self::IS_UNDERLINE;
	}
	public function getName()
	{
		return $this->_name;
	}
	public function setName($value)
	{
		$this->_flags |= self::IS_SET_NAME;
		$this->_name=$value;
	}
	public function getIsEmpty()
	{
		return !$this->_flags;
	}
	public function reset()
	{
		$this->_flags=0;
		$this->_name='';
		$this->_size='';
	}
	public function mergeWith($font)
	{
		if($font===null || $font->_flags===0)
			return;
		if(!($this->_flags & self::IS_SET_BOLD) && ($font->_flags & self::IS_SET_BOLD))
			$this->setBold($font->getBold());
		if(!($this->_flags & self::IS_SET_ITALIC) && ($font->_flags & self::IS_SET_ITALIC))
			$this->setItalic($font->getItalic());
		if(!($this->_flags & self::IS_SET_OVERLINE) && ($font->_flags & self::IS_SET_OVERLINE))
			$this->setOverline($font->getOverline());
		if(!($this->_flags & self::IS_SET_STRIKEOUT) && ($font->_flags & self::IS_SET_STRIKEOUT))
			$this->setStrikeout($font->getStrikeout());
		if(!($this->_flags & self::IS_SET_UNDERLINE) && ($font->_flags & self::IS_SET_UNDERLINE))
			$this->setUnderline($font->getUnderline());
		if(!($this->_flags & self::IS_SET_SIZE) && ($font->_flags & self::IS_SET_SIZE))
			$this->setSize($font->getSize());
		if(!($this->_flags & self::IS_SET_NAME) && ($font->_flags & self::IS_SET_NAME))
			$this->setName($font->getName());
	}
	public function copyFrom($font)
	{
		if($font===null || $font->_flags===0)
			return;
		if($font->_flags & self::IS_SET_BOLD)
			$this->setBold($font->getBold());
		if($font->_flags & self::IS_SET_ITALIC)
			$this->setItalic($font->getItalic());
		if($font->_flags & self::IS_SET_OVERLINE)
			$this->setOverline($font->getOverline());
		if($font->_flags & self::IS_SET_STRIKEOUT)
			$this->setStrikeout($font->getStrikeout());
		if($font->_flags & self::IS_SET_UNDERLINE)
			$this->setUnderline($font->getUnderline());
		if($font->_flags & self::IS_SET_SIZE)
			$this->setSize($font->getSize());
		if($font->_flags & self::IS_SET_NAME)
			$this->setName($font->getName());
	}
	public function toString()
	{
		if($this->_flags===0)
			return '';
		$str='';
		if($this->_flags & self::IS_SET_BOLD)
			$str.='font-weight:'.(($this->_flags & self::IS_BOLD)?'bold;':'normal;');
		if($this->_flags & self::IS_SET_ITALIC)
			$str.='font-style:'.(($this->_flags & self::IS_ITALIC)?'italic;':'normal;');
		$textDec='';
		if($this->_flags & self::IS_UNDERLINE)
			$textDec.='underline';
		if($this->_flags & self::IS_OVERLINE)
			$textDec.=' overline';
		if($this->_flags & self::IS_STRIKEOUT)
			$textDec.=' line-through';
		$textDec=ltrim($textDec);
		if($textDec!=='')
			$str.='text-decoration:'.$textDec.';';
		if($this->_size!=='')
			$str.='font-size:'.$this->_size.';';
		if($this->_name!=='')
			$str.='font-family:'.$this->_name.';';
		return $str;
	}
	public function addAttributesToRender($writer)
	{
		if($this->_flags===0)
			return;
		if($this->_flags & self::IS_SET_BOLD)
			$writer->addStyleAttribute('font-weight',(($this->_flags & self::IS_BOLD)?'bold':'normal'));
		if($this->_flags & self::IS_SET_ITALIC)
			$writer->addStyleAttribute('font-style',(($this->_flags & self::IS_ITALIC)?'italic':'normal'));
		$textDec='';
		if($this->_flags & self::IS_UNDERLINE)
			$textDec.='underline';
		if($this->_flags & self::IS_OVERLINE)
			$textDec.=' overline';
		if($this->_flags & self::IS_STRIKEOUT)
			$textDec.=' line-through';
		$textDec=ltrim($textDec);
		if($textDec!=='')
			$writer->addStyleAttribute('text-decoration',$textDec);
		if($this->_size!=='')
			$writer->addStyleAttribute('font-size',$this->_size);
		if($this->_name!=='')
			$writer->addStyleAttribute('font-family',$this->_name);
	}
}
class TStyle extends TComponent
{
	private $_fields=array();
	private $_font=null;
	private $_class=null;
	private $_customStyle=null;
	public function __construct($style=null)
	{
		if($style!==null)
			$this->copyFrom($style);
	}
	public function getBackColor()
	{
		return isset($this->_fields['background-color'])?$this->_fields['background-color']:'';
	}
	public function setBackColor($value)
	{
		if(trim($value)==='')
			unset($this->_fields['background-color']);
		else
			$this->_fields['background-color']=$value;
	}
	public function getBorderColor()
	{
		return isset($this->_fields['border-color'])?$this->_fields['border-color']:'';
	}
	public function setBorderColor($value)
	{
		if(trim($value)==='')
			unset($this->_fields['border-color']);
		else
			$this->_fields['border-color']=$value;
	}
	public function getBorderStyle()
	{
		return isset($this->_fields['border-style'])?$this->_fields['border-style']:'';
	}
	public function setBorderStyle($value)
	{
		if(trim($value)==='')
			unset($this->_fields['border-style']);
		else
			$this->_fields['border-style']=$value;
	}
	public function getBorderWidth()
	{
		return isset($this->_fields['border-width'])?$this->_fields['border-width']:'';
	}
	public function setBorderWidth($value)
	{
		if(trim($value)==='')
			unset($this->_fields['border-width']);
		else
			$this->_fields['border-width']=$value;
	}
	public function getCssClass()
	{
		return $this->_class===null?'':$this->_class;
	}
	public function setCssClass($value)
	{
		$this->_class=$value;
	}
	public function getFont()
	{
		if($this->_font===null)
			$this->_font=new TFont;
		return $this->_font;
	}
	public function getForeColor()
	{
		return isset($this->_fields['color'])?$this->_fields['color']:'';
	}
	public function setForeColor($value)
	{
		if(trim($value)==='')
			unset($this->_fields['color']);
		else
			$this->_fields['color']=$value;
	}
	public function getHeight()
	{
		return isset($this->_fields['height'])?$this->_fields['height']:'';
	}
	public function setHeight($value)
	{
		if(trim($value)==='')
			unset($this->_fields['height']);
		else
			$this->_fields['height']=$value;
	}
	public function getCustomStyle()
	{
		return $this->_customStyle===null?'':$this->_customStyle;
	}
	public function setCustomStyle($value)
	{
		$this->_customStyle=$value;
	}
	public function getStyleField($name)
	{
		return isset($this->_fields[$name])?$this->_fields[$name]:'';
	}
	public function setStyleField($name,$value)
	{
		$this->_fields[$name]=$value;
	}
	public function clearStyleField($name)
	{
		unset($this->_fields[$name]);
	}
	public function hasStyleField($name)
	{
		return isset($this->_fields[$name]);
	}
	public function getWidth()
	{
		return isset($this->_fields['width'])?$this->_fields['width']:'';
	}
	public function setWidth($value)
	{
		$this->_fields['width']=$value;
	}
	public function reset()
	{
		$this->_fields=array();
		$this->_font=null;
		$this->_class=null;
		$this->_customStyle=null;
	}
	public function copyFrom($style)
	{
		if($style instanceof TStyle)
		{
			$this->_fields=array_merge($this->_fields,$style->_fields);
			if($style->_class!==null)
				$this->_class=$style->_class;
			if($style->_customStyle!==null)
				$this->_customStyle=$style->_customStyle;
			if($style->_font!==null)
				$this->getFont()->copyFrom($style->_font);
		}
	}
	public function mergeWith($style)
	{
		if($style instanceof TStyle)
		{
			$this->_fields=array_merge($style->_fields,$this->_fields);
			if($this->_class===null)
				$this->_class=$style->_class;
			if($this->_customStyle===null)
				$this->_customStyle=$style->_customStyle;
			if($style->_font!==null)
				$this->getFont()->mergeWith($style->_font);
		}
	}
	public function addAttributesToRender($writer)
	{
		if($this->_customStyle!==null)
		{
			foreach(explode(';',$this->_customStyle) as $style)
			{
				$arr=explode(':',$style);
				if(isset($arr[1]) && trim($arr[0])!=='')
					$writer->addStyleAttribute(trim($arr[0]),trim($arr[1]));
			}
		}
		$writer->addStyleAttributes($this->_fields);
		if($this->_font!==null)
			$this->_font->addAttributesToRender($writer);
		if($this->_class!==null)
			$writer->addAttribute('class',$this->_class);
	}
}
class TTableStyle extends TStyle
{
	private $_backImageUrl=null;
	private $_horizontalAlign=null;
	private $_cellPadding=null;
	private $_cellSpacing=null;
	private $_gridLines=null;
	public function reset()
	{
		$this->_backImageUrl=null;
		$this->_horizontalAlign=null;
		$this->_cellPadding=null;
		$this->_cellSpacing=null;
		$this->_gridLines=null;
	}
	public function copyFrom($style)
	{
		parent::copyFrom($style);
		if($style instanceof TTableStyle)
		{
			if($style->_backImageUrl!==null)
				$this->_backImageUrl=$style->_backImageUrl;
			if($style->_horizontalAlign!==null)
				$this->_horizontalAlign=$style->_horizontalAlign;
			if($style->_cellPadding!==null)
				$this->_cellPadding=$style->_cellPadding;
			if($style->_cellSpacing!==null)
				$this->_cellSpacing=$style->_cellSpacing;
			if($style->_gridLines!==null)
				$this->_gridLines=$style->_gridLines;
		}
	}
	public function mergeWith($style)
	{
		parent::mergeWith($style);
		if($style instanceof TTableStyle)
		{
			if($this->_backImageUrl===null && $style->_backImageUrl!==null)
				$this->_backImageUrl=$style->_backImageUrl;
			if($this->_horizontalAlign===null && $style->_horizontalAlign!==null)
				$this->_horizontalAlign=$style->_horizontalAlign;
			if($this->_cellPadding===null && $style->_cellPadding!==null)
				$this->_cellPadding=$style->_cellPadding;
			if($this->_cellSpacing===null && $style->_cellSpacing!==null)
				$this->_cellSpacing=$style->_cellSpacing;
			if($this->_gridLines===null && $style->_gridLines!==null)
				$this->_gridLines=$style->_gridLines;
		}
	}
	public function addAttributesToRender($writer)
	{
		if(($url=trim($this->getBackImageUrl()))!=='')
			$writer->addStyleAttribute('background-image','url('.$url.')');
		if(($horizontalAlign=$this->getHorizontalAlign())!=='NotSet')
			$writer->addStyleAttribute('text-align',strtolower($horizontalAlign));
		if(($cellPadding=$this->getCellPadding())>=0)
			$writer->addAttribute('cellpadding',"$cellPadding");
		if(($cellSpacing=$this->getCellSpacing())>=0)
		{
			$writer->addAttribute('cellspacing',"$cellSpacing");
			if($this->getCellSpacing()===0)
				$writer->addStyleAttribute('border-collapse','collapse');
		}
		switch($this->getGridLines())
		{
			case 'Horizontal' : $writer->addAttribute('rules','rows'); break;
			case 'Vertical' : $writer->addAttribute('rules','cols'); break;
			case 'Both' : $writer->addAttribute('rules','all'); break;
		}
		parent::addAttributesToRender($writer);
	}
	public function getBackImageUrl()
	{
		return $this->_backImageUrl===null?'':$this->_backImageUrl;
	}
	public function setBackImageUrl($value)
	{
		$this->_backImageUrl=$value;
	}
	public function getHorizontalAlign()
	{
		return $this->_horizontalAlign===null?'NotSet':$this->_horizontalAlign;
	}
	public function setHorizontalAlign($value)
	{
		$this->_horizontalAlign=TPropertyValue::ensureEnum($value,array('NotSet','Left','Right','Center','Justify'));
	}
	public function getCellPadding()
	{
		return $this->_cellPadding===null?-1:$this->_cellPadding;
	}
	public function setCellPadding($value)
	{
		if(($this->_cellPadding=TPropertyValue::ensureInteger($value))<-1)
			throw new TInvalidDataValueException('tablestyle_cellpadding_invalid');
	}
	public function getCellSpacing()
	{
		return $this->_cellSpacing===null?-1:$this->_cellSpacing;
	}
	public function setCellSpacing($value)
	{
		if(($this->_cellSpacing=TPropertyValue::ensureInteger($value))<-1)
			throw new TInvalidDataValueException('tablestyle_cellspacing_invalid');
	}
	public function getGridLines()
	{
		return $this->_gridLines===null?'None':$this->_gridLines;
	}
	public function setGridLines($value)
	{
		$this->_gridLines=TPropertyValue::ensureEnum($value,array('None', 'Horizontal', 'Vertical', 'Both'));
	}
}
class TTableItemStyle extends TStyle
{
	private $_horizontalAlign=null;
	private $_verticalAlign=null;
	private $_wrap=null;
	public function reset()
	{
		parent::reset();
		$this->_verticalAlign=null;
		$this->_horizontalAlign=null;
		$this->_wrap=null;
	}
	public function copyFrom($style)
	{
		parent::copyFrom($style);
		if($style instanceof TTableItemStyle)
		{
			if($this->_verticalAlign===null && $style->_verticalAlign!==null)
				$this->_verticalAlign=$style->_verticalAlign;
			if($this->_horizontalAlign===null && $style->_horizontalAlign!==null)
				$this->_horizontalAlign=$style->_horizontalAlign;
			if($this->_wrap===null && $style->_wrap!==null)
				$this->_wrap=$style->_wrap;
		}
	}
	public function mergeWith($style)
	{
		parent::mergeWith($style);
		if($style instanceof TTableItemStyle)
		{
			if($style->_verticalAlign!==null)
				$this->_verticalAlign=$style->_verticalAlign;
			if($style->_horizontalAlign!==null)
				$this->_horizontalAlign=$style->_horizontalAlign;
			if($style->_wrap!==null)
				$this->_wrap=$style->_wrap;
		}
	}
	public function addAttributesToRender($writer)
	{
		if(!$this->getWrap())
			$writer->addStyleAttribute('white-space','nowrap');
		if(($horizontalAlign=$this->getHorizontalAlign())!=='NotSet')
			$writer->addAttribute('align',strtolower($horizontalAlign));
		if(($verticalAlign=$this->getVerticalAlign())!=='NotSet')
			$writer->addAttribute('valign',strtolower($verticalAlign));
		parent::addAttributesToRender($writer);
	}
	public function getHorizontalAlign()
	{
		return $this->_horizontalAlign===null?'NotSet':$this->_horizontalAlign;
	}
	public function setHorizontalAlign($value)
	{
		$this->_horizontalAlign=TPropertyValue::ensureEnum($value,array('NotSet','Left','Right','Center','Justify'));
	}
	public function getVerticalAlign()
	{
		return $this->_verticalAlign===null?'NotSet':$this->_verticalAlign;
	}
	public function setVerticalAlign($value)
	{
		$this->_verticalAlign=TPropertyValue::ensureEnum($value,array('NotSet','Top','Bottom','Middle'));
	}
	public function getWrap()
	{
		return $this->_wrap===null?true:$this->_wrap;
	}
	public function setWrap($value)
	{
		$this->_wrap=TPropertyValue::ensureBoolean($value);
	}
}
class TWebControlAdapter extends TControlAdapter
{
	public function render($writer)
	{
		$this->renderBeginTag($writer);
		$this->renderContents($writer);
		$this->renderEndTag($writer);
	}
	public function renderBeginTag($writer)
	{
		$this->getControl()->renderBeginTag($writer);
	}
	public function renderContents($writer)
	{
		$this->getControl()->renderContents($writer);
	}
	public function renderEndTag($writer)
	{
		$this->getControl()->renderEndTag($writer);
	}
}
class TWebControl extends TControl
{
	public function copyBaseAttributes(TWebControl $control)
	{
		$this->setAccessKey($control->getAccessKey());
		$this->setToolTip($control->getToolTip());
		$this->setTabIndex($control->getTabIndex());
		if(!$control->getEnabled())
			$this->setEnabled(false);
		if($control->getHasAttributes())
			$this->getAttributes()->copyFrom($control->getAttributes());
	}
	public function getAccessKey()
	{
		return $this->getViewState('AccessKey','');
	}
	public function setAccessKey($value)
	{
		if(strlen($value)>1)
			throw new TInvalidDataValueException('webcontrol_accesskey_invalid',get_class($this),$value);
		$this->setViewState('AccessKey',$value,'');
	}
	public function getBackColor()
	{
		if($style=$this->getViewState('Style',null))
			return $style->getBackColor();
		else
			return '';
	}
	public function setBackColor($value)
	{
		$this->getStyle()->setBackColor($value);
	}
	public function getBorderColor()
	{
		if($style=$this->getViewState('Style',null))
			return $style->getBorderColor();
		else
			return '';
	}
	public function setBorderColor($value)
	{
		$this->getStyle()->setBorderColor($value);
	}
	public function getBorderStyle()
	{
		if($style=$this->getViewState('Style',null))
			return $style->getBorderStyle();
		else
			return '';
	}
	public function setBorderStyle($value)
	{
		$this->getStyle()->setBorderStyle($value);
	}
	public function getBorderWidth()
	{
		if($style=$this->getViewState('Style',null))
			return $style->getBorderWidth();
		else
			return '';
	}
	public function setBorderWidth($value)
	{
		$this->getStyle()->setBorderWidth($value);
	}
	public function getFont()
	{
		return $this->getStyle()->getFont();
	}
	public function getForeColor()
	{
		if($style=$this->getViewState('Style',null))
			return $style->getForeColor();
		else
			return '';
	}
	public function setForeColor($value)
	{
		$this->getStyle()->setForeColor($value);
	}
	public function getHeight()
	{
		if($style=$this->getViewState('Style',null))
			return $style->getHeight();
		else
			return '';
	}
	public function setCssClass($value)
	{
		$this->getStyle()->setCssClass($value);
	}
	public function getCssClass()
	{
		if($style=$this->getViewState('Style',null))
			return $style->getCssClass();
		else
			return '';
	}
	public function setHeight($value)
	{
		$this->getStyle()->setHeight($value);
	}
	public function getHasStyle()
	{
		return $this->getViewState('Style',null)!==null;
	}
	protected function createStyle()
	{
		return new TStyle;
	}
	public function getStyle()
	{
		if($style=$this->getViewState('Style',null))
			return $style;
		else
		{
			$style=$this->createStyle();
			$this->setViewState('Style',$style,null);
			return $style;
		}
	}
	public function setStyle($value)
	{
		if(is_string($value))
			$this->getStyle()->setCustomStyle($value);
		else
			throw new TInvalidDataValueException('webcontrol_style_invalid',get_class($this));
	}
	public function getTabIndex()
	{
		return $this->getViewState('TabIndex',0);
	}
	public function setTabIndex($value)
	{
		$this->setViewState('TabIndex',TPropertyValue::ensureInteger($value),0);
	}
	protected function getTagName()
	{
		return 'span';
	}
	public function getToolTip()
	{
		return $this->getViewState('ToolTip','');
	}
	public function setToolTip($value)
	{
		$this->setViewState('ToolTip',$value,'');
	}
	public function getWidth()
	{
		if($style=$this->getViewState('Style',null))
			return $style->getWidth();
		else
			return '';
	}
	public function setWidth($value)
	{
		$this->getStyle()->setWidth($value);
	}
	protected function addAttributesToRender($writer)
	{
		if($this->getID()!=='')
			$writer->addAttribute('id',$this->getClientID());
		if(($accessKey=$this->getAccessKey())!=='')
			$writer->addAttribute('accesskey',$accessKey);
		if(!$this->getEnabled())
			$writer->addAttribute('disabled','disabled');
		if(($tabIndex=$this->getTabIndex())>0)
			$writer->addAttribute('tabindex',"$tabIndex");
		if(($toolTip=$this->getToolTip())!=='')
			$writer->addAttribute('title',$toolTip);
		if($style=$this->getViewState('Style',null))
			$style->addAttributesToRender($writer);
		if($this->getHasAttributes())
		{
			foreach($this->getAttributes() as $name=>$value)
				$writer->addAttribute($name,$value);
		}
	}
	public function render($writer)
	{
		$this->renderBeginTag($writer);
		$this->renderContents($writer);
		$this->renderEndTag($writer);
	}
	public function renderBeginTag($writer)
	{
		$this->addAttributesToRender($writer);
		$writer->renderBeginTag($this->getTagName());
	}
	public function renderContents($writer)
	{
		parent::renderChildren($writer);
	}
	public function renderEndTag($writer)
	{
		$writer->renderEndTag();
	}
}
class TCompositeControl extends TControl implements INamingContainer
{
	protected function initRecursive($namingContainer=null)
	{
		$this->ensureChildControls();
		parent::initRecursive($namingContainer);
	}
}
class TTemplateControl extends TCompositeControl
{
	const EXT_TEMPLATE='.tpl';
	private static $_template=array();
	private $_localTemplate=null;
	private $_master=null;
	private $_masterClass='';
	private $_contents=array();
	private $_placeholders=array();
	public function getTemplate()
	{
		if($this->_localTemplate===null)
		{
			$class=get_class($this);
			if(!isset(self::$_template[$class]))
				self::$_template[$class]=$this->loadTemplate();
			return self::$_template[$class];
		}
		else
			return $this->_localTemplate;
	}
	public function setTemplate($value)
	{
		$this->_localTemplate=$value;
	}
	public function getIsSourceTemplateControl()
	{
		if(($template=$this->getTemplate())!==null)
			return $template->getIsSourceTemplate();
		else
			return false;
	}
	public function getTemplateDirectory()
	{
		if(($template=$this->getTemplate())!==null)
			return $template->getContextPath();
		else
			return '';
	}
	protected function loadTemplate()
	{
		$template=$this->getService()->getTemplateManager()->getTemplateByClassName(get_class($this));
		self::$_template[get_class($this)]=$template;
		return $template;
	}
	public function createChildControls()
	{
		if($tpl=$this->getTemplate(true))
		{
			foreach($tpl->getDirective() as $name=>$value)
			{
				if(is_string($value))
					$this->setSubProperty($name,$value);
				else
					throw new TConfigurationException('templatecontrol_directive_invalid',get_class($this),$name);
			}
			$tpl->instantiateIn($this);
		}
	}
	public function registerContent($id,TContent $object)
	{
		if(isset($this->_contents[$id]))
			throw new TConfigurationException('templatecontrol_contentid_duplicated',$id);
		else
			$this->_contents[$id]=$object;
	}
	public function registerContentPlaceHolder($id,TContentPlaceHolder $object)
	{
		if(isset($this->_placeholders[$id]))
			throw new TConfigurationException('templatecontrol_placeholderid_duplicated',$id);
		else
			$this->_placeholders[$id]=$object;
	}
	public function getMasterClass()
	{
		return $this->_masterClass;
	}
	public function setMasterClass($value)
	{
		$this->_masterClass=$value;
	}
	public function getMaster()
	{
		return $this->_master;
	}
	public function injectContent($id,$content)
	{
		if(isset($this->_placeholders[$id]))
		{
			$placeholder=$this->_placeholders[$id];
			$controls=$placeholder->getParent()->getControls();
			$loc=$controls->remove($placeholder);
			$controls->insertAt($loc,$content);
		}
		else
			throw new TConfigurationException('templatecontrol_placeholder_inexistent',$id);
	}
	protected function initRecursive($namingContainer=null)
	{
		$this->ensureChildControls();
		if($this->_masterClass!=='')
		{
			$master=Prado::createComponent($this->_masterClass);
			if(!($master instanceof TTemplateControl))
				throw new TInvalidDataValueException('templatecontrol_mastercontrol_invalid');
			$this->_master=$master;
			$this->getControls()->clear();
			$this->getControls()->add($master);
			$master->ensureChildControls();
			foreach($this->_contents as $id=>$content)
				$master->injectContent($id,$content);
		}
		parent::initRecursive($namingContainer);
	}
}
class TForm extends TControl
{
	public function onInit($param)
	{
		parent::onInit($param);
		$this->getPage()->setForm($this);
	}
	protected function addAttributesToRender($writer)
	{
		$writer->addAttribute('id',$this->getClientID());
		$writer->addAttribute('method',$this->getMethod());
		$writer->addAttribute('action',$this->getRequest()->getRequestURI());
		if(($enctype=$this->getEnctype())!=='')
			$writer->addAttribute('enctype',$enctype);
		$attributes=$this->getAttributes();
		$attributes->remove('action');
		$writer->addAttributes($attributes);
		if(($butt=$this->getDefaultButton())!=='')
		{
			if(($button=$this->findControl($butt))!==null)
				$this->getPage()->getClientScript()->registerDefaultButton($this,$button);
			else
				throw new TInvalidDataValueException('form_defaultbutton_invalid',$butt);
		}
	}
	public function render($writer)
	{
		$this->addAttributesToRender($writer);
		$writer->renderBeginTag('form');
		$page=$this->getPage();
		$page->beginFormRender($writer);
		$this->renderChildren($writer);
		$page->endFormRender($writer);
		$writer->renderEndTag();
	}
	public function getDefaultButton()
	{
		return $this->getViewState('DefaultButton','');
	}
	public function setDefaultButton($value)
	{
		$this->setViewState('DefaultButton',$value,'');
	}
	public function getMethod()
	{
		return $this->getViewState('Method','post');
	}
	public function setMethod($value)
	{
		$this->setViewState('Method',TPropertyValue::ensureEnum($value,'post','get'),'post');
	}
	public function getEnctype()
	{
		return $this->getViewState('Enctype','');
	}
	public function setEnctype($value)
	{
		$this->setViewState('Enctype',$value,'');
	}
	public function getName()
	{
		return $this->getUniqueID();
	}
}
class TClientScriptManager extends TApplicationComponent
{
	const SCRIPT_PATH='Web/Javascripts/js';
	const SCRIPT_LOADER='clientscripts.php';
	private $_page;
	private $_hiddenFields=array();
	private $_beginScripts=array();
	private $_endScripts=array();
	private $_scriptFiles=array();
	private $_headScriptFiles=array();
	private $_headScripts=array();
	private $_styleSheetFiles=array();
	private $_styleSheets=array();
	private $_registeredPradoScripts=array();
	private $_registeredPradoFiles=array();
	private static $_pradoScripts=array(
		'prado'			=> array('prado'),
		'effects'		=> array('prado', 'effects'),
		'ajax'			=> array('prado', 'effects', 'ajax'),
		'validator'		=> array('prado', 'validator'),
		'logger'		=> array('prado', 'logger'),
		'datepicker'	=> array('prado', 'datepicker'),
		'rico'			=> array('prado', 'effects', 'ajax', 'rico'),
		'colorpicker'	=> array('prado', 'colorpicker')
		);
	public function __construct(TPage $owner)
	{
		$this->_page=$owner;
	}
	public function registerPradoScript($name)
	{
		if(!isset($this->_registeredPradoScripts[$name]))
		{
			$this->_registeredPradoScripts[$name]=true;
			if(!isset(self::$_pradoScripts[$name]))
				throw new TInvalidOperationException('csmanager_pradoscript_invalid',$name);
			$basePath=Prado::getFrameworkPath().'/'.self::SCRIPT_PATH;
			foreach(self::$_pradoScripts[$name] as $script)
			{
				if(!isset($this->_registeredPradoFiles[$script]))
				{
					$this->publishFilePath($basePath.'/'.$script.'.js');
					$this->_registeredPradoFiles[$script]=false;
				}
			}
		}
	}
	protected function renderPradoScripts($writer)
	{
		$files='';
		foreach($this->_registeredPradoFiles as $file=>$rendered)
		{
			if(!$rendered)
			{
				$files.=','.$file;
				$this->_registeredPradoFiles[$file]=true;
			}
		}
		if($files!=='')
		{
			$basePath=Prado::getFrameworkPath().'/'.self::SCRIPT_PATH;
			$scriptLoader=$basePath.'/'.self::SCRIPT_LOADER;
			$url=$this->publishFilePath($scriptLoader).'?js='.trim($files,',');
			if($this->getApplication()->getMode()===TApplication::STATE_DEBUG)
				$url.='&amp;mode=debug';
			$writer->write(TJavaScript::renderScriptFile($url));
		}
	}
	public function registerPostBackControl($jsClass,$options)
	{
		if(!isset($options['FormID']))
			$options['FormID']=$this->_page->getForm()->getClientID();
		$optionString=TJavaScript::encode($options);
		$code="new $jsClass($optionString);";
		$this->registerEndScript(sprintf('%08X', crc32($code)), $code);
		$this->registerHiddenField(TPage::FIELD_POSTBACK_TARGET,'');
		$this->registerHiddenField(TPage::FIELD_POSTBACK_PARAMETER,'');
		$this->registerPradoScript('prado');
	}
	public function registerDefaultButton($panel, $button)
	{
		$options = TJavaScript::encode($this->getDefaultButtonOptions($panel, $button));
		$code = "new Prado.WebUI.DefaultButton($options);";
		$this->registerEndScript("prado:".$panel->getClientID(), $code);
		$this->registerPradoScript('prado');
	}
	public function registerFocusControl($target)
	{
		$this->registerPradoScript('prado');
		if($target instanceof TControl)
			$target=$target->getClientID();
		$this->registerEndScript('prado:focus','Prado.Focus.setFocus("'.TJavaScript::quoteString($target).'");');
	}
	protected function getDefaultButtonOptions($panel, $button)
	{
		$options['Panel'] = $panel->getClientID();
		$options['Target'] = $button->getClientID();
		$options['Event'] = 'click';
		return $options;
	}
	public function registerStyleSheetFile($key,$url)
	{
		$this->_styleSheetFiles[$key]=$url;
	}
	public function registerStyleSheet($key,$css)
	{
		$this->_styleSheets[$key]=$css;
	}
	public function registerHeadScriptFile($key,$url)
	{
		$this->_headScriptFiles[$key]=$url;
	}
	public function registerHeadScript($key,$script)
	{
		$this->_headScripts[$key]=$script;
	}
	public function registerScriptFile($key,$url)
	{
		if(!isset($this->_scriptFiles[$key]))
			$this->_scriptFiles[$key]=$url;
	}
	public function registerBeginScript($key,$script)
	{
		$this->_beginScripts[$key]=$script;
	}
	public function registerEndScript($key,$script)
	{
		$this->_endScripts[$key]=$script;
	}
	public function registerHiddenField($name,$value)
	{
		if(!isset($this->_hiddenFields[$name]))
			$this->_hiddenFields[$name]=$value;
	}
	public function isStyleSheetFileRegistered($key)
	{
		return isset($this->_styleSheetFiles[$key]);
	}
	public function isStyleSheetRegistered($key)
	{
		return isset($this->_styleSheets[$key]);
	}
	public function isHeadScriptFileRegistered($key)
	{
		return isset($this->_headScriptFiles[$key]);
	}
	public function isHeadScriptRegistered($key)
	{
		return isset($this->_headScripts[$key]);
	}
	public function isScriptFileRegistered($key)
	{
		return isset($this->_scriptFiles[$key]);
	}
	public function isBeginScriptRegistered($key)
	{
		return isset($this->_beginScripts[$key]);
	}
	public function isEndScriptRegistered($key)
	{
		return isset($this->_endScripts[$key]);
	}
	public function isHiddenFieldRegistered($key)
	{
		return isset($this->_hiddenFields[$key]);
	}
	public function renderStyleSheetFiles($writer)
	{
		$str='';
		foreach($this->_styleSheetFiles as $url)
			$str.="<link rel=\"stylesheet\" type=\"text/css\" href=\"".THttpUtility::htmlEncode($url)."\" />\n";
		$writer->write($str);
	}
	public function renderStyleSheets($writer)
	{
		if(count($this->_styleSheets))
			$writer->write("<style type=\"text/css\">\n/*<![CDATA[*/\n".implode("\n",$this->_styleSheets)."\n/*]]>*/\n</style>\n");
	}
	public function renderHeadScriptFiles($writer)
	{
		$writer->write(TJavaScript::renderScriptFiles($this->_headScriptFiles));
	}
	public function renderHeadScripts($writer)
	{
		$writer->write(TJavaScript::renderScriptBlocks($this->_headScripts));
	}
	public function renderScriptFiles($writer)
	{
		$this->renderPradoScripts($writer);
		$files=array();
		foreach($this->_scriptFiles as $key=>$file)
		{
			if($file!==true)
			{
				$files[]=$file;
				$this->_scriptFiles[$key]=true;
			}
		}
		if(!empty($files))
			$writer->write(TJavaScript::renderScriptFiles($files));
	}
	public function renderBeginScripts($writer)
	{
		$writer->write(TJavaScript::renderScriptBlocks($this->_beginScripts));
	}
	public function renderEndScripts($writer)
	{
		$writer->write(TJavaScript::renderScriptBlocks($this->_endScripts));
	}
	public function renderHiddenFields($writer)
	{
		$str='';
		foreach($this->_hiddenFields as $name=>$value)
		{
			if($value!==true)
			{
				if(is_array($value))
				{
					foreach($value as $v)
						$str.='<input type="hidden" name="'.$name.'[]" id="'.$name.'" value="'.THttpUtility::htmlEncode($value)."\" />\n";
				}
				else
				{
					$str.='<input type="hidden" name="'.$name.'" id="'.$name.'" value="'.THttpUtility::htmlEncode($value)."\" />\n";
				}
												$this->_hiddenFields[$name]=true;
			}
		}
		if($str!=='')
			$writer->write("<div>\n".$str."</div>\n");
	}
}
class TPage extends TTemplateControl
{
	const FIELD_POSTBACK_TARGET='PRADO_POSTBACK_TARGET';
	const FIELD_POSTBACK_PARAMETER='PRADO_POSTBACK_PARAMETER';
	const FIELD_LASTFOCUS='PRADO_LASTFOCUS';
	const FIELD_PAGESTATE='PRADO_PAGESTATE';
	const FIELD_CALLBACK_TARGET='PRADO_CALLBACK_TARGET';
	const FIELD_CALLBACK_PARAMETER='PRADO_CALLBACK_PARAMETER';
	const FIELD_CALLBACK_ID='PRADO_CALLBACK_ID';
	private static $_systemPostFields=array(
		'PRADO_POSTBACK_TARGET'=>true,
		'PRADO_POSTBACK_PARAMETER'=>true,
		'PRADO_LASTFOCUS'=>true,
		'PRADO_PAGESTATE'=>true,
		'PRADO_CALLBACK_TARGET'=>true,
		'PRADO_CALLBACK_PARAMETER'=>true,
		'PRADO_CALLBACK_ID'=>true
	);
	private $_form=null;
	private $_head=null;
	private $_validators=array();
	private $_validated=false;
	private $_theme=null;
	private $_title=null;
	private $_styleSheet=null;
	private $_clientScript=null;
	private $_postData;
	private $_restPostData;
	private $_controlsPostDataChanged=array();
	private $_controlsRequiringPostData=array();
	private $_controlsRegisteredForPostData=array();
	private $_postBackEventTarget=null;
	private $_postBackEventParameter=null;
	private $_formRendered=false;
	private $_inFormRender=false;
	private $_focus=null;
	private $_pagePath='';
	private $_enableStateValidation=true;
	private $_enableStateEncryption=false;
	private $_statePersisterClass='System.Web.UI.TPageStatePersister';
	private $_statePersister=null;
	public function __construct()
	{
		parent::__construct();
		$this->setPage($this);
	}
	public function run($writer)
	{
		$this->determinePostBackMode();
		if($this->getIsPostBack())
		{
			if($this->getIsCallback())
				$this->processCallbackRequest($writer);
			else
				$this->processPostBackRequest($writer);
		}
		else
			$this->processNormalRequest($writer);
	}
	protected function processNormalRequest($writer)
	{
		$this->onPreInit(null);
		$this->initRecursive();
		$this->onInitComplete(null);
		$this->onPreLoad(null);
		$this->loadRecursive();
		$this->onLoadComplete(null);
		$this->preRenderRecursive();
		$this->onPreRenderComplete(null);
		$this->savePageState();
		$this->onSaveStateComplete(null);
		$this->renderControl($writer);
		$this->unloadRecursive();
	}
	protected function processPostBackRequest($writer)
	{
		$this->onPreInit(null);
		$this->initRecursive();
		$this->onInitComplete(null);
		$this->_restPostData=new TMap;
		$this->loadPageState();
		$this->processPostData($this->_postData,true);
		$this->onPreLoad(null);
		$this->loadRecursive();
		$this->processPostData($this->_restPostData,false);
		$this->raiseChangedEvents();
		$this->raisePostBackEvent();
		$this->onLoadComplete(null);
		$this->preRenderRecursive();
		$this->onPreRenderComplete(null);
		$this->savePageState();
		$this->onSaveStateComplete(null);
		$this->renderControl($writer);
		$this->unloadRecursive();
	}
	protected function processCallbackRequest($writer)
	{
	}
	public function getForm()
	{
		return $this->_form;
	}
	public function setForm(TForm $form)
	{
		if($this->_form===null)
			$this->_form=$form;
		else
			throw new TInvalidOperationException('page_form_duplicated');
	}
	public function getValidators($validationGroup=null)
	{
		if(!$this->_validators)
			$this->_validators=new TList;
		if($validationGroup===null)
			return $this->_validators;
		else
		{
			$list=new TList;
			foreach($this->_validators as $validator)
				if($validator->getValidationGroup()===$validationGroup)
					$list->add($validator);
			return $list;
		}
	}
	public function validate($validationGroup=null)
	{
		$this->_validated=true;
		if($this->_validators && $this->_validators->getCount())
		{
			if($validationGroup===null)
			{
				foreach($this->_validators as $validator)
					$validator->validate();
			}
			else
			{
				foreach($this->_validators as $validator)
				{
					if($validator->getValidationGroup()===$validationGroup)
						$validator->validate();
				}
			}
		}
	}
	public function getIsValid()
	{
		if($this->_validated)
		{
			if($this->_validators && $this->_validators->getCount())
			{
				foreach($this->_validators as $validator)
					if(!$validator->getIsValid())
						return false;
			}
			return true;
		}
		else
			throw new TInvalidOperationException('page_isvalid_unknown');
	}
	public function getTheme()
	{
		if(is_string($this->_theme))
			$this->_theme=$this->getService()->getThemeManager()->getTheme($this->_theme);
		return $this->_theme;
	}
	public function setTheme($value)
	{
		$this->_theme=$value;
	}
	public function getStyleSheetTheme()
	{
		if(is_string($this->_styleSheet))
			$this->_styleSheet=$this->getService()->getThemeManager()->getTheme($this->_styleSheet);
		return $this->_styleSheet;
	}
	public function setStyleSheetTheme($value)
	{
		$this->_styleSheet=$value;
	}
	public function applyControlSkin($control)
	{
		if(($theme=$this->getTheme())!==null)
			$theme->applySkin($control);
	}
	public function applyControlStyleSheet($control)
	{
		if(($theme=$this->getStyleSheetTheme())!==null)
			$theme->applySkin($control);
	}
	public function getClientScript()
	{
		if(!$this->_clientScript)
			$this->_clientScript=new TClientScriptManager($this);
		return $this->_clientScript;
	}
	public function onPreInit($param)
	{
		$this->raiseEvent('OnPreInit',$this,$param);
	}
	public function onInitComplete($param)
	{
		$this->raiseEvent('OnInitComplete',$this,$param);
	}
	public function onPreLoad($param)
	{
		$this->raiseEvent('OnPreLoad',$this,$param);
	}
	public function onLoadComplete($param)
	{
		$this->raiseEvent('OnLoadComplete',$this,$param);
	}
	public function onPreRenderComplete($param)
	{
		$this->raiseEvent('OnPreRenderComplete',$this,$param);
		$cs=$this->getClientScript();
		if($this->_theme instanceof ITheme)
		{
			foreach($this->_theme->getStyleSheetFiles() as $url)
				$cs->registerStyleSheetFile($url,$url);
			foreach($this->_theme->getJavaScriptFiles() as $url)
				$cs->registerHeadScriptFile($url,$url);
		}
		if($this->_styleSheet instanceof ITheme)
		{
			foreach($this->_styleSheet->getStyleSheetFiles() as $url)
				$cs->registerStyleSheetFile($url,$url);
			foreach($this->_styleSheet->getJavaScriptFiles() as $url)
				$cs->registerHeadScriptFile($url,$url);
		}
	}
	public function onSaveStateComplete($param)
	{
		$this->raiseEvent('OnSaveStateComplete',$this,$param);
	}
	private function determinePostBackMode()
	{
		$postData=$this->getRequest();
		if($postData->contains(self::FIELD_PAGESTATE) || $postData->contains(self::FIELD_POSTBACK_TARGET))
			$this->_postData=$postData;
	}
	public function getIsPostBack()
	{
		return $this->_postData!==null;
	}
	public function getIsCallback()
	{
		return false;
	}
	public function saveState()
	{
		parent::saveState();
		$this->setViewState('ControlsRequiringPostBack',$this->_controlsRegisteredForPostData,array());
	}
	public function loadState()
	{
		parent::loadState();
		$this->_controlsRequiringPostData=$this->getViewState('ControlsRequiringPostBack',array());
	}
	protected function loadPageState()
	{
		$state=$this->getStatePersister()->load();
		$this->loadStateRecursive($state,$this->getEnableViewState());
	}
	protected function savePageState()
	{
		$state=&$this->saveStateRecursive($this->getEnableViewState());
		$this->getStatePersister()->save($state);
	}
	protected function isSystemPostField($field)
	{
		return isset(self::$_systemPostFields[$field]);
	}
	public function registerRequiresPostData(TControl $control)
	{
		$this->_controlsRegisteredForPostData[$control->getUniqueID()]=true;
	}
	public function getPostBackEventTarget()
	{
		if($this->_postBackEventTarget===null)
		{
			$eventTarget=$this->_postData->itemAt(self::FIELD_POSTBACK_TARGET);
			if(!empty($eventTarget))
				$this->_postBackEventTarget=$this->findControl($eventTarget);
		}
		return $this->_postBackEventTarget;
	}
	public function setPostBackEventTarget(TControl $control)
	{
		$this->_postBackEventTarget=$control;
	}
	public function getPostBackEventParameter()
	{
		if($this->_postBackEventParameter===null)
		{
			if(($this->_postBackEventParameter=$this->_postData->itemAt(self::FIELD_POSTBACK_PARAMETER))===null)
				$this->_postBackEventParameter='';
		}
		return $this->_postBackEventParameter;
	}
	public function setPostBackEventParameter($value)
	{
		$this->_postBackEventParameter=$value;
	}
	protected function processPostData($postData,$beforeLoad)
	{
		if($beforeLoad)
			$this->_restPostData=new TMap;
		foreach($postData as $key=>$value)
		{
			if($this->isSystemPostField($key))
				continue;
			else if($control=$this->findControl($key))
			{
				if($control instanceof IPostBackDataHandler)
				{
					if($control->loadPostData($key,$postData))
						$this->_controlsPostDataChanged[]=$control;
				}
				else if($control instanceof IPostBackEventHandler)
					$this->setPostBackEventTarget($control);
				unset($this->_controlsRequiringPostData[$key]);
			}
			else if($beforeLoad)
				$this->_restPostData->add($key,$value);
		}
		foreach($this->_controlsRequiringPostData as $key=>$value)
		{
			if($control=$this->findControl($key))
			{
				if($control instanceof IPostBackDataHandler)
				{
					if($control->loadPostData($key,$this->_postData))
						$this->_controlsPostDataChanged[]=$control;
				}
				else
					throw new TInvalidDataValueException('page_postbackcontrol_invalid',$key);
				unset($this->_controlsRequiringPostData[$key]);
			}
		}
	}
	private function raiseChangedEvents()
	{
		foreach($this->_controlsPostDataChanged as $control)
			$control->raisePostDataChangedEvent();
	}
	private function raisePostBackEvent()
	{
		if(($postBackHandler=$this->getPostBackEventTarget())===null)
			$this->validate();
		else if($postBackHandler instanceof IPostBackEventHandler)
			$postBackHandler->raisePostBackEvent($this->getPostBackEventParameter());
	}
	public function ensureRenderInForm($control)
	{
		if(!$this->_inFormRender)
			throw new TConfigurationException('page_control_outofform',$control->getUniqueID());
	}
	public function beginFormRender($writer)
	{
		if($this->_formRendered)
			throw new TConfigurationException('page_form_duplicated');
		$this->_formRendered=true;
		$this->_inFormRender=true;
		$cs=$this->getClientScript();
		$cs->renderHiddenFields($writer);
		$cs->renderScriptFiles($writer);
		$cs->renderBeginScripts($writer);
	}
	public function endFormRender($writer)
	{
		$cs=$this->getClientScript();
		if($this->getClientSupportsJavaScript())
		{
			if($this->_focus)
			{
				if(($this->_focus instanceof TControl) && $this->_focus->getVisible(true) || is_string($this->_focus))
					$cs->registerFocusControl($this->_focus);
			}
			else if($this->_postData && ($lastFocus=$this->_postData->itemAt(self::FIELD_LASTFOCUS))!==null)
				$cs->registerFocusControl($lastFocus);
			$cs->renderHiddenFields($writer);
			$cs->renderScriptFiles($writer);
			$cs->renderEndScripts($writer);
		}
		else
			$cs->renderHiddenFields($writer);
		$this->_inFormRender=false;
	}
	public function setFocus($value)
	{
		$this->_focus=$value;
	}
	public function getClientSupportsJavaScript()
	{
		return true;
	}
	public function getHead()
	{
		return $this->_head;
	}
	public function setHead(THead $value)
	{
		if($this->_head)
			throw new TInvalidOperationException('page_head_duplicated');
		$this->_head=$value;
		if($this->_title!==null)
		{
			$this->_head->setTitle($this->_title);
			$this->_title=null;
		}
	}
	public function getTitle()
	{
		if($this->_head)
			return $this->_head->getTitle();
		else
			return $this->_title===null ? '' : $this->_title;
	}
	public function setTitle($value)
	{
		if($this->_head)
			$this->_head->setTitle($value);
		else
			$this->_title=$value;
	}
	public function getStatePersisterClass()
	{
		return $this->_statePersisterClass;
	}
	public function setStatePersisterClass($value)
	{
		$this->_statePersisterClass=$value;
	}
	public function getStatePersister()
	{
		if($this->_statePersister===null)
		{
			$this->_statePersister=Prado::createComponent($this->_statePersisterClass);
			if(!($this->_statePersister instanceof IPageStatePersister))
				throw new TInvalidDataTypeException('page_statepersister_invalid');
			$this->_statePersister->setPage($this);
		}
		return $this->_statePersister;
	}
	public function getEnableStateValidation()
	{
		return $this->_enableStateValidation;
	}
	public function setEnableStateValidation($value)
	{
		$this->_enableStateValidation=TPropertyValue::ensureBoolean($value);
	}
	public function getEnableStateEncryption()
	{
		return $this->_enableStateEncryption;
	}
	public function setEnableStateEncryption($value)
	{
		$this->_enableStateEncryption=TPropertyValue::ensureBoolean($value);
	}
	public function getPagePath()
	{
		return $this->_pagePath;
	}
	public function setPagePath($value)
	{
		$this->_pagePath=$value;
	}
}
interface IPageStatePersister
{
	public function getPage();
	public function setPage(TPage $page);
	public function save($state);
	public function load();
}
class TTemplateManager extends TModule
{
	const TEMPLATE_FILE_EXT='.tpl';
	const TEMPLATE_CACHE_PREFIX='prado:template:';
	public function init($config)
	{
		$this->getService()->setTemplateManager($this);
	}
	public function getTemplateByClassName($className)
	{
		$class=new ReflectionClass($className);
		$tplFile=dirname($class->getFileName()).'/'.$className.self::TEMPLATE_FILE_EXT;
		return $this->getTemplateByFileName($tplFile);
	}
	public function getTemplateByFileName($fileName)
	{
		if(($fileName=$this->getLocalizedTemplate($fileName))!==null)
		{
			if(($cache=$this->getApplication()->getCache())===null)
				return new TTemplate(file_get_contents($fileName),dirname($fileName),$fileName);
			else
			{
				$array=$cache->get(self::TEMPLATE_CACHE_PREFIX.$fileName);
				if(is_array($array))
				{
					list($template,$timestamp)=$array;
					if(filemtime($fileName)<$timestamp)
						return $template;
				}
				$template=new TTemplate(file_get_contents($fileName),dirname($fileName),$fileName);
				$cache->set(self::TEMPLATE_CACHE_PREFIX.$fileName,array($template,time()));
				return $template;
			}
		}
		else
			return null;
	}
	protected function getLocalizedTemplate($filename)
	{
		if(($app=$this->getApplication()->getGlobalization(false))===null)
			return $filename;
		foreach($app->getLocalizedResource($filename) as $file)
		{
			if(($file=realpath($file))!==false && is_file($file))
				return $file;
		}
		return null;
	}
}
class TTemplate extends TApplicationComponent implements ITemplate
{
	const REGEX_RULES='/<!--.*?--!>|<!--.*?-->|<\/?com:([\w\.]+)((?:\s*[\w\.]+=\'.*?\'|\s*[\w\.]+=".*?"|\s*[\w\.]+=<%.*?%>)*)\s*\/?>|<\/?prop:([\w\.]+)\s*>|<%@\s*((?:\s*[\w\.]+=\'.*?\'|\s*[\w\.]+=".*?")*)\s*%>|<%[%#~\\$=\\[](.*?)%>/msS';
	const CONFIG_DATABIND=0;
	const CONFIG_EXPRESSION=1;
	const CONFIG_ASSET=2;
	const CONFIG_PARAMETER=3;
	const CONFIG_LOCALIZATION=4;
	const CONFIG_TEMPLATE=5;
	private $_tpl=array();
	private $_directive=array();
	private $_contextPath;
	private $_tplFile=null;
	private $_startingLine=0;
	private $_content;
	private $_sourceTemplate=true;
	private $_tplControl=null;
	public function __construct($template,$contextPath,$tplFile=null,$startingLine=0,$sourceTemplate=true)
	{
		$this->_sourceTemplate=$sourceTemplate;
		$this->_contextPath=$contextPath;
		$this->_tplFile=$tplFile;
		$this->_startingLine=$startingLine;
		$this->_content=$template;
		$this->parse($template);
		$this->_content=null; 
	}
	public function getIsSourceTemplate()
	{
		return $this->_sourceTemplate;
	}
	public function getContextPath()
	{
		return $this->_contextPath;
	}
	public function getDirective()
	{
		return $this->_directive;
	}
	public function &getItems()
	{
		return $this->_tpl;
	}
	public function instantiateIn($tplControl)
	{
		$this->_tplControl=$tplControl;
		if(($page=$tplControl->getPage())===null)
			$page=$this->getService()->getRequestedPage();
		$controls=array();
		$directChildren=array();
		foreach($this->_tpl as $key=>$object)
		{
			$parent=isset($controls[$object[0]])?$controls[$object[0]]:$tplControl;
			if(!$parent->getAllowChildControls())
				continue;
			if(isset($object[2]))	
			{
				$component=Prado::createComponent($object[1]);
				$properties=&$object[2];
				if($component instanceof TControl)
				{
					$controls[$key]=$component;
					$component->setTemplateControl($tplControl);
					if(isset($properties['id']))
					{
						if(is_array($properties['id']))
							$properties['id']=$component->evaluateExpression($properties['id'][1]);
						$tplControl->registerObject($properties['id'],$component);
					}
					if(isset($properties['skinid']))
					{
						if(is_array($properties['skinid']))
							$component->setSkinID($component->evaluateExpression($properties['skinid'][1]));
						else
							$component->setSkinID($properties['skinid']);
						unset($properties['skinid']);
					}
					$component->applyStyleSheetSkin($page);
					foreach($properties as $name=>$value)
						$this->configureControl($component,$name,$value);
					if($parent===$tplControl)
						$directChildren[]=$component;
					else
						$component->createdOnTemplate($parent);
				}
				else if($component instanceof TComponent)
				{
					if(isset($properties['id']))
					{
						if(is_array($properties['id']))
							$properties['id']=$component->evaluateExpression($properties['id'][1]);
						$tplControl->registerObject($properties['id'],$component);
						if(!$component->hasProperty('id'))
							unset($properties['id']);
					}
					foreach($properties as $name=>$value)
						$this->configureComponent($component,$name,$value);
					if($parent===$tplControl)
						$directChildren[]=$component;
					else
						$parent->addParsedObject($component);
				}
			}
			else	
			{
				if($object[1] instanceof TCompositeLiteral)
				{
					$o=clone $object[1];
					$o->setContainer($tplControl);
					if($parent===$tplControl)
						$directChildren[]=$o;
					else
						$parent->addParsedObject($o);
				}
				else
				{
					if($parent===$tplControl)
						$directChildren[]=$object[1];
					else
						$parent->addParsedObject($object[1]);
				}
			}
		}
		foreach($directChildren as $control)
		{
			if($control instanceof TControl)
				$control->createdOnTemplate($tplControl);
			else
				$tplControl->addParsedObject($control);
		}
	}
	protected function configureControl2($control,$name,$value)
	{
		if(strncasecmp($name,'on',2)===0)		
			$this->configureEvent($control,$name,$value,$control);
		else if(($pos=strrpos($name,'.'))===false)	
			$this->configureProperty($control,$name,$value);
		else	
		{
			$subName=substr($name,$pos+1);
			if(strncasecmp($subName,'on',2)===0) 
			{
				$object=$control->getSubProperty(substr($name,0,$pos));
				if(($object instanceof TControl))
					$this->configureEvent($object,$subName,$value,$control);
				else
					$this->configureSubProperty($control,$name,$value);
			}
			else
				$this->configureSubProperty($control,$name,$value);
		}
	}
	protected function configureControl($control,$name,$value)
	{
		if(strncasecmp($name,'on',2)===0)		
			$this->configureEvent($control,$name,$value,$control);
		else if(($pos=strrpos($name,'.'))===false)	
			$this->configureProperty($control,$name,$value);
		else	
			$this->configureSubProperty($control,$name,$value);
	}
	protected function configureComponent($component,$name,$value)
	{
		if(strpos($name,'.')===false)	
			$this->configureProperty($component,$name,$value);
		else	
			$this->configureSubProperty($component,$name,$value);
	}
	protected function configureEvent($control,$name,$value,$contextControl)
	{
		if(strpos($value,'.')===false)
			$control->attachEventHandler($name,array($contextControl,'TemplateControl.'.$value));
		else
			$control->attachEventHandler($name,array($contextControl,$value));
	}
	protected function configureProperty($component,$name,$value)
	{
		if(is_array($value))
		{
			switch($value[0])
			{
				case self::CONFIG_DATABIND:
					$component->bindProperty($name,$value[1]);
					break;
				case self::CONFIG_EXPRESSION:
					if($component instanceof TControl)
						$component->autoBindProperty($name,$value[1]);
					else
					{
						$setter='set'.$name;
						$component->$setter($this->_tplControl->evaluateExpression($value[1]));
					}
					break;
				case self::CONFIG_TEMPLATE:
					$setter='set'.$name;
					$component->$setter($value[1]);
					break;
				case self::CONFIG_ASSET:		
					$setter='set'.$name;
					$url=$this->publishFilePath($this->_contextPath.'/'.$value[1]);
					$component->$setter($url);
					break;
				case self::CONFIG_PARAMETER:		
					$setter='set'.$name;
					$component->$setter($this->getApplication()->getParameters()->itemAt($value[1]));
					break;
				case self::CONFIG_LOCALIZATION:
					$setter='set'.$name;
					$component->$setter(Prado::localize($value[1]));
					break;
				default:	
					break;
			}
		}
		else
		{
			$setter='set'.$name;
			$component->$setter($value);
		}
	}
	protected function configureSubProperty($component,$name,$value)
	{
		if(is_array($value))
		{
			switch($value[0])
			{
				case self::CONFIG_DATABIND:		
					$component->bindProperty($name,$value[1]);
					break;
				case self::CONFIG_EXPRESSION:		
					if($component instanceof TControl)
						$component->autoBindProperty($name,$value[1]);
					else
						$component->setSubProperty($name,$this->_tplControl->evaluateExpression($value[1]));
					break;
				case self::CONFIG_TEMPLATE:
					$component->setSubProperty($name,$value[1]);
					break;
				case self::CONFIG_ASSET:		
					$url=$this->publishFilePath($this->_contextPath.'/'.$value[1]);
					$component->setSubProperty($name,$url);
					break;
				case self::CONFIG_PARAMETER:		
					$component->setSubProperty($name,$this->getApplication()->getParameters()->itemAt($value[1]));
					break;
				case self::CONFIG_LOCALIZATION:
					$component->setSubProperty($name,Prado::localize($value[1]));
					break;
				default:	
					break;
			}
		}
		else
			$component->setSubProperty($name,$value);
	}
	protected function parse($input)
	{
		$tpl=&$this->_tpl;
		$n=preg_match_all(self::REGEX_RULES,$input,$matches,PREG_SET_ORDER|PREG_OFFSET_CAPTURE);
		$expectPropEnd=false;
		$textStart=0;
        $stack=array();
		$container=-1;
		$matchEnd=0;
		$c=0;
		$this->_directive=null;
		try
		{
			for($i=0;$i<$n;++$i)
			{
				$match=&$matches[$i];
				$str=$match[0][0];
				$matchStart=$match[0][1];
				$matchEnd=$matchStart+strlen($str)-1;
				if(strpos($str,'<com:')===0)	
				{
					if($expectPropEnd)
						continue;
					if($matchStart>$textStart)
						$tpl[$c++]=array($container,substr($input,$textStart,$matchStart-$textStart));
					$textStart=$matchEnd+1;
					$type=$match[1][0];
					$attributes=$this->parseAttributes($match[2][0],$match[2][1]);
					$this->validateAttributes($type,$attributes);
					$tpl[$c++]=array($container,$type,$attributes);
					if($str[strlen($str)-2]!=='/')  
					{
						array_push($stack,$type);
						$container=$c-1;
					}
				}
				else if(strpos($str,'</com:')===0)	
				{
					if($expectPropEnd)
						continue;
					if($matchStart>$textStart)
						$tpl[$c++]=array($container,substr($input,$textStart,$matchStart-$textStart));
					$textStart=$matchEnd+1;
					$type=$match[1][0];
					if(empty($stack))
						throw new TConfigurationException('template_closingtag_unexpected',"</com:$type>");
					$name=array_pop($stack);
					if($name!==$type)
					{
						$tag=$name[0]==='@' ? '</prop:'.substr($name,1).'>' : "</com:$name>";
						throw new TConfigurationException('template_closingtag_expected',$tag);
					}
					$container=$tpl[$container][0];
				}
				else if(strpos($str,'<%@')===0)	
				{
					if($expectPropEnd)
						continue;
					if($matchStart>$textStart)
						$tpl[$c++]=array($container,substr($input,$textStart,$matchStart-$textStart));
					$textStart=$matchEnd+1;
					if(isset($tpl[0]) || $this->_directive!==null)
						throw new TConfigurationException('template_directive_nonunique');
					$this->_directive=$this->parseAttributes($match[4][0],$match[4][1]);
				}
				else if(strpos($str,'<%')===0)	
				{
					if($expectPropEnd)
						continue;
					if($matchStart>$textStart)
						$tpl[$c++]=array($container,substr($input,$textStart,$matchStart-$textStart));
					$textStart=$matchEnd+1;
					$literal=trim(THttpUtility::htmlDecode($match[5][0]));
					if($str[2]==='=')	
						$tpl[$c++]=array($container,array(TCompositeLiteral::TYPE_EXPRESSION,$literal));
					else if($str[2]==='%')  
						$tpl[$c++]=array($container,array(TCompositeLiteral::TYPE_STATEMENTS,$literal));
					else if($str[2]==='#')
						$tpl[$c++]=array($container,array(TCompositeLiteral::TYPE_DATABINDING,$literal));
					else if($str[2]==='$')
						$tpl[$c++]=array($container,array(TCompositeLiteral::TYPE_EXPRESSION,"\$this->getApplication()->getParameters()->itemAt('$literal')"));
					else if($str[2]==='~')
						$tpl[$c++]=array($container,array(TCompositeLiteral::TYPE_EXPRESSION,"\$this->publishFilePath('$this->_contextPath/$literal')"));
					else if($str[2]==='[')
					{
						$literal=trim(substr($literal,0,strlen($literal)-1));
						$tpl[$c++]=array($container,array(TCompositeLiteral::TYPE_EXPRESSION,"Prado::localize('$literal')"));
					}
				}
				else if(strpos($str,'<prop:')===0)	
				{
					$prop=strtolower($match[3][0]);
					array_push($stack,'@'.$prop);
					if(!$expectPropEnd)
					{
						if($matchStart>$textStart)
							$tpl[$c++]=array($container,substr($input,$textStart,$matchStart-$textStart));
						$textStart=$matchEnd+1;
						$expectPropEnd=true;
					}
				}
				else if(strpos($str,'</prop:')===0)	
				{
					$prop=strtolower($match[3][0]);
					if(empty($stack))
						throw new TConfigurationException('template_closingtag_unexpected',"</prop:$prop>");
					$name=array_pop($stack);
					if($name!=='@'.$prop)
					{
						$tag=$name[0]==='@' ? '</prop:'.substr($name,1).'>' : "</com:$name>";
						throw new TConfigurationException('template_closingtag_expected',$tag);
					}
					if(($last=count($stack))<1 || $stack[$last-1][0]!=='@')
					{
						if($matchStart>$textStart)
						{
							$value=substr($input,$textStart,$matchStart-$textStart);
							if(strrpos($prop,'template')===strlen($prop)-8)
								$value=$this->parseTemplateProperty($value,$textStart);
							else
								$value=$this->parseAttribute($value);
							if($container>=0)
							{
								$type=$tpl[$container][1];
								$this->validateAttributes($type,array($prop=>$value));
								if(isset($tpl[$container][2][$prop]))
									throw new TConfigurationException('template_property_duplicated',$prop);
								$tpl[$container][2][$prop]=$value;
							}
							else	
								$this->_directive[$prop]=$value;
							$textStart=$matchEnd+1;
						}
						$expectPropEnd=false;
					}
				}
				else if(strpos($str,'<!--')===0)	
				{
					if(strrpos($str,'--!>')===strlen($str)-4)  
					{
						if($expectPropEnd)
							throw new TConfigurationException('template_comments_forbidden');
						if($matchStart>$textStart)
							$tpl[$c++]=array($container,substr($input,$textStart,$matchStart-$textStart));
						$textStart=$matchEnd+1;
					}
				}
				else
					throw new TConfigurationException('template_matching_unexpected',$match);
			}
			if(!empty($stack))
			{
				$name=array_pop($stack);
				$tag=$name[0]==='@' ? '</prop:'.substr($name,1).'>' : "</com:$name>";
				throw new TConfigurationException('template_closingtag_expected',$tag);
			}
			if($textStart<strlen($input))
				$tpl[$c++]=array($container,substr($input,$textStart));
		}
		catch(Exception $e)
		{
			if($e->getErrorCode()==='template_format_invalid' || $e->getErrorCode()==='template_format_invalid2')
				throw $e;
			if($matchEnd===0)
				$line=$this->_startingLine+1;
			else
				$line=$this->_startingLine+count(explode("\n",substr($input,0,$matchEnd+1)));
			if(empty($this->_tplFile))
				throw new TConfigurationException('template_format_invalid2',$line,$e->getMessage(),$input);
			else
				throw new TConfigurationException('template_format_invalid',$this->_tplFile,$line,$e->getMessage());
		}
		if($this->_directive===null)
			$this->_directive=array();
		$objects=array();
		$parent=null;
		$merged=array();
		foreach($tpl as $id=>$object)
		{
			if(isset($object[2]) || $object[0]!==$parent)
			{
				if($parent!==null)
				{
					if(count($merged[1])===1 && is_string($merged[1][0]))
						$objects[$id-1]=array($merged[0],$merged[1][0]);
					else
						$objects[$id-1]=array($merged[0],new TCompositeLiteral($merged[1]));
				}
				if(isset($object[2]))
				{
					$parent=null;
					$objects[$id]=$object;
				}
				else
				{
					$parent=$object[0];
					$merged=array($parent,array($object[1]));
				}
			}
			else
				$merged[1][]=$object[1];
		}
		if($parent!==null)
		{
			if(count($merged[1])===1 && is_string($merged[1][0]))
				$objects[$id]=array($merged[0],$merged[1][0]);
			else
				$objects[$id]=array($merged[0],new TCompositeLiteral($merged[1]));
		}
		$tpl=$objects;
		return $objects;
	}
	protected function parseAttributes($str,$offset)
	{
		if($str==='')
			return array();
		$pattern='/([\w\.]+)=(\'.*?\'|".*?"|<%.*?%>)/msS';
		$attributes=array();
		$n=preg_match_all($pattern,$str,$matches,PREG_SET_ORDER|PREG_OFFSET_CAPTURE);
		for($i=0;$i<$n;++$i)
		{
			$match=&$matches[$i];
			$name=strtolower($match[1][0]);
			if(isset($attributes[$name]))
				throw new TConfigurationException('template_property_duplicated',$name);
			$value=$match[2][0];
			if(strrpos($name,'template')===strlen($name)-8)
			{
				if($value[0]==='\'' || $value[0]==='"')
					$attributes[$name]=$this->parseTemplateProperty(substr($value,1,strlen($value)-2),$match[2][1]+1);
				else
					$attributes[$name]=$this->parseTemplateProperty($value,$match[2][1]);
			}
			else
			{
				if($value[0]==='\'' || $value[0]==='"')
					$attributes[$name]=$this->parseAttribute(substr($value,1,strlen($value)-2));
				else
					$attributes[$name]=$this->parseAttribute($value);
			}
		}
		return $attributes;
	}
	protected function parseTemplateProperty($content,$offset)
	{
		$line=$this->_startingLine+count(explode("\n",substr($this->_content,0,$offset)))-1;
		return array(self::CONFIG_TEMPLATE,new TTemplate($content,$this->_contextPath,$this->_tplFile,$line,false));
	}
	protected function parseAttribute($value)
	{
		$matches=array();
		if(!preg_match('/\\s*(<%#.*?%>|<%=.*?%>|<%~.*?%>|<%\\$.*?%>|<%\\[.*?\\]%>)\\s*/msS',$value,$matches) || $matches[0]!==$value)
			return THttpUtility::htmlDecode($value);
		$value=THttpUtility::htmlDecode($matches[1]);
		if($value[2]==='#') 
			return array(self::CONFIG_DATABIND,substr($value,3,strlen($value)-5));
		else if($value[2]==='=') 
			return array(self::CONFIG_EXPRESSION,substr($value,3,strlen($value)-5));
		else if($value[2]==='~') 
			return array(self::CONFIG_ASSET,trim(substr($value,3,strlen($value)-5)));
		else if($value[2]==='[')
			return array(self::CONFIG_LOCALIZATION,trim(substr($value,3,strlen($value)-6)));
		else if($value[2]==='$')
			return array(self::CONFIG_PARAMETER,trim(substr($value,3,strlen($value)-5)));
		return '';
	}
	protected function validateAttributes($type,$attributes)
	{
		Prado::using($type);
		if(($pos=strrpos($type,'.'))!==false)
			$className=substr($type,$pos+1);
		else
			$className=$type;
		$class=new TReflectionClass($className);
		if(is_subclass_of($className,'TControl') || $className==='TControl')
		{
			foreach($attributes as $name=>$att)
			{
				if(($pos=strpos($name,'.'))!==false)
				{
					$subname=substr($name,0,$pos);
					if(!$class->hasMethod('get'.$subname))
						throw new TConfigurationException('template_property_unknown',$type,$subname);
				}
				else if(strncasecmp($name,'on',2)===0)
				{
					if(!$class->hasMethod($name))
						throw new TConfigurationException('template_event_unknown',$type,$name);
					else if(!is_string($att))
						throw new TConfigurationException('template_eventhandler_invalid',$type,$name);
				}
				else
				{
					if(!$class->hasMethod('set'.$name))
					{
						if($class->hasMethod('get'.$name))
							throw new TConfigurationException('template_property_readonly',$type,$name);
						else
							throw new TConfigurationException('template_property_unknown',$type,$name);
					}
					else if(is_array($att) && $att[0]!==self::CONFIG_EXPRESSION)
					{
						if(strcasecmp($name,'id')===0)
							throw new TConfigurationException('template_controlid_invalid',$type);
						else if(strcasecmp($name,'skinid')===0)
							throw new TConfigurationException('template_controlskinid_invalid',$type);
					}
				}
			}
		}
		else if(is_subclass_of($className,'TComponent') || $className==='TComponent')
		{
			foreach($attributes as $name=>$att)
			{
				if(is_array($att) && ($att[0]===self::CONFIG_DATABIND))
					throw new TConfigurationException('template_databind_forbidden',$type,$name);
				if(($pos=strpos($name,'.'))!==false)
				{
					$subname=substr($name,0,$pos);
					if(!$class->hasMethod('get'.$subname))
						throw new TConfigurationException('template_property_unknown',$type,$subname);
				}
				else if(strncasecmp($name,'on',2)===0)
					throw new TConfigurationException('template_event_forbidden',$type,$name);
				else
				{
					if(strcasecmp($name,'id')!==0 && !$class->hasMethod('set'.$name))
					{
						if($class->hasMethod('get'.$name))
							throw new TConfigurationException('template_property_readonly',$type,$name);
						else
							throw new TConfigurationException('template_property_unknown',$type,$name);
					}
				}
			}
		}
		else
			throw new TConfigurationException('template_component_required',$type);
	}
}
class TThemeManager extends TModule
{
	const DEFAULT_BASEPATH='themes';
	private $_initialized=false;
	private $_basePath=null;
	private $_baseUrl=null;
	public function init($config)
	{
		$this->_initialized=true;
		$this->getService()->setThemeManager($this);
	}
	public function getTheme($name)
	{
		$themePath=$this->getBasePath().'/'.$name;
		$themeUrl=rtrim($this->getBaseUrl(),'/').'/'.$name;
		return new TTheme($themePath,$themeUrl);
	}
	public function getAvailableThemes()
	{
		$themes=array();
		$basePath=$this->getBasePath();
		$folder=@opendir($basePath);
		while($file=@readdir($folder))
		{
			if($file!=='.' && $file!=='..' && $file!=='.svn' && is_dir($basePath.'/'.$file))
				$themes[]=$file;
		}
		closedir($folder);
		return $themes;
	}
	public function getBasePath()
	{
		if($this->_basePath===null)
		{
			$this->_basePath=dirname($this->getRequest()->getApplicationFilePath()).'/'.self::DEFAULT_BASEPATH;
			if(($basePath=realpath($this->_basePath))===false || !is_dir($basePath))
				throw new TConfigurationException('thememanager_basepath_invalid',$this->_basePath);
			$this->_basePath=$basePath;
		}
		return $this->_basePath;
	}
	public function setBasePath($value)
	{
		if($this->_initialized)
			throw new TInvalidOperationException('thememanager_basepath_unchangeable');
		else
		{
			$this->_basePath=Prado::getPathOfNamespace($value);
			if($this->_basePath===null || !is_dir($this->_basePath))
				throw new TInvalidDataValueException('thememanager_basepath_invalid',$value);
		}
	}
	public function getBaseUrl()
	{
		if($this->_baseUrl===null)
		{
			$appPath=dirname($this->getRequest()->getApplicationFilePath());
			$basePath=$this->getBasePath();
			if(strpos($basePath,$appPath)===false)
				throw new TConfigurationException('thememanager_baseurl_required');
			$appUrl=rtrim(dirname($this->getRequest()->getApplicationUrl()),'/\\');
			$this->_baseUrl=$appUrl.strtr(substr($basePath,strlen($appPath)),'\\','/');
		}
		return $this->_baseUrl;
	}
	public function setBaseUrl($value)
	{
		$this->_baseUrl=rtrim($value,'/');
	}
}
class TTheme extends TApplicationComponent implements ITheme
{
	const THEME_CACHE_PREFIX='prado:theme:';
	const SKIN_FILE_EXT='.skin';
	private $_themePath;
	private $_themeUrl;
	private $_skins=null;
	private $_name='';
	private $_cssFiles=array();
	private $_jsFiles=array();
	public function __construct($themePath,$themeUrl)
	{
		$this->_themeUrl=$themeUrl;
		$this->_themePath=realpath($themePath);
		$this->_name=basename($themePath);
		$cacheValid=false;
		if(($cache=$this->getApplication()->getCache())!==null)
		{
			$array=$cache->get(self::THEME_CACHE_PREFIX.$themePath);
			if(is_array($array))
			{
				list($skins,$cssFiles,$jsFiles,$timestamp)=$array;
				if($this->getApplication()->getMode()!==TApplication::STATE_PERFORMANCE)
				{
					if(($dir=opendir($themePath))===false)
						throw new TIOException('theme_path_inexistent',$themePath);
					$cacheValid=true;
					while(($file=readdir($dir))!==false)
					{
						if($file==='.' || $file==='..')
							continue;
						else if(basename($file,'.css')!==$file)
							$this->_cssFiles[]=$themeUrl.'/'.$file;
						else if(basename($file,'.js')!==$file)
							$this->_jsFiles[]=$themeUrl.'/'.$file;
						else if(basename($file,self::SKIN_FILE_EXT)!==$file && filemtime($themePath.'/'.$file)>$timestamp)
						{
							$cacheValid=false;
							break;
						}
					}
					closedir($dir);
					if($cacheValid)
						$this->_skins=$skins;
				}
				else
				{
					$cacheValid=true;
					$this->_cssFiles=$cssFiles;
					$this->_jsFiles=$jsFiles;
					$this->_skins=$skins;
				}
			}
		}
		if(!$cacheValid)
		{
			$this->_cssFiles=array();
			$this->_jsFiles=array();
			$this->_skins=array();
			if(($dir=opendir($themePath))===false)
				throw new TIOException('theme_path_inexistent',$themePath);
			while(($file=readdir($dir))!==false)
			{
				if($file==='.' || $file==='..')
					continue;
				else if(basename($file,'.css')!==$file)
					$this->_cssFiles[]=$themeUrl.'/'.$file;
				else if(basename($file,'.js')!==$file)
					$this->_jsFiles[]=$themeUrl.'/'.$file;
				else if(basename($file,self::SKIN_FILE_EXT)!==$file)
				{
					$template=new TTemplate(file_get_contents($themePath.'/'.$file),$themePath,$themePath.'/'.$file);
					foreach($template->getItems() as $skin)
					{
						if($skin[0]!==-1)
							throw new TConfigurationException('theme_control_nested',$skin[1],dirname($themePath));
						else if(!isset($skin[2]))  
							continue;
						$type=$skin[1];
						$id=isset($skin[2]['skinid'])?$skin[2]['skinid']:0;
						unset($skin[2]['skinid']);
						if(isset($this->_skins[$type][$id]))
							throw new TConfigurationException('theme_skinid_duplicated',$type,$id,dirname($themePath));
						foreach($skin[2] as $name=>$value)
						{
							if(is_array($value) && ($value[0]===TTemplate::CONFIG_DATABIND || $value[0]===TTemplate::CONFIG_PARAMETER))
								throw new TConfigurationException('theme_databind_forbidden',dirname($themePath),$type,$id);
						}
						$this->_skins[$type][$id]=$skin[2];
					}
				}
			}
			closedir($dir);
			if($cache!==null)
				$cache->set(self::THEME_CACHE_PREFIX.$themePath,array($this->_skins,$this->_cssFiles,$this->_jsFiles,time()));
		}
	}
	public function getName()
	{
		return $this->_name;
	}
	public function getBaseUrl()
	{
		return $this->_themeUrl;
	}
	public function getBasePath()
	{
		return $this->_themePath;
	}
	public function applySkin($control)
	{
		$type=get_class($control);
		if(($id=$control->getSkinID())==='')
			$id=0;
		if(isset($this->_skins[$type][$id]))
		{
			foreach($this->_skins[$type][$id] as $name=>$value)
			{
				if(is_array($value))
				{
					if($value[0]===TTemplate::CONFIG_EXPRESSION)
						$value=$this->evaluateExpression($value[1]);
					else if($value[0]===TTemplate::CONFIG_ASSET)
						$value=$this->_themeUrl.'/'.ltrim($value[1],'/');
				}
				if(strpos($name,'.')===false)	
				{
					if($control->hasProperty($name))
					{
						if($control->canSetProperty($name))
						{
							$setter='set'.$name;
							$control->$setter($value);
						}
						else
							throw new TConfigurationException('theme_property_readonly',$type,$name);
					}
					else
						throw new TConfigurationException('theme_property_undefined',$type,$name);
				}
				else	
					$control->setSubProperty($name,$value);
			}
			return true;
		}
		else
			return false;
	}
	public function getStyleSheetFiles()
	{
		return $this->_cssFiles;
	}
	public function getJavaScriptFiles()
	{
		return $this->_jsFiles;
	}
}
class TPageService extends TService
{
	const CONFIG_FILE='config.xml';
	const DEFAULT_BASEPATH='pages';
	const CONFIG_CACHE_PREFIX='prado:pageservice:';
	const PAGE_FILE_EXT='.page';
	private $_basePath=null;
	private $_defaultPage='Home';
	private $_pagePath=null;
	private $_page=null;
	private $_properties;
	private $_initialized=false;
	private $_themeManager=null;
	private $_templateManager=null;
	public function __construct()
	{
		$this->setID('page');
	}
	public function init($config)
	{
		$this->getApplication()->setPageService($this);
		$pageConfig=$this->loadPageConfig($this->getRequestedPagePath(),$config);
		$this->initPageContext($pageConfig);
		$this->_initialized=true;
	}
	protected function initPageContext($pageConfig)
	{
		$application=$this->getApplication();
		foreach($pageConfig->getAliases() as $alias=>$path)
			Prado::setPathOfAlias($alias,$path);
		foreach($pageConfig->getUsings() as $using)
			Prado::using($using);
		$this->_properties=$pageConfig->getProperties();
		$parameters=$application->getParameters();
		foreach($pageConfig->getParameters() as $id=>$parameter)
		{
			if(is_array($parameter))
			{
				$component=Prado::createComponent($parameter[0]);
				foreach($parameter[1] as $name=>$value)
					$component->setSubProperty($name,$value);
				$parameters->add($id,$component);
			}
			else
				$parameters->add($id,$parameter);
		}
		$modules=array();
		foreach($pageConfig->getModules() as $id=>$moduleConfig)
		{
			$module=Prado::createComponent($moduleConfig[0]);
			if(is_string($id))
				$application->setModule($id,$module);
			foreach($moduleConfig[1] as $name=>$value)
				$module->setSubProperty($name,$value);
			$modules[]=array($module,$moduleConfig[2]);
		}
		foreach($modules as $module)
			$module[0]->init($module[1]);
		$application->getAuthorizationRules()->mergeWith($pageConfig->getRules());
	}
	protected function determineRequestedPagePath()
	{
		$pagePath=$this->getRequest()->getServiceParameter();
		if(empty($pagePath))
			$pagePath=$this->getDefaultPage();
		return $pagePath;
	}
	protected function loadPageConfig($pagePath,$config=null)
	{
		$application=$this->getApplication();
		if(($cache=$application->getCache())===null)
		{
			$pageConfig=new TPageConfiguration;
			if($config!==null)
				$pageConfig->loadXmlElement($config,$application->getBasePath(),null);
			$pageConfig->loadConfigurationFiles($pagePath,$this->getBasePath());
		}
		else
		{
			$configCached=true;
			$currentTimestamp=array();
			$arr=$cache->get(self::CONFIG_CACHE_PREFIX.$pagePath);
			if(is_array($arr))
			{
				list($pageConfig,$timestamps)=$arr;
				if($application->getMode()!==TApplication::STATE_PERFORMANCE)
				{
					foreach($timestamps as $fileName=>$timestamp)
					{
						if($fileName===0) 
						{
							$appConfigFile=$application->getConfigurationFile();
							$currentTimestamp[0]=$appConfigFile===null?0:@filemtime($appConfigFile);
							if($currentTimestamp[0]>$timestamp || ($timestamp>0 && !$currentTimestamp[0]))
								$configCached=false;
						}
						else
						{
							$currentTimestamp[$fileName]=@filemtime($fileName);
							if($currentTimestamp[$fileName]>$timestamp || ($timestamp>0 && !$currentTimestamp[$fileName]))
								$configCached=false;
						}
					}
				}
			}
			else
			{
				$configCached=false;
				$paths=explode('.',$pagePath);
				$configPath=$this->getBasePath();
				foreach($paths as $path)
				{
					$configFile=$configPath.'/'.self::CONFIG_FILE;
					$currentTimestamp[$configFile]=@filemtime($configFile);
					$configPath.='/'.$path;
				}
				$appConfigFile=$application->getConfigurationFile();
				$currentTimestamp[0]=$appConfigFile===null?0:@filemtime($appConfigFile);
			}
			if(!$configCached)
			{
				$pageConfig=new TPageConfiguration;
				if($config!==null)
					$pageConfig->loadXmlElement($config,$application->getBasePath(),null);
				$pageConfig->loadConfigurationFiles($pagePath,$this->getBasePath());
				$cache->set(self::CONFIG_CACHE_PREFIX.$pagePath,array($pageConfig,$currentTimestamp));
			}
		}
		return $pageConfig;
	}
	public function getTemplateManager()
	{
		if(!$this->_templateManager)
		{
			$this->_templateManager=new TTemplateManager;
			$this->_templateManager->init(null);
		}
		return $this->_templateManager;
	}
	public function setTemplateManager(TTemplateManager $value)
	{
		$this->_templateManager=$value;
	}
	public function getThemeManager()
	{
		if(!$this->_themeManager)
		{
			$this->_themeManager=new TThemeManager;
			$this->_themeManager->init(null);
		}
		return $this->_themeManager;
	}
	public function setThemeManager(TThemeManager $value)
	{
		$this->_themeManager=$value;
	}
	public function getRequestedPagePath()
	{
		if($this->_pagePath===null)
		{
			$this->_pagePath=strtr($this->determineRequestedPagePath(),'/\\','..');
			if(empty($this->_pagePath))
				throw new THttpException(404,'pageservice_page_required');
		}
		return $this->_pagePath;
	}
	public function getRequestedPage()
	{
		return $this->_page;
	}
	public function getDefaultPage()
	{
		return $this->_defaultPage;
	}
	public function setDefaultPage($value)
	{
		if($this->_initialized)
			throw new TInvalidOperationException('pageservice_defaultpage_unchangeable');
		else
			$this->_defaultPage=$value;
	}
	public function getBasePath()
	{
		if($this->_basePath===null)
		{
			$basePath=$this->getApplication()->getBasePath().'/'.self::DEFAULT_BASEPATH;
			if(($this->_basePath=realpath($basePath))===false || !is_dir($this->_basePath))
				throw new TConfigurationException('pageservice_basepath_invalid',$basePath);
		}
		return $this->_basePath;
	}
	public function setBasePath($value)
	{
		if($this->_initialized)
			throw new TInvalidOperationException('pageservice_basepath_unchangeable');
		else if(($path=Prado::getPathOfNamespace($value))===null || !is_dir($path))
			throw new TConfigurationException('pageservice_basepath_invalid',$value);
		$this->_basePath=realpath($path);
	}
	public function run()
	{
		$path=$this->getBasePath().'/'.strtr($this->getRequestedPagePath(),'.','/');
		if(is_file($path.self::PAGE_FILE_EXT))
		{
			if(is_file($path.Prado::CLASS_FILE_EXT))
			{
				$className=basename($path);
				if(!class_exists($className,false))
					include_once($path.Prado::CLASS_FILE_EXT);
				if(!class_exists($className,false))
					throw new TConfigurationException('pageservice_pageclass_unknown',$className);
			}
			else
				$className='TPage';
			$this->_page=new $className();
			$this->_page->setPagePath($this->getRequestedPagePath());
			foreach($this->_properties as $name=>$value)
				$this->_page->setSubProperty($name,$value);
			$this->_page->setTemplate($this->getTemplateManager()->getTemplateByFileName($path.self::PAGE_FILE_EXT));
		}
		else
			throw new THttpException(404,'pageservice_page_unknown',$this->getRequestedPagePath());
		$this->_page->run($this->getResponse()->createHtmlWriter());
	}
	public function constructUrl($pagePath,$getParams=null,$encodeAmpersand=false,$encodeGetItems=true)
	{
		return $this->getRequest()->constructUrl($this->getID(),$pagePath,$getParams,$encodeAmpersand,$encodeGetItems);
	}
}
class TPageConfiguration extends TComponent
{
	private $_properties=array();
	private $_usings=array();
	private $_aliases=array();
	private $_modules=array();
	private $_parameters=array();
	private $_rules=array();
	public function getProperties()
	{
		return $this->_properties;
	}
	public function getAliases()
	{
		return $this->_aliases;
	}
	public function getUsings()
	{
		return $this->_usings;
	}
	public function getModules()
	{
		return $this->_modules;
	}
	public function getParameters()
	{
		return $this->_parameters;
	}
	public function getRules()
	{
		return $this->_rules;
	}
	public function loadConfigurationFiles($pagePath,$basePath)
	{
		$paths=explode('.',$pagePath);
		$page=array_pop($paths);
		$path=$basePath;
		foreach($paths as $p)
		{
			$this->loadFromFile($path.'/'.TPageService::CONFIG_FILE,null);
			$path.='/'.$p;
		}
		$this->loadFromFile($path.'/'.TPageService::CONFIG_FILE,$page);
		$this->_rules=new TAuthorizationRuleCollection($this->_rules);
	}
	private function loadFromFile($fname,$page)
	{
		if(empty($fname) || !is_file($fname))
			return;
		$dom=new TXmlDocument;
		if($dom->loadFromFile($fname))
			$this->loadXmlElement($dom,dirname($fname),$page);
		else
			throw new TConfigurationException('pageserviceconf_file_invalid',$fname);
	}
	public function loadXmlElement($dom,$configPath,$page)
	{
		if(($pathsNode=$dom->getElementByTagName('paths'))!==null)
		{
			foreach($pathsNode->getElementsByTagName('alias') as $aliasNode)
			{
				if(($id=$aliasNode->getAttribute('id'))!==null && ($p=$aliasNode->getAttribute('path'))!==null)
				{
					$p=str_replace('\\','/',$p);
					$path=realpath(preg_match('/^\\/|.:\\//',$p)?$p:$configPath.'/'.$p);
					if($path===false || !is_dir($path))
						throw new TConfigurationException('pageserviceconf_aliaspath_invalid',$id,$p,$configPath);
					if(isset($this->_aliases[$id]))
						throw new TConfigurationException('pageserviceconf_alias_redefined',$id,$configPath);
					$this->_aliases[$id]=$path;
				}
				else
					throw new TConfigurationException('pageserviceconf_alias_invalid',$configPath);
			}
			foreach($pathsNode->getElementsByTagName('using') as $usingNode)
			{
				if(($namespace=$usingNode->getAttribute('namespace'))!==null)
					$this->_usings[]=$namespace;
				else
					throw new TConfigurationException('pageserviceconf_using_invalid',$configPath);
			}
		}
		if(($modulesNode=$dom->getElementByTagName('modules'))!==null)
		{
			foreach($modulesNode->getElementsByTagName('module') as $node)
			{
				$properties=$node->getAttributes();
				$type=$properties->remove('class');
				$id=$properties->itemAt('id');
				if($type===null)
					throw new TConfigurationException('pageserviceconf_moduletype_required',$id,$configPath);
				$node->setParent(null);
				if($id===null)
					$this->_modules[]=array($type,$properties->toArray(),$node);
				else
					$this->_modules[$id]=array($type,$properties->toArray(),$node);
			}
		}
		if(($parametersNode=$dom->getElementByTagName('parameters'))!==null)
		{
			foreach($parametersNode->getElementsByTagName('parameter') as $node)
			{
				$properties=$node->getAttributes();
				if(($id=$properties->remove('id'))===null)
					throw new TConfigurationException('pageserviceconf_parameter_invalid',$configPath);
				if(($type=$properties->remove('class'))===null)
				{
					if(($value=$properties->remove('value'))===null)
						$this->_parameters[$id]=$node;
					else
						$this->_parameters[$id]=$value;
				}
				else
					$this->_parameters[$id]=array($type,$properties->toArray());
			}
		}
		if(($authorizationNode=$dom->getElementByTagName('authorization'))!==null)
		{
			$rules=array();
			foreach($authorizationNode->getElements() as $node)
			{
				$pages=$node->getAttribute('pages');
				$ruleApplies=false;
				if(empty($pages))
					$ruleApplies=true;
				else if($page!==null)
				{
					$ps=explode(',',$pages);
					foreach($ps as $p)
					{
						if($page===trim($p))
						{
							$ruleApplies=true;
							break;
						}
					}
				}
				if($ruleApplies)
					$rules[]=new TAuthorizationRule($node->getTagName(),$node->getAttribute('users'),$node->getAttribute('roles'),$node->getAttribute('verb'));
			}
			$this->_rules=array_merge($rules,$this->_rules);
		}
		if(($pagesNode=$dom->getElementByTagName('pages'))!==null)
		{
			$this->_properties=array_merge($this->_properties,$pagesNode->getAttributes()->toArray());
			if($page!==null)   
			{
				foreach($pagesNode->getElementsByTagName('page') as $node)
				{
					$properties=$node->getAttributes();
					if(($id=$properties->itemAt('id'))===null)
						throw new TConfigurationException('pageserviceconf_page_invalid',$configPath);
					if($id===$page)
						$this->_properties=array_merge($this->_properties,$properties->toArray());
				}
			}
		}
	}
}
class TAssetManager extends TModule
{
	const DEFAULT_BASEPATH='assets';
	private $_basePath=null;
	private $_baseUrl=null;
	private $_checkTimestamp=false;
	private $_application;
	private $_published=array();
	private $_initialized=false;
	public function init($config)
	{
		$application=$this->getApplication();
		if($this->_basePath===null)
			$this->_basePath=dirname($application->getRequest()->getApplicationFilePath()).'/'.self::DEFAULT_BASEPATH;
		if(!is_writable($this->_basePath) || !is_dir($this->_basePath))
			throw new TConfigurationException('assetmanager_basepath_invalid',$this->_basePath);
		if($this->_baseUrl===null)
			$this->_baseUrl=rtrim(dirname($application->getRequest()->getApplicationUrl()),'/\\').'/'.self::DEFAULT_BASEPATH;
		$application->setAssetManager($this);
		$this->_initialized=true;
	}
	public function getBasePath()
	{
		return $this->_basePath;
	}
	public function setBasePath($value)
	{
		if($this->_initialized)
			throw new TInvalidOperationException('assetmanager_basepath_unchangeable');
		else
		{
			$this->_basePath=Prado::getPathOfNamespace($value);
			if($this->_basePath===null || !is_dir($this->_basePath) || !is_writable($this->_basePath))
				throw new TInvalidDataValueException('assetmanage_basepath_invalid',$value);
		}
	}
	public function getBaseUrl()
	{
		return $this->_baseUrl;
	}
	public function setBaseUrl($value)
	{
		if($this->_initialized)
			throw new TInvalidOperationException('assetmanager_baseurl_unchangeable');
		else
			$this->_baseUrl=rtrim($value,'/');
	}
	public function publishFilePath($path,$checkTimestamp=false)
	{
		if(isset($this->_published[$path]))
			return $this->_published[$path];
		else if(empty($path) || ($fullpath=realpath($path))===false)
			throw new TInvalidDataValueException('assetmanager_filepath_invalid',$path);
		else if(is_file($fullpath))
		{
			$dir=$this->hash(dirname($fullpath));
			$fileName=basename($fullpath);
			$dst=$this->_basePath.'/'.$dir;
			if(!is_file($dst.'/'.$fileName) || $checkTimestamp || $this->getApplication()->getMode()!==TApplication::STATE_PERFORMANCE)
				$this->copyFile($fullpath,$dst);
			return $this->_published[$path]=$this->_baseUrl.'/'.$dir.'/'.$fileName;
		}
		else
		{
			$dir=$this->hash($fullpath);
			if(!is_dir($this->_basePath.'/'.$dir) || $checkTimestamp || $this->getApplication()->getMode()!==TApplication::STATE_PERFORMANCE)
			{
				$this->copyDirectory($fullpath,$this->_basePath.'/'.$dir);
			}
			return $this->_published[$path]=$this->_baseUrl.'/'.$dir;
		}
	}
	protected function hash($dir)
	{
		return sprintf('%x',crc32($dir));
	}
	protected function copyFile($src,$dst)
	{
		if(!is_dir($dst))
			@mkdir($dst);
		$dstFile=$dst.'/'.basename($src);
		if(@filemtime($dstFile)<@filemtime($src))
		{
			@copy($src,$dstFile);
		}
	}
	protected function copyDirectory($src,$dst)
	{
		if(!is_dir($dst))
			@mkdir($dst);
		$folder=@opendir($src);
		while($file=@readdir($folder))
		{
			if($file==='.' || $file==='..' || $file==='.svn')
				continue;
			else if(is_file($src.'/'.$file))
			{
				if(@filemtime($dst.'/'.$file)<@filemtime($src.'/'.$file))
					@copy($src.'/'.$file,$dst.'/'.$file);
			}
			else
				$this->copyDirectory($src.'/'.$file,$dst.'/'.$file);
		}
		closedir($folder);
	}
	public function publishTarFile($tarfile, $md5sum, $checkTimestamp=false)
	{
		if(isset($this->_published[$md5sum]))
			return $this->_published[$md5sum];
		else if(($fullpath=realpath($md5sum))===false)
			throw new TInvalidDataValueException('assetmanager_tarchecksum_invalid',$md5sum);
		else
		{
			$dir=$this->hash(dirname($fullpath));
			$fileName=basename($fullpath);
			$dst=$this->_basePath.'/'.$dir;
			if(!is_file($dst.'/'.$fileName) || $checkTimestamp || $this->getApplication()->getMode()!==TApplication::STATE_PERFORMANCE)
			{
				if(@filemtime($dst.'/'.$fileName)<@filemtime($fullpath))
				{
					$this->copyFile($fullpath,$dst);
					$this->deployTarFile($tarfile,$dst);
				}
			}
			return $this->_published[$md5sum]=$this->_baseUrl.'/'.$dir;
		}
	}
	protected function deployTarFile($path,$destination)
	{
		if(($fullpath=realpath($path))===false)
			throw new TIOException('assetmanager_tarfile_invalid',$path);
		else
		{
			Prado::using('System.IO.TTarFileExtractor');
			$tar = new TTarFileExtractor($fullpath);
			return $tar->extract($destination);
		}
	}
}
class TGlobalization extends TModule
{
	private $_defaultCharset = 'UTF-8';
	private $_defaultCulture = 'en';
	private $_charset=null;
	private $_culture=null;
	private $_translation;
	public function init($xml)
	{
		if($this->_charset===null)
			$this->_charset=$this->getDefaultCharset();
		if($this->_culture===null)
			$this->_culture=$this->getDefaultCulture();
		if($xml!==null)
		{
			$translation = $xml->getElementByTagName('translation');
			if($translation)
				$this->setTranslationConfiguration($translation->getAttributes());
		}
		$this->getApplication()->setGlobalization($this);
	}
	public function getDefaultCulture()
	{
		return $this->_defaultCulture;
	}
	public function setDefaultCulture($culture)
	{
		$this->_defaultCharset = str_replace('-','_',$culture);
	}
	public function getDefaultCharset()
	{
		return $this->_defaultCharset;
	}
	public function setDefaultCharset($charset)
	{
		$this->_defaultCharset = $charset;
	}
	public function getCulture()
	{
		return $this->_culture;
	}
	public function setCulture($culture)
	{
		$this->_culture = str_replace('-','_',$culture);
	}
	public function getCharset()
	{
		return $this->_charset;
	}
	public function setCharset($charset)
	{
		$this->_charset = $charset;
	}
	public function getTranslationConfiguration()
	{
		return $this->_translation;
	}
	protected function setTranslationConfiguration(TMap $config)
	{
		if($config['type'] == 'XLIFF' || $config['type'] == 'gettext')
		{
			$config['source'] = Prado::getPathOfNamespace($config['source']);
			if($config['source']===null || !is_dir($config['source']))
				throw new TException("invalid source dir '{$config['source']}'");
		}
		if($config['cache'])
			$config['cache'] = $this->getApplication()->getRunTimePath().'/i18n';
		$this->_translation = $config;
	}
	public function getTranslationCatalogue()
	{
		return $this->_translation['catalogue'];
	}
	public function setTranslationCatalogue($value)
	{
		$this->_translation['catalogue'] = $value;
	}
	public function getCultureVariants($culture=null)
	{
		if(is_null($culture)) $culture = $this->getCulture();
		$variants = explode('_', $culture);
		$result = array();
		for(; count($variants) > 0; array_pop($variants))
			$result[] = implode('_', $variants);
		return $result;
	}
	public function getLocalizedResource($file,$culture=null)
	{
		$files = array();
		$variants = $this->getCultureVariants($culture);
		$path = pathinfo($file);
		foreach($variants as $variant)
			$files[] = $path['dirname'].'/'.$variant.'/'.$path['basename'];
		$filename = substr($path['basename'],0,strrpos($path['basename'],'.'));
		foreach($variants as $variant)
			$files[] = $path['dirname'].'/'.$filename.'.'.$variant.'.'.$path['extension'];
		$files[] = $file;
		return $files;
	}
}
class TApplication extends TComponent
{
	const STATE_OFF='Off';
	const STATE_DEBUG='Debug';
	const STATE_NORMAL='Normal';
	const STATE_PERFORMANCE='Performance';
	const PAGE_SERVICE_ID='page';
	const CONFIG_FILE='application.xml';
	const RUNTIME_PATH='runtime';
	const CONFIGCACHE_FILE='config.cache';
	const GLOBAL_FILE='global.cache';
	private static $_steps=array(
		'onBeginRequest',
		'onAuthentication',
		'onAuthenticationComplete',
		'onAuthorization',
		'onAuthorizationComplete',
		'onLoadState',
		'onLoadStateComplete',
		'onPreRunService',
		'runService',
		'onSaveState',
		'onSaveStateComplete',
		'onPreFlushOutput',
		'flushOutput'
	);
	private $_id;
	private $_uniqueID;
	private $_requestCompleted=false;
	private $_step;
	private $_service=null;
	private $_pageService=null;
	private $_modules;
	private $_parameters;
	private $_configFile;
	private $_basePath;
	private $_runtimePath;
	private $_stateChanged=false;
	private $_globals=array();
	private $_cacheFile;
	private $_errorHandler=null;
	private $_request=null;
	private $_response=null;
	private $_session=null;
	private $_cache=null;
	private $_statePersister=null;
	private $_user=null;
	private $_globalization=null;
	private $_security=null;
	private $_assetManager=null;
	private $_authRules=null;
	private $_mode='Debug';
	public function __construct($basePath='protected',$cacheConfig=true)
	{
				Prado::setApplication($this);
				if(($this->_basePath=realpath($basePath))===false)
			throw new TConfigurationException('application_basepath_invalid',$basePath);
		if(is_file($this->_basePath))
		{
			$this->_configFile=$this->_basePath;
			$this->_basePath=dirname($this->_basePath);
		}
		else if(is_file($this->_basePath.'/'.self::CONFIG_FILE))
			$this->_configFile=$this->_basePath.'/'.self::CONFIG_FILE;
		else
			$this->_configFile=null;
				$this->_runtimePath=$this->_basePath.'/'.self::RUNTIME_PATH;
		if(is_writable($this->_runtimePath))
		{
			if($this->_configFile!==null)
			{
				$subdir=basename($this->_configFile);
				$this->_runtimePath.='/'.$subdir;
				if(!is_dir($this->_runtimePath))
					if(@mkdir($this->_runtimePath)===false)
						throw new TConfigurationException('application_runtimepath_failed',$this->_runtimePath);
			}
		}
		else
			throw new TConfigurationException('application_runtimepath_invalid',$this->_runtimePath);
		$this->_cacheFile=$cacheConfig ? $this->_runtimePath.'/'.self::CONFIGCACHE_FILE : null;
				$this->_uniqueID=md5($this->_runtimePath);
	}
	public function run()
	{
		try
		{
			$this->initApplication();
			$n=count(self::$_steps);
			$this->_step=0;
			$this->_requestCompleted=false;
			while($this->_step<$n)
			{
				if($this->_mode===self::STATE_OFF)
					throw new THttpException(503,'application_service_unavailable');
				if($this->_requestCompleted)
					break;
				$method=self::$_steps[$this->_step];
				$this->$method();
				$this->_step++;
			}
		}
		catch(Exception $e)
		{
			$this->onError($e);
		}
		$this->onEndRequest();
	}
	public function completeRequest()
	{
		$this->_requestCompleted=true;
	}
	public function getRequestCompleted()
	{
		return $this->_requestCompleted;
	}
	public function getGlobalState($key,$defaultValue=null)
	{
		return isset($this->_globals[$key])?$this->_globals[$key]:$defaultValue;
	}
	public function setGlobalState($key,$value,$defaultValue=null)
	{
		$this->_stateChanged=true;
		if($value===$defaultValue)
			unset($this->_globals[$key]);
		else
			$this->_globals[$key]=$value;
	}
	public function clearGlobalState($key)
	{
		$this->_stateChanged=true;
		unset($this->_globals[$key]);
	}
	protected function loadGlobals()
	{
		$this->_globals=$this->getApplicationStatePersister()->load();
	}
	protected function saveGlobals()
	{
		if(!$this->_stateChanged)
			return;
		$this->getApplicationStatePersister()->save($this->_globals);
	}
	public function getID()
	{
		return $this->_id;
	}
	public function setID($value)
	{
		$this->_id=$value;
	}
	public function getUniqueID()
	{
		return $this->_uniqueID;
	}
	public function getMode()
	{
		return $this->_mode;
	}
	public function setMode($value)
	{
		$this->_mode=TPropertyValue::ensureEnum($value,array(self::STATE_OFF,self::STATE_DEBUG,self::STATE_NORMAL,self::STATE_PERFORMANCE));
	}
	public function getBasePath()
	{
		return $this->_basePath;
	}
	public function getConfigurationFile()
	{
		return $this->_configFile;
	}
	public function getRuntimePath()
	{
		return $this->_runtimePath;
	}
	public function getService()
	{
		return $this->_service;
	}
	public function setModule($id,IModule $module)
	{
		if(isset($this->_modules[$id]))
			throw new TConfigurationException('application_moduleid_duplicated',$id);
		else
			$this->_modules[$id]=$module;
	}
	public function getModule($id)
	{
		return isset($this->_modules[$id])?$this->_modules[$id]:null;
	}
	public function getModules()
	{
		return $this->_modules;
	}
	public function getParameters()
	{
		return $this->_parameters;
	}
	public function getPageService()
	{
		if(!$this->_pageService)
		{
			$this->_pageService=new TPageService;
			$this->_pageService->init(null);
		}
		return $this->_pageService;
	}
	public function setPageService(TPageService $service)
	{
		$this->_pageService=$service;
	}
	public function getRequest()
	{
		if(!$this->_request)
		{
			$this->_request=new THttpRequest;
			$this->_request->init(null);
		}
		return $this->_request;
	}
	public function setRequest(THttpRequest $request)
	{
		$this->_request=$request;
	}
	public function getResponse()
	{
		if(!$this->_response)
		{
			$this->_response=new THttpResponse;
			$this->_response->init(null);
		}
		return $this->_response;
	}
	public function setResponse(THttpResponse $response)
	{
		$this->_response=$response;
	}
	public function getSession()
	{
		if(!$this->_session)
		{
			$this->_session=new THttpSession;
			$this->_session->init(null);
		}
		return $this->_session;
	}
	public function setSession(THttpSession $session)
	{
		$this->_session=$session;
	}
	public function getErrorHandler()
	{
		if(!$this->_errorHandler)
		{
			$this->_errorHandler=new TErrorHandler;
			$this->_errorHandler->init(null);
		}
		return $this->_errorHandler;
	}
	public function setErrorHandler(TErrorHandler $handler)
	{
		$this->_errorHandler=$handler;
	}
	public function getSecurityManager()
	{
		if(!$this->_security)
		{
			$this->_security=new TSecurityManager;
			$this->_security->init(null);
		}
		return $this->_security;
	}
	public function setSecurityManager(TSecurityManager $sm)
	{
		$this->_security=$sm;
	}
	public function getAssetManager()
	{
		if(!$this->_assetManager)
		{
			$this->_assetManager=new TAssetManager;
			$this->_assetManager->init(null);
		}
		return $this->_assetManager;
	}
	public function setAssetManager(TAssetManager $value)
	{
		$this->_assetManager=$value;
	}
	public function getApplicationStatePersister()
	{
		if(!$this->_statePersister)
		{
			$this->_statePersister=new TApplicationStatePersister;
			$this->_statePersister->init(null);
		}
		return $this->_statePersister;
	}
	public function setApplicationStatePersister(IStatePersister $persister)
	{
		$this->_statePersister=$persister;
	}
	public function getCache()
	{
		return $this->_cache;
	}
	public function setCache(ICache $cache)
	{
		$this->_cache=$cache;
	}
	public function getUser()
	{
		return $this->_user;
	}
	public function setUser(IUser $user)
	{
		$this->_user=$user;
	}
	public function getGlobalization($createIfNotExists=true)
	{
		if($this->_globalization===null && $createIfNotExists)
			$this->_globalization=new TGlobalization;
		return $this->_globalization;
	}
	public function setGlobalization(TGlobalization $glob)
	{
		$this->_globalization=$glob;
	}
	public function getAuthorizationRules()
	{
		if($this->_authRules===null)
			$this->_authRules=new TAuthorizationRuleCollection;
		return $this->_authRules;
	}
	protected function initApplication()
	{
		Prado::setPathOfAlias('Application',$this->_basePath);
		if($this->_configFile===null)
		{
			$this->getRequest()->setAvailableServices(array(self::PAGE_SERVICE_ID));
			$this->_service=$this->getPageService();
			return;
		}
		if($this->_cacheFile===null || @filemtime($this->_cacheFile)<filemtime($this->_configFile))
		{
			$config=new TApplicationConfiguration;
			$config->loadFromFile($this->_configFile);
			if($this->_cacheFile!==null)
			{
				if(($fp=fopen($this->_cacheFile,'wb'))!==false)
				{
					fputs($fp,Prado::serialize($config));
					fclose($fp);
				}
				else
					syslog(LOG_WARNING, 'Prado application config cache file "'.$this->_cacheFile.'" cannot be created.');
			}
		}
		else
		{
			$config=Prado::unserialize(file_get_contents($this->_cacheFile));
		}
				foreach($config->getAliases() as $alias=>$path)
			Prado::setPathOfAlias($alias,$path);
		foreach($config->getUsings() as $using)
			Prado::using($using);
				foreach($config->getProperties() as $name=>$value)
			$this->setSubProperty($name,$value);
				$this->_parameters=new TMap;
		foreach($config->getParameters() as $id=>$parameter)
		{
			if(is_array($parameter))
			{
				$component=Prado::createComponent($parameter[0]);
				foreach($parameter[1] as $name=>$value)
					$component->setSubProperty($name,$value);
				$this->_parameters->add($id,$component);
			}
			else
				$this->_parameters->add($id,$parameter);
		}
				$this->_modules=array();
		$modules=array();
		foreach($config->getModules() as $id=>$moduleConfig)
		{
			$module=Prado::createComponent($moduleConfig[0]);
			if(is_string($id))
				$this->setModule($id,$module);
			foreach($moduleConfig[1] as $name=>$value)
				$module->setSubProperty($name,$value);
			$modules[]=array($module,$moduleConfig[2]);
		}
		foreach($modules as $module)
			$module[0]->init($module[1]);
				$services=$config->getServices();
		$serviceIDs=array_keys($services);
		array_unshift($serviceIDs,self::PAGE_SERVICE_ID);
		$request=$this->getRequest();
		$request->setAvailableServices($serviceIDs);
		if(($serviceID=$request->getServiceID())===null)
			$serviceID=self::PAGE_SERVICE_ID;
		if(isset($services[$serviceID]))
		{
			$serviceConfig=$services[$serviceID];
			$service=Prado::createComponent($serviceConfig[0]);
			if(!($service instanceof IService))
				throw new THttpException(500,'application_service_unknown',$serviceID);
			$this->_service=$service;
			foreach($serviceConfig[1] as $name=>$value)
				$service->setSubProperty($name,$value);
			$service->init($serviceConfig[2]);
		}
		else
			$this->_service=$this->getPageService();
	}
	public function onError($param)
	{
		Prado::log($param->getMessage(),TLogger::ERROR,'System.TApplication');
		$this->raiseEvent('OnError',$this,$param);
		$this->getErrorHandler()->handleError($this,$param);
	}
	public function onBeginRequest()
	{
		$this->raiseEvent('OnBeginRequest',$this,null);
	}
	public function onAuthentication()
	{
		$this->raiseEvent('OnAuthentication',$this,null);
	}
	public function onAuthenticationComplete()
	{
		$this->raiseEvent('OnAuthenticationComplete',$this,null);
	}
	public function onAuthorization()
	{
		$this->raiseEvent('OnAuthorization',$this,null);
	}
	public function onAuthorizationComplete()
	{
		$this->raiseEvent('OnAuthorizationComplete',$this,null);
	}
	public function onLoadState()
	{
		$this->loadGlobals();
		$this->raiseEvent('OnLoadState',$this,null);
	}
	public function onLoadStateComplete()
	{
		$this->raiseEvent('OnLoadStateComplete',$this,null);
	}
	public function onPreRunService()
	{
		$this->raiseEvent('OnPreRunService',$this,null);
	}
	public function runService()
	{
		if($this->_service)
			$this->_service->run();
	}
	public function onSaveState()
	{
		$this->raiseEvent('OnSaveState',$this,null);
		$this->saveGlobals();
	}
	public function onSaveStateComplete()
	{
		$this->raiseEvent('OnSaveStateComplete',$this,null);
	}
	public function onPreFlushOutput()
	{
		$this->raiseEvent('OnPreFlushOutput',$this,null);
	}
	public function flushOutput()
	{
		$this->getResponse()->flush();
	}
	public function onEndRequest()
	{
		$this->raiseEvent('OnEndRequest',$this,null);
	}
}
class TApplicationConfiguration extends TComponent
{
	private $_properties=array();
	private $_usings=array();
	private $_aliases=array();
	private $_modules=array();
	private $_services=array();
	private $_parameters=array();
	public function loadFromFile($fname)
	{
		$configPath=dirname($fname);
		$dom=new TXmlDocument;
		$dom->loadFromFile($fname);
				foreach($dom->getAttributes() as $name=>$value)
			$this->_properties[$name]=$value;
				if(($pathsNode=$dom->getElementByTagName('paths'))!==null)
		{
			foreach($pathsNode->getElementsByTagName('alias') as $aliasNode)
			{
				if(($id=$aliasNode->getAttribute('id'))!==null && ($path=$aliasNode->getAttribute('path'))!==null)
				{
					$path=str_replace('\\','/',$path);
					if(preg_match('/^\\/|.:\\/|.:\\\\/',$path))							$p=realpath($path);
					else
						$p=realpath($configPath.'/'.$path);
					if($p===false || !is_dir($p))
						throw new TConfigurationException('appconfig_aliaspath_invalid',$id,$path);
					if(isset($this->_aliases[$id]))
						throw new TConfigurationException('appconfig_alias_redefined',$id);
					$this->_aliases[$id]=$p;
				}
				else
					throw new TConfigurationException('appconfig_alias_invalid');
			}
			foreach($pathsNode->getElementsByTagName('using') as $usingNode)
			{
				if(($namespace=$usingNode->getAttribute('namespace'))!==null)
					$this->_usings[]=$namespace;
				else
					throw new TConfigurationException('appconfig_using_invalid');
			}
		}
				if(($modulesNode=$dom->getElementByTagName('modules'))!==null)
		{
			foreach($modulesNode->getElementsByTagName('module') as $node)
			{
				$properties=$node->getAttributes();
				$id=$properties->itemAt('id');
				$type=$properties->remove('class');
				if($type===null)
					throw new TConfigurationException('appconfig_moduletype_required',$id);
				$node->setParent(null);
				if($id===null)
					$this->_modules[]=array($type,$properties->toArray(),$node);
				else
					$this->_modules[$id]=array($type,$properties->toArray(),$node);
			}
		}
				if(($servicesNode=$dom->getElementByTagName('services'))!==null)
		{
			foreach($servicesNode->getElementsByTagName('service') as $node)
			{
				$properties=$node->getAttributes();
				if(($id=$properties->itemAt('id'))===null)
					throw new TConfigurationException('appconfig_serviceid_required');
				if(($type=$properties->remove('class'))===null)
					throw new TConfigurationException('appconfig_servicetype_required',$id);
				$node->setParent(null);
				$this->_services[$id]=array($type,$properties->toArray(),$node);
			}
		}
				if(($parametersNode=$dom->getElementByTagName('parameters'))!==null)
		{
			foreach($parametersNode->getElementsByTagName('parameter') as $node)
			{
				$properties=$node->getAttributes();
				if(($id=$properties->remove('id'))===null)
					throw new TConfigurationException('appconfig_parameterid_required');
				if(($type=$properties->remove('class'))===null)
				{
					if(($value=$properties->remove('value'))===null)
						$this->_parameters[$id]=$node;
					else
						$this->_parameters[$id]=$value;
				}
				else
					$this->_parameters[$id]=array($type,$properties->toArray());
			}
		}
	}
	public function getProperties()
	{
		return $this->_properties;
	}
	public function getAliases()
	{
		return $this->_aliases;
	}
	public function getUsings()
	{
		return $this->_usings;
	}
	public function getModules()
	{
		return $this->_modules;
	}
	public function getServices()
	{
		return $this->_services;
	}
	public function getParameters()
	{
		return $this->_parameters;
	}
}
class TApplicationStatePersister extends TModule implements IStatePersister
{
	const CACHE_NAME='prado:appstate';
	public function init($config)
	{
		$this->getApplication()->setApplicationStatePersister($this);
	}
	protected function getStateFilePath()
	{
		return $this->getApplication()->getRuntimePath().'/global.cache';
	}
	public function load()
	{
		if(($cache=$this->getApplication()->getCache())!==null && ($value=$cache->get(self::CACHE_NAME))!==false)
			return unserialize($value);
		else
		{
			if(($content=@file_get_contents($this->getStateFilePath()))!==false)
				return unserialize($content);
			else
				return null;
		}
	}
	public function save($state)
	{
		$content=serialize($state);
		$saveFile=true;
		if(($cache=$this->getApplication()->getCache())!==null)
		{
			if($cache->get(self::CACHE_NAME)===$content)
				$saveFile=false;
			else
				$cache->set(self::CACHE_NAME,$content);
		}
		if($saveFile)
		{
			$fileName=$this->getStateFilePath();
			if(version_compare(phpversion(),'5.1.0','>='))
				file_put_contents($fileName,$content,LOCK_EX);
			else
				file_put_contents($fileName,$content);
		}
	}
}
?>