/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.lucene.document.DateField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public class FileDocument {
    public static Document Document(File f, boolean store) throws FileNotFoundException {
        Document doc = new Document();
        doc.add(Field.Text("path", f.getPath()));
        doc.add(Field.Keyword("modified", DateField.timeToString(f.lastModified())));
        FileInputStream is = new FileInputStream(f);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        if (store) {
            long size = f.length();
            if (size > Integer.MAX_VALUE) {
                size = Integer.MAX_VALUE;
            }
            char[] buffer = new char[(int)size];
            try {
                ((Reader)reader).read(buffer, 0, (int)size);
            }
            catch (Exception e) {
                System.out.println(" caught a " + e.getClass() + "\n with message: " + e.getMessage());
            }
            doc.add(Field.Text("contents", new String(buffer)));
        } else {
            doc.add(Field.Text("contents", reader));
        }
        return doc;
    }

    private FileDocument() {
    }
}

