/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo;

import java.io.File;
import java.util.Arrays;
import java.util.Date;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.demo.HTMLDocument;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;

class IndexHTML {
    private static boolean deleting = false;
    private static IndexReader reader;
    private static IndexWriter writer;
    private static TermEnum uidIter;

    IndexHTML() {
    }

    public static void main(String[] argv) {
        try {
            String index = "index";
            boolean create = false;
            File root = null;
            String usage = "IndexHTML [-create] [-index <index>] <root_directory>";
            if (argv.length == 0) {
                System.err.println("Usage: " + usage);
                return;
            }
            for (int i = 0; i < argv.length; ++i) {
                if (argv[i].equals("-index")) {
                    index = argv[++i];
                    continue;
                }
                if (argv[i].equals("-create")) {
                    create = true;
                    continue;
                }
                if (i != argv.length - 1) {
                    System.err.println("Usage: " + usage);
                    return;
                }
                root = new File(argv[i]);
            }
            Date start = new Date();
            if (!create) {
                deleting = true;
                IndexHTML.indexDocs(root, index, create);
            }
            writer = new IndexWriter(index, (Analyzer)new StandardAnalyzer(), create);
            IndexHTML.writer.maxFieldLength = 1000000;
            IndexHTML.indexDocs(root, index, create);
            System.out.println("Optimizing index...");
            writer.optimize();
            writer.close();
            Date end = new Date();
            System.out.print(end.getTime() - start.getTime());
            System.out.println(" total milliseconds");
        }
        catch (Exception e) {
            System.out.println(" caught a " + e.getClass() + "\n with message: " + e.getMessage());
        }
    }

    private static void indexDocs(File file, String index, boolean create) throws Exception {
        if (!create) {
            reader = IndexReader.open(index);
            uidIter = reader.terms(new Term("uid", ""));
            IndexHTML.indexDocs(file);
            if (deleting) {
                while (uidIter.term() != null && uidIter.term().field() == "uid") {
                    System.out.println("deleting " + HTMLDocument.uid2url(uidIter.term().text()));
                    reader.delete(uidIter.term());
                    uidIter.next();
                }
                deleting = false;
            }
            uidIter.close();
            reader.close();
        } else {
            IndexHTML.indexDocs(file);
        }
    }

    private static void indexDocs(File file) throws Exception {
        if (file.isDirectory()) {
            Object[] files = file.list();
            Arrays.sort(files);
            for (int i = 0; i < files.length; ++i) {
                IndexHTML.indexDocs(new File(file, (String)files[i]));
            }
        } else if (file.getPath().endsWith(".html") || file.getPath().endsWith(".htm") || file.getPath().endsWith(".txt")) {
            if (uidIter != null) {
                String uid = HTMLDocument.uid(file);
                while (uidIter.term() != null && uidIter.term().field() == "uid" && uidIter.term().text().compareTo(uid) < 0) {
                    if (deleting) {
                        System.out.println("deleting " + HTMLDocument.uid2url(uidIter.term().text()));
                        reader.delete(uidIter.term());
                    }
                    uidIter.next();
                }
                if (uidIter.term() != null && uidIter.term().field() == "uid" && uidIter.term().text().compareTo(uid) == 0) {
                    uidIter.next();
                } else if (!deleting) {
                    Document doc = HTMLDocument.Document(file);
                    System.out.println("adding " + doc.get("url"));
                    writer.addDocument(doc);
                }
            } else {
                Document doc = HTMLDocument.Document(file);
                System.out.println("adding " + doc.get("url"));
                writer.addDocument(doc);
            }
        }
    }
}

