/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.standard;

import java.io.IOException;
import java.io.Reader;
import java.util.Vector;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.standard.CharStream;
import org.apache.lucene.analysis.standard.FastCharStream;
import org.apache.lucene.analysis.standard.ParseException;
import org.apache.lucene.analysis.standard.StandardTokenizerConstants;
import org.apache.lucene.analysis.standard.StandardTokenizerTokenManager;

public class StandardTokenizer
extends Tokenizer
implements StandardTokenizerConstants {
    public StandardTokenizerTokenManager token_source;
    public org.apache.lucene.analysis.standard.Token token;
    public org.apache.lucene.analysis.standard.Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[1];
    private static int[] jj_la1_0;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public StandardTokenizer(Reader reader) {
        this(new FastCharStream(reader));
        this.input = reader;
    }

    public final Token next() throws ParseException, IOException {
        org.apache.lucene.analysis.standard.Token token = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: {
                token = this.jj_consume_token(1);
                break;
            }
            case 2: {
                token = this.jj_consume_token(2);
                break;
            }
            case 3: {
                token = this.jj_consume_token(3);
                break;
            }
            case 4: {
                token = this.jj_consume_token(4);
                break;
            }
            case 5: {
                token = this.jj_consume_token(5);
                break;
            }
            case 6: {
                token = this.jj_consume_token(6);
                break;
            }
            case 7: {
                token = this.jj_consume_token(7);
                break;
            }
            case 12: {
                token = this.jj_consume_token(12);
                break;
            }
            case 0: {
                token = this.jj_consume_token(0);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (token.kind == 0) {
            return null;
        }
        return new Token(token.image, token.beginColumn, token.endColumn, tokenImage[token.kind]);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{4351};
    }

    public StandardTokenizer(CharStream stream) {
        this.token_source = new StandardTokenizerTokenManager(stream);
        this.token = new org.apache.lucene.analysis.standard.Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 1; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(CharStream stream) {
        this.token_source.ReInit(stream);
        this.token = new org.apache.lucene.analysis.standard.Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 1; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public StandardTokenizer(StandardTokenizerTokenManager tm) {
        this.token_source = tm;
        this.token = new org.apache.lucene.analysis.standard.Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 1; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(StandardTokenizerTokenManager tm) {
        this.token_source = tm;
        this.token = new org.apache.lucene.analysis.standard.Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 1; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private final org.apache.lucene.analysis.standard.Token jj_consume_token(int kind) throws ParseException {
        org.apache.lucene.analysis.standard.Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final org.apache.lucene.analysis.standard.Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final org.apache.lucene.analysis.standard.Token getToken(int index) {
        org.apache.lucene.analysis.standard.Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[15];
        for (i = 0; i < 15; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 1; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 15; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        StandardTokenizer.jj_la1_0();
    }
}

