/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLDocument {
    public static Document Document(File f) throws Exception {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        SAXParser saxParser = saxParserFactory.newSAXParser();
        XMLReader parser = saxParser.getXMLReader();
        DocumentConstructor docConstructor = new DocumentConstructor();
        parser.setContentHandler(docConstructor);
        FileInputStream is = new FileInputStream(f);
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        parser.parse(new InputSource(reader));
        return docConstructor.getDoc();
    }

    private XMLDocument() {
    }

    static class DocumentConstructor
    extends DefaultHandler
    implements ContentHandler {
        private Document doc = new Document();
        private int deep = 0;
        private String currentField = "";
        private String currentFieldData = "";
        private boolean storeCurrentField = false;
        private boolean isKeyword = false;

        public void startElement(String namespace, String localname, String type, Attributes attributes) throws SAXException {
            if (this.deep == 0) {
                if (!type.equals("xml")) {
                    throw new SAXException("Incorrect XML format");
                }
                ++this.deep;
                return;
            }
            if (this.deep != 1) {
                throw new SAXException("Incorrect XML format");
            }
            ++this.deep;
            this.currentField = type;
            this.currentFieldData = "";
            this.storeCurrentField = new String("true").equalsIgnoreCase(attributes.getValue("stored"));
            this.isKeyword = new String("keyword").equalsIgnoreCase(attributes.getValue("type"));
        }

        public void endElement(String namespace, String localname, String type) throws SAXException {
            Field newField = this.isKeyword ? Field.Keyword(this.currentField, this.currentFieldData) : (this.storeCurrentField ? Field.Text(this.currentField, this.currentFieldData) : Field.Text(this.currentField, new StringReader(this.currentFieldData)));
            this.doc.add(newField);
            --this.deep;
        }

        public void characters(char[] ch, int start, int len) {
            this.currentFieldData = this.currentFieldData + new String(ch, start, len).trim();
        }

        public Document getDoc() {
            return this.doc;
        }
    }
}

