<?php
/**
 * @package    Zend_Feed
 * @subpackage UnitTests
 */


/**
 * Zend_Feed_EntryAtom
 */
require_once 'Zend/Feed/EntryAtom.php';


/**
 * @package    Zend_Feed
 * @subpackage UnitTests
 */
class Zend_Feed_ElementTest extends PHPUnit_Framework_TestCase {

    public function testIsInitialized()
    {
        $e = new Zend_Feed_EntryAtom();
        $e->author->name['last'] = 'hagenbuch';
        $e->author->name['first'] = 'chuck';
        $e->author->name->{'chuck:url'} = 'marina.horde.org';

        $e->author->title['foo'] = 'bar';
        if ($e->pants()) {
            $this->fail('<pants> does not exist, it should not have a true value');
            // This should not create an element in the actual tree.
        }
        if ($e->pants()) {
            $this->fail('<pants> should not have been created by testing for it');
            // This should not create an element in the actual tree.
        }

        $xml = $e->saveXML();

        $this->assertFalse(strpos($xml, 'pants'), '<pants> should not be in the xml output');
        $this->assertTrue(strpos($xml, 'marina.horde.org') !== false, 'the url attribute should be set');
    }

    public function testStrings()
    {
        $xml = "<entry>
	<title> Using C++ Intrinsic Functions for Pipelined Text Processing</title>
	<id>http://www.oreillynet.com/pub/wlg/8356</id>
	<link rel='alternate' href='http://www.oreillynet.com/pub/wlg/8356'/>
	<summary type='xhtml'>
	<div xmlns='http://www.w3.org/1999/xhtml'>
	A good C++ programming technique that has almost no published material available on the WWW relates to using the special pipeline instructions in modern CPUs for faster text processing. Here's example code using C++ intrinsic functions to give a fourfold speed increase for a UTF-8 to UTF-16 converter compared to the original C/C++ code.
	</div>
	</summary>
	<author><name>Rick Jelliffe</name></author>
	<updated>2005-11-07T08:15:57-08:00</updated>
</entry>";

        $entry = new Zend_Feed_EntryAtom('uri', $xml);

        $this->assertTrue($entry->summary instanceof Zend_Feed_Element, '__get access should return an Zend_Feed_Element instance');
        $this->assertFalse($entry->summary() instanceof Zend_Feed_Element, 'method access should not return an Zend_Feed_Element instance');
        $this->assertTrue(is_string($entry->summary()), 'method access should return a string');
        $this->assertFalse(is_string($entry->summary), '__get access should not return a string');
    }

}
