/*
 * Decompiled with CFR 0.152.
 */
package org.jresearch.jssplitter.jsprocessor;

import java.util.ArrayList;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.jresearch.jssplitter.jsprocessor.Patterns;

public class Sweeper {
    private boolean comment = false;

    public String sweep(String s) throws RESyntaxException {
        ArrayList<String> quotedStrings = new ArrayList<String>();
        while (Patterns.quotePattern.match(s)) {
            quotedStrings.add(Patterns.quotePattern.getParen(0));
            s = Patterns.quotePattern.subst(s, "%_" + (quotedStrings.size() - 1) + "_%", 1);
        }
        if (!this.comment) {
            s = Patterns.lncomPattern.subst(s, "\n");
            s = Patterns.singlePattern.subst(s, "");
            s = this.cleanBlankSpace(s);
            if (Patterns.openPattern.match(s = this.cleanInline(s))) {
                s = Patterns.openPattern.subst(s, "");
                this.comment = true;
            }
            if (!s.equals("")) {
                s = this.cleanBlankSpace(s);
                char c = (s = this.cleanInline(s)).charAt(s.length() - 1);
                if (c != '{' && c != ';' && c != ',') {
                    s = s + "\n";
                }
            }
        } else if (Patterns.closePattern.match(s)) {
            s = Patterns.closePattern.subst(s, "");
            this.comment = false;
            if (Patterns.openPattern.match(s = Patterns.singlePattern.subst(s, ""))) {
                s = Patterns.openPattern.subst(s, "");
                this.comment = true;
            }
        } else {
            s = "";
        }
        int i = 0;
        while (i < quotedStrings.size()) {
            RE re = new RE("%_" + i + "_%");
            s = re.subst(s, (String)quotedStrings.get(i));
            ++i;
        }
        return s;
    }

    private String cleanInline(String s) {
        s = this.clean(s, Patterns.inlinePattern, 0);
        s = this.clean(s, Patterns.mathPattern, 0);
        return s;
    }

    private String clean(String s, RE re, int paren) {
        while (re.match(s)) {
            s = re.subst(s, re.getParen(paren).trim(), 1);
        }
        return s;
    }

    private String cleanBlankSpace(String s) {
        s = Patterns.leadspPattern.subst(s, "");
        s = Patterns.endspPattern.subst(s, "");
        s = Patterns.multsPattern.subst(s, " ");
        return s;
    }
}

