/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.app.vo;

import com.google.gwt.user.client.rpc.IsSerializable;

import java.util.ArrayList;
import java.util.List;

/**
 * Response object which contains entity data for multiple entities.
 *
 * @author Sergey Kozmin
 * @since 30.10.2006, 11:02:25
 */
public class AccumulatedEntityDataResponse implements IsSerializable {
    /**
     * external sets data
     */
    private EntityData[] entitiesList;
    /**
     * external fields data
     */
    private EntityData[] externalFieldsList;

    /**
     * grid data objects
     * List<GridData>
     */
    private List gridData;

    /**
     * Construct the response object with the given parameters
     *
     * @param entitiesData       incoming data for entities
     * @param externalFieldsList this entities list contains one field with entity defenition
     * @param gridData           this is data for grid
     */
    public AccumulatedEntityDataResponse(EntityData[] entitiesData, EntityData[] externalFieldsList, List gridData) {
        if(externalFieldsList != null) {
            this.externalFieldsList = externalFieldsList;
        } else {
            this.externalFieldsList = new EntityData[0];
        }
        if(entitiesData != null) {
            entitiesList = entitiesData;
        } else {
            entitiesList = new EntityData[0];
        }
        if(gridData != null) {
            this.gridData = gridData;
        } else {
            this.gridData = new ArrayList();
        }
    }

    public AccumulatedEntityDataResponse() {
        this(null, null, null);
    }

    public EntityData[] getEntitiesList() {
        return entitiesList;
    }

    public void setEntitiesList(EntityData[] entitiesList) {
        if(entitiesList != null) {
            this.entitiesList = entitiesList;
        }
    }

    public EntityData[] getExternalFieldsList() {
        return externalFieldsList;
    }

    public void setExternalFieldsList(EntityData[] externalFieldsList) {
        if(externalFieldsList != null) {
            this.externalFieldsList = externalFieldsList;
        }
    }

    public List getGridData() {
        return gridData;
    }
}
