/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.app.vo;


/**
 * Transfer the data which element should be deleted and current grid properties.
 * @author Sergey Kozmin
 */
public class AdhocDeleteReportRequest extends BaseGridRequest {
    private Long reportId;

    public AdhocDeleteReportRequest(GridSearchProperties props, Long reportId) {
        super(props);
        this.reportId = reportId;
    }

    public AdhocDeleteReportRequest() {
        this(null, new Long(-1L));
    }

    public Long getReportId() {
        return reportId;
    }

    public void setReportId(Long reportId) {
        this.reportId = reportId;
    }
}
