/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.app.vo;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Request object which specifys all needed parameters to get full record data.
 *
 * @author Sergey Kozmin
 * @since 30.10.2006, 11:02:25
 */
public class EntityIDRequestObject implements IsSerializable {
    protected String formID;
    protected Long rowID;

    public EntityIDRequestObject() {
    }

    public EntityIDRequestObject(String formID, Long rowID) {
        this.formID = formID;
        this.rowID = rowID;
    }

    public String getFormID() {
        return formID;
    }

    public void setFormID(String formID) {
        this.formID = formID;
    }

    public Long getRowID() {
        return rowID;
    }

    public void setRowID(Long rowID) {
        this.rowID = rowID;
    }
}
