/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.app.vo;

/**
 * MetaData container for EntityLink field.
 *
 * @author Sergey Kozmin
 * @since 26.09.2006, 16:18:53
 */
public class EntityLinkFieldMeta extends BaseFieldMeta {
    /**
     * Entity, that linked to the current entity.
     */
    private String linkedEntity;
    /**
     * Linked entity field name, that is linked to current entity.
     */
    private String linkedFieldName;

    public EntityLinkFieldMeta(String fieldID, String caption, String linkedEntity, String linkedFieldName,
                               boolean required, boolean descriptive) {
        super(ENTITYLINK, fieldID, caption, required, descriptive);
        this.linkedEntity = linkedEntity;
        this.linkedFieldName = linkedFieldName;
    }

    public EntityLinkFieldMeta(String fieldID, String caption,
                               String linkedEntity, String linkedFieldName) {
        this(fieldID, caption, linkedEntity, linkedFieldName, false,  false);
    }

    public EntityLinkFieldMeta(String fieldID) {
        this(fieldID, "", "", "");
    }

    public EntityLinkFieldMeta() {
        this("");
    }

    public String getLinkedEntity() {
        return linkedEntity;
    }

    public void setLinkedEntity(String linkedEntity) {
        this.linkedEntity = linkedEntity;
    }

    public String getLinkedFieldName() {
        return linkedFieldName;
    }

    public void setLinkedFieldName(String linkedFieldName) {
        this.linkedFieldName = linkedFieldName;
    }
}
