/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the 
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.app.vo;

/**
 * Contains operation with fields.
 *
 * @author Sergey Kozmin
 * @since 12.04.2007
 */
public class FieldsHelper {
    /**
     * Extract referencing record id from the field, if field doesn't contain
     * such information or data is malformed method returns null object.
     * @param meta meta for field
     * @param data field data
     * @return record id, contained in field
     */
    public static Long extractReferencedRecordId(FieldMeta meta, FieldData data) {
        Long recordId = null;
        if(!(meta == null || data == null)) {
            int type = meta.getDataType();
            switch(type) {
                case FieldMeta.LISTBOX: {
                    ListboxFieldData ldata = (ListboxFieldData) data;
                    SubsetData selected = ldata.getItemsSelected();
                    recordId = extractFromSubsetData(selected);
                    break;
                }
                case FieldMeta.MEMO: {
                    MemoFieldData mdata = (MemoFieldData) data;
                    recordId = extractFromPlainText(mdata.getText());
                    break;
                }
                case FieldMeta.MULTISELECT: {
                    MultiselectFieldData mdata = (MultiselectFieldData) data;
                    SubsetData selected = mdata.getItemsSelected();
                    recordId = extractFromSubsetData(selected);
                    break;
                }
                case FieldMeta.TEXTAREA: {
                    TextareaFieldData tdata = (TextareaFieldData) data;
                    recordId = extractFromPlainText(tdata.getText());
                    break;
                }
                case FieldMeta.TEXTBOX: {
                    TextboxFieldData tdata = (TextboxFieldData) data;
                    recordId = extractFromPlainText(tdata.getText());
                    break;
                }
                case FieldMeta.ENTITYREFERENCE: {
                    EntityReferenceData edata = (EntityReferenceData) data;
                    recordId = edata.getSelectedRowID();
                    break;
                }
                case FieldMeta.ENTITYLINK: {
                    EntityLinkFieldData edata = (EntityLinkFieldData) data;
                    if(!edata.getLinkedEntityIDs().isEmpty()) {//has at least 1 value
                        recordId = (Long) edata.getLinkedEntityIDs().iterator().next();
                    }
                    break;
                }
            }
        }
        return recordId;
    }

    private static Long extractFromSubsetData(SubsetData selected) {
        long[] selArr = selected.getSelectedIDs();
        if(selArr.length > 0) {
            return new Long(selArr[0]);//choose first selected
        }
        return null;
    }

    private static Long extractFromPlainText(String text) {
        try {
            return new Long(text);
        } catch(NumberFormatException e) {
            return null;
        }
    }
}
