/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the 
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.app.vo;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Represents form button metadata.
 * @author Dmitry Antonov
 * @since 22 Dec 2006
 */
public class FormButtonMeta implements IsSerializable {
    public static final int BUTTON_TYPE_BUTTON = 0;
    public static final int BUTTON_TYPE_LINK = 1;
    
    private String id;
    private String caption;
    private int buttonType;
    private String icon;
    private String tag;
    private String captionStyle;
    
    public FormButtonMeta() {
        this("", "Button");
    }
    
    public FormButtonMeta(String id, String caption) {
        this(id, caption, BUTTON_TYPE_BUTTON, null, null);
    }

    public FormButtonMeta(String id, String caption, int buttonType, 
            String icon, String captionStyle) {
        setId(id);
        setCaption(caption);
        this.buttonType = buttonType;
        this.icon = icon;
        this.captionStyle = captionStyle;
    }

    public String getId() {
        return (id != null) ? id : "";
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCaption() {
        return caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof FormButtonMeta) {
            return id.equals(((FormButtonMeta) obj).id);
        } else {
            return true;
        }
    }
    
    public int hashCode() {
        return id.hashCode();
    }

    public int getButtonType() {
        return buttonType;
    }

    public void setButtonType(int buttonType) {
        this.buttonType = buttonType;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getTag() {
        return tag;
    }

    /**
     * Can be used to store any associated information
     */
    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getCaptionStyle() {
        return captionStyle;
    }

    public void setCaptionStyle(String captionStyle) {
        this.captionStyle = captionStyle;
    }
   
}
