/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.app.vo;

import java.util.Collection;
import java.util.List;

/**
 * In form grid on demand data for the type {@link #GET_RECORDS_DATA_TYPE}.
 *
 * @author Sergey Kozmin
 * @since 04.04.2007
 */
public class GetRecordsInformOnDemandData extends InFormGridOnDemandData {
    /**
     * List of {@link com.queplix.core.client.app.vo.RowData}
     * List<RowData>
     */
    private List data;
    /**
     * filters list  Collection<FieldData> 
     */
    private Collection filters;

    public GetRecordsInformOnDemandData(String elementID, List data, Collection filters) {
        super(elementID, GET_RECORDS_DATA_TYPE);
        this.filters = filters;
        this.data = data;
    }

    public GetRecordsInformOnDemandData() {
        this("", null, null);
    }

    public List getData() {
        return data;
    }

    public void setData(List data) {
        this.data = data;
    }

    public Collection getFilters() {
        return filters;
    }

    public void setFilters(Collection filters) {
        this.filters = filters;
    }
}
