/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.app.vo;

/**
 * @author: Melnik Alexander
 * @since: 11.01.2007
 */
public class HistoryFieldMeta extends BaseFieldMeta {
    private String prefixCaption;
    private String dialogCaption;

    public HistoryFieldMeta(String fieldID, String fieldCaption, String prefixCaption, String dialogCaption) {
        super(HISTORY, fieldID, fieldCaption);
        this.dialogCaption = dialogCaption;
        this.prefixCaption = prefixCaption;
    }

    public HistoryFieldMeta() {
        this("", "", "", "");
    }

    public String getPrefixCaption() {
        return this.prefixCaption;
    }
    
    public void setPrefixCaption(String prefixCaption) {
        this.prefixCaption = prefixCaption;
    }
    
    public String getDialogCaption() {
        return dialogCaption;
    }

    public void setDialogCaption(String dialogCaption) {
        this.dialogCaption = dialogCaption;
    }
}
