/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.app.vo;

/**
 * On demand data container for in-form grid field.
 *
 * @author Sergey Kozmin
 * @since 26.09.2006, 16:18:53
 */
public abstract class InFormGridOnDemandData extends BaseFieldOnDemandData
        implements InFormGridType {
    /**
     * Can be one of the listed in the
     * {@link com.queplix.core.client.app.vo.InFormGridType}
     */
    private int informReqType;

    protected InFormGridOnDemandData(String fieldID, int informReqType) {
        super(fieldID);
        this.informReqType = informReqType;
    }

    public InFormGridOnDemandData() {
        this("", SEARCH_TYPE);
    }

    public int getInformGridRequestType() {
        return informReqType;
    }
}
