/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.app.vo;

/**
 * MetaData container for memo field.
 *
 * @author Sergey Kozmin
 * @since 26.09.2006, 16:18:53
 */
public class MemoFieldMeta extends BaseFieldMeta {
    private String prefixCaption;
    private String dialogCaption;
    
    public final static int EDIT_TYPE = 0;
    public final static int APPEND_TYPE = 1;
    public final static int PREPPEND_TYPE = 2;
    
    private int memoType;

    public MemoFieldMeta(String fieldID, String fieldCaption, String prefixCaption, String dialogCaption, int memoType) {
        super(MEMO, fieldID, fieldCaption);
        this.dialogCaption = dialogCaption;
        this.prefixCaption = prefixCaption;
        setMemoType(memoType);
    }

    public MemoFieldMeta() {
        this("", "", "", "", 0);
    }

    public String getPrefixCaption() {
        return this.prefixCaption;
    }
    
    public void setPrefixCaption(String prefixCaption) {
        this.prefixCaption = prefixCaption;
    }
    
    public String getDialogCaption() {
        return dialogCaption;
    }

    public void setDialogCaption(String dialogCaption) {
        this.dialogCaption = dialogCaption;
    }
    
    public int getMemoType() {
        return memoType;
    }
    
    public void setMemoType(int memoType) {
        this.memoType = memoType;
    }
    
}
