/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.app.vo;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.List;

/**
 *
 * @author aliaksandr.melnik
 */
public class PrintFormRequestObject extends EntityIDRequestObject {
    private long processId;
    private boolean printPage;
    private boolean doCount;
    private int page;
    private int pageSize;

    public PrintFormRequestObject() {
    }
    
    public PrintFormRequestObject(String formID, Long recordID, boolean printPage, boolean doCount, int page, int pageSize) {
        super(formID, recordID);
        this.printPage = printPage;
        this.doCount = doCount;
        this.page = page;
        this.pageSize = pageSize;
        processId = System.currentTimeMillis();
    }
    
    public long getProcessId() {
        return processId;
    }

    public boolean isPrintPage() {
        return printPage;
    }

    public boolean isDoCount() {
        return doCount;
    }

    public int getPage() {
        return page;
    }

    public int getPageSize() {
        return pageSize;
    }
}
