/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.client.app.vo;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.Iterator;

/**
 * Subset Data
 * @author Sultan Tezadov
 */
public class SubsetData implements IsSerializable {
    private long[] selectedIDs;
    
    /** Creates a new instance of SubsetData */
    public SubsetData() {
        this(new long[0]);
    }

    public SubsetData(long[] selectedIDs) {
        setSelectedIDs(selectedIDs);
    }

    public long[] getSelectedIDs() {
        return selectedIDs;
    }

    public void setSelectedIDs(long[] selectedIDs) {
        if (selectedIDs == null) {
            throw new IllegalArgumentException("Argument 'selectedIDs' can not be null");
        }
        this.selectedIDs = selectedIDs;
    }
    
    public boolean isIDSelected(long id) {
        return getSelectedIndex(id) > -1;
    }

    public void setIDSelected(long id, boolean select) {
        if (select) {
            if (! isIDSelected(id)) {
                long[] oldIDs = selectedIDs;
                int n = oldIDs.length;
                selectedIDs = new long[n + 1];
                for (int i = 0; i < n; i++) {
                    selectedIDs[i] = oldIDs[i];
                }
                selectedIDs[n] = id;
            }
        } else { // deselect
            if (isIDSelected(id)) {
                long[] oldIDs = selectedIDs;
                int n = oldIDs.length;
                selectedIDs = new long[n - 1];
                int j = 0;
                for (int i = 0; i < n; i++) {
                    if (oldIDs[i] != id) {
                        selectedIDs[j] = oldIDs[i];
                        j++;
                    }
                }
            }
        }
    }

    public void swapItems(int index1, int index2) {
        if (index1 >= 0  &&  index1 < selectedIDs.length  &&
                index2 >= 0  &&  index2 < selectedIDs.length) {
            long tmp = selectedIDs[index1];
            selectedIDs[index1] = selectedIDs[index2];
            selectedIDs[index2] = tmp;
        }
    }
    
    public Object clone() {
        return new SubsetData(selectedIDs);
    }

    public int getSelectedIndex(long id) {
        int i = selectedIDs.length - 1;
        while ((i >= 0)  &&  (selectedIDs[i] != id)) {
            i--;
        }
        return i;
    }

    public SubsetData clone2() {
        SubsetData clone = new SubsetData();
        long[] arr = new long[selectedIDs.length];
        for (int i = 0; i < arr.length; i++) {
            arr[i] = selectedIDs[i];
        }
        clone.setSelectedIDs(arr);
        return clone;
    }

    public boolean isNullSelected() {
        for(int i = 0; i < this.selectedIDs.length; i++) {
            if(this.selectedIDs[i] == -1) {
                return true;
            }
        }
        return false;
    }
    
    public void setNullSelected(boolean select) {
        ArrayList idList = new ArrayList();
        for(int i = 0; i < this.selectedIDs.length; i++) {
            idList.add(new Long(this.selectedIDs[i]));
        }
        if(select && !this.isNullSelected()) {
            idList.add(new Long(-1));
        } else if(!select && this.isNullSelected()) {
            idList.remove(new Long(-1));
        }
        long[] newIds = new long[idList.size()];
        Iterator it = idList.iterator();
        int i = 0;
        while(it.hasNext()) {
            Long id = (Long) it.next();
            newIds[i] = id.longValue();
            i++;
        }
        this.selectedIDs = newIds;
    }

    public boolean equalsToData(SubsetData obj) {
        if(obj.selectedIDs.length == selectedIDs.length) {
            for (int i = 0; i < selectedIDs.length; i++) {
                if(obj.selectedIDs[i] != selectedIDs[i]) {
                    return false;
                }
            }
            return true;
        } else {
            return false;
        }
    }
}
