/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT 
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the 
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.app.vo;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * Represents Tab metadata
 * @author Sergey Kozmin
 * @since 13 Oct 2006
 */
public class TabMeta implements IsSerializable {
    public static class Index extends SubFocusMeta.Index {
        public int tab;

        public int getType() {
            return TAB;
        }

        public void init(SubFocusMeta.Index subFocusIndex, int tabIndex) {
            super.init(subFocusIndex, subFocusIndex.subFocus);
            this.tab = tabIndex;
        }

        //do not reload Object.equals method, because Famg==Tab.
        public boolean equalsToIndex(TabMeta.Index index) {
            return index.focus == focus && index.subFocus == subFocus && index.tab == tab;
        }
    }
    
    
    private Index index;
    private String caption;
    private String tabName;
    private String icon;
    private String helpLink;
    private FamgMeta[] famgs;
    private boolean inFrameLinks;

    public TabMeta(String caption, String tabName, FamgMeta[] famgs) {
        index = new Index();
        this.caption = caption;
        this.tabName = tabName;
        if(famgs != null) {
            this.famgs = famgs;
        } else {
            this.famgs = new FamgMeta[0];
        }
    }

    public TabMeta() {
        this("", "", null);
    }

    void initIndexes(SubFocusMeta.Index subFocusIndex, int tabIndex) {
        index.init(subFocusIndex, tabIndex);
        initChildrenIndexes();
    }

    private void initChildrenIndexes() {
        for (int i = 0; i < famgs.length; i++) {
            famgs[i].initIndexes(index, i);
        }
    }
    
    public String getCaption() {
        return caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public FamgMeta[] getFamgs() {
        return famgs;
    }

    public void setFamgs(FamgMeta[] famgs) {
        if(famgs != null) {
            this.famgs = famgs;
            initChildrenIndexes();
        }
    }

    public String getTabName() {
        return tabName;
    }

    public Index getIndex() {
        return index;
    }

    public FamgMeta getFamgMeta(FamgMeta.Index index) {
        return famgs[index.famg];
    }

    public FamgMeta.Index getFormIndex(String entityName) {
        FamgMeta.Index index = null;
        for (int i = 0; i < famgs.length; i++) {
            if(famgs[i].getForm().getEntityMeta().getEntityID().equalsIgnoreCase(entityName)) {
                index = famgs[i].getIndex();
                break;
            }
        }
        return index;
    }

    public String getFormID(FamgMeta.Index index) {
        return famgs[index.famg].getFormID();
    }

    public String getIcon() {
        return null;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public boolean isInFrameLinks() {
        return inFrameLinks;
    }

    public void setInFrameLinks(boolean inFrameLinks) {
        this.inFrameLinks = inFrameLinks;
    }

    /**
     * @return
     */
    public boolean isMyQueWeb() {
        return "MyQueWeb".equalsIgnoreCase(tabName);
    }
    
    private boolean haveGrid;
    
    public boolean canHaveGrid(){
        return haveGrid;
    }

    public void setHaveGrid(boolean value){
        haveGrid = value;
    }

    public String getHelpLink() {
        return helpLink;
    }

    public void setHelpLink(String helpLink) {
        this.helpLink = helpLink;
    }

}