/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.queplix.core.client.app.vo.uisettings;

import com.google.gwt.user.client.rpc.IsSerializable;

import java.util.Map;

/**
 * GridUISettings.
 * @author Sultan Tezadov
 * @since 30 Jan 2007
 */
public class GridUISettings implements IsSerializable {
    private boolean counterOn;
    private int pageSize;
    /**
     * Map&lt;String, Integer&gt;
     */
    private Map columnWidths;
    
    public GridUISettings() {
    }

    public GridUISettings(boolean counterOn, int pageSize, Map columnWidths) {
        this.counterOn = counterOn;
        this.pageSize = pageSize;
        this.columnWidths = columnWidths;
    }

    public boolean isCounterOn() {
        return counterOn;
    }

    public void setCounterOn(boolean counterOn) {
        this.counterOn = counterOn;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public Map getColumnWidths() {
        return columnWidths;
    }

    public void setColumnWidths(Map columnWidths) {
        this.columnWidths = columnWidths;
    }
    
    public boolean isPageSizeSet() {
        return pageSize > 0;
    }
    
    public boolean isAnyColumnWidthSet() {
        return (columnWidths != null) && (columnWidths.size() > 0);
    }

    public boolean isColumnWidthSet(String columnID) {
        return (columnWidths != null)  &&  (columnWidths.get(columnID) != null);
    }
    
    public int getColumnWidth(String columnID) {
        int width = -1;
        if (columnWidths != null) {
            Integer widthString = (Integer) columnWidths.get(columnID);
            if (widthString != null) {
                width = widthString.intValue();
            }
        }
        return width;
    }
}
