/*
 * Copyright 2006-2007 Queplix Corp.
 *
 * Licensed under the Queplix Public License, Version 1.1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.queplix.com/solutions/commercial-open-source/queplix-public-license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package com.queplix.core.ant;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.Task;

/**
 *
 * @author Sultan Tezadov
 */
public class SplitTask extends Task {
    private String value;
    private String resultProperty;
    private String regex;
    
    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getResultProperty() {
        return resultProperty;
    }

    public void setResultProperty(String resultProperty) {
        this.resultProperty = resultProperty;
    }

    public String getRegex() {
        return regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public void execute() throws BuildException {
        String[] results = value.split(regex);
        for (int i = 0; i < results.length; i++) {
            String propertyName = resultProperty + i;
            String propertyValue = results[i];
            log("Setting new property: name='" + propertyName + 
                    "' value='" + propertyValue + "'", Project.MSG_VERBOSE);
            PropertyHelper ph = PropertyHelper.getPropertyHelper(getProject());
            ph.setNewProperty(null, propertyName, propertyValue);
        }
    }

}
